/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountUserLevelCollection;
import com.kingdee.eas.basedata.master.account.AccountUserLevelInfo;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.master.account.Account_ControlCollection;
import com.kingdee.eas.basedata.master.account.Account_ControlFactory;
import com.kingdee.eas.basedata.master.account.Account_ControlInfo;
import com.kingdee.eas.basedata.master.account.IAccountTable;
import com.kingdee.eas.basedata.master.account.IAccount_Control;
import com.kingdee.eas.basedata.master.account.client.AbstractAccountTableEditUI;
import com.kingdee.eas.basedata.master.account.client.AccountClientUtils;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import javax.swing.JScrollBar;
import javax.swing.JTextField;

public class AccountTableEditUI
extends AbstractAccountTableEditUI {
    private static final String ACCOUNT_TABLE = "accountTable";
    private boolean isUsedByAccoutView = false;
    private CompanyOrgUnitInfo currentCompany = null;
    private OrgUnitInfo[] mainOrgs = null;
    private int idxDefaultMainOrg = -1;
    private OrgUnitInfo mainOrg = null;
    private final String PERMISSION_ITEM = "bd_account_accountTable_view";
    private int EAS_MODE_VALUE = 0;

    public void onLoad() throws Exception {
        this.currentCompany = (CompanyOrgUnitInfo)this.getUIContext().get("CurrentCompany");
        if (this.currentCompany == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"CurrentOrgIsNotCompany"));
            SysUtil.abort();
        }
        this.EAS_MODE_VALUE = AccountUtils.getEASModeValue(null);
        super.onLoad();
        this.kdtControl.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar());
        this.kdtUserLevel.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar());
        this.kdtControl.checkParsed();
        this.kdtUserLevel.checkParsed();
        this.mltCreator.setEnabled(false);
        this.mltCompanyName.setEnabled(false);
        this.txtCreateTime.setEnabled(false);
        this.initUIMainOrgContext(this.currentCompany.getId().toString());
        if (this.getOprtState().equals("ADDNEW")) {
            this.actionAddLine_actionPerformed(null);
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnInsertLine.setText(null);
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDeleteLine.setText(null);
        this.btnDeleteLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    private void loadCtrlProperties() {
        Account_ControlInfo ctr = this.editData.getControl().get(0);
        this.kdtControl.getRow(0).getCell(2).setValue((Object)new Boolean(ctr.getDc() == 1));
        this.kdtControl.getRow(1).getCell(2).setValue((Object)new Boolean(ctr.getCurrencyID() == 1));
        this.kdtControl.getRow(2).getCell(2).setValue((Object)new Boolean(ctr.getIsChangeCurrency() == 1));
        this.kdtControl.getRow(3).getCell(2).setValue((Object)new Boolean(ctr.getIsCountAccrual() == 1));
        this.kdtControl.getRow(4).getCell(2).setValue((Object)new Boolean(ctr.getIsQty() == 1));
        this.kdtControl.getRow(5).getCell(2).setValue((Object)new Boolean(ctr.getAc() == 1));
        this.kdtControl.getRow(6).getCell(2).setValue((Object)new Boolean(ctr.getControl() == 1));
        this.kdtControl.getColumn(1).getStyleAttributes().setLocked(true);
    }

    private void enableCtrlPropertiesUnseleted(Account_ControlInfo ctr) {
        this.kdtControl.getRow(0).getCell(2).getStyleAttributes().setLocked(ctr.getDc() == 0);
        this.kdtControl.getRow(1).getCell(2).getStyleAttributes().setLocked(ctr.getCurrencyID() == 0);
        this.kdtControl.getRow(2).getCell(2).getStyleAttributes().setLocked(ctr.getIsChangeCurrency() == 0);
        this.kdtControl.getRow(3).getCell(2).getStyleAttributes().setLocked(ctr.getIsCountAccrual() == 0);
        this.kdtControl.getRow(4).getCell(2).getStyleAttributes().setLocked(ctr.getIsQty() == 0);
        this.kdtControl.getRow(5).getCell(2).getStyleAttributes().setLocked(ctr.getAc() == 0);
        this.kdtControl.getRow(6).getCell(2).getStyleAttributes().setLocked(ctr.getControl() == 0);
    }

    private void storeCtrlProperties() {
        this.editData.getControl().clear();
        Account_ControlInfo ctlInfo = new Account_ControlInfo();
        ctlInfo.setDc(this.kdtControl.getRow(0).getCell(2).getValue().toString().equals("true") ? 1 : 0);
        ctlInfo.setCurrencyID(this.kdtControl.getRow(1).getCell(2).getValue().toString().equals("true") ? 1 : 0);
        ctlInfo.setIsChangeCurrency(this.kdtControl.getRow(2).getCell(2).getValue().toString().equals("true") ? 1 : 0);
        ctlInfo.setIsCountAccrual(this.kdtControl.getRow(3).getCell(2).getValue().toString().equals("true") ? 1 : 0);
        ctlInfo.setIsQty(this.kdtControl.getRow(4).getCell(2).getValue().toString().equals("true") ? 1 : 0);
        ctlInfo.setAc(this.kdtControl.getRow(5).getCell(2).getValue().toString().equals("true") ? 1 : 0);
        ctlInfo.setControl(this.kdtControl.getRow(6).getCell(2).getValue().toString().equals("true") ? 1 : 0);
        this.editData.getControl().add(ctlInfo);
    }

    @Override
    public void loadFields() {
        this.setEditStatus();
        this.kdtUserLevel.checkParsed();
        KDFormattedTextField intFormatter = new KDFormattedTextField();
        intFormatter.setDataType(0);
        intFormatter.setPrecision(0);
        intFormatter.setValue((Object)new Integer(2));
        intFormatter.setMinimumValue((Comparable)new Integer(1));
        intFormatter.setMaximumValue((Comparable)new Integer(9999));
        intFormatter.setDataVerifierType(12);
        KDTDefaultCellEditor intCellEditor = new KDTDefaultCellEditor((JTextField)intFormatter);
        this.kdtUserLevel.getColumn(3).setEditor((ICellEditor)intCellEditor);
        this.clearUI();
        super.loadFields();
        this.loadCreateProperties();
        if (!this.getOprtState().equals("ADDNEW")) {
            int i;
            for (i = 0; i < this.cbxSeparator.getItemCount(); ++i) {
                if (!this.cbxSeparator.getItemAt(i).toString().equals(this.editData.getSeparator())) continue;
                this.cbxSeparator.setSelectedIndex(i);
                break;
            }
            this.kdtUserLevel.removeRows();
            for (i = 0; i < this.editData.getUserLevel().size(); ++i) {
                IRow row = this.kdtUserLevel.addRow();
                AccountUserLevelInfo userLevel = null;
                userLevel = AccountTools.getAccountUserLevelInfoByLevel(i + 1, this.editData.getUserLevel());
                row.getCell(0).setValue((Object)userLevel.getId());
                row.getCell(1).setValue((Object)userLevel.getAccountTable());
                row.getCell(2).setValue(userLevel.get("level"));
                row.getCell(3).setValue(userLevel.get("length"));
            }
            this.kdtUserLevel.getColumn("id").setWidth(0);
            this.kdtUserLevel.getColumn("id").setResizeable(false);
            this.kdtUserLevel.getColumn(1).setWidth(0);
            this.kdtUserLevel.getColumn(1).setResizeable(false);
            this.kdtUserLevel.getColumn(2).getStyleAttributes().setLocked(true);
            IAccountTable iAccountTable = null;
            try {
                iAccountTable = AccountTableFactory.getRemoteInstance();
                this.isUsedByAccoutView = iAccountTable.usedByAccountView((IObjectPK)new ObjectUuidPK(this.editData.getId()));
                if (this.isUsedByAccoutView) {
                    this.chkisUseSeparator.setEnabled(false);
                    this.cbxSeparator.setEnabled(false);
                    this.chkIsUserLevel.setEnabled(false);
                    if (this.editData.isIsUserLevel()) {
                        int maxAccountLevel = this.getMaxAccountLevel();
                        for (int i2 = 0; i2 < maxAccountLevel && i2 < this.kdtUserLevel.getRowCount(); ++i2) {
                            this.kdtUserLevel.getRow(i2).getStyleAttributes().setLocked(true);
                        }
                    }
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
        AccountClientUtils.setupUITitle((CoreUIObject)this, EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)ACCOUNT_TABLE));
    }

    private void loadCreateProperties() {
        if (this.editData != null) {
            if (this.editData.getCreateTime() != null) {
                this.txtCreateTime.setText(AccountTools.formatTime(this.editData.getCreateTime()));
            } else {
                this.txtCreateTime.setText(AccountTools.getMLTime());
            }
            if (this.editData.getCreator() != null) {
                UIHelper.loadMultiLangFields((KDMultiLangBox)this.mltCreator, (IObjectValue)this.editData.getCreator(), (String)"name");
            } else {
                UIHelper.loadMultiLangFields((KDMultiLangBox)this.mltCreator, (IObjectValue)SysContext.getSysContext().getCurrentUserInfo(), (String)"name");
            }
            if (this.editData.getCompany() != null) {
                UIHelper.loadMultiLangFields((KDMultiLangBox)this.mltCompanyName, (IObjectValue)this.editData.getCompany(), (String)"name");
            } else {
                UIHelper.loadMultiLangFields((KDMultiLangBox)this.mltCompanyName, (IObjectValue)this.currentCompany, (String)"name");
            }
        } else {
            this.txtCreateTime.setText(AccountTools.getMLTime());
            UIHelper.loadMultiLangFields((KDMultiLangBox)this.mltCreator, (IObjectValue)SysContext.getSysContext().getCurrentUserInfo(), (String)"name");
            UIHelper.loadMultiLangFields((KDMultiLangBox)this.mltCompanyName, (IObjectValue)this.currentCompany, (String)"name");
        }
    }

    private void setEditStatus() {
        if (this.getOprtState().equals("EDIT")) {
            this.actionSubmit.setEnabled(false);
            if (this.editData != null) {
                try {
                    Account_ControlInfo acctCtrlInfo;
                    IAccount_Control acctCtrl = Account_ControlFactory.getRemoteInstance();
                    EntityViewInfo evi = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)this.editData.getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)this.currentCompany.getId().toString()));
                    evi.setFilter(filter);
                    Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
                    if (acctCtrlCols != null && (acctCtrlInfo = acctCtrlCols.get(0)) != null && acctCtrlInfo.getSrcCompany() == null) {
                        this.actionSubmit.setEnabled(true);
                    }
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                }
            }
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        boolean isAllowEdit = true;
        ICUBDControl cubdControl = CUBDControlFactory.getRemoteInstance();
        try {
            CUBDControlInfo cubdControlInfo = cubdControl.getBDCtrlInfo(this.editData.getBOSType().toString(), SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            isAllowEdit = cubdControlInfo.isIsSubordinateEditable();
        }
        catch (BOSException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (!isAllowEdit) {
            throw new AccountException(AccountException.CUBD_CANNOT_EDITACCOUNTTABLE);
        }
        if (this.editData != null && this.editData.getId() != null) {
            AccountTools.checkAcctTable(this.currentCompany.getId().toString(), this.editData.getId().toString());
        }
        String tempOprState = this.getOprtState();
        this.setSave(false);
        this.setOprtState("EDIT");
        IObjectValue val = (IObjectValue)this.getUIContext().get("CURRENT.VO");
        this.getUIContext().put("CURRENT.VO", null);
        try {
            this.setDataObject(val);
        }
        catch (Exception ex) {
            this.setOprtState(tempOprState);
            this.getUIContext().put("CURRENT.VO", val);
            throw ex;
        }
        this.unLockUI();
        this.showMessageForStatus();
        this.initDataStatus();
        this.setDefaultFocused();
    }

    private int getMaxAccountLevel() throws EASBizException, BOSException {
        return AccountTableFactory.getRemoteInstance().getMaxAccoutLevel((IObjectPK)new ObjectUuidPK(this.editData.getId()));
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
    }

    @Override
    public void storeFields() {
        int count;
        super.storeFields();
        this.editData.setIsControlNumber(true);
        this.editData.setIsUseSeparator(this.chkisUseSeparator.isSelected());
        this.editData.setIsUserLevel(this.chkIsUserLevel.isSelected());
        this.editData.setSeparator(this.cbxSeparator.getSelectedItem().toString());
        AccountUserLevelInfo levelInfo = null;
        AccountUserLevelCollection levelc = new AccountUserLevelCollection();
        for (int k = count = this.editData.getUserLevel().size(); k > 0; --k) {
            this.editData.getUserLevel().removeObject(k - 1);
        }
        if (this.chkIsUserLevel.isSelected() && this.kdtUserLevel.getRowCount() > 0) {
            for (int i = 0; i < this.kdtUserLevel.getRowCount(); ++i) {
                levelInfo = new AccountUserLevelInfo();
                IRow irow = null;
                irow = this.kdtUserLevel.getRow(i);
                if (irow == null) continue;
                if (irow.getCell("id").getValue() != null) {
                    levelInfo.setId(BOSUuid.read((String)irow.getCell("id").getValue().toString()));
                }
                if (irow.getCell("accounttableid") != null) {
                    levelInfo.setAccountTable((AccountTableInfo)irow.getCell("accounttableid").getValue());
                } else {
                    levelInfo.setAccountTable(this.editData);
                }
                levelInfo.setLevel(Integer.parseInt(irow.getCell("level").getValue().toString()));
                if (irow.getCell("length").getValue() == null) {
                    String s = EASResource.getString((String)"com.kingdee.eas.basedata.master.account.ACCOUNTAutoGenerateResource", (String)"110_AccountTableEditUIMerge");
                    MessageFormat mf = new MessageFormat(s);
                    String result = mf.format(new Object[]{new Integer(i + 1)});
                    MsgBox.showWarning((Component)((Object)this), (String)result);
                    SysUtil.abort();
                }
                levelInfo.setLength(Integer.parseInt(irow.getCell("length").getValue().toString()));
                levelc.add(levelInfo);
                levelInfo = new AccountUserLevelInfo();
            }
            this.editData.getUserLevel().addCollection(levelc);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return AccountTableFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        AccountTableInfo info = new AccountTableInfo();
        info.setName(null);
        info.setNumber(null);
        info.setDescription(null);
        info.setIsUseSeparator(true);
        info.setSeparator(".");
        info.setIsUserLevel(true);
        info.setIsControlNumber(true);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setCompany(this.currentCompany);
        return info;
    }

    private void createTableTitle() {
        IRow iRow;
        int headRowCount = 1;
        String[] strHeaders = new String[]{EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"ID"), EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"property"), EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"blocControl")};
        for (int j = 0; j < strHeaders.length; ++j) {
            IColumn iCol = this.kdtControl.addColumn(j);
            if (j == 0) continue;
            iCol.setWidth(258);
        }
        for (int i = 0; i < headRowCount; ++i) {
            iRow = this.kdtControl.addHeadRow(i);
            for (int j = 0; j < strHeaders.length; ++j) {
                ICell iCell = iRow.getCell(j);
                iCell.setValue((Object)strHeaders[j]);
            }
        }
        for (int g = 0; g < 7; ++g) {
            iRow = this.kdtControl.addRow(g);
            String resName = "";
            switch (g) {
                case 0: {
                    resName = "dc";
                    break;
                }
                case 1: {
                    resName = "currency";
                    break;
                }
                case 2: {
                    resName = "ChangeCurrency";
                    break;
                }
                case 3: {
                    resName = "CountAccrual";
                    break;
                }
                case 4: {
                    resName = "Qty";
                    break;
                }
                case 5: {
                    resName = "ac";
                    break;
                }
                case 6: {
                    resName = "control";
                    break;
                }
                default: {
                    resName = "";
                }
            }
            String strName = EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)resName);
            iRow.getCell(0).setValue((Object)String.valueOf(g));
            iRow.getCell(1).setValue((Object)strName);
            iRow.getCell(2).setValue((Object)new Boolean(false));
        }
        this.kdtControl.getColumn(0).setWidth(0);
        this.kdtControl.getColumn(0).setResizeable(false);
    }

    private void clearUI() {
        this.chkisUseSeparator.setEnabled(true);
        this.cbxSeparator.setEnabled(true);
        this.chkIsUserLevel.setEnabled(true);
        this.chkisUseSeparator.setSelected(true);
        this.chkIsUserLevel.setSelected(true);
        if (this.kdtUserLevel.getRowCount() > 0) {
            this.kdtUserLevel.removeRows();
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (this.getOprtState().equals("ADDNEW")) {
            this.actionAddLine_actionPerformed(null);
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void chkisUseSeparator_actionPerformed(ActionEvent e) {
        this.cbxSeparator.setEnabled(this.chkisUseSeparator.isSelected());
    }

    @Override
    public void chkIsUserLevel_actionPerformed(ActionEvent e) {
        this.btnInsertLine.setEnabled(this.chkIsUserLevel.isSelected());
        this.btnDeleteLine.setEnabled(this.chkIsUserLevel.isSelected());
    }

    public void btnInsertLine_actionPerformed(ActionEvent e) {
        if (this.kdtUserLevel.getRowCount() >= 10) {
            String msg = EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"accountTableLevelTooLong");
            MessageFormat mf = new MessageFormat(msg);
            String result = mf.format(new String[]{Integer.toString(10)});
            MsgBox.showInfo((Component)((Object)this), (String)result);
        } else {
            this.kdtUserLevel.addRow();
            IRow irow = this.kdtUserLevel.getRow(this.kdtUserLevel.getRowCount() - 1);
            ICell icell = irow.getCell(1);
            icell.setValue((Object)this.editData);
            irow.setCell("accounttableid", icell);
            icell = irow.getCell(2);
            icell.setValue((Object)new Integer(this.kdtUserLevel.getRowCount()));
            irow.setCell("level", icell);
            icell = irow.getCell(3);
            if (irow.getRowIndex() == 0) {
                icell.setValue((Object)new Integer(4));
            } else {
                icell.setValue((Object)new Integer(2));
            }
            irow.setCell("length", icell);
            this.kdtUserLevel.getColumn(2).getStyleAttributes().setLocked(true);
        }
    }

    public void btnDeleteLine_actionPerformed(ActionEvent e) {
        int selectIndex = this.kdtUserLevel.getSelectManager().getActiveRowIndex();
        if (selectIndex < 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"SelectLines"));
        } else if (selectIndex != this.kdtUserLevel.getRowCount() - 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"MustIsLastLines"));
        } else {
            try {
                if (this.getOprtState().equals(OprtState.EDIT) && this.editData.isIsUserLevel() && selectIndex < this.getMaxAccountLevel()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"levelUsedByAccount"));
                } else {
                    this.kdtUserLevel.removeRow(selectIndex);
                    this.kdtUserLevel.updateUI();
                }
            }
            catch (Exception e1) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                super.abort();
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            throw new AccountException(AccountException.ACCOUNTTABLENUMBLANK);
        }
        if (this.editData.getName() == null || this.editData.getName().trim().length() == 0) {
            throw new AccountException(AccountException.ACCOUNTTABLENAMEBANK);
        }
        if (!this.chkisUseSeparator.isSelected() && !this.chkIsUserLevel.isSelected()) {
            throw new AccountException(AccountException.MUSTHASONECHECKED);
        }
        if (this.chkIsUserLevel.isSelected() && this.kdtUserLevel.getRowCount() < 1) {
            throw new AccountException(AccountException.MUSTHASONEUSERLEVEL);
        }
    }

    public boolean isModify() {
        return super.isModify();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("userLevel.*"));
        sic.add("CU.name");
        sic.add("company.name");
        sic.add("creator.name");
        return sic;
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkAddNew(null, this.currentCompany)) {
            super.actionAddNew_actionPerformed(e);
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"cannotadd"));
        }
        this.btnInsertLine_actionPerformed(null);
    }

    public boolean checkAddNew(Context context, CompanyOrgUnitInfo child) throws BOSException, EASBizException {
        boolean checkinfo = false;
        ICUBDControl cuBdCtrl = context == null ? CUBDControlFactory.getRemoteInstance() : CUBDControlFactory.getLocalInstance((Context)context);
        AccountTableInfo acctTblInfo = new AccountTableInfo();
        try {
            CUBDControlInfo cuBdCtrlInfo = cuBdCtrl.getBDCtrlInfo(acctTblInfo.getBOSType().toString(), child.getCU().getId().toString());
            checkinfo = cuBdCtrlInfo.isIsSubordinateAddnewable();
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return checkinfo;
    }

    public boolean checkAddNew(Context context, CtrlUnitInfo child) throws BOSException, EASBizException {
        boolean checkinfo = false;
        ICUBDControl cuBdCtrl = context == null ? CUBDControlFactory.getRemoteInstance() : CUBDControlFactory.getLocalInstance((Context)context);
        AccountTableInfo acctTblInfo = new AccountTableInfo();
        try {
            CUBDControlInfo cuBdCtrlInfo = cuBdCtrl.getBDCtrlInfo(acctTblInfo.getBOSType().toString(), child.getId().toString());
            checkinfo = cuBdCtrlInfo.isIsSubordinateAddnewable();
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return checkinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeByPK(IObjectPK pk) throws Exception {
        String tempState = this.getOprtState();
        this.setOprtState("REMOVE");
        try {
            this.pubFireVOChangeListener(pk.toString());
        }
        catch (Throwable e) {
            this.setOprtState(tempState);
            this.handUIException(e);
            this.abort();
        }
        try {
            ((IAccountTable)this.getBizInterface()).delete(pk, this.currentCompany);
            this.editData = null;
        }
        finally {
            this.setOprtState(tempState);
            this.initOldData(null);
        }
        this.idList.remove(pk.toString(), false);
        if (this.idList.size() > 0) {
            if (this.actionNext.isEnabled()) {
                this.actionNext_actionPerformed(null);
            } else {
                this.actionPre_actionPerformed(null);
            }
        } else {
            try {
                this.setOprtState("RELEASEALL");
                this.pubFireVOChangeListener(pk.toString());
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.setOprtState("ADDNEW");
            IObjectValue value = this.createNewData();
            if (value != null) {
                this.setDataObject(value);
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.confirm_close"));
                this.destroyWindow();
            }
            this.loadFields();
            if (this.idList.size() == 0) {
                this.actionEdit.setEnabled(false);
            }
        }
        this.setSave(true);
        this.setSaved(true);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo child = this.currentCompany;
        boolean checkinfo = false;
        ICUBDControl cuBdCtrl = CUBDControlFactory.getRemoteInstance();
        AccountTableInfo acctTblInfo = new AccountTableInfo();
        try {
            CUBDControlInfo cuBdCtrlInfo = cuBdCtrl.getBDCtrlInfo(acctTblInfo.getBOSType().toString(), child.getCU().getId().toString());
            checkinfo = cuBdCtrlInfo.isIsSubordinateDeletable();
        }
        catch (BOSException ee) {
            this.handleException((Exception)((Object)ee));
        }
        if (checkinfo) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            if (this.confirmRemove()) {
                this.removeByPK((IObjectPK)pk);
            }
        } else {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"cannotdel"));
        }
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK userPK = CommonUtil.convert2PK((String)SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        IObjectPK orgPK = CommonUtil.convert2PK((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        boolean hasPermission = PermissionFactory.getRemoteInstance().hasFunctionPermission(userPK, orgPK, "bd_account_accountTable_addNew");
        if (!hasPermission) {
            throw new AccountException(AccountException.NO_ACCOUNT_TABLE_ADD_PERMISSION);
        }
        AccountTableInfo oldInfo = this.editData;
        boolean isUseSeparator = oldInfo.isIsUseSeparator();
        boolean isUserLevel = oldInfo.isIsUserLevel();
        String separator = oldInfo.getSeparator();
        int selectedSeparator = this.cbxSeparator.getSelectedIndex();
        AccountUserLevelCollection userLevelColls = oldInfo.getUserLevel();
        super.actionCopy_actionPerformed(e);
        Timestamp createTime = AccountTools.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyy-MM-dd HH:MM:SS");
        this.txtCreateTime.setText(format.format(createTime));
        UIHelper.loadMultiLangFields((KDMultiLangBox)this.mltCreator, (IObjectValue)SysContext.getSysContext().getCurrentUserInfo(), (String)"name");
        UIHelper.loadMultiLangFields((KDMultiLangBox)this.mltCompanyName, (IObjectValue)this.currentCompany, (String)"name");
        this.editData.setCreateTime(createTime);
        this.editData.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        this.editData.setCompany(this.currentCompany);
        this.txtCreateTime.setEnabled(false);
        this.mltCompanyName.setEnabled(false);
        this.mltCreator.setEnabled(false);
        this.editData.setIsUserLevel(isUserLevel);
        this.editData.setIsUseSeparator(isUseSeparator);
        this.editData.setSeparator(separator);
        this.cbxSeparator.setSelectedIndex(selectedSeparator);
        if (isUserLevel && !userLevelColls.isEmpty()) {
            Iterator it = userLevelColls.iterator();
            while (it.hasNext()) {
                AccountUserLevelInfo level = (AccountUserLevelInfo)it.next();
                this.btnInsertLine_actionPerformed(e);
                IRow row = this.kdtUserLevel.getRow(this.kdtUserLevel.getRowCount() - 1);
                ICell cell = row.getCell("length");
                cell.setValue((Object)level.getLength());
            }
        }
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.currentCompany != null && action != null) {
            ObjectUuidPK orgPk = new ObjectUuidPK(this.currentCompany.getId());
            action.putValue("ORG.PK", (Object)orgPk);
            return orgPk;
        }
        return super.getOrgPK(action);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.btnInsertLine_actionPerformed(e);
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        this.btnDeleteLine_actionPerformed(e);
    }
}

