/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.Account_ControlCollection;
import com.kingdee.eas.basedata.master.account.Account_ControlFactory;
import com.kingdee.eas.basedata.master.account.Account_ControlInfo;
import com.kingdee.eas.basedata.master.account.IAccountTable;
import com.kingdee.eas.basedata.master.account.IAccount_Control;
import com.kingdee.eas.basedata.master.account.client.AbstractAccountTableListUI;
import com.kingdee.eas.basedata.master.account.client.AccountClientUtils;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.dynbusiness.util.SortUtil;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public class AccountTableListUI
extends AbstractAccountTableListUI {
    private CompanyOrgUnitInfo company = null;
    private OrgUnitInfo[] mainOrgs = null;
    private int idxDefaultMainOrg = -1;
    private OrgUnitInfo mainOrg = null;
    private final String PERMISSION_ITEM = "bd_account_accountTable_view";

    public String getUITitle() {
        String resFullName = "com.kingdee.eas.basedata.master.account.client.AccountResource.accountTable";
        String returnValue = EASResource.getString((String)resFullName);
        return returnValue;
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkAddNew(null, this.company)) {
            super.actionAddNew_actionPerformed(e);
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"cannotadd"));
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String acctTableID = this.getSelectedKeyValue();
        if (acctTableID != null) {
            AccountTools.checkAcctTable(this.company.getId().toString(), acctTableID);
        }
        boolean isAllowEdit = true;
        ICUBDControl cubdControl = CUBDControlFactory.getRemoteInstance();
        try {
            CUBDControlInfo cubdControlInfo = cubdControl.getBDCtrlInfo("17698E6D", SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            isAllowEdit = cubdControlInfo.isIsSubordinateEditable();
        }
        catch (BOSException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (!isAllowEdit) {
            throw new AccountException(AccountException.CUBD_CANNOT_EDITACCOUNTTABLE);
        }
        super.actionEdit_actionPerformed(e);
    }

    public boolean checkAddNew(Context context, CompanyOrgUnitInfo child) throws BOSException, EASBizException {
        boolean checkinfo = false;
        ICUBDControl cuBdCtrl = context == null ? CUBDControlFactory.getRemoteInstance() : CUBDControlFactory.getLocalInstance((Context)context);
        AccountTableInfo acctTblInfo = new AccountTableInfo();
        try {
            CUBDControlInfo cuBdCtrlInfo = cuBdCtrl.getBDCtrlInfo(acctTblInfo.getBOSType().toString(), child.getCU().getId().toString());
            checkinfo = cuBdCtrlInfo.isIsSubordinateAddnewable();
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return checkinfo;
    }

    public boolean checkAddNew(Context context, CtrlUnitInfo child) throws BOSException, EASBizException {
        boolean checkinfo = false;
        ICUBDControl cuBdCtrl = context == null ? CUBDControlFactory.getRemoteInstance() : CUBDControlFactory.getLocalInstance((Context)context);
        AccountTableInfo acctTblInfo = new AccountTableInfo();
        try {
            CUBDControlInfo cuBdCtrlInfo = cuBdCtrl.getBDCtrlInfo(acctTblInfo.getBOSType().toString(), child.getId().toString());
            checkinfo = cuBdCtrlInfo.isIsSubordinateAddnewable();
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return checkinfo;
    }

    public void onLoad() throws Exception {
        NewCompanyF7 companyf7 = this.generateCompanyF7();
        this.prmtCompany.setSelector((KDPromptSelector)companyf7);
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company);
        this.prmtCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        if (this.getDefaultMainBizOrg() instanceof CompanyOrgUnitInfo) {
            this.company = (CompanyOrgUnitInfo)this.getDefaultMainBizOrg();
        }
        if (this.company == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"CurrentOrgIsNotCompany"));
            SysUtil.abort();
        } else {
            this.prmtCompany.setValue((Object)this.company);
        }
        this.actionQuery.setVisible(false);
        super.onLoad();
        this.actionQuery.setVisible(true);
    }

    private NewCompanyF7 generateCompanyF7() {
        NewCompanyF7 companyF7 = new NewCompanyF7();
        companyF7.setShowAssistantOrg(true);
        companyF7.setIsCUFilter(false);
        companyF7.setShowSub(true);
        companyF7.setPermissionItem("bd_account_accountTable_view");
        return companyF7;
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setAccountTableVisibilityByCompany();
    }

    private void setAccountTableVisibilityByCompany() {
        ArrayList<String> tableIdList = new ArrayList<String>();
        this.company = SysContext.getSysContext().getCurrentFIUnit();
        try {
            IAccount_Control acctCtrl = Account_ControlFactory.getRemoteInstance();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("destCompany", (Object)this.company.getId().toString()));
            evi.setFilter(filter);
            Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
            if (acctCtrlCols != null) {
                int count = acctCtrlCols.size();
                for (int i = 0; i < count; ++i) {
                    Account_ControlInfo acctCtrlInfo = acctCtrlCols.get(i);
                    tableIdList.add(acctCtrlInfo.getAccountTableID().getId().toString());
                }
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        int count = this.tblMain.getRowCount();
        for (int i = count - 1; i > -1; --i) {
            IRow row = this.tblMain.getRow(i);
            row.getStyleAttributes().setLocked(true);
            String id = row.getCell("id").getValue().toString();
            if (tableIdList.contains(id)) {
                row.getStyleAttributes().setHided(false);
            } else {
                row.getStyleAttributes().setHided(true);
            }
            if (this.company.getAccountTable() != null && this.company.getAccountTable().getId() != null && this.company.getAccountTable().getId().toString().equals(id)) {
                row.getCell("useStatus").setValue((Object)Boolean.TRUE);
                continue;
            }
            row.getCell("useStatus").setValue((Object)Boolean.FALSE);
        }
    }

    private void setAccountTableVisibilityByCU() {
        ArrayList<String> tableIdList = new ArrayList<String>();
        try {
            IAccount_Control acctCtrl = Account_ControlFactory.getRemoteInstance();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("destCu", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString()));
            evi.setFilter(filter);
            Account_ControlCollection acctCtrlCols = acctCtrl.getAccount_ControlCollection(evi);
            if (acctCtrlCols != null) {
                int count = acctCtrlCols.size();
                for (int i = 0; i < count; ++i) {
                    Account_ControlInfo acctCtrlInfo = acctCtrlCols.get(i);
                    tableIdList.add(acctCtrlInfo.getAccountTableID().getId().toString());
                }
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        int count = this.tblMain.getRowCount();
        for (int i = count - 1; i > -1; --i) {
            IRow row = this.tblMain.getRow(i);
            String id = row.getCell("id").getValue().toString();
            if (tableIdList.contains(id)) continue;
            this.tblMain.removeRow(i);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.setAccountTableVisibilityByCompany();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected String getEditUIName() {
        return "com.kingdee.eas.basedata.master.account.client.AccountTableEditUI";
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        IAccountTable iAccountTable = AccountTableFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        return iAccountTable;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.setAccountTableVisibilityByCompany();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        String sql = "select faccounttableid  from t_bd_acct_contorl where fdestcompanyid ='" + this.company.getId().toString() + "'";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        return filter;
    }

    protected boolean isOrderForClickTableHead() {
        return true;
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo child = this.company;
        boolean checkinfo = false;
        ICUBDControl cuBdCtrl = CUBDControlFactory.getRemoteInstance();
        AccountTableInfo acctTblInfo = new AccountTableInfo();
        try {
            CUBDControlInfo cuBdCtrlInfo = cuBdCtrl.getBDCtrlInfo(acctTblInfo.getBOSType().toString(), child.getCU().getId().toString());
            checkinfo = cuBdCtrlInfo.isIsSubordinateDeletable();
        }
        catch (BOSException ee) {
            this.handleException((Exception)((Object)ee));
        }
        if (checkinfo) {
            super.actionRemove_actionPerformed(e);
        } else {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"cannotdel"));
        }
    }

    @Override
    protected void Remove() throws Exception {
        String selectID = null;
        selectID = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(selectID);
        ((IAccountTable)this.getBizInterface()).delete((IObjectPK)pk, this.company);
        ActionEvent event = new ActionEvent(this.btnRefresh, 0, "Refresh");
        this.actionRefresh_actionPerformed(event);
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtCompany.getData() != null && this.prmtCompany.getData() instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo companyOrgUnitInfo;
            this.company = companyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtCompany.getData();
            this.initUIMainOrgContext(this.company.getId().toString());
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"currentCompanyNull"));
            this.prmtCompany.setData((Object)this.company);
            SysUtil.abort();
        }
        FilterInfo filter = new FilterInfo();
        String sql = "select faccounttableid  from t_bd_acct_contorl where fdestcompanyid ='" + this.company.getId().toString() + "'";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        EntityViewInfo entryViewInfo = new EntityViewInfo();
        entryViewInfo.setFilter(filter);
        this.mainQuery = entryViewInfo;
        ActionEvent event = new ActionEvent(this.btnRefresh, 0, "Refresh");
        this.actionRefresh_actionPerformed(event);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"CurrentCompany", (Object)this.company);
    }

    protected void initContextOrg() {
        this.initUIMainOrgContext(this.company.getId().toString());
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (this.company != null && action != null) {
            ObjectUuidPK orgPk = new ObjectUuidPK(this.company.getId());
            action.putValue("ORG.PK", (Object)orgPk);
            return orgPk;
        }
        return super.getOrgPK(action);
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        OrgUnitInfo currentMainOrg;
        if (this.mainOrg != null) {
            return this.mainOrg;
        }
        if (this.idxDefaultMainOrg > -1) {
            return this.mainOrgs[this.idxDefaultMainOrg];
        }
        if (this.mainOrgs == null) {
            try {
                this.mainOrgs = AccountClientUtils.getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), "bd_account_accountTable_view");
                if (this.mainOrgs == null || this.mainOrgs.length == 0) {
                    return null;
                }
                if (this.mainOrgs.length > 0) {
                    this.mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])this.mainOrgs, (boolean)true);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if ((currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType())) != null && this.mainOrgs.length > 0) {
            for (int i = 0; i < this.mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(this.mainOrgs[i].getId().toString())) continue;
                this.idxDefaultMainOrg = i;
                return currentMainOrg;
            }
        }
        if (this.mainOrgs.length > 0) {
            this.idxDefaultMainOrg = 0;
            return this.mainOrgs[0];
        }
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        this.setAccountTableVisibilityByCompany();
    }
}

