/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.basedata.master.account.client.AbstractAcctRefContrastConsoleUI;
import com.kingdee.eas.basedata.master.account.client.AcctRefContrastEditUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.framework.client.mutex.DataObjectMutex;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AcctRefContrastConsoleUI
extends AbstractAcctRefContrastConsoleUI {
    private static final Logger logger = CoreUIObject.getLogger(AcctRefContrastConsoleUI.class);
    private static final String RESOURCE = "com.kingdee.eas.basedata.master.account.AcctRefContrastResource";
    boolean isDeleting = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAddNew.setVisible(false);
        this.btnEnableNewAcct.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnDisableNewAcct.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnQuery.setVisible(true);
        this.btnQuery.setEnabled(true);
        this.menuImportCompanyRefProfit.setEnabled(true);
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    AcctRefContrastConsoleUI.this.tableSelectChange(e);
                }
                catch (Exception exc) {
                    AcctRefContrastConsoleUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void tableSelectChange(KDTSelectEvent e) throws Exception {
        String acctRefID = this.getSelectedKeyValue();
        if (acctRefID != null) {
            boolean isEnalbed = this.getBizInterface().exists("where id='" + acctRefID + "' and isEnabled = 1");
            this.actionEnableNewAcct.setEnabled(!isEnalbed);
            this.actionDisableNewAcct.setEnabled(isEnalbed);
        }
    }

    protected String getEditUIName() {
        return AcctRefContrastCrossEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AccountRefContrastFactory.getRemoteInstance();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("refType", (Object)3, CompareType.EQUALS));
        try {
            Set set = PermissionFactory.getRemoteInstance().getAuthorizedOrgIds((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), OrgType.Company, null, "bd_account_accountRefContrast_view");
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)set, CompareType.INCLUDE));
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionEnableNewAcct_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        StringBuilder sb = new StringBuilder();
        ArrayList acctRefIDs = this.getSelectedIdValues();
        Set set = PermissionFactory.getRemoteInstance().getAuthorizedOrgIds((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), OrgType.Company, null, "bd_account_accountRefContrast_enable");
        DataObjectMutex mutextControl = new DataObjectMutex();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.name"));
        ListUiHelper listUiHelper = new ListUiHelper();
        Map rowNumMap = listUiHelper.getSelectRowNumberMap(this.tblMain, "id");
        String rowIndexMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.account.AcctRefContrastResource.Msg_EnableFail_ByRowIndex");
        for (int i = 0; i < acctRefIDs.size(); ++i) {
            String acctRefID = (String)acctRefIDs.get(i);
            AccountRefContrastInfo accountRefContrast = ((IAccountRefContrast)this.getBizInterface()).getAccountRefContrastInfo((IObjectPK)new ObjectUuidPK(acctRefID), sic);
            if (set.contains(accountRefContrast.getCompany().getId().toString())) {
                try {
                    mutextControl.requestDataObjectLock(acctRefID);
                }
                catch (Throwable ex) {
                    this.handUIException(ex);
                    this.abort();
                }
                try {
                    ((IAccountRefContrast)this.getBizInterface()).enableNewAcctTable(acctRefID);
                    continue;
                }
                catch (Exception e1) {
                    sb.append(MessageFormat.format(rowIndexMsg, rowNumMap.get(acctRefID))).append(",");
                    if (e1 instanceof BOSException && e1.getCause() != null) {
                        sb.append(e1.getCause().getMessage()).append("\n");
                        continue;
                    }
                    sb.append(e1.getMessage()).append("\n");
                    continue;
                }
                finally {
                    mutextControl.releaseDataObjectLock(acctRefID);
                }
            }
            sb.append(MessageFormat.format(rowIndexMsg, rowNumMap.get(acctRefID))).append(",");
            sb.append(EASResource.getString((String)"com.kingdee.eas.basedata.master.account.AcctRefContrastResource.NO_ENABLE_ACCTREF_PERM", (Object[])new String[]{accountRefContrast.getCompany().getName()})).append("\n");
        }
        if (sb.length() > 1) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.AcctRefContrastResource.Msg_EnableError"), (String)sb.toString(), (int)1);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.AcctRefContrastResource.enableSuccess"));
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.basedata.master.account.AcctRefContrastResource.enableSuccess"));
            this.showMessage();
        }
        this.refreshList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionDisableNewAcct_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        StringBuilder sb = new StringBuilder();
        ArrayList acctRefIDs = this.getSelectedIdValues();
        Set set = PermissionFactory.getRemoteInstance().getAuthorizedOrgIds((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), OrgType.Company, null, "bd_account_accountRefContrast_disable");
        DataObjectMutex mutextControl = new DataObjectMutex();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.name"));
        ListUiHelper listUiHelper = new ListUiHelper();
        Map rowNumMap = listUiHelper.getSelectRowNumberMap(this.tblMain, "id");
        String rowIndexMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.account.AcctRefContrastResource.Msg_DisableFail_ByRowIndex");
        for (int i = 0; i < acctRefIDs.size(); ++i) {
            String acctRefID = (String)acctRefIDs.get(i);
            AccountRefContrastInfo accountRefContrast = ((IAccountRefContrast)this.getBizInterface()).getAccountRefContrastInfo((IObjectPK)new ObjectUuidPK(acctRefID), sic);
            if (set.contains(accountRefContrast.getCompany().getId().toString())) {
                try {
                    mutextControl.requestDataObjectLock(acctRefID);
                }
                catch (Throwable ex) {
                    this.handUIException(ex);
                    this.abort();
                }
                try {
                    ((IAccountRefContrast)this.getBizInterface()).disableNewAcctTable(acctRefID);
                    continue;
                }
                catch (Exception e1) {
                    sb.append(MessageFormat.format(rowIndexMsg, rowNumMap.get(acctRefID))).append(",");
                    if (e1 instanceof BOSException && e1.getCause() != null) {
                        sb.append(e1.getCause().getMessage()).append("\n");
                        continue;
                    }
                    sb.append(e1.getMessage()).append("\n");
                    continue;
                }
                finally {
                    mutextControl.releaseDataObjectLock(acctRefID);
                }
            }
            sb.append(MessageFormat.format(rowIndexMsg, rowNumMap.get(acctRefID))).append(",");
            sb.append(EASResource.getString((String)"com.kingdee.eas.basedata.master.account.AcctRefContrastResource.NO_DISABLE_ASSTREF_PERM", (Object[])new String[]{accountRefContrast.getCompany().getName()})).append("\n");
        }
        if (sb.length() > 1) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.AcctRefContrastResource.Msg_DisableError"), (String)sb.toString(), (int)1);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.AcctRefContrastResource.disableSuccess"));
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.basedata.master.account.AcctRefContrastResource.disableSuccess"));
            this.showMessage();
        }
        this.refreshList();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.isDeleting = true;
            super.actionRemove_actionPerformed(e);
        }
        finally {
            this.isDeleting = false;
        }
    }

    protected ArrayList getSelectedIdValues() {
        if (this.isDeleting) {
            ArrayList list = super.getSelectedIdValues();
            try {
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(list), CompareType.INCLUDE));
                SorterItemInfo si = new SorterItemInfo("company.longnumber");
                si.setSortType(SortType.DESCEND);
                SorterItemCollection sort = new SorterItemCollection();
                sort.add(si);
                ev.setSorter(sort);
                ev.setFilter(filter);
                AccountRefContrastCollection coll = AccountRefContrastFactory.getRemoteInstance().getAccountRefContrastCollection(ev);
                list.clear();
                for (int i = 0; i < coll.size(); ++i) {
                    list.add(coll.get(i).getId().toString());
                }
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            return list;
        }
        return super.getSelectedIdValues();
    }

    @Override
    public void actionImportCompanyRefProfit_actionPerformed(ActionEvent e) throws Exception {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.basedata.common.crossCompanyRefProfitCenter";
        Hashtable dataTaskCtx = new Hashtable();
        param.setContextParam(dataTaskCtx);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        if (param != null) {
            task.invoke(paramList, 0);
            this.refreshList();
        }
    }

    public static class AcctRefContrastCrossEditUI
    extends AcctRefContrastEditUI {
        AccountRefContrastInfo info = null;

        @Override
        protected CompanyOrgUnitInfo getCurrentCompany() {
            if (this.info == null) {
                String id = (String)this.getUIContext().get("ID");
                try {
                    this.info = AccountRefContrastFactory.getRemoteInstance().getAccountRefContrastInfo("select company.* where id='" + id + "'");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this.info == null ? super.getCurrentCompany() : this.info.getCompany();
        }
    }
}

