/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fi.gl.GLUtilPorcessFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountCashEnum;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.account.IAccountFacade;
import com.kingdee.eas.basedata.master.account.client.AbstractAssistChangeUI;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class AssistChangeUI
extends AbstractAssistChangeUI {
    private static final Logger logger = CoreUIObject.getLogger(AssistChangeUI.class);
    private List<AsstActTypeInfo> asstcol = null;
    private AccountViewInfo account = null;
    private AccountViewCollection coll = null;
    private boolean hasLeaf = false;
    private CompanyOrgUnitInfo currentCompany = null;
    private boolean isSelectTabSup = false;
    private boolean checkPeriod = false;
    private Map<String, List<AsstActTypeInfo>> asstActTypess = new HashMap<String, List<AsstActTypeInfo>>();

    public AssistChangeUI() throws Exception {
        this.kbpOldAsst.setDisplayFormat("$number$ $name$");
        this.kbpOldAsst.setEditFormat("$number$ $name$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        String currentCuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)currentCuId));
        filter.getFilterItems().add(new FilterItemInfo("DatabasedCU.id", (Object)currentCuId));
        filter.setMaskString("#0 or #1");
        this.kbpNewAsst.setQueryInfo("com.kingdee.eas.basedata.master.auxacct.app.F7AsstAccountForRefQuery");
        this.kbpNewAsst.setDisplayFormat("$number$ $name$");
        this.kbpNewAsst.setEditFormat("$number$");
        this.kbpNewAsst.setCommitFormat("$number$");
        this.promptLastPeriod.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
        this.promptEnablePeriod.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
        this.promptEnablePeriod.setEditFormat("$number$");
        this.promptEnablePeriod.setCommitFormat("$number$");
        this.tblUnit.checkParsed();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public static void queryByCondition(EntityViewInfo currentCondition, CoreUIObject owner, AccountTableInfo accaountTableInfo, String id, boolean onlyAssist) throws Exception {
        UIContext uiContext = new UIContext((Object)owner);
        uiContext.put((Object)"accaountTableInfo", (Object)accaountTableInfo);
        uiContext.put((Object)"accaountId", (Object)id);
        uiContext.put((Object)"onlyAssist", (Object)onlyAssist);
        String mode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)mode).create(AssistChangeUI.class.getName(), (Map)uiContext, null);
        uiWindow.show();
    }

    public static void queryByCondition(EntityViewInfo currentCondition, CoreUIObject owner, AccountTableInfo accaountTableInfo, List id, boolean onlyAssist, CompanyOrgUnitInfo company) throws Exception {
        UIContext uiContext = new UIContext((Object)owner);
        uiContext.put((Object)"accaountTableInfo", (Object)accaountTableInfo);
        uiContext.put((Object)"accaountId", (Object)id);
        uiContext.put((Object)"onlyAssist", (Object)onlyAssist);
        uiContext.put((Object)"CurrentCompany", (Object)company);
        uiContext.put((Object)"COMPANY", (Object)company);
        uiContext.put((Object)"CU", (Object)company.getCU());
        String mode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)mode).create(AssistChangeUI.class.getName(), (Map)uiContext, null);
        uiWindow.show();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kbpNewAsst.setFilterInfoProducer(new IFilterInfoProducer(){

            public FilterInfo getFilterInfo() {
                AssistChangeUI.this.currentCompany = (CompanyOrgUnitInfo)AssistChangeUI.this.getUIContext().get("CurrentCompany");
                EntityViewInfo evi = AccountTools.getAsstAccountReferenceFilter(AssistChangeUI.this.currentCompany);
                return evi.getFilter();
            }

            public void setCurrentCtrlUnit(CtrlUnitInfo cui) {
            }

            public void setCurrentMainBizOrgUnit(OrgUnitInfo oui, OrgType ot) {
            }
        });
        this.kbpNewAsst.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    AssistChangeUI.this.kbpNewAsst_dataChange(e);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    AssistChangeUI.this.handleException(e1);
                }
            }
        });
        this.initData();
        this.initMyIcon();
    }

    protected void initContextOrg() {
        this.currentCompany = (CompanyOrgUnitInfo)this.getUIContext().get("CurrentCompany");
        this.initUIMainOrgContext(this.currentCompany.getId().toString());
    }

    private void initData() throws Exception {
        AccountTableInfo accaountTableInfo = (AccountTableInfo)this.getUIContext().get("accaountTableInfo");
        EntityViewInfo evi = this.getAcctColl(SortType.DESCEND);
        this.coll = AccountViewFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).getAccountViewCollection(evi);
        HashSet<String> accountIds = new HashSet<String>();
        Iterator it = this.coll.iterator();
        String displayStr = "";
        while (it.hasNext()) {
            this.account = (AccountViewInfo)it.next();
            displayStr = displayStr + this.account.getNumber() + "-" + this.account.getName() + ";";
            if (!this.account.isIsLeaf()) continue;
            this.hasLeaf = true;
            accountIds.add(this.account.getId().toString());
        }
        displayStr = displayStr.substring(0, displayStr.length() - 1);
        this.kbpAccount.setValue((Object)this.coll);
        this.kbpAccount.setText(displayStr);
        this.kbpAccountTable.setValue((Object)accaountTableInfo);
        this.kbpOldAsst.setValue((Object)this.account.getCAA());
        if (this.account.getCAA() != null) {
            this.btnNoAsst.setSelected(false);
            this.kDRadioButton2.setSelected(true);
            this.asstcol = this.getAsstActTypes(this.account.getCAA().getId().toString());
        } else {
            this.btnNoAsst.setEnabled(false);
            this.kDRadioButton2.setSelected(true);
        }
        if (this.currentCompany.isIsBizUnit()) {
            PeriodInfo lastPeriod = null;
            AsstAccountChangeInfo change = AccountFacadeFactory.getRemoteInstance().getLastAsstAccountChange(accountIds);
            if (change != null) {
                lastPeriod = change.getPeriod();
            }
            if (lastPeriod == null) {
                lastPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.currentCompany);
            }
            this.promptLastPeriod.setValue((Object)lastPeriod);
            if (lastPeriod != null) {
                PeriodInfo enablePeriod = lastPeriod;
                PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.currentCompany);
                if (currentPeriod != null) {
                    PeriodInfo lp;
                    if (currentPeriod.getNumber() > enablePeriod.getNumber()) {
                        enablePeriod = currentPeriod;
                    }
                    if ((lp = this.getYearLastPeriod(enablePeriod.getPeriodYear())) != null && lp.getNumber() > enablePeriod.getNumber()) {
                        enablePeriod = lp;
                    }
                }
                boolean limited = true;
                HashMap param = new HashMap();
                param.put("AAC_Period_Limited", null);
                param = ParamControlFactory.getRemoteInstance().getParamHashMap(param);
                Object pv = param.get("AAC_Period_Limited");
                if (pv != null && "false".equals(pv.toString())) {
                    limited = false;
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.currentCompany.getAccountPeriodType().getId().toString()));
                int from = lastPeriod.getNumber();
                if (limited && currentPeriod != null) {
                    PeriodInfo lp = this.getYearLastPeriod(currentPeriod.getPeriodYear() - 1);
                    if (lp != null && lp.isIsAdjustPeriod() && lp.getNumber() > from) {
                        from = lp.getNumber();
                    } else if (currentPeriod.getPeriodYear() * 100 + 1 > from) {
                        from = currentPeriod.getPeriodYear() * 100 + 1;
                    }
                }
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)from, CompareType.GREATER_EQUALS));
                if (limited) {
                    int to = enablePeriod.getPeriodYear() + 1;
                    filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)to, CompareType.LESS_EQUALS));
                }
                this.promptEnablePeriod.setEntityViewInfo(view);
                this.promptEnablePeriod.setValue((Object)enablePeriod);
                this.checkPeriod = true;
            } else {
                this.promptEnablePeriod.setEnabled(false);
            }
        } else {
            this.promptEnablePeriod.setEnabled(false);
        }
    }

    private PeriodInfo getYearLastPeriod(int year) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("periodYear");
        selector.add("periodNumber");
        selector.add("isAdjustPeriod");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.currentCompany.getAccountPeriodType().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)year));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo item = new SorterItemInfo("number");
        item.setSortType(SortType.DESCEND);
        sorter.add(item);
        view.setSorter(sorter);
        PeriodCollection coll = PeriodFactory.getRemoteInstance().getPeriodCollection(view);
        if (coll != null && coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    private EntityViewInfo getAcctColl(SortType sortType) {
        ArrayList id = (ArrayList)this.getUIContext().get("accaountId");
        StringBuffer tempIds = new StringBuffer();
        for (int i = 0; i < id.size(); ++i) {
            tempIds.append(id.get(i) + ",");
        }
        String ids = tempIds.toString().substring(0, tempIds.length() - 1);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("CAA.*"));
        SorterItemCollection sorterColl = new SorterItemCollection();
        SorterItemInfo sorterNumber = new SorterItemInfo("number");
        sorterNumber.setSortType(sortType);
        sorterColl.add(sorterNumber);
        evi.setSelector(selector);
        evi.setSorter(sorterColl);
        evi.setFilter(filterInfo);
        return evi;
    }

    public static Object setSelectedItem(KDComboBox cb, Object obj) {
        ComboBoxModel model = cb.getModel();
        Object element = null;
        int n = model.getSize();
        for (int i = 0; i < n; ++i) {
            element = model.getElementAt(i);
            if (element instanceof IntEnum && obj instanceof Integer && ((IntEnum)element).getValue() == ((Integer)obj).intValue()) {
                cb.setSelectedIndex(i);
                break;
            }
            if (element instanceof IntEnum && obj instanceof IntEnum && ((IntEnum)element).getValue() == ((IntEnum)obj).getValue()) {
                cb.setSelectedIndex(i);
                break;
            }
            if (!(obj instanceof StringEnum) || !((StringEnum)element).getValue().equals(obj)) continue;
            cb.setSelectedIndex(i);
            break;
        }
        return element;
    }

    private void initMyIcon() {
        this.btnComfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
        boolean onlyAssist = (Boolean)this.getUIContext().get("onlyAssist");
        if (onlyAssist) {
            this.tpAccount.remove((Component)this.kDPanel3);
            this.setUITitle(this.tpAccount.getTitleAt(this.tpAccount.getSelectedIndex()));
        } else {
            this.tpAccount.remove((Component)this.kDPanel2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kbpNewAsst_dataChange(DataChangeEvent e) throws Exception {
        this.tblMain.removeRows();
        Object _newValue = e.getNewValue();
        if (_newValue == null || !(_newValue instanceof AsstAccountInfo)) {
            return;
        }
        AsstAccountInfo newValue = (AsstAccountInfo)e.getNewValue();
        if (newValue == null) {
            return;
        }
        List<AsstActTypeInfo> newasstcol = this.getAsstActTypes(newValue.getId().toString());
        for (int i = 0; i < newasstcol.size(); ++i) {
            IRow tbrow = this.tblMain.addRow();
            AsstActTypeInfo asstActInfo = newasstcol.get(i);
            tbrow.setUserObject((Object)asstActInfo);
            tbrow.getCell("type").setValue((Object)asstActInfo.getName());
            if (this.asstcol != null) {
                for (int j = 0; j < this.asstcol.size(); ++j) {
                    AsstActTypeInfo oldInfo = this.asstcol.get(j);
                    if (!asstActInfo.getId().toString().equals(oldInfo.getId().toString())) continue;
                    tbrow.getStyleAttributes().setLocked(true);
                    tbrow.getStyleAttributes().setBackground(new Color(191, 226, 253));
                }
            }
            try {
                asstActInfo.put("aacCompany", (Object)this.currentCompany);
                tbrow.getCell("dataBaseInfo").setEditor(GLUtilPorcessFactory.getGLUtilPorcess().getCellEditor(asstActInfo, (CoreUIObject)this));
                continue;
            }
            finally {
                asstActInfo.remove("aacCompany");
            }
        }
        if (!this.hasLeaf || !this.currentCompany.isIsBizUnit()) {
            this.tblMain.setEnabled(false);
        }
    }

    private List<AsstActTypeInfo> getAsstActTypes(String asstAccountId) throws BOSException {
        if (this.asstActTypess.containsKey(asstAccountId)) {
            return this.asstActTypess.get(asstAccountId);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("asstActType.id");
        evi.getSelector().add("asstActType.number");
        evi.getSelector().add("asstActType.name");
        evi.getSelector().add("asstActType.asstHGAttribute");
        evi.getSelector().add("asstActType.mappingFieldName");
        evi.getSelector().add("asstActType.defaultQueryName");
        evi.getSelector().add("asstActType.isForCompany");
        evi.getSelector().add("asstActType.defaultF7UI");
        evi.getSelector().add("asstActType.glAsstActTypeGrp.id");
        evi.getSelector().add("asstActType.isMultilevel");
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)asstAccountId));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("number"));
        AsstActGroupDetailCollection col = AsstActGroupDetailFactory.getRemoteInstance().getAsstActGroupDetailCollection(evi);
        ArrayList<AsstActTypeInfo> asstActTypes = new ArrayList<AsstActTypeInfo>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            asstActTypes.add(col.get(i).getAsstActType());
        }
        this.asstActTypess.put(asstAccountId, asstActTypes);
        return asstActTypes;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.isSelectTabSup()) {
            this.actionConfirmOther();
        } else {
            this.actionConfirmAsst();
        }
        AccountViewInfo accountViewInfo = new AccountViewInfo();
        CacheServiceFactory.getInstance().discardType(accountViewInfo.getBOSType());
        this.btnComfirm.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionCancel), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        String finished = EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"finished");
        this.btnComfirm.setText(finished);
        String exit = EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"exit");
        this.btnCancel.setText(exit);
        String msg = EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"changeSuccess");
        MsgBox.showInfo((Component)((Object)this), (String)msg);
    }

    public void actionConfirmOther() throws Exception {
        AccountViewInfo account = (AccountViewInfo)this.kbpAccount.getValue();
        AccountTableInfo accountTable = (AccountTableInfo)this.kbpAccountTable.getValue();
        HashMap<String, Object> data = new HashMap<String, Object>();
        String id = accountTable.getId().toString();
        ArrayList<String> cuList = new ArrayList<String>();
        if (!account.getDC().equals(this.kcbDC.getSelectedItem())) {
            data.put("FDC", new Integer(((BalanceDirectionEnum)((Object)this.kcbDC.getSelectedItem())).getValue()));
        }
        if (this.chkIsAc.isSelected() != account.isAC()) {
            data.put("FAC", this.chkIsAc.isSelected());
        }
        if (this.chkIsQty.isSelected() != account.isIsQty()) {
            data.put("FISQTY", this.chkIsQty.isSelected());
        }
        if (AccountCashEnum.CASH.equals(this.kcbCash.getSelectedItem())) {
            data.put("FISCASH", Boolean.TRUE);
        } else if (AccountCashEnum.BANK.equals(this.kcbCash.getSelectedItem())) {
            data.put("FISBANK", Boolean.TRUE);
        } else if (AccountCashEnum.EQUI.equals(this.kcbCash.getSelectedItem())) {
            data.put("fiscashequivalent", Boolean.TRUE);
        } else {
            data.put("FISCASH", Boolean.FALSE);
            data.put("FISBANK", Boolean.FALSE);
            data.put("FIscashequivalent", Boolean.FALSE);
        }
        data.put("FNumber", account.getNumber());
        int rowCount = this.tblUnit.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow rowAss = this.tblUnit.getRow(i);
            boolean isSelected = (Boolean)rowAss.getCell("select").getValue();
            if (!isSelected) continue;
            String cuid = (String)rowAss.getUserObject();
            cuList.add(cuid);
        }
        if (cuList.size() > 0) {
            this.getBizInterface().changeOthers(data, id, cuList);
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.ACCOUNTAutoGenerateResource", (String)"123_AssistChangeUI"));
            SysUtil.abort();
        }
        this.tblUnit.getStyleAttributes().setLocked(true);
    }

    public void actionConfirmAsst() throws Exception {
        String warnStr;
        Object _newValue;
        int r;
        PeriodInfo enablePeriod = (PeriodInfo)this.promptEnablePeriod.getValue();
        if (this.checkPeriod && enablePeriod == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.ACCOUNTAutoGenerateResource", (String)"AsstAccountChange_NoPeriod"));
            SysUtil.abort();
        }
        if (enablePeriod != null && !enablePeriod.isIsAdjustPeriod() && (r = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.ACCOUNTAutoGenerateResource", (String)"EnablePeriod_Not_Adjust"))) != 1) {
            SysUtil.abort();
        }
        if ((_newValue = this.kbpNewAsst.getValue()) == null || !(_newValue instanceof AsstAccountInfo)) {
            logger.error((Object)("\u8f85\u52a9\u8d26\u786e\u8ba4\u70b9\u51fb\uff1a \u5f53\u524d\u503c" + _newValue + ", \u53ef\u80fd\u6ca1\u6709\u6743\u9650\u9020\u6210\uff01"));
            this.kbpNewAsst.setValue(null);
        }
        AsstAccountInfo caa = (AsstAccountInfo)this.kbpNewAsst.getValue();
        String group = null;
        Map defaultVal = this.getDefaultVal();
        if (!this.btnNoAsst.isSelected()) {
            if (caa != null) {
                group = caa.getId().toString();
                if (this.account.getCAA() != null && group.equals(this.account.getCAA().getId().toString())) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.ACCOUNTAutoGenerateResource", (String)"124_AssistChangeUI"));
                    SysUtil.abort();
                }
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.ACCOUNTAutoGenerateResource", (String)"125_AssistChangeUI"));
                SysUtil.abort();
            }
        }
        boolean isNew = false;
        if (this.account.getCAA() == null && group != null) {
            isNew = true;
        }
        if (this.account.getCAA() != null) {
            if (group == null) {
                StringBuffer names = new StringBuffer();
                for (AsstActTypeInfo type : this.asstcol) {
                    if (names.length() > 0) {
                        names.append("\uff0c");
                    }
                    names.append(type.getName());
                }
                if (names.length() > 0 && MsgBox.isCancel((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"changeAsstWarning_empty", (Object[])new Object[]{names.toString()})))) {
                    SysUtil.abort();
                }
            } else {
                HashMap<String, AsstActTypeInfo> newAsstActTypes = new HashMap<String, AsstActTypeInfo>();
                List<AsstActTypeInfo> newasstcol = this.getAsstActTypes(group);
                for (AsstActTypeInfo type : newasstcol) {
                    newAsstActTypes.put(type.getId().toString(), type);
                }
                StringBuffer names = new StringBuffer();
                for (AsstActTypeInfo type : this.asstcol) {
                    if (newAsstActTypes.containsKey(type.getId().toString())) continue;
                    if (names.length() > 0) {
                        names.append(",");
                    }
                    names.append(type.getName());
                }
                if (names.length() > 0 && MsgBox.isCancel((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"changeAsstWarning_new", (Object[])new Object[]{names.toString()})))) {
                    SysUtil.abort();
                }
            }
        }
        if (!StringUtils.isEmpty((String)(warnStr = this.getBizInterface().batchChangeAsst(this.coll, group, defaultVal, isNew, enablePeriod)))) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"batchModifyAsstFail"), (String)warnStr.toString(), (int)2);
            SysUtil.abort();
        }
        this.tblMain.getStyleAttributes().setLocked(true);
        this.btnNoAsst.setEnabled(false);
        this.kDRadioButton2.setEnabled(false);
    }

    @Override
    protected void btnNoAsst_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnNoAsst.isSelected()) {
            this.kbpNewAsst.setValue(null);
            this.kbpNewAsst.setEnabled(false);
        } else {
            this.kbpNewAsst.setEnabled(true);
        }
    }

    @Override
    protected void tpAccount_stateChanged(ChangeEvent e) throws Exception {
        KDTabbedPane tabbedPane = (KDTabbedPane)e.getSource();
        if (tabbedPane.getSelectedIndex() == -1) {
            return;
        }
        this.isSelectTabSup = tabbedPane.getSelectedIndex() == 0 ? (this.isSelectTabSup ? false : false) : true;
    }

    protected boolean isSelectTabSup() {
        return this.isSelectTabSup;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    protected IAccountFacade getBizInterface() throws Exception {
        return AccountFacadeFactory.getRemoteInstance();
    }

    protected Map getDefaultVal() {
        HashMap<Object, Object> defaultVal = new HashMap<Object, Object>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow tbrow = this.tblMain.getRow(i);
            Object value = tbrow.getCell("dataBaseInfo").getValue();
            CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)this.getUIContext().get("CurrentCompany");
            if (value == null && !tbrow.getStyleAttributes().isLocked() && currentCompany.isIsBizUnit()) {
                Iterator it = this.coll.iterator();
                while (it.hasNext()) {
                    AccountViewInfo info = (AccountViewInfo)it.next();
                    if (!info.isIsLeaf()) continue;
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.account.ACCOUNTAutoGenerateResource", (String)"126_AssistChangeUI"));
                    SysUtil.abort();
                }
            }
            defaultVal.put(tbrow.getUserObject(), value);
        }
        return defaultVal;
    }
}

