/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AbstractAssistDataSyncToSubUI;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AssistDataSyncToSubUI
extends AbstractAssistDataSyncToSubUI {
    private static final Logger logger = CoreUIObject.getLogger(AssistDataSyncToSubUI.class);
    private CompanyOrgUnitInfo company = null;
    private AccountTableInfo accountTable = null;
    private AccountViewInfo account = null;
    private final String[] fields = new String[]{"borrowerMainCashFlowItem", "borrowerAttCashFlowItem", "lenderMainCashFlowItem", "lenderAttCashFlowItem", "helpCode", "isAllowCA"};
    private CommonQueryDialog cqdOrg;

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiCtx = this.getUIContext();
        this.company = (CompanyOrgUnitInfo)uiCtx.get("company");
        this.accountTable = (AccountTableInfo)uiCtx.get("accountTable");
        String accountID = (String)uiCtx.get("accountID");
        this.account = AccountViewFactory.getRemoteInstance().getAccountViewInfo("where id='" + accountID + "'");
        this.initWorkButton();
        this.initOrgCommonQueryDialog();
        this.initFields();
        this.initOrg();
        this.tblOrg.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                    AssistDataSyncToSubUI.this.tblOrg.getCell(i, 0).setValue((Object)false);
                }
            }
        });
    }

    private void initOrg() throws BOSException {
        this.queryCompanyOrgUnitQuery = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuilder sb = new StringBuilder("select FCompanyID from t_bd_accountview where ");
        sb.append(" FAccountTableID='").append(this.accountTable.getId().toString()).append("'").append(" AND FNumber='").append(this.account.getNumber()).append("'");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(this.company.getLongNumber() + "!%"), CompareType.LIKE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("simplename"));
        selector.add(new SelectorItemInfo("level"));
        selector.add(new SelectorItemInfo("isLeaf"));
        selector.add(new SelectorItemInfo("longnumber"));
        selector.add(new SelectorItemInfo("id"));
        this.queryCompanyOrgUnitQuery.setFilter(filter);
        this.queryCompanyOrgUnitQuery.setSelector(selector);
        SorterItemCollection sorts = new SorterItemCollection();
        sorts.add(new SorterItemInfo("longnumber"));
        this.queryCompanyOrgUnitQuery.setSorter(sorts);
        this.tblOrg.removeRows();
    }

    private void initFields() {
        this.listField.removeAllItems();
        Object[] items = new FieldInfo[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            items[i] = new FieldInfo(this.fields[i], EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)this.fields[i]));
        }
        this.listField.addItems(items);
    }

    private void initOrgCommonQueryDialog() {
        this.cqdOrg = new CommonQueryDialog();
        this.cqdOrg.setOwner((Component)((Object)this));
        this.cqdOrg.setQueryObjectPK(this.queryCompanyOrgUnitQueryPK);
        this.cqdOrg.setShowToolbar(false);
        this.cqdOrg.setWidth(640);
        this.cqdOrg.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.cqdOrg.setShowSorter(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSelAllOrg.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnUnSelOrg.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.actionSelAllOrg.setEnabled(true);
        this.actionUnSelOrg.setEnabled(true);
        this.save.setEnabled(true);
        this.orgQuery.setEnabled(true);
    }

    @Override
    public void actionSelAllOrg_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelAllOrg_actionPerformed(e);
        for (int i = 0; i < this.tblOrg.getRowCount(); ++i) {
            this.tblOrg.getRow(i).getCell(0).setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    public void actionUnSelOrg_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnSelOrg_actionPerformed(e);
        for (int i = 0; i < this.tblOrg.getRowCount(); ++i) {
            this.tblOrg.getRow(i).getCell(0).setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    public void actionOrgQuery_actionPerformed(ActionEvent e) throws Exception {
        String newOql;
        super.actionOrgQuery_actionPerformed(e);
        String oldOql = null;
        try {
            oldOql = this.cqdOrg.getEntityViewInfoResult().toString();
        }
        catch (Exception ex) {
            oldOql = "";
        }
        if (this.cqdOrg.show() && !(newOql = this.cqdOrg.getEntityViewInfoResult().toString()).equals(oldOql)) {
            this.tblOrg.removeRows();
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        try {
            List<Object> orgIds = this.getSelectOrgIds();
            if (orgIds.size() == 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                SysUtil.abort();
            }
            FieldInfo field = (FieldInfo)this.listField.getSelectedItem();
            AccountFacadeFactory.getRemoteInstance().batchSyncInferiorProperties(this.account.getId().toString(), field.getField(), orgIds);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.batch.client.BatchModifyResource", (String)"editSuccess"));
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    protected List<Object> getSelectOrgIds() {
        ArrayList<Object> cuList = new ArrayList<Object>();
        for (int i = 0; i < this.tblOrg.getRowCount(); ++i) {
            IRow row = this.tblOrg.getRow(i);
            if (row.getCell(0).getValue() != Boolean.TRUE) continue;
            cuList.add(row.getCell("id").getValue());
        }
        return cuList;
    }

    class FieldInfo {
        private String field;
        private String desc;

        public FieldInfo(String field, String desc) {
            this.setField(field);
            this.desc = desc;
        }

        public String toString() {
            return this.desc;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }
    }
}

