/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.base.permission.client.util.UITools;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountFacadeFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountViewParser;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeInfo;
import com.kingdee.eas.basedata.master.account.AsstChangeInfo;
import com.kingdee.eas.basedata.master.account.client.AbstractAsstBatchChangeUI;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class AsstBatchChangeUI
extends AbstractAsstBatchChangeUI {
    private static final Logger logger = CoreUIObject.getLogger(AsstBatchChangeUI.class);
    private static final String ACCOUNTRESOURCE = "com.kingdee.eas.basedata.master.account.client.AccountResource";
    private static Color normal = new Color(255, 255, 255);
    private CompanyOrgUnitInfo company = null;
    private AccountTableInfo accountTable = null;
    private Set companyIds = new HashSet();
    private Map peroidRangeMap = new HashMap();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiCtx = this.getUIContext();
        this.company = (CompanyOrgUnitInfo)uiCtx.get("company");
        this.accountTable = (AccountTableInfo)uiCtx.get("accountTable");
        DetailPanel detailPanel = new DetailPanel(this, this.dataBinder, this.tblMain, null, null, false){

            public void actionAddnewLine_actionPerformed(ActionEvent e) throws Exception {
                AsstBatchChangeUI.this.addCompany(AsstBatchChangeUI.this.tblMain.getRowCount());
            }

            public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
                int[] selectRows = KDTableUtil.getSelectedRows((KDTable)AsstBatchChangeUI.this.tblMain);
                int curRow = 0;
                curRow = selectRows.length > 0 ? selectRows[0] : AsstBatchChangeUI.this.tblMain.getRowCount();
                int curDown = curRow + 1;
                while (AsstBatchChangeUI.this.tblMain.getRow(curDown) != null && AsstBatchChangeUI.this.tblMain.getRow(curDown).getCell("company").getValue() == null) {
                    ++curDown;
                }
                AsstBatchChangeUI.this.addCompany(curDown);
            }

            public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
                AsstBatchChangeUI.this.removeCompany();
            }
        };
        this.add((Component)detailPanel, new KDLayout.Constraints(10, 58, 991, 557, 15));
        this.initAccountF7();
        this.initTable();
    }

    private void initTable() {
        this.tblMain.checkParsed();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        String currentCuId = this.company.getCU().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)currentCuId));
        filter.getFilterItems().add(new FilterItemInfo("DatabasedCU.id", (Object)currentCuId));
        filter.setMaskString("#0 or #1");
        KDBizPromptBox asstAccountF7 = new KDBizPromptBox();
        asstAccountF7.setQueryInfo("com.kingdee.eas.basedata.master.auxacct.app.F7AsstAccountForRefQuery");
        asstAccountF7.setDisplayFormat("$number$ $name$");
        asstAccountF7.setEditFormat("$number$");
        asstAccountF7.setCommitFormat("$number$");
        asstAccountF7.setHistoryRecordEnabled(false);
        asstAccountF7.setEditable(true);
        asstAccountF7.setFilterInfoProducer(new IFilterInfoProducer(){

            public FilterInfo getFilterInfo() {
                EntityViewInfo evi = AccountTools.getAsstAccountReferenceFilter(AsstBatchChangeUI.this.company);
                return evi.getFilter();
            }

            public void setCurrentCtrlUnit(CtrlUnitInfo cui) {
            }

            public void setCurrentMainBizOrgUnit(OrgUnitInfo oui, OrgType ot) {
            }
        });
        this.tblMain.getColumn("newAsst").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)asstAccountF7));
        KDBizPromptBox asstActType = new KDBizPromptBox();
        asstActType.setQueryInfo("com.kingdee.eas.basedata.master.auxacct.app.F7AsstActTypeQuery");
        asstActType.setDisplayFormat("$number$ $name$");
        asstActType.setEditFormat("$number$");
        asstActType.setCommitFormat("$number$");
        asstActType.setHistoryRecordEnabled(false);
        asstActType.setEditable(true);
        this.tblMain.getColumn("oldAsstType").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)asstActType));
        this.tblMain.getColumn("newAsstType").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)asstActType));
        KDBizPromptBox period = new KDBizPromptBox();
        period.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
        period.setDisplayFormat("$number$ $name$");
        period.setEditFormat("$number$");
        period.setCommitFormat("$number$");
        period.setHistoryRecordEnabled(false);
        period.setEditable(true);
        this.tblMain.getColumn("oldEffectiveTime").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)period));
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (AsstBatchChangeUI.this.tblMain.getColumnIndex("newAsst") == e.getColIndex()) {
                    try {
                        if (e.getOldValue() != null && !e.getOldValue().equals(e.getValue()) || e.getOldValue() == null && e.getValue() != null) {
                            AsstBatchChangeUI.this.refreshNewAsstActType(e.getRowIndex());
                        }
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            }
        });
    }

    private void initAccountF7() {
        AccountPromptBox f7Selector = new AccountPromptBox((IUIObject)this, this.accountTable, false);
        f7Selector.setCompanyInfo(this.company);
        this.prmtAccount.setSelector((KDPromptSelector)f7Selector);
        this.prmtAccount.setHistoryRecordEnabled(true);
        this.prmtAccount.setEditable(true);
        this.prmtAccount.setEditFormat("$number$");
        this.prmtAccount.setDisplayFormat("$number$");
        this.prmtAccount.setCommitFormat("$helpCode$;$number$;$name$;$longName$");
        this.prmtAccount.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.prmtAccount.setCommitParser((IParser)new AccountViewParser(this.prmtAccount));
        this.prmtAccount.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    AsstBatchChangeUI.this.refreshTable();
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
    }

    private void refreshTable() throws EASBizException, BOSException {
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        this.companyIds.clear();
        if (this.prmtAccount.getData() == null) {
            return;
        }
        AccountViewCollection coll = AccountViewFactory.getRemoteInstance().getAccountViewCollection(this.buildSubEntityView());
        int offset = 0;
        for (int i = 0; i < coll.size(); ++i) {
            AccountViewInfo info = coll.get(i);
            this.companyIds.add(info.getCompanyID().getId().toString());
            IRow row = this.tblMain.addRow(i + offset);
            offset += this.initRow(row, info);
        }
    }

    private int initRow(IRow row, AccountViewInfo info) throws EASBizException, BOSException {
        int offset = 0;
        row.setUserObject((Object)info);
        row.getCell("companyNumber").setValue((Object)info.getCompanyID().getNumber());
        row.getCell("company").setValue((Object)info.getCompanyID().getName());
        row.getCell("oldAsst").setValue((Object)(info.getCAA() == null ? EASResource.getString((String)ACCOUNTRESOURCE, (String)"ACCOUNT_ACC_NONE") : info.getCAA().getName()));
        this.setCellDisable(row, new String[]{"defaultValue", "oldEffectiveTime"});
        if (info.getCAA() == null) {
            row.getCell("oldAsstType").setValue((Object)EASResource.getString((String)ACCOUNTRESOURCE, (String)"ACCOUNT_ACC_NONE"));
        } else {
            AsstActGroupDetailCollection asstActGpDt = info.getCAA().getAsstActGpDt();
            for (int j = 0; j < asstActGpDt.size(); ++j) {
                if (j == 0) {
                    row.getCell("oldAsstType").setValue((Object)asstActGpDt.get(j).getAsstActType());
                    continue;
                }
                IRow row1 = this.tblMain.addRow(row.getRowIndex() + j);
                ++offset;
                row1.setUserObject((Object)info);
                row1.getCell("oldAsstType").setValue((Object)asstActGpDt.get(j).getAsstActType());
                this.setCellDisable(row1, new String[]{"company", "oldAsst", "newAsst", "defaultValue", "oldEffectiveTime", "newEffectiveTime"});
            }
        }
        if (info.getCompanyID().isIsBizUnit() && info.isIsLeaf()) {
            this.setCellEnable(row, new String[]{"newEffectiveTime"});
            this.fillPeroid(row, info);
        } else {
            this.setCellDisable(row, new String[]{"newEffectiveTime"});
        }
        return offset;
    }

    private EntityViewInfo buildEntityView(Set companyIds) {
        String number = ((AccountViewInfo)this.prmtAccount.getData()).getNumber();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)this.accountTable.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        ev.setFilter(filter);
        SelectorItemCollection items = new SelectorItemCollection();
        items.add(new SelectorItemInfo("*"));
        items.add(new SelectorItemInfo("companyID.*"));
        items.add(new SelectorItemInfo("companyID.accountPeriodType.*"));
        items.add(new SelectorItemInfo("caa.*"));
        items.add(new SelectorItemInfo("caa.asstActGpDt.asstActType.*"));
        ev.setSelector(items);
        SorterItemCollection sorts = new SorterItemCollection();
        sorts.add(new SorterItemInfo("companyID.longNumber"));
        ev.setSorter(sorts);
        return ev;
    }

    private EntityViewInfo buildSubEntityView() {
        String number = ((AccountViewInfo)this.prmtAccount.getData()).getNumber();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.longnumber", (Object)this.company.getLongNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyID.longnumber", (Object)(this.company.getLongNumber() + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)this.accountTable.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.setMaskString("(#0 or #1) and #2 and #3");
        ev.setFilter(filter);
        SelectorItemCollection items = new SelectorItemCollection();
        items.add(new SelectorItemInfo("*"));
        items.add(new SelectorItemInfo("companyID.*"));
        items.add(new SelectorItemInfo("companyID.accountPeriodType.*"));
        items.add(new SelectorItemInfo("caa.*"));
        items.add(new SelectorItemInfo("caa.asstActGpDt.asstActType.*"));
        ev.setSelector(items);
        SorterItemCollection sorts = new SorterItemCollection();
        sorts.add(new SorterItemInfo("companyID.longNumber"));
        ev.setSorter(sorts);
        return ev;
    }

    private void fillPeroid(IRow row, AccountViewInfo info) throws EASBizException, BOSException {
        PeriodInfo lastPeriod = null;
        AsstAccountChangeInfo change = AccountFacadeFactory.getRemoteInstance().getLastAsstAccountChange(info.getId().toString());
        if (change != null) {
            lastPeriod = change.getPeriod();
        }
        if (lastPeriod == null) {
            lastPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)info.getCompanyID());
        }
        row.getCell("oldEffectiveTime").setValue((Object)lastPeriod);
        if (lastPeriod != null) {
            PeriodInfo enablePeriod = lastPeriod;
            PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)info.getCompanyID());
            if (currentPeriod != null && currentPeriod.getNumber() > enablePeriod.getNumber()) {
                enablePeriod = currentPeriod;
            }
            boolean limited = true;
            HashMap param = new HashMap();
            param.put("AAC_Period_Limited", null);
            param = ParamControlFactory.getRemoteInstance().getParamHashMap(param);
            Object pv = param.get("AAC_Period_Limited");
            if (pv != null && "false".equals(pv.toString())) {
                limited = false;
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)info.getCompanyID().getAccountPeriodType().getId().toString()));
            int from = lastPeriod.getNumber();
            if (limited && currentPeriod != null && currentPeriod.getPeriodYear() * 100 + 1 > from) {
                from = currentPeriod.getPeriodYear() * 100 + 1;
            }
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)from, CompareType.GREATER_EQUALS));
            int to = (enablePeriod.getPeriodYear() + 20) * 100 + 1;
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)to, CompareType.LESS_EQUALS));
            KDBizPromptBox promptEnablePeriod = new KDBizPromptBox();
            promptEnablePeriod.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PeriodQuery");
            promptEnablePeriod.setDisplayFormat("$number$ $name$");
            promptEnablePeriod.setEditFormat("$number$");
            promptEnablePeriod.setCommitFormat("$number$");
            promptEnablePeriod.setHistoryRecordEnabled(false);
            promptEnablePeriod.setEditable(true);
            promptEnablePeriod.setEntityViewInfo(view);
            promptEnablePeriod.setValue((Object)enablePeriod);
            row.getCell("newEffectiveTime").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptEnablePeriod));
            this.peroidRangeMap.put(info, filter);
        } else {
            this.setCellDisable(row, new String[]{"newEffectiveTime"});
        }
    }

    private void setCellDisable(IRow row, String[] columns) {
        if (row == null || columns == null) {
            return;
        }
        for (String column : columns) {
            row.getCell(column).getStyleAttributes().setLocked(true);
            row.getCell(column).getStyleAttributes().setBackground(normal);
        }
    }

    private void setCellEnable(IRow row, String[] columns) {
        if (row == null || columns == null) {
            return;
        }
        for (String column : columns) {
            row.getCell(column).getStyleAttributes().setLocked(false);
            row.getCell(column).getStyleAttributes().setBackground(UIManager.getColor("TextField.requiredBackground"));
        }
    }

    private AsstActGroupDetailCollection getAsstActTypeByAccID(String accountID, SortType sortType) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("asstActType.id");
        evi.getSelector().add("asstActType.number");
        evi.getSelector().add("asstActType.name");
        evi.getSelector().add("asstActType.asstHGAttribute");
        evi.getSelector().add("asstActType.mappingFieldName");
        evi.getSelector().add("asstActType.defaultQueryName");
        evi.getSelector().add("asstActType.isForCompany");
        evi.getSelector().add("asstActType.defaultF7UI");
        evi.getSelector().add("asstActType.glAsstActTypeGrp.id");
        evi.getSelector().add("asstActType.isMultilevel");
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("asstAccount.id", (Object)accountID));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("number"));
        return AsstActGroupDetailFactory.getRemoteInstance().getAsstActGroupDetailCollection(evi);
    }

    private void refreshNewAsstActType(int rowIndex) throws Exception {
        IRow row = this.tblMain.getRow(rowIndex);
        AccountViewInfo account = (AccountViewInfo)row.getUserObject();
        String curCompanyNumber = account.getCompanyID().getLongNumber();
        int curCompanyIndex = rowIndex;
        AsstAccountInfo newAsst = (AsstAccountInfo)row.getCell("newAsst").getValue();
        if (newAsst != null) {
            AsstActGroupDetailCollection coll = this.getAsstActTypeByAccID(newAsst.getId().toString(), SortType.ASCEND);
            newAsst.put("asstActGpDt", (Object)coll);
        }
        IRow tmpRow = null;
        while (curCompanyIndex < this.tblMain.getRowCount()) {
            int nextCompany;
            tmpRow = this.tblMain.getRow(curCompanyIndex);
            AccountViewInfo tmp = (AccountViewInfo)tmpRow.getUserObject();
            if (tmp.getCompanyID().getLongNumber().startsWith(curCompanyNumber)) {
                this.clearNewAcctType(curCompanyIndex);
                this.fillNewAcctType(curCompanyIndex, newAsst);
                tmpRow.getCell("newAsst").setValue((Object)newAsst);
            }
            for (nextCompany = curCompanyIndex + 1; nextCompany < this.tblMain.getRowCount() && this.tblMain.getRow(nextCompany).getUserObject().equals(this.tblMain.getRow(curCompanyIndex).getUserObject()); ++nextCompany) {
            }
            curCompanyIndex = nextCompany;
        }
    }

    private void clearNewAcctType(int rowIndex) {
        IRow row = this.tblMain.getRow(rowIndex);
        AsstActTypeInfo asstActType = (AsstActTypeInfo)row.getCell("newAsstType").getValue();
        if (asstActType == null) {
            return;
        }
        row.getCell("newAsstType").setValue(null);
        for (int curRowIndex = rowIndex; curRowIndex < this.tblMain.getRowCount(); ++curRowIndex) {
            IRow curRow = this.tblMain.getRow(curRowIndex);
            IRow nextRow = this.tblMain.getRow(curRowIndex + 1);
            curRow.getCell("newAsstType").setValue(null);
            this.setCellDisable(curRow, new String[]{"defaultValue"});
            if (curRow.getCell("oldAsstType").getValue() != null || curRowIndex <= rowIndex) continue;
            this.tblMain.removeRow(curRowIndex);
            --curRowIndex;
            if (nextRow != null && curRow.getUserObject().equals(nextRow.getUserObject())) continue;
            break;
        }
    }

    private void fillNewAcctType(int rowIndex, AsstAccountInfo newAsst) throws Exception {
        if (newAsst == null) {
            return;
        }
        IRow row = this.tblMain.getRow(rowIndex);
        AsstActGroupDetailCollection newasstcol = newAsst.getAsstActGpDt();
        for (int i = 0; i < newasstcol.size(); ++i) {
            AsstActTypeInfo asstActInfo = newasstcol.get(i).getAsstActType();
            IRow tmp = this.tblMain.getRow(rowIndex + i);
            if (tmp != null && tmp.getUserObject().equals(row.getUserObject())) {
                tmp.getCell("newAsstType").setValue((Object)asstActInfo);
            } else {
                tmp = this.tblMain.addRow(rowIndex + i);
                tmp.setUserObject(row.getUserObject());
                tmp.getCell("newAsstType").setValue((Object)asstActInfo);
                this.setCellDisable(tmp, new String[]{"company", "oldAsst", "newAsst", "oldAsstType", "defaultValue", "oldEffectiveTime", "newEffectiveTime"});
            }
            AccountViewInfo info = (AccountViewInfo)tmp.getUserObject();
            if (!info.getCompanyID().isIsBizUnit() || !info.isIsLeaf()) continue;
            boolean isOldHas = false;
            if (info.getCAA() != null) {
                AsstActGroupDetailCollection asstActGpDt = info.getCAA().getAsstActGpDt();
                for (int j = 0; j < asstActGpDt.size(); ++j) {
                    if (!asstActInfo.getId().toString().equals(asstActGpDt.get(j).getAsstActType().getId().toString())) continue;
                    isOldHas = true;
                    break;
                }
            }
            if (isOldHas) {
                this.setCellDisable(tmp, new String[]{"defaultValue"});
                continue;
            }
            this.setCellEnable(tmp, new String[]{"defaultValue"});
            tmp.getCell("defaultValue").setValue(null);
            tmp.getCell("defaultValue").setEditor((ICellEditor)this.getCellEditor(info.getCompanyID(), asstActInfo));
        }
    }

    private KDTDefaultCellEditor getCellEditor(CompanyOrgUnitInfo companyOrgUnitInfo, AsstActTypeInfo asstActInfo) throws Exception {
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        bizPromptBox.setEditable(true);
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setDisplayFormat("$number$;$name$");
        bizPromptBox.setCommitFormat("$number$;$name$");
        bizPromptBox.setQueryInfo(asstActInfo.getDefaultQueryName());
        bizPromptBox.setDefaultF7UIName(asstActInfo.getDefaultF7UI());
        Class<?> clzParam = Class.forName("com.kingdee.eas.fi.gl.client.asstf7.GLF7Parameter");
        Object f7Param = clzParam.newInstance();
        clzParam.getMethod("setOnlyLeaf", Boolean.TYPE).invoke(f7Param, true);
        Class<?> clzF7Handler = Class.forName("com.kingdee.eas.fi.gl.client.asstf7.GLF7handler");
        Method assignSelector = clzF7Handler.getMethod("assignSelector", CoreUIObject.class, KDBizPromptBox.class, AsstActTypeInfo.class, CompanyOrgUnitInfo.class, clzParam);
        assignSelector.invoke(null, new Object[]{this, bizPromptBox, asstActInfo, companyOrgUnitInfo, f7Param});
        return new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
    }

    @Override
    public void actionAsstBatchChange_actionPerformed(ActionEvent e) throws Exception {
        int flag;
        if (this.tblMain.getRowCount() < 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        final ArrayList<AsstChangeInfo> list = new ArrayList<AsstChangeInfo>();
        IRow tmpRow = null;
        AccountViewInfo curInfo = null;
        AsstChangeInfo changeInfo = null;
        StringBuilder sb = new StringBuilder();
        HashSet<String> ignore = new HashSet<String>();
        for (int curCompanyIndex = 0; curCompanyIndex < this.tblMain.getRowCount(); ++curCompanyIndex) {
            tmpRow = this.tblMain.getRow(curCompanyIndex);
            AccountViewInfo tmp = (AccountViewInfo)tmpRow.getUserObject();
            if (!tmp.equals(curInfo)) {
                changeInfo = new AsstChangeInfo(tmp);
                list.add(changeInfo);
                AsstAccountInfo newAsst = (AsstAccountInfo)tmpRow.getCell("newAsst").getValue();
                if (newAsst == null && tmp.getCAA() == null || newAsst != null && tmp.getCAA() != null && newAsst.getId().toString().equalsIgnoreCase(tmp.getCAA().getId().toString())) {
                    sb.append(EASResource.getString((String)ACCOUNTRESOURCE, (String)"ASST_BATCH_CHANGE_NODIFF", (Object[])new Object[]{curCompanyIndex + 1})).append("\n");
                    ignore.add(tmp.getId().toString());
                }
                changeInfo.setNewAsstAccount(newAsst == null ? null : newAsst.getId().toString());
                curInfo = tmp;
                if (!tmpRow.getCell("newEffectiveTime").getStyleAttributes().isLocked()) {
                    if (tmpRow.getCell("newEffectiveTime").getValue() == null) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)ACCOUNTRESOURCE, (String)"ASST_BATCH_CHANGE_EFFTIVETIME_CHECK", (Object[])new Object[]{curCompanyIndex + 1}));
                        SysUtil.abort();
                    } else {
                        changeInfo.setNewEffectiveTime((PeriodInfo)tmpRow.getCell("newEffectiveTime").getValue());
                    }
                }
            }
            if (changeInfo.getNewAsstAccount() == null) continue;
            if (!tmpRow.getCell("defaultValue").getStyleAttributes().isLocked() && tmpRow.getCell("defaultValue").getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)ACCOUNTRESOURCE, (String)"ASST_BATCH_CHANGE_DEFAULTVALUE_CHECK", (Object[])new Object[]{curCompanyIndex + 1, tmpRow.getCell("newAsstType").getValue().toString()}));
                SysUtil.abort();
            }
            AsstActTypeInfo newAsstType = (AsstActTypeInfo)tmpRow.getCell("newAsstType").getValue();
            Object defaultValue = tmpRow.getCell("defaultValue").getValue();
            if (newAsstType == null) continue;
            changeInfo.getDefaultValue().put(newAsstType, defaultValue);
        }
        if (ignore.size() > 0 && (flag = MsgBox.showConfirm3a((Component)((Object)this), (String)EASResource.getString((String)ACCOUNTRESOURCE, (String)"ASST_BATCH_PART_NOT_CHANGE"), (String)sb.toString())) != 0) {
            return;
        }
        Iterator ite = list.iterator();
        while (ite.hasNext()) {
            AsstChangeInfo tmp = (AsstChangeInfo)ite.next();
            if (!ignore.contains(tmp.getAccountView().getId().toString())) continue;
            ite.remove();
        }
        if (list.size() < 1) {
            return;
        }
        LongTimeDialog dialog = UITools.getDialog((Component)((Object)this));
        final KDBizPromptBox account = this.prmtAccount;
        final Object data = this.prmtAccount.getData();
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                try {
                    return AccountFacadeFactory.getRemoteInstance().batchChangeAsst(list);
                }
                catch (Exception e) {
                    MsgBox.showDetailAndOK((Component)((Object)AsstBatchChangeUI.this), (String)EASResource.getString((String)AsstBatchChangeUI.ACCOUNTRESOURCE, (String)"ASST_BATCH_CHANGE_FAILED"), (String)e.getMessage(), (int)1);
                    return "false";
                }
            }

            public void afterExec(Object result) throws Exception {
                if (!"false".equalsIgnoreCase(result.toString())) {
                    account.setValue(null);
                    account.setValue(data);
                }
            }
        });
        dialog.show();
    }

    private void addCompany(int rowIdx) throws BOSException, EASBizException {
        if (this.prmtAccount.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)ACCOUNTRESOURCE, (String)"ASST_BATCH_ACCOUNT_NOTNULL"));
            return;
        }
        NewCompanyF7 f7 = new NewCompanyF7();
        f7.setNeedAddOrgRange(false);
        f7.setMultiSelect(true);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)this.companyIds, CompareType.INCLUDE));
        HashSet<String> hasChosen = new HashSet<String>();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            Object account = this.tblMain.getRow(i).getUserObject();
            if (this.company == null) continue;
            AccountViewInfo tmp = (AccountViewInfo)account;
            hasChosen.add(tmp.getCompanyID().getId().toString());
        }
        if (hasChosen.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("unit.id", hasChosen, CompareType.NOTINCLUDE));
        }
        f7.setOuterFilterInfo(filter);
        f7.show();
        if (f7.isCanceled()) {
            return;
        }
        OrgUnitInfo[] comanys = (OrgUnitInfo[])f7.getData();
        if (comanys != null && comanys.length > 0) {
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < comanys.length; ++i) {
                set.add(comanys[i].getId().toString());
            }
            AccountViewCollection coll = AccountViewFactory.getRemoteInstance().getAccountViewCollection(this.buildEntityView(set));
            for (int i = 0; i < coll.size(); ++i) {
                AccountViewInfo info = coll.get(i);
                this.companyIds.add(info.getCompanyID().getId().toString());
                IRow row = this.tblMain.addRow(rowIdx++);
                this.initRow(row, info);
            }
        }
    }

    private void removeCompany() {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        HashSet<Integer> recordToDelete = new HashSet<Integer>();
        for (int idx : selectRows) {
            int curUp = 0;
            int curDown = 0;
            if (this.tblMain.getRow(idx).getCell("company").getValue() == null) {
                curUp = idx - 1;
                curDown = idx + 1;
                while (this.tblMain.getRow(curUp) != null && this.tblMain.getRow(curUp).getCell("company").getValue() == null) {
                    --curUp;
                }
                while (this.tblMain.getRow(curDown) != null && this.tblMain.getRow(curDown).getCell("company").getValue() == null) {
                    ++curDown;
                }
            } else if (this.tblMain.getRow(idx).getCell("company").getValue() != null) {
                curUp = idx;
                curDown = idx + 1;
                while (this.tblMain.getRow(curDown) != null && this.tblMain.getRow(curDown).getCell("company").getValue() == null) {
                    ++curDown;
                }
            }
            while (curUp < curDown) {
                recordToDelete.add(curUp++);
            }
        }
        Object[] indexArr = new Integer[recordToDelete.size()];
        System.arraycopy(recordToDelete.toArray(), 0, indexArr, 0, indexArr.length);
        Arrays.sort(indexArr);
        for (int i = indexArr.length - 1; i >= 0; --i) {
            this.tblMain.removeRow(((Integer)indexArr[i]).intValue());
        }
    }

    @Override
    public void actionAsstAutoFill_actionPerformed(ActionEvent e) throws Exception {
        int currentIndex;
        IRow selectRows = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (selectRows == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        int idx = selectRows.getRowIndex();
        int curDown = 0;
        HashMap asstActTypeMap = new HashMap();
        this.buildAsstActMap(asstActTypeMap, selectRows);
        if (this.tblMain.getRow(idx).getCell("company").getValue() == null) {
            int curUp = idx - 1;
            curDown = idx + 1;
            while (this.tblMain.getRow(curUp) != null && this.tblMain.getRow(curUp).getCell("company").getValue() == null) {
                this.buildAsstActMap(asstActTypeMap, this.tblMain.getRow(curUp));
                --curUp;
            }
            if (this.tblMain.getRow(curUp) != null) {
                this.buildAsstActMap(asstActTypeMap, this.tblMain.getRow(curUp));
            }
            while (this.tblMain.getRow(curDown) != null && this.tblMain.getRow(curDown).getCell("company").getValue() == null) {
                this.buildAsstActMap(asstActTypeMap, this.tblMain.getRow(curDown));
                ++curDown;
            }
        } else if (this.tblMain.getRow(idx).getCell("company").getValue() != null) {
            curDown = idx + 1;
            while (this.tblMain.getRow(curDown) != null && this.tblMain.getRow(curDown).getCell("company").getValue() == null) {
                this.buildAsstActMap(asstActTypeMap, this.tblMain.getRow(curDown));
                ++curDown;
            }
        }
        HashSet<String> org = new HashSet<String>();
        for (currentIndex = curDown; currentIndex < this.tblMain.getRowCount(); ++currentIndex) {
            AccountViewInfo account = (AccountViewInfo)this.tblMain.getRow(currentIndex).getUserObject();
            if (!account.getCompanyID().isIsBizUnit()) continue;
            org.add(account.getCompanyID().getId().toString());
        }
        StringBuilder sb = new StringBuilder();
        if (!asstActTypeMap.isEmpty() && !org.isEmpty()) {
            Map map = AccountFacadeFactory.getRemoteInstance().findAsstActByCompany(asstActTypeMap, new ArrayList(org));
            for (currentIndex = curDown; currentIndex < this.tblMain.getRowCount(); ++currentIndex) {
                Map asstActMap;
                AccountViewInfo account = (AccountViewInfo)this.tblMain.getRow(currentIndex).getUserObject();
                if (!account.getCompanyID().isIsBizUnit()) continue;
                AsstActTypeInfo asstActType = (AsstActTypeInfo)this.tblMain.getRow(currentIndex).getCell("newAsstType").getValue();
                Object currentValue = this.tblMain.getRow(currentIndex).getCell("defaultValue").getValue();
                if (asstActType == null || currentValue != null || this.tblMain.getRow(currentIndex).getCell("defaultValue").getStyleAttributes().isLocked() || (asstActMap = (Map)map.get(account.getCompanyID().getId().toString())) == null) continue;
                Object value = asstActMap.get(asstActType.getId().toString());
                if (value instanceof String) {
                    sb.append(EASResource.getString((String)ACCOUNTRESOURCE, (String)"ASST_BATCH_ACCOUNT_ASST_FILLERROR", (Object[])new Object[]{account.getCompanyID().getName(), asstActType.getName(), value})).append("\n");
                    continue;
                }
                if (value == null) continue;
                this.tblMain.getRow(currentIndex).getCell("defaultValue").setValue(value);
            }
        }
        PeriodInfo curNewEffectiveTime = (PeriodInfo)selectRows.getCell("newEffectiveTime").getValue();
        IPeriod period = PeriodFactory.getRemoteInstance();
        if (curNewEffectiveTime != null && !org.isEmpty()) {
            for (currentIndex = curDown; currentIndex < this.tblMain.getRowCount(); ++currentIndex) {
                AccountViewInfo account = (AccountViewInfo)this.tblMain.getRow(currentIndex).getUserObject();
                if (!account.getCompanyID().isIsBizUnit() || this.tblMain.getRow(currentIndex).getCell("company").getValue() == null || this.tblMain.getRow(currentIndex).getCell("newEffectiveTime").getStyleAttributes().isLocked()) continue;
                FilterInfo fix = (FilterInfo)this.peroidRangeMap.get(account);
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)curNewEffectiveTime.getNumber()));
                filter.mergeFilter(fix, "and");
                ev.setFilter(filter);
                PeriodCollection coll = period.getPeriodCollection(ev);
                if (coll.size() > 0) {
                    this.tblMain.getRow(currentIndex).getCell("newEffectiveTime").setValue((Object)coll.get(0));
                    continue;
                }
                sb.append(EASResource.getString((String)ACCOUNTRESOURCE, (String)"ASST_BATCH_ACCOUNT_TIME_FILLERROR", (Object[])new Object[]{account.getCompanyID().getName()})).append("\n");
            }
        }
        if (sb.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)ACCOUNTRESOURCE, (String)"ASST_BATCH_ACCOUNT_AUTOFILL_PARTRROR"), (String)sb.toString(), (int)1);
        }
    }

    private void buildAsstActMap(Map map, IRow row) {
        AsstActTypeInfo asstActType = (AsstActTypeInfo)row.getCell("newAsstType").getValue();
        CoreBaseInfo defaultValue = (CoreBaseInfo)row.getCell("defaultValue").getValue();
        if (defaultValue != null) {
            map.put(asstActType, defaultValue.getId().toString());
        }
    }
}

