/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.client.AbstractImportGroupAccountsExtendedDlg;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import java.awt.event.ActionEvent;
import javax.swing.JButton;

public class ImportGroupAccountsExtendedDlg
extends AbstractImportGroupAccountsExtendedDlg {
    private final String IMPORT_GA = "importGA";
    public IObjectPK[] selectedPKs = null;
    public boolean isSelectedAll = false;
    public boolean isCanceled = false;

    public ImportGroupAccountsExtendedDlg() throws Exception {
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    ImportGroupAccountsExtendedDlg.this.tblMain_tableClicked(e);
                }
                catch (Exception exc) {
                    ImportGroupAccountsExtendedDlg.this.handUIException(exc);
                }
            }
        });
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.loadData();
        super.onLoad();
        this.selectedPKs = null;
        this.isSelectedAll = false;
        this.isCanceled = false;
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"importGA"));
    }

    private void loadData() throws Exception {
        AccountTableInfo table = (AccountTableInfo)this.getUIContext().get("table");
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getUIContext().get("company");
        AccountViewCollection accounts = this.getBizInterface().getNonImportedGAsByCompany((IObjectPK)new ObjectUuidPK(table.getId()), (IObjectPK)new ObjectUuidPK(company.getId()));
        for (int i = 0; i < accounts.size(); ++i) {
            AccountViewInfo account = accounts.get(i);
            IRow row = this.tblMain.addRow();
            row.getCell(0).setValue((Object)account.getId());
            row.getCell(1).setValue((Object)account.getNumber());
            row.getCell(2).setValue((Object)account.getName());
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        int[] rowID;
        super.btnOK_actionPerformed(e);
        this.isCanceled = false;
        this.isSelectedAll = this.chkSelectedAll.isSelected();
        if (!this.isSelectedAll && (rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain)) != null && rowID.length > 0) {
            this.selectedPKs = new IObjectPK[rowID.length];
            for (int i = 0; i < rowID.length; ++i) {
                String strID = this.tblMain.getRow(rowID[i]).getCell(0).getValue().toString();
                this.selectedPKs[i] = new ObjectUuidPK(strID);
            }
        }
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 1) {
            super.tblMain_tableClicked(e);
        } else if (e.getClickCount() == 2) {
            this.btnOK_actionPerformed(null);
        }
    }

    protected IAccountView getBizInterface() throws Exception {
        return AccountViewFactory.getRemoteInstance();
    }

    protected JButton getDefaultButton() {
        return this.btnOK;
    }
}

