/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.client.AbstractHidedMenuItem;
import com.kingdee.eas.base.core.util.OrgRelationUtils;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public abstract class BDCMClientUtils {
    public static String getNcmResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.assistant.client.NcmResource", (String)key);
    }

    public static String getSaleResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.sale.client.SaleResource", (String)key);
    }

    public static void setResizble(boolean b, IUIWindow uiWindow) {
        if (uiWindow == null) {
            return;
        }
        Window win = SwingUtilities.getWindowAncestor((JComponent)uiWindow.getUIObject());
        if (win instanceof UINewFrame) {
            ((UINewFrame)win).setResizable(b);
        } else if (win instanceof UIModelDialog) {
            ((UIModelDialog)win).setResizable(b);
        }
    }

    public static void setNumberEnabledByCodeRule(IObjectValue caller, DataBinder dataBinder) {
        boolean isModifiable = false;
        boolean isExist = false;
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            String orgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            isExist = iCodingRuleManager.isExist(caller, orgID);
            if (isExist) {
                isModifiable = iCodingRuleManager.isModifiable(caller, orgID);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        Component txtNumber = dataBinder.getComponetByField("number");
        if (txtNumber != null) {
            boolean isEnabled = !isExist || isModifiable;
            txtNumber.setEnabled(isEnabled);
        }
        if (txtNumber != null && txtNumber.isEnabled()) {
            txtNumber.requestFocus();
        }
    }

    public static void showCannotBeEmptyMsg(String fieldName) {
        String msg = BDCMClientUtils.getSaleResource("FieldCannotEmpty");
        MsgBox.showInfo((String)MessageFormat.format(msg, fieldName));
        SysUtil.abort();
    }

    public static void verifyTextFieldInput(KDTextField txt, String fieldName) {
        if (txt.getText().trim().length() == 0 || txt.getText() == null) {
            txt.requestFocus();
            txt.requestFocusInWindow();
            BDCMClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyTextAreaInput(KDTextArea txt, String fieldName) {
        if (txt.getText().trim().length() == 0 || txt.getText() == null) {
            txt.requestFocus();
            txt.requestFocusInWindow();
            BDCMClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyMutilTextFieldInput(KDBizMultiLangBox txt, String fieldName) {
        if (txt.getSelectedItem() == null || ((MultiLangItem)txt.getSelectedItem()).getData().toString().length() == 0) {
            txt.requestFocus();
            BDCMClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyMutilAreaFieldInput(KDBizMultiLangArea txt, String fieldName) {
        if (txt.getSelectedItem() == null || ((MultiLangItem)txt.getSelectedItem()).getData().toString().length() == 0) {
            txt.requestFocus();
            BDCMClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyNumFieldInput(KDFormattedTextField txt, String fieldName) {
        if (txt.getText().trim().length() == 0 || txt.getText() == null) {
            txt.requestFocus();
            BDCMClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyF7Input(KDPromptBox box, String fieldName) {
        if (box.getText().trim().length() == 0 || box.getText() == null) {
            box.requestFocus();
            BDCMClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyComboInput(KDComboBox box, String fieldName) {
        if (box.getSelectedIndex() < 0) {
            box.requestFocus();
            BDCMClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void setVisible(boolean b, Component[] comps) {
        if (comps == null) {
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            comps[i].setVisible(b);
        }
    }

    public static void removeDataChangeListeners(JComponent owner) {
        EventListener[] listeners;
        if (owner != null && (listeners = owner.getListeners(DataChangeListener.class)) != null) {
            EventListener event2 = null;
            for (EventListener event2 : listeners) {
                if (event2 == null || !(event2 instanceof DataChangeListener) || !(owner instanceof IKDEditor)) continue;
                ((IKDEditor)owner).removeDataChangeListener((DataChangeListener)event2);
            }
        }
    }

    public static void removeKDTEditListeners(KDTable owner) {
        EventListener[] listeners;
        if (owner != null && (listeners = owner.getListeners(KDTEditListener.class)) != null) {
            EventListener event2 = null;
            for (EventListener event2 : listeners) {
                if (event2 == null || !(event2 instanceof KDTEditListener)) continue;
                owner.removeKDTEditListener((KDTEditListener)event2);
            }
        }
    }

    public static void addDataChangeListeners(JComponent owner, EventListener[] listeners) {
        if (owner == null || listeners == null || listeners.length < 0) {
            SysUtil.abort();
            return;
        }
        EventListener event2 = null;
        for (EventListener event2 : listeners) {
            if (event2 == null || !(event2 instanceof DataChangeListener) || !(owner instanceof IKDEditor)) continue;
            ((IKDEditor)owner).addDataChangeListener((DataChangeListener)event2);
        }
    }

    public static void addKDTEditListeners(KDTable owner, EventListener[] listeners) {
        if (owner == null || listeners == null || listeners.length < 0) {
            SysUtil.abort();
            return;
        }
        EventListener event2 = null;
        for (EventListener event2 : listeners) {
            if (event2 == null || !(event2 instanceof KDTEditListener)) continue;
            owner.addKDTEditListener((KDTEditListener)event2);
        }
    }

    public static void filterF7(KDBizPromptBox f7, String fieldName, IntEnum compareValue) {
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)compareValue.getValue(), CompareType.EQUALS));
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterF7(KDBizPromptBox f7, String fieldName, Object compareValue) {
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(fieldName, compareValue, CompareType.EQUALS));
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterCostCenterF7(KDBizPromptBox f7, String fieldName, Object compareValue, String companyOrgID) throws BOSException, EASBizException {
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ccColl = iOUR.getFromUnit(companyOrgID, 1, 5);
        int ccSize = ccColl.size();
        if (ccSize == 0) {
            MsgBox.showWarning((String)BDCMClientUtils.getNcmResource("NoCostCenterDelegateThisCompanyOrg"));
            SysUtil.abort();
        }
        HashSet<String> ccIDSet = new HashSet<String>(ccSize);
        for (int i = 0; i < ccSize; ++i) {
            ccIDSet.add(ccColl.get(i).getId().toString());
        }
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(fieldName, compareValue, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", ccIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)1, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or #3)");
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static void filterCostObjectF7(KDBizPromptBox f7, String companyOrgID) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyOrgID));
        EntityViewInfo eviCostObject = new EntityViewInfo();
        eviCostObject.setFilter(filter);
        f7.setEntityViewInfo(eviCostObject);
    }

    public static void filterCostCenterF7(KDBizPromptBox f7, String companyOrgID) throws BOSException, EASBizException {
        BDCMClientUtils.filterCostCenterF7(f7, "isBizUnit", Boolean.TRUE, companyOrgID);
    }

    public static void filterCostObject(KDBizPromptBox f7, CompanyOrgUnitInfo com) {
        BDCMClientUtils.filterF7(f7, "company.id", com.getId().toString());
    }

    public static void filterSuperior(KDBizPromptBox f7, CostCenterOrgUnitInfo node) {
        BDCMClientUtils.filterF7(f7, "parent", node.getId().toString());
    }

    public static void filterCompanyOrgForPeriod(KDBizPromptBox prmt, String periodTypeID) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)periodTypeID, CompareType.EQUALS));
        if (prmt.getEntityViewInfo() != null) {
            try {
                prmt.getEntityViewInfo().getFilter().mergeFilter(filter, "and");
            }
            catch (BOSException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            prmt.setEntityViewInfo(view);
        }
    }

    public static void filterCompanyOrgForPeriod(KDBizPromptBox prmt, CompanyOrgUnitInfo orgInfo) {
        if (orgInfo == null) {
            throw new IllegalArgumentException("CompanyOrgUnit is NULL !");
        }
        BDCMClientUtils.filterCompanyOrgForPeriod(prmt, orgInfo.getAccountPeriodType().getId().toString());
    }

    public static void filterAccountVIewF7(KDBizPromptBox f7, String cuID, CompanyOrgUnitInfo companyOrg) {
        if (UIRuleUtil.isNull((String)cuID) || UIRuleUtil.isNull((Object)companyOrg)) {
            throw new IllegalArgumentException("Argument is null");
        }
        EntityViewInfo view = null;
        view = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("CU.id", (Object)cuID));
        fic.add(new FilterItemInfo("accountTableID.id", (Object)companyOrg.getAccountTable().getId().toString()));
        fic.add(new FilterItemInfo("control", (Object)0));
        fic.add(new FilterItemInfo("isGFreeze", (Object)0));
        fic.add(new FilterItemInfo("isCFreeze", (Object)0));
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
    }

    public static OrgUnitInfo getBizOrgUnitInfo(String addNewPermItemName, OrgType orgType, Context mainOrgContext) {
        if (addNewPermItemName == null || mainOrgContext == null) {
            return null;
        }
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)mainOrgContext.get((Object)orgType);
        OrgUnitInfo retOrgUnitInfo = null;
        retOrgUnitInfo = BDCMClientUtils.getBizOrgUnit(SysContext.getSysContext().getCurrentUserInfo(), orgType, addNewPermItemName, orgUnitInfo);
        return retOrgUnitInfo;
    }

    public static OrgUnitInfo getBizOrgUnit(UserInfo userInfo, OrgType orgType, String permissionItem, OrgUnitInfo orgUnitInfo) {
        if (orgUnitInfo == null) {
            return null;
        }
        OrgUnitInfo bizSaleOrgUnitInfo = null;
        if (orgUnitInfo.getBoolean("isBizUnit")) {
            bizSaleOrgUnitInfo = orgUnitInfo;
        } else {
            try {
                OrgUnitInfo[] mainOrgs = null;
                FullOrgUnitCollection collection = BDCMClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(userInfo.getId().toString()), orgType, permissionItem);
                mainOrgs = OrgRelationUtils.getOrgUnitInfosByType((FullOrgUnitCollection)collection, (OrgType)orgType);
                if (mainOrgs == null) {
                    return null;
                }
                if (mainOrgs.length > 0) {
                    mainOrgs = (OrgUnitInfo[])BDCMClientUtils.sortDataByNumber((DataBaseInfo[])mainOrgs, true);
                }
                bizSaleOrgUnitInfo = mainOrgs[0];
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return bizSaleOrgUnitInfo;
    }

    public static DataBaseInfo[] sortDataByNumber(DataBaseInfo[] datas, boolean isAsc) {
        if (datas == null || datas.length < 2) {
            return datas;
        }
        class DataCompare
        implements Comparator {
            private boolean isAsc = true;

            public DataCompare(boolean isAsc) {
                this.isAsc = isAsc;
            }

            public int compare(Object arg0, Object arg1) {
                return this.isAsc ? ((DataBaseInfo)arg0).getNumber().compareTo(((DataBaseInfo)arg1).getNumber()) : ((DataBaseInfo)arg1).getNumber().compareTo(((DataBaseInfo)arg0).getNumber());
            }
        }
        Arrays.sort(datas, new DataCompare(isAsc));
        return datas;
    }

    public static FullOrgUnitCollection getAuthOrgByPermItem(IObjectPK user, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection result = null;
        IPermission permission = PermissionFactory.getRemoteInstance();
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        ObjectUuidPK cuPk = null;
        if (cu != null) {
            cuPk = new ObjectUuidPK(cu.getId());
        }
        result = permission.getAuthorizedOrgOfIncludeSubCU((IObjectPK)cuPk, user, orgType, null, permItem);
        return result;
    }

    public static void checkLoginCompanyOrgIsVirtual() {
        CompanyOrgUnitInfo companyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (companyOrgUnitInfo == null || !companyOrgUnitInfo.isIsBizUnit()) {
            MsgBox.showError((String)BDCMClientUtils.getNcmResource("CannotOperationInVirtualOrgUnit"));
            SysUtil.abort();
        }
    }

    public static boolean hasTableDuplication(KDTable table, String colName) {
        if (table == null || UIRuleUtil.isNull((String)colName)) {
            throw new IllegalArgumentException("argument is null !");
        }
        int rowCount = table.getRowCount();
        HashSet<Object> values = new HashSet<Object>();
        Object value = null;
        for (int i = 0; i < rowCount; ++i) {
            value = table.getCell(i, colName).getValue();
            if (!UIRuleUtil.isNotNull((Object)value) || values.add(value)) continue;
            String title = (String)table.getHeadRow(0).getCell(colName).getValue();
            MsgBox.showWarning((String)(EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"52_BDCMClientUtils") + title + EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"53_BDCMClientUtils")));
            return true;
        }
        return false;
    }

    public static void setBizOrgF7ByType(KDBizPromptBox prmtCompany, OrgType company) {
        BDCMClientUtils.setBizOrgF7ByType(prmtCompany, company, true);
    }

    public static void setBizOrgF7ByType(KDBizPromptBox f7, OrgType orgType, boolean hasCU) {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(orgType);
        iProducer.getModel().setIsCUFilter(hasCU);
        f7.setFilterInfoProducer((IFilterInfoProducer)iProducer);
    }

    public static void addNCMDataToolUI(final CoreUIObject uiObject, KDMenu menu) {
        menu.add((JMenuItem)new AbstractHidedMenuItem("ctrl F9"){

            public void action_actionPerformed() {
                try {
                    IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
                    UIContext uiContext = new UIContext((Object)uiObject);
                    IUIWindow wnd = fy.create("com.kingdee.eas.ncm.common.client.DataToolSolutionUI", (Map)uiContext);
                    wnd.show();
                }
                catch (UIException e) {
                    SysUtil.abort((Throwable)e);
                }
            }
        });
    }
}

