/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.client.DefaultFilterInfoProducer;
import com.kingdee.eas.basedata.assistant.BDCMCommonFacadeFactory;
import com.kingdee.eas.basedata.assistant.CostItemEnum;
import com.kingdee.eas.basedata.assistant.CostItemFactory;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.IBDCMCommonFacade;
import com.kingdee.eas.basedata.assistant.ICostItem;
import com.kingdee.eas.basedata.assistant.client.AbstractBDCMMultiViewUI;
import com.kingdee.eas.basedata.assistant.client.BDCMClientUtils;
import com.kingdee.eas.basedata.framework.DataBaseDCollection;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.framework.util.KDTableUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.SysUtil;
import java.util.Map;

public class BDCMMultiViewUI
extends AbstractBDCMMultiViewUI {
    private static final long serialVersionUID = 1987776890868348301L;
    public static final String ViewCategory = "0";
    public static final String ViewOrgByExpense = "1";
    public static final String ViewExpenseByOrg = "2";
    public static final String ViewOrgByCostItem = "3";
    public static final String ViewCostItemByOrg = "4";
    public static final String ViewOrgByAllocStd = "5";
    public static final String ViewAllocStdByOrg = "6";
    public static final String ViewOrgByAUXOverhead = "7";
    public static final String ViewAUXOverheadByOrg = "8";
    public static final String ExpenseBostype = "4A255827";
    public static final String CostItemBostype = "548C5A91";
    public static final String AllocStdBostype = "D9EA44BF";
    public static final String AUXOverheaBosType = "8CB367E7";

    public void onShow() throws Exception {
        super.onShow();
        Map uictx = this.getUIContext();
        String viewCategory = (String)uictx.get(ViewCategory);
        if (viewCategory.equals(ViewExpenseByOrg)) {
            this.initViewExpenseByOrg();
        } else if (viewCategory.equals(ViewOrgByCostItem)) {
            this.initViewOrgByCostItem();
        } else if (viewCategory.equals(ViewCostItemByOrg)) {
            this.initViewCostItemByOrg();
        } else if (viewCategory.equals(ViewAllocStdByOrg)) {
            this.initViewAllocStdByOrg();
        } else if (viewCategory.equals(ViewOrgByAUXOverhead)) {
            this.initViewOrgByAUXOverhead();
        } else if (viewCategory.equals(ViewAUXOverheadByOrg)) {
            this.initViewAUXOverheadByOrg();
        }
    }

    private void initViewExpenseByOrg() {
        this.setUITitle(BDCMClientUtils.getNcmResource("ViewExpenseByOrg"));
        this.lblNumber.setBoundLabelText(BDCMClientUtils.getNcmResource("CtrlUnitName"));
        this.prmtNumber.setQueryInfo("com.kingdee.eas.basedata.org.app.F7CUQuery");
        this.lblCostItem.setVisible(false);
        this.txtCostItem.setVisible(false);
        IRow headRow = this.kDTable1.getHeadRow(0);
        headRow.getCell("number").setValue((Object)BDCMClientUtils.getNcmResource("ExpenseNumber"));
        headRow.getCell("name").setValue((Object)BDCMClientUtils.getNcmResource("ExpenseName"));
        headRow.getCell("simpleName").setValue((Object)BDCMClientUtils.getNcmResource("RelatedCostItem"));
        headRow.getCell("description").setValue((Object)BDCMClientUtils.getNcmResource("Remark"));
    }

    private void initViewOrgByCostItem() {
        this.setUITitle(BDCMClientUtils.getNcmResource("ViewOrgByCostItem"));
        this.lblNumber.setBoundLabelText(BDCMClientUtils.getNcmResource("CostItemNumber"));
        this.prmtNumber.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CostItemTreeListQuery");
        this.lblCostItem.setBoundLabelText(BDCMClientUtils.getNcmResource("CostItemType"));
        this.kDTable1.setFormatXml(this.resHelper.getString("kDTable1.formatXml"));
    }

    private void initViewCostItemByOrg() {
        this.setUITitle(BDCMClientUtils.getNcmResource("ViewCostItemByOrg"));
        this.lblNumber.setBoundLabelText(BDCMClientUtils.getNcmResource("CtrlUnitName"));
        this.lblCostItem.setVisible(false);
        this.txtCostItem.setVisible(false);
        this.prmtNumber.setQueryInfo("com.kingdee.eas.basedata.org.app.F7CUQuery");
        BDCMMultiViewUI.setBizOrgF7ByType(this.prmtNumber, OrgType.ControlUnit, false);
        this.lblCostItem.setBoundLabelText(BDCMClientUtils.getNcmResource("RelatedCostItem"));
        IRow headRow = this.kDTable1.getHeadRow(0);
        headRow.getCell("number").setValue((Object)BDCMClientUtils.getNcmResource("CostItemNumber"));
        headRow.getCell("name").setValue((Object)BDCMClientUtils.getNcmResource("CostItemName"));
        headRow.getCell("simpleName").setValue((Object)BDCMClientUtils.getNcmResource("CostItemType"));
        headRow.getCell("description").setValue((Object)BDCMClientUtils.getNcmResource("Description"));
    }

    public static void setBizOrgF7ByType(KDBizPromptBox f7, OrgType orgType, boolean hasCU) {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(orgType);
        iProducer.getModel().setIsCUFilter(hasCU);
        f7.setFilterInfoProducer((IFilterInfoProducer)iProducer);
    }

    private void initViewAllocStdByOrg() {
        this.setUITitle(BDCMClientUtils.getNcmResource("ViewAllocStdByOrg"));
        this.lblNumber.setBoundLabelText(BDCMClientUtils.getNcmResource("CtrlUnitName"));
        this.prmtNumber.setQueryInfo("com.kingdee.eas.basedata.org.app.F7CUQuery");
        this.lblCostItem.setVisible(false);
        this.txtCostItem.setVisible(false);
        IRow headRow = this.kDTable1.getHeadRow(0);
        headRow.getCell("number").setValue((Object)BDCMClientUtils.getNcmResource("AllocStdNumber"));
        headRow.getCell("name").setValue((Object)BDCMClientUtils.getNcmResource("AllocStdName"));
        headRow.getCell("description").setValue((Object)BDCMClientUtils.getNcmResource("Remark"));
    }

    @Override
    protected void prmtNumber_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == null) {
            return;
        }
        this.kDTable1.removeRows();
        Map uictx = this.getUIContext();
        String viewCategory = (String)uictx.get(ViewCategory);
        if (viewCategory.equals(ViewOrgByCostItem)) {
            if (e.getNewValue() instanceof CostItemInfo) {
                CostItemInfo expenseInfo = (CostItemInfo)e.getNewValue();
                this.txtCostItem.setText(expenseInfo.getItemType().toString());
                this.doViewOrgByDataBaseD(expenseInfo.getId().toString());
            }
        } else if (viewCategory.equals(ViewCostItemByOrg)) {
            if (e.getNewValue() instanceof CtrlUnitInfo) {
                CtrlUnitInfo adminCU = (CtrlUnitInfo)e.getNewValue();
                this.doViewCostItemByOrg(adminCU.getId().toString());
            }
        } else if (viewCategory.equals(ViewOrgByAUXOverhead)) {
            DataBaseInfo aUXOverheadInfo = (DataBaseInfo)e.getNewValue();
            this.doViewOrgByDataBaseD(aUXOverheadInfo.getId().toString());
        } else if (viewCategory.equals(ViewAUXOverheadByOrg)) {
            CtrlUnitInfo adminCU = (CtrlUnitInfo)e.getNewValue();
            this.doViewAUXOverheadByOrg(adminCU.getId().toString());
        }
    }

    private void doViewOrgByDataBaseD(String id) throws BOSException, EASBizException {
        IBDCMCommonFacade bdFacade = BDCMCommonFacadeFactory.getRemoteInstance();
        Object[][] data = bdFacade.getOrgsByDataBaseD(id);
        if (data != null) {
            KDTableUtil.insertRows((Object[][])data, null, (int)0, (KDTable)this.kDTable1);
        }
    }

    private void doViewCostItemByOrg(String currentCUID) throws BOSException, EASBizException {
        ICostItem idbd = CostItemFactory.getRemoteInstance();
        FilterInfo dbdFilter = idbd.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(currentCUID), "id", "adminCU.id");
        if (dbdFilter == null) {
            dbdFilter = new FilterInfo();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(dbdFilter);
        evi.getSelector().addObjectCollection((IObjectCollection)this.getSelectors());
        evi.getSelector().add("ItemType");
        DataBaseDCollection dbd = idbd.getDataBaseDCollection(evi);
        if (dbd.size() > 0) {
            this.fillTable(dbd, true);
        }
    }

    private void doViewOrgByCostItem(String id) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo dbdFilter = new FilterInfo();
        dbdFilter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        evi.setFilter(dbdFilter);
        evi.getSelector().addObjectCollection((IObjectCollection)this.getSelectors());
        ICostItem idbd = CostItemFactory.getRemoteInstance();
        DataBaseDCollection dbd = idbd.getDataBaseDCollection(evi);
        if (dbd.size() > 0) {
            this.fillTable(dbd, false);
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("simpleName"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("adminCU.*"));
        return sic;
    }

    private void fillTable(DataBaseDCollection entrys, boolean isD) {
        Object dInfo = null;
        IRow row = null;
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            dInfo = isD ? entrys.get(i) : entrys.get(i).getAdminCU();
            row = this.kDTable1.addRow();
            row.getCell("number").setValue((Object)dInfo.getNumber());
            row.getCell("name").setValue((Object)dInfo.getName());
            row.getCell("description").setValue((Object)dInfo.getDescription());
            Map uictx = this.getUIContext();
            String viewCategory = (String)uictx.get(ViewCategory);
            if (viewCategory.equals(ViewCostItemByOrg)) {
                if (ViewOrgByExpense.equals(dInfo.get("ItemType"))) {
                    row.getCell("simpleName").setValue((Object)CostItemEnum.STUFF);
                    continue;
                }
                row.getCell("simpleName").setValue((Object)CostItemEnum.MANUF);
                continue;
            }
            row.getCell("simpleName").setValue((Object)dInfo.getSimpleName());
        }
    }

    private void initViewOrgByAUXOverhead() {
        this.setUITitle(BDCMClientUtils.getNcmResource("viewOrgByAUXOverhead"));
        this.lblNumber.setBoundLabelText(BDCMClientUtils.getNcmResource("AUXOverheadNumber"));
        this.prmtNumber.setQueryInfo("com.kingdee.eas.basedata.ncm.app.AUXOverheadQuery");
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        if (cu == null) {
            SysUtil.abort();
        }
        EntityViewInfo view = new EntityViewInfo();
        Map uictx = this.getUIContext();
        if (uictx.get("filter") instanceof FilterInfo) {
            FilterInfo filter = (FilterInfo)uictx.get("filter");
            view.setFilter(filter);
            this.prmtNumber.setFilterInfoProducer((IFilterInfoProducer)new DefaultFilterInfoProducer(filter));
            this.prmtNumber.setEntityViewInfo(view);
        }
        this.lblCostItem.setVisible(false);
        this.kDTable1.setFormatXml(this.resHelper.getString("kDTable1.formatXml"));
    }

    private void initViewAUXOverheadByOrg() {
        this.setUITitle(BDCMClientUtils.getNcmResource("viewAUXOverheadByOrg"));
        this.lblNumber.setBoundLabelText(BDCMClientUtils.getNcmResource("CtrlUnitName"));
        this.lblCostItem.setVisible(false);
        this.txtCostItem.setVisible(false);
        this.prmtNumber.setQueryInfo("com.kingdee.eas.basedata.org.app.F7CUQuery");
        BDCMMultiViewUI.setBizOrgF7ByType(this.prmtNumber, OrgType.ControlUnit, false);
        IRow headRow = this.kDTable1.getHeadRow(0);
        headRow.getCell("number").setValue((Object)BDCMClientUtils.getNcmResource("AUXOverheadNumber"));
        headRow.getCell("name").setValue((Object)BDCMClientUtils.getNcmResource("AUXOverheadName"));
        this.kDTable1.getColumn("number").setWidth(130);
        this.kDTable1.getColumn("name").setWidth(250);
        this.kDTable1.getColumn("simpleName").getStyleAttributes().setHided(true);
        headRow.getCell("description").setValue((Object)BDCMClientUtils.getNcmResource("Description"));
    }

    private void doViewAUXOverheadByOrg(String currentCUID) throws BOSException, EASBizException {
        Class<?> AUXOverheadFactory;
        IBOSObject ibo = BOSObjectFactory.createRemoteBOSObject((BOSObjectType)BOSObjectType.create((String)AUXOverheaBosType), IDataBaseD.class);
        IDataBaseD idbd = (IDataBaseD)ibo;
        FilterInfo dbdFilter = idbd.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(currentCUID), "id", "adminCU.id");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(dbdFilter);
        try {
            AUXOverheadFactory = Class.forName("com.kingdee.eas.basedata.ncm.AUXOverheadFactory");
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        IDataBaseD idbdx = (IDataBaseD)BusinessProcessUtil.getBizInterface(null, AUXOverheadFactory);
        DataBaseDCollection dbd = idbdx.getDataBaseDCollection(evi);
        if (dbd.size() > 0) {
            this.fillTable(dbd, true);
        }
    }
}

