/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.PrecisionUtil;
import com.kingdee.eas.basedata.assistant.CalculateModeEnum;
import com.kingdee.eas.basedata.assistant.CostObjectEntryCollection;
import com.kingdee.eas.basedata.assistant.CostObjectEntryInfo;
import com.kingdee.eas.basedata.assistant.CostObjectException;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectGroupInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.client.AbstractCostObjectEditUI;
import com.kingdee.eas.basedata.assistant.client.BDCMClientUtils;
import com.kingdee.eas.basedata.assistant.client.CostObjectListUI;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.IRefChecker;
import com.kingdee.eas.common.RefCheckerFactory;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class CostObjectEditUI
extends AbstractCostObjectEditUI {
    private CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
    private String companyID = this.currentCompany.getId().toString();
    private HashMap mtlForBom = new HashMap();
    private String Key = "mtlForBom";
    private Object oldValue = null;

    public void onLoad() throws Exception {
        this.actionExport.setEnabled(true);
        CostObjectEditUI.checkLoginCompanyOrgIsVirtual();
        this.txtBatch.setMaxLength(80);
        this.table.checkParsed();
        EventListener[] combComputeModeListners = this.combComputeMode.getListeners(DataChangeListener.class);
        BDCMClientUtils.removeDataChangeListeners((JComponent)this.combComputeMode);
        super.onLoad();
        BDCMClientUtils.addDataChangeListeners((JComponent)this.combComputeMode, combComputeModeListners);
        if ("ADDNEW".equals(this.getOprtState())) {
            for (int i = this.combComputeMode.getItemCount() - 1; i >= 0; --i) {
                if (!CalculateModeEnum.VARIET.equals(this.combComputeMode.getItemAt(i)) && !CalculateModeEnum.BYORDER.equals(this.combComputeMode.getItemAt(i))) continue;
                this.combComputeMode.removeItemAt(i);
            }
        } else {
            this.combComputeMode.setEnabled(false);
        }
        this.initEntry();
        this.menuItemAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.menuItemInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.menuItemRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.menuView.setVisible(false);
        this.menuBiz.setVisible(false);
        this.menuItemRemove.setVisible(false);
        if ("VIEW".equals(this.getOprtState())) {
            this.actionPrint.setVisible(false);
            this.actionPrintPreview.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionSave.setVisible(false);
        }
        this.filterBOMF7(this.kDBizPromptBOM, this.companyID, null);
        CostObjectListUI costObjectListUI = (CostObjectListUI)((Object)this.getUIContext().get("Owner"));
        if (costObjectListUI.getSelectedTreeNode().getUserObject() != null && costObjectListUI.getSelectedTreeNode().getUserObject() instanceof CostObjectGroupInfo) {
            CostObjectGroupInfo groupInfo = (CostObjectGroupInfo)costObjectListUI.getSelectedTreeNode().getUserObject();
            this.editData.setCostObjectGroup(groupInfo);
        }
        super.storeFields();
        this.initOldData((IObjectValue)this.editData);
        if (CalculateModeEnum.VARIET.equals((Object)this.editData.getCalculateMode())) {
            this.actionCopy.setEnabled(false);
        }
        if ("COPY".equals(this.getOprtState())) {
            ActionEvent event = (ActionEvent)this.getUIContext().get("ActionEvent");
            this.actionCopy_actionPerformed(event);
        }
        if (this.editData.getCalculateMode().equals((Object)CalculateModeEnum.VARIET) && "EDIT".equals(this.getOprtState())) {
            this.kDTxtNumber.setEnabled(false);
            this.kDBizMultiLangBox1.setEditable(false);
            this.txtBatch.setEnabled(false);
            this.table.setEnabled(false);
            this.kDBizMultiLangArea1.setEditable(false);
        }
        this.table.getActionMap().remove("Delete");
    }

    protected void initEntry() {
        this.table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    CostObjectEditUI.this.table_editStarting(e);
                }
                catch (Exception exc) {
                    CostObjectEditUI.this.handUIException(exc);
                }
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    CostObjectEditUI.this.table_editStopped(e);
                }
                catch (Exception exc) {
                    CostObjectEditUI.this.handUIException(exc);
                }
            }
        });
        KDBizPromptBox prmtRelation = new KDBizPromptBox();
        prmtRelation.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MaterialCostObjectQuery");
        prmtRelation.setVisible(true);
        prmtRelation.setEditable(true);
        prmtRelation.setDisplayFormat("$number$");
        prmtRelation.setEditFormat("$number$");
        prmtRelation.setCommitFormat("$number$");
        EntityViewInfo eviCostObject = new EntityViewInfo();
        eviCostObject.setFilter(this.getCostObjectFilter());
        prmtRelation.setEntityViewInfo(eviCostObject);
        ObjectValueRender avrCostObject = new ObjectValueRender();
        avrCostObject.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.table.getColumn("RelatedNumber").setRenderer((IBasicRender)avrCostObject);
        prmtRelation.setRequired(true);
        this.table.getColumn("RelatedNumber").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtRelation));
        final KDCheckBox mainpro = new KDCheckBox();
        final KDCheckBox bypro = new KDCheckBox();
        mainpro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (mainpro.isSelected()) {
                    CostObjectEditUI.this.AfterBillMainSelected(event);
                } else {
                    int rowIndex = CostObjectEditUI.this.table.getSelectManager().getActiveRowIndex();
                    IRow curRow = CostObjectEditUI.this.table.getRow(rowIndex);
                    curRow.getCell("quotiety").getStyleAttributes().setLocked(false);
                    curRow.getCell("isMainProduct").setValue((Object)Boolean.FALSE);
                }
            }
        });
        bypro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (bypro.isSelected()) {
                    CostObjectEditUI.this.AfterBillByproSelected(event);
                }
            }
        });
        this.table.getColumn("isMainProduct").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)mainpro));
        this.table.getColumn("isByproduct").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)bypro));
        KDFormattedTextField textField = new KDFormattedTextField(1);
        textField.setNegatived(false);
        textField.setRequired(true);
        textField.setPrecision(4);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)textField);
        this.table.getColumn("quotiety").setEditor((ICellEditor)editor);
        String colPrecision = PrecisionUtil.getFormatString((int)4);
        this.table.getColumn("quotiety").getStyleAttributes().setNumberFormat(colPrecision);
        this.table.getColumn("quotiety").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        if ("ADDNEW".equals(this.getOprtState()) && this.table.getRowCount() < 1) {
            this.addLine(this.table);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        KDTableHelper.downArrowAutoAddRow((KDTable)this.table, (boolean)true, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CostObjectEditUI.this.combComputeMode.getSelectedItem() != null && !((CalculateModeEnum)CostObjectEditUI.this.combComputeMode.getSelectedItem()).equals((Object)CalculateModeEnum.BYCLASS) && CostObjectEditUI.this.table.getRowCount() > 0) {
                    CostObjectEditUI.this.table.removeRow(CostObjectEditUI.this.table.getRowCount() - 1);
                    String msg = CostObjectEditUI.getResource("onlyOne");
                    MsgBox.showError((String)msg);
                }
            }
        });
    }

    @Override
    public void storeFields() {
        this.editData.getEntries().clear();
        if (this.kDBizPromptBOM.getData() != null) {
            IObjectValue info = (IObjectValue)this.kDBizPromptBOM.getData();
            String bomID = info.getBOSUuid("id").toString();
            this.editData.setBomID(bomID);
        }
        super.storeFields();
        this.batchNumberTrim();
        this.storeEntrysFields(this.editData);
    }

    protected void storeEntrysFields(CostObjectInfo COinfo) {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            CostObjectEntryInfo entryInfo = new CostObjectEntryInfo();
            IRow row = this.table.getRow(i);
            entryInfo.setParent(COinfo);
            entryInfo.setQuotiety((BigDecimal)row.getCell("quotiety").getValue());
            entryInfo.setRelatedID(BOSUuid.read((String)row.getCell("RelatedID").getValue().toString()));
            COinfo.getEntries().get(i).setRelatedNumber(((MaterialInfo)row.getCell("RelatedNumber").getValue()).getNumber());
            if (row.getCell("isMainProduct").getValue() != null) {
                entryInfo.setIsMainProduct((Boolean)row.getCell("isMainProduct").getValue());
            }
            if (row.getCell("isByproduct").getValue() != null) {
                entryInfo.setIsByproduct((Boolean)row.getCell("isByproduct").getValue());
            }
            if (row.getCell("isMainProduct").getValue() == null || !((Boolean)row.getCell("isMainProduct").getValue()).booleanValue()) continue;
            try {
                MaterialInfo materialCompanyInfo = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(row.getCell("RelatedID").getValue().toString()));
                COinfo.setRelatedId(materialCompanyInfo.getId());
                COinfo.setStdProductID(materialCompanyInfo);
                COinfo.setGroup(materialCompanyInfo.getMaterialGroup());
                continue;
            }
            catch (EASBizException e1) {
                this.handleException((Exception)((Object)e1));
                continue;
            }
            catch (BOSException e1) {
                this.handleException((Exception)((Object)e1));
            }
        }
    }

    @Override
    protected void kDBizPromptBOM_willShow(SelectorEvent e) throws Exception {
        if (this.getOprtState() == "VIEW") {
            e.setCanceled(true);
            return;
        }
        String stdProductId = this.getStdProductID();
        if (stdProductId == null || stdProductId.length() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"60_CostObjectEditUI"));
            e.setCanceled(true);
            return;
        }
        this.kDBizPromptBOM.getQueryAgent().resetRuntimeEntityView();
        this.filterBOMF7(this.kDBizPromptBOM, this.companyID, stdProductId);
    }

    @Override
    protected void kDBizPromptBOM_willCommit(CommitEvent e) throws Exception {
        String stdProductId = this.getStdProductID();
        if (stdProductId == null || stdProductId.length() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"60_CostObjectEditUI"));
            e.setCanceled(true);
            return;
        }
    }

    private String getStdProductID() {
        String relatedId = "";
        if (this.table.getRowCount() > 0) {
            int m = this.table.getRowCount();
            int onlyone = 0;
            while (m-- > 0) {
                IRow row = this.table.getRow(m);
                if (!((Boolean)row.getCell("isMainProduct").getValue()).booleanValue()) continue;
                if (row.getCell("RelatedID").getValue() != null) {
                    relatedId = row.getCell("RelatedID").getValue().toString();
                }
                ++onlyone;
            }
            if (onlyone > 1) {
                relatedId = "";
            }
        }
        return relatedId;
    }

    public boolean isModify() {
        int countOld;
        if (this.editData == null) {
            return false;
        }
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            this.handleControlException();
            this.abort();
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        if ("COPY".equals(this.getOprtState())) {
            return false;
        }
        if (!StringUtils.equals((String)this.editData.getNumber(), (String)this.kDTxtNumber.getText())) {
            return true;
        }
        if (!StringUtils.equals((String)this.editData.getName(), (String)((String)this.kDBizMultiLangBox1.getSelectedItemData()))) {
            return true;
        }
        IObjectValue newBom = (IObjectValue)this.kDBizPromptBOM.getData();
        if (this.editData.getBomID() == null && newBom != null || this.editData.getBomID() != null && newBom == null || this.editData.getBomID() != null && newBom != null && !this.editData.getBomID().equals(newBom.getBOSUuid("id").toString())) {
            return true;
        }
        if (!StringUtils.equals((String)this.editData.getDescription(), (String)((String)this.kDBizMultiLangArea1.getSelectedItemData()))) {
            return true;
        }
        CostObjectEntryCollection newCollection = this.editData.getEntries();
        int countNew = newCollection.size();
        if (countNew != (countOld = this.table.getRowCount())) {
            return true;
        }
        CostObjectEntryInfo tempNew = null;
        Object relatedID = null;
        for (int i = 0; i < countNew; ++i) {
            boolean isFound = false;
            tempNew = newCollection.get(i);
            Object tempRelatedID = tempNew.getRelatedID();
            if (tempRelatedID != null) {
                tempRelatedID = tempRelatedID.toString();
            }
            for (int j = 0; j < countOld; ++j) {
                relatedID = this.table.getRow(j).getCell("RelatedID").getValue();
                if (relatedID != null) {
                    relatedID = relatedID.toString();
                }
                if (!StringUtils.equals((String)((String)tempRelatedID), (String)((String)relatedID))) continue;
                isFound = true;
                break;
            }
            if (isFound) continue;
            return true;
        }
        return false;
    }

    @Override
    public void loadFields() {
        EventListener[] combComputeModeListners = this.combComputeMode.getListeners(DataChangeListener.class);
        BDCMClientUtils.removeDataChangeListeners((JComponent)this.combComputeMode);
        super.loadFields();
        BDCMClientUtils.addDataChangeListeners((JComponent)this.combComputeMode, combComputeModeListners);
        if (CalculateModeEnum.BYORDER.equals((Object)this.editData.getCalculateMode()) && this.editData.getOrderID() != null && this.editData.getOrderID().length() > 0) {
            String orderNumber = "";
            String projectNumber = "";
            String trackNumber = "";
            String saleNumber = "";
            try {
                HashSet<String> ids = new HashSet<String>();
                String orderID = this.editData.getOrderID().toString();
                ids.add(orderID);
                Map orders = CostObjectFactory.getRemoteInstance().getOrderInfo(ids);
                Map orderInfo = (Map)orders.get(orderID);
                if (orderInfo != null) {
                    orderNumber = (String)orderInfo.get("orderNumber");
                    projectNumber = (String)orderInfo.get("projectNumber");
                    trackNumber = (String)orderInfo.get("trackNumber");
                    saleNumber = (String)orderInfo.get("saleNumber");
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
            this.prmtOrder.setData((Object)orderNumber);
            this.prmtProject.setData((Object)projectNumber);
            this.prmtTrack.setData((Object)trackNumber);
            this.prmtSale.setData((Object)saleNumber);
        }
        if ("COPY".equals(this.getOprtState())) {
            return;
        }
        try {
            IRefChecker checker;
            this.loadEntrysFields(this.editData);
            this.initEntryCol(this.table);
            if (this.editData.getBomID() != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("material.id"));
                IObjectValue bom = (IObjectValue)BusinessProcessUtil.getValueByBosType(null, (IObjectPK)new ObjectUuidPK(this.editData.getBomID()), (SelectorItemCollection)sic);
                this.kDBizPromptBOM.setValue((Object)bom);
                if (bom != null) {
                    String materialId = bom.getObjectValue("material").getBOSUuid("id").toString();
                    this.mtlForBom.put(this.Key, materialId);
                }
            }
            if ("EDIT".equals(this.getOprtState()) && ((checker = RefCheckerFactory.getRemoteInstance()).isReferenced(this.editData.getId()) || this.editData.getCalculateMode().equals((Object)CalculateModeEnum.VARIET))) {
                this.btnAddLine.setEnabled(false);
                this.btnInsertLine.setEnabled(false);
                this.btnRemoveLine.setEnabled(false);
                this.menuTable1.setVisible(false);
                this.table.setEditable(false);
            }
        }
        catch (EASBizException e1) {
            this.handleException((Exception)((Object)e1));
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
    }

    protected void loadEntrysFields(CostObjectInfo COinfo) throws BOSException, EASBizException {
        CostObjectEntryCollection COEntryColl = COinfo.getEntries();
        if (COEntryColl != null && COEntryColl.size() > 0) {
            int i;
            HashSet<String> matSet = new HashSet<String>();
            for (int i2 = 0; i2 < COEntryColl.size(); ++i2) {
                matSet.add(COEntryColl.get(i2).getRelatedID().toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", matSet, CompareType.INCLUDE));
            view.setFilter(filter);
            MaterialCollection matColl = MaterialFactory.getRemoteInstance().getMaterialCollection(view);
            HashMap<String, MaterialInfo> matMap = new HashMap<String, MaterialInfo>();
            if (matColl != null && matColl.size() > 0) {
                for (i = 0; i < matColl.size(); ++i) {
                    MaterialInfo matInfo = matColl.get(i);
                    matMap.put(matInfo.getId().toString(), matInfo);
                }
            }
            this.table.removeRows();
            for (i = 0; i < COEntryColl.size(); ++i) {
                CostObjectEntryInfo coInfo = COEntryColl.get(i);
                IRow row = this.table.addRow();
                row.getCell("RelatedID").setValue((Object)coInfo.getRelatedID());
                MaterialInfo matInfo = (MaterialInfo)matMap.get(coInfo.getRelatedID().toString());
                if (matInfo != null) {
                    row.getCell("RelatedNumber").setValue((Object)matInfo);
                    row.getCell("RelatedName").setValue((Object)matInfo.getName());
                    row.getCell("remark").setValue((Object)matInfo.getModel());
                    row.getCell("shortName").setValue((Object)matInfo.getShortName());
                }
                row.getCell("isMainProduct").setValue((Object)coInfo.isIsMainProduct());
                row.getCell("isByproduct").setValue((Object)coInfo.isIsByproduct());
                row.getCell("quotiety").setValue((Object)coInfo.getQuotiety());
            }
        }
    }

    @Override
    protected void txtBatch_focusLost(FocusEvent e) throws Exception {
        super.txtBatch_focusLost(e);
    }

    private void initEntryRow(IRow row) {
        row.getCell("isMainProduct").setValue((Object)Boolean.FALSE);
        row.getCell("isByproduct").setValue((Object)Boolean.FALSE);
        row.getCell("quotiety").setValue((Object)new BigDecimal("0.0"));
    }

    private void initEntryCol(KDTable table) {
        if (this.combComputeMode.getSelectedItem() != null && ((CalculateModeEnum)this.combComputeMode.getSelectedItem()).equals((Object)CalculateModeEnum.BYCLASS)) {
            table.getColumn("quotiety").getStyleAttributes().setHided(false);
            table.getColumn("isMainProduct").getStyleAttributes().setHided(false);
            table.getColumn("isByproduct").getStyleAttributes().setHided(false);
        } else {
            table.getColumn("quotiety").getStyleAttributes().setHided(true);
            table.getColumn("isMainProduct").getStyleAttributes().setHided(true);
            table.getColumn("isByproduct").getStyleAttributes().setHided(true);
        }
    }

    private void ctlEntryAddnew(KDTable table) throws Exception {
        if (this.combComputeMode.getSelectedItem() != null && !((CalculateModeEnum)this.combComputeMode.getSelectedItem()).equals((Object)CalculateModeEnum.BYCLASS) && table.getRowCount() > 0) {
            throw new CostObjectException(CostObjectException.ONLYONE);
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.ctlEntryAddnew(this.table);
        if (this.actionAddLine.isEnabled()) {
            IRow row = this.table.addRow();
            this.initEntryRow(row);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        super.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        super.storeFields();
        this.initOldData((IObjectValue)this.editData);
        if (CalculateModeEnum.VARIET.equals((Object)this.editData.getCalculateMode())) {
            this.actionCopy.setEnabled(false);
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.ctlEntryAddnew(this.table);
        if (this.actionInsertLine.isEnabled()) {
            int index = this.table.getSelectManager().getActiveRowIndex();
            this.addLine(index, this.table);
        }
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        int index = this.table.getSelectManager().getActiveRowIndex();
        if (index < 0 || index >= this.table.getRowCount()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"61_CostObjectEditUI"));
            return;
        }
        this.table.removeRow(index);
    }

    @Override
    protected void combComputeMode_itemStateChanged(ItemEvent e) throws Exception {
        super.combComputeMode_itemStateChanged(e);
        this.initEntryCol(this.table);
        if (this.combComputeMode.getSelectedItem() != null && ((CalculateModeEnum)this.combComputeMode.getSelectedItem()).equals((Object)CalculateModeEnum.BYBATCH)) {
            this.txtBatch.setEnabled(true);
            if ("ADDNEW".equals(this.getOprtState()) && this.table.getRowCount() >= 2) {
                this.table.removeRows();
                this.addAnotherLine(this.table, true);
            }
        } else {
            this.txtBatch.setText(null);
            this.txtBatch.setEnabled(false);
            if ("ADDNEW".equals(this.getOprtState()) && this.table.getRowCount() < 2) {
                this.addAnotherLine(this.table, false);
            }
        }
        this.initEntry();
        CostObjectEditUI.clearcol(this.table, new String[]{"RelatedID", "RelatedName", "RelatedNumber"});
    }

    @Override
    protected IObjectValue createNewData() {
        CostObjectInfo info = new CostObjectInfo();
        info.setCalculateMode(CalculateModeEnum.BYBATCH);
        info.setCompany(this.currentCompany);
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setIsSys(false);
        info.setDescription("");
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return super.getBizInterface();
    }

    private void addLine(int index, KDTable kdtEntrys) throws EASBizException, BOSException {
        IRow row = null;
        row = index != -1 ? kdtEntrys.addRow(index) : kdtEntrys.addRow();
        this.initEntryRow(row);
    }

    protected void fillCellAfterBillSelectedRelation(DataChangeEvent eventObj) {
        MaterialInfo info;
        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
        IRow curRow = this.table.getRow(rowIndex);
        CostObjectEditUI.clearCells(this.table, rowIndex, new String[]{"RelatedName", "RelatedID", "remark"});
        if (eventObj.getNewValue() instanceof MaterialInfo && (info = (MaterialInfo)eventObj.getNewValue()) != null) {
            curRow.getCell("RelatedNumber").setValue((Object)info.getNumber());
            curRow.getCell("RelatedName").setValue((Object)info.getName());
            curRow.getCell("RelatedID").setValue((Object)info.getId());
            curRow.getCell("remark").setValue((Object)info.getModel());
            curRow.getCell("shortName").setValue((Object)info.getShortName());
        }
    }

    public void table_editStarting(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        this.oldValue = this.table.getRow(rowIndex).getCell(colIndex).getValue();
    }

    public void table_editStopped(KDTEditEvent e) throws Exception {
        int colIndex;
        int rowIndex = e.getRowIndex();
        if (!this.isCellValueChanged(rowIndex, colIndex = e.getColIndex())) {
            return;
        }
        IRow curRow = this.table.getRow(rowIndex);
        Object newValue = curRow.getCell(colIndex).getValue();
        if (this.table.getColumn("RelatedNumber").getColumnIndex() == colIndex) {
            CostObjectEditUI.clearCells(this.table, rowIndex, new String[]{"RelatedName", "RelatedID", "remark"});
            if (newValue instanceof MaterialInfo) {
                MaterialInfo info = (MaterialInfo)newValue;
                curRow.getCell("RelatedNumber").setValue((Object)info);
                curRow.getCell("RelatedName").setValue((Object)info.getName());
                curRow.getCell("RelatedID").setValue((Object)info.getId());
                curRow.getCell("remark").setValue((Object)info.getModel());
                curRow.getCell("shortName").setValue((Object)info.getShortName());
            }
        }
    }

    private boolean isCellValueChanged(int rowIndex, int colIndex) {
        Object newValue = this.table.getRow(rowIndex).getCell(colIndex).getValue();
        if (this.oldValue == null && newValue == null) {
            return false;
        }
        if (this.oldValue == null || newValue == null) {
            return true;
        }
        if (this.table.getColumn("RelatedNumber").getColumnIndex() == colIndex && this.oldValue instanceof MaterialInfo && newValue instanceof MaterialInfo) {
            return !((MaterialInfo)this.oldValue).getId().equals((Object)((MaterialInfo)newValue).getId());
        }
        return true;
    }

    protected void AfterBillMainSelected(ActionEvent eventObj) {
        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
        IRow curRow = this.table.getRow(rowIndex);
        curRow.getCell("isByproduct").setValue((Object)Boolean.FALSE);
        curRow.getCell("isMainProduct").setValue((Object)Boolean.TRUE);
        ICell quotietyCell = curRow.getCell("quotiety");
        quotietyCell.getStyleAttributes().setLocked(true);
        quotietyCell.setValue((Object)new BigDecimal("1"));
        this.setOtherRowNotMainProduct(rowIndex);
    }

    private void setOtherRowNotMainProduct(int rowIndex) {
        int rowNum = this.table.getRowCount();
        if (rowNum > 0) {
            IRow curRow = null;
            for (int i = 0; i < rowNum; ++i) {
                if (i == rowIndex) continue;
                curRow = this.table.getRow(i);
                curRow.getCell("isMainProduct").setValue((Object)Boolean.FALSE);
                curRow.getCell("quotiety").getStyleAttributes().setLocked(false);
            }
        }
    }

    protected void AfterBillByproSelected(ActionEvent eventObj) {
        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
        IRow curRow = this.table.getRow(rowIndex);
        curRow.getCell("isByproduct").setValue((Object)Boolean.TRUE);
        curRow.getCell("isMainProduct").setValue((Object)Boolean.FALSE);
        curRow.getCell("quotiety").getStyleAttributes().setLocked(false);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.kDTxtNumber.getText() == null || "".equals(this.kDTxtNumber.getText())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"57_CostItemEditUI"));
            SysUtil.abort();
        }
        if (this.kDBizMultiLangBox1.getEditor().getItem() == null || "".equals(this.kDBizMultiLangBox1.getEditor().getItem().toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"58_CostItemEditUI"));
            SysUtil.abort();
        }
        BigDecimal sum_quotiety = SysConstant.BIGZERO;
        boolean hasMainProduct = false;
        if (this.table.getRowCount() < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"62_CostObjectEditUI"));
            SysUtil.abort();
        }
        if (this.combComputeMode.getSelectedItem() != null && !((CalculateModeEnum)this.combComputeMode.getSelectedItem()).equals((Object)CalculateModeEnum.BYCLASS)) {
            if (this.table.getRowCount() > 1) {
                throw new CostObjectException(CostObjectException.ONLYONE);
            }
        } else if (this.table.getRowCount() < 2) {
            throw new CostObjectException(CostObjectException.NOTONLYONE);
        }
        int m = this.table.getRowCount();
        HashMap<Object, Object> infoMap = new HashMap<Object, Object>();
        int onlyone = 0;
        while (m-- > 0) {
            IRow row = this.table.getRow(m);
            BigDecimal quotiety = (BigDecimal)row.getCell("quotiety").getValue();
            if (quotiety == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"63_CostObjectEditUI"));
                SysUtil.abort();
            }
            sum_quotiety = sum_quotiety.add(quotiety);
            if (row.getCell("RelatedID").getValue() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"64_CostObjectEditUI"));
                SysUtil.abort();
            }
            if (infoMap.containsKey(row.getCell("RelatedID").getValue())) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"65_CostObjectEditUI"));
                this.abort();
            }
            infoMap.put(row.getCell("RelatedID").getValue(), row.getCell("RelatedID").getValue());
            if (row.getCell("isMainProduct").getValue() != null && ((Boolean)row.getCell("isMainProduct").getValue()).booleanValue()) {
                hasMainProduct = true;
                if (quotiety.intValue() != 1) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"66_CostObjectEditUI"));
                    SysUtil.abort();
                }
                ++onlyone;
                if (!this.mtlForBom.containsKey(this.Key) || this.mtlForBom.get(this.Key).toString().equals(row.getCell("RelatedID").getValue().toString())) continue;
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"67_CostObjectEditUI"));
                SysUtil.abort();
                continue;
            }
            if (!(quotiety.doubleValue() < 0.0)) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"68_CostObjectEditUI"));
            SysUtil.abort();
        }
        if (!hasMainProduct && onlyone > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"69_CostObjectEditUI"));
            SysUtil.abort();
        }
    }

    @Override
    protected void kDBizPromptBOM_dataChanged(DataChangeEvent e) throws Exception {
        super.kDBizPromptBOM_dataChanged(e);
        if (e.getOldValue() != e.getNewValue() && e.getNewValue() == null) {
            this.editData.setBomID(null);
        }
        this.mtlForBom.remove(this.Key);
        if (this.kDBizPromptBOM.getValue() != null) {
            IObjectValue info = (IObjectValue)e.getNewValue();
            String materialId = info.getObjectValue("material").getBOSUuid("id").toString();
            this.mtlForBom.put(this.Key, materialId);
        }
    }

    protected void addAnotherLine(KDTable table, boolean b) {
        if (table == null) {
            return;
        }
        CostObjectEntryInfo entry = new CostObjectEntryInfo();
        entry.setQuotiety(new BigDecimal(b ? "1.0" : "0"));
        entry.setIsMainProduct(b);
        entry.setIsByproduct(false);
        IRow row = table.addRow();
        row.getCell("quotiety").getStyleAttributes().setLocked(b);
        this.dataBinder.loadLineFields(table, row, (IObjectValue)entry);
    }

    protected void addLine(KDTable table) {
        if (table == null) {
            return;
        }
        IObjectValue detailData = this.createNewDetail(table);
        IRow row = table.addRow();
        row.getCell("quotiety").getStyleAttributes().setLocked(true);
        this.dataBinder.loadLineFields(table, row, detailData);
    }

    private IObjectValue createNewDetail(KDTable table) {
        CostObjectEntryInfo entry = new CostObjectEntryInfo();
        entry.setQuotiety(new BigDecimal("1.0"));
        entry.setIsMainProduct(true);
        entry.setIsByproduct(false);
        return entry;
    }

    public static void clearcol(KDTable kdt, String[] colNames) {
        for (int m = 0; m < kdt.getRowCount(); ++m) {
            ICell cell;
            int i;
            int n;
            IRow row = kdt.getRow(m);
            if (colNames != null) {
                n = colNames.length;
                for (i = 0; i < n; ++i) {
                    cell = row.getCell(colNames[i]);
                    cell.setValue(null);
                }
                continue;
            }
            n = kdt.getColumnCount();
            for (i = 0; i < n; ++i) {
                cell = row.getCell(i);
                cell.setValue(null);
            }
        }
    }

    protected FilterInfo getCostObjectFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyID));
        filter.getFilterItems().add(new FilterItemInfo("materialCompany.calculateType", (Object)"2"));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf(1)));
        if (this.combComputeMode.getSelectedItem() != null) {
            if (((CalculateModeEnum)this.combComputeMode.getSelectedItem()).equals((Object)CalculateModeEnum.BYBATCH)) {
                filter.getFilterItems().add(new FilterItemInfo("materialCompany.accountType", (Object)"5"));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("materialCompany.accountType", (Object)"5", CompareType.NOTEQUALS));
            }
        }
        FilterInfo notCreateCOByOrder = new FilterInfo();
        notCreateCOByOrder.getFilterItems().add(new FilterItemInfo("materialCompany.createCOByOrder", null));
        notCreateCOByOrder.getFilterItems().add(new FilterItemInfo("materialCompany.createCOByOrder", (Object)0));
        notCreateCOByOrder.setMaskString("#0 or #1");
        try {
            filter.mergeFilter(notCreateCOByOrder, "and");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return filter;
    }

    public void filterBOMF7(KDBizPromptBox f7, String companyOrgID, String stdProductId) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyOrgID));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)"4"));
        filter.getFilterItems().add(new FilterItemInfo("orgUnitRelation.toUnit.id", (Object)companyOrgID));
        if (stdProductId == null) {
            stdProductId = this.getStdProductID();
        }
        if (stdProductId.length() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)stdProductId));
        }
        EntityViewInfo eviBOM = new EntityViewInfo();
        eviBOM.setFilter(filter);
        f7.setEntityViewInfo(eviBOM);
    }

    public static void clearCells(KDTable kdt, int rowIndex, String[] colNames) {
        IRow row = kdt.getRow(rowIndex);
        if (colNames != null) {
            int n = colNames.length;
            for (int i = 0; i < n; ++i) {
                ICell cell = row.getCell(colNames[i]);
                cell.setValue(null);
            }
        } else {
            int n = kdt.getColumnCount();
            for (int i = 0; i < n; ++i) {
                ICell cell = row.getCell(i);
                cell.setValue(null);
            }
        }
    }

    public static void checkLoginCompanyOrgIsVirtual() {
        CompanyOrgUnitInfo companyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (companyOrgUnitInfo == null || !companyOrgUnitInfo.isIsBizUnit()) {
            MsgBox.showError((String)CostObjectEditUI.getResource("CannotOperationInVirtualOrgUnit"));
            SysUtil.abort();
        }
    }

    public static String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.assistant.CostObjectResource", (String)key);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("bomID"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("batchNumber"));
        sic.add(new SelectorItemInfo("calculateMode"));
        sic.add(new SelectorItemInfo("entries.quotiety"));
        sic.add(new SelectorItemInfo("entries.isMainProduct"));
        sic.add(new SelectorItemInfo("entries.isByproduct"));
        sic.add(new SelectorItemInfo("CostObjectGroup.*"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("entries.RelatedID"));
        sic.add(new SelectorItemInfo("entries.RelatedNumber"));
        sic.add(new SelectorItemInfo("entries.RelatedName"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("relatedType"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("orderID"));
        return sic;
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        if (this.isCostObjectGenByOrder(this.editData)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.CostObjectResource", (String)"OrderCO_CanNot_Copy"));
            return;
        }
        super.actionCopy_actionPerformed(e);
        for (int i = this.combComputeMode.getItemCount() - 1; i >= 0; --i) {
            if (!CalculateModeEnum.VARIET.equals(this.combComputeMode.getItemAt(i)) && !CalculateModeEnum.BYORDER.equals(this.combComputeMode.getItemAt(i))) continue;
            this.combComputeMode.removeItemAt(i);
        }
        this.combComputeMode.setEnabled(true);
    }

    private void batchNumberTrim() {
        String batchNumber = this.editData.getBatchNumber();
        if (batchNumber == null) {
            return;
        }
        batchNumber = batchNumber + " ";
        int j = 0;
        int k = 0;
        int i = 0;
        char[] stra = new char[batchNumber.length()];
        batchNumber.getChars(0, batchNumber.length(), stra, 0);
        i = batchNumber.length() - 1;
        while (i + 1 > 0 && (stra[i] == ' ' || stra[i] == '\u3000')) {
            k = i--;
        }
        batchNumber = new String(stra, j, k - j);
        this.editData.setBatchNumber(batchNumber.trim());
    }

    private boolean isCostObjectGenByOrder(CostObjectInfo costObject) {
        return costObject != null && CalculateModeEnum.BYORDER.equals((Object)costObject.getCalculateMode());
    }
}

