/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.CORelatedType;
import com.kingdee.eas.basedata.assistant.CalculateModeEnum;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectGroupFactory;
import com.kingdee.eas.basedata.assistant.CostObjectGroupInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.client.AbstractCostObjectListUI;
import com.kingdee.eas.basedata.assistant.client.BDCMClientUtils;
import com.kingdee.eas.basedata.assistant.client.COCommonQueryProcess;
import com.kingdee.eas.basedata.assistant.client.COGroupEditUI;
import com.kingdee.eas.basedata.assistant.client.CostObjectEditUI;
import com.kingdee.eas.basedata.assistant.client.CostObjectSetBomDataParamUI;
import com.kingdee.eas.basedata.assistant.client.OtherCostObjectEditUI;
import com.kingdee.eas.basedata.assistant.client.OverheadCostObjectEditUI;
import com.kingdee.eas.basedata.assistant.client.ProjectCostObjectEditUI;
import com.kingdee.eas.basedata.assistant.client.SynchronousCheckWizardUI;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.MoveTreeEvent;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.BizReference;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class CostObjectListUI
extends AbstractCostObjectListUI {
    private static final String COST_OBJECT_RESOURCE = "com.kingdee.eas.basedata.assistant.CostObjectResource";
    private static final Color FORBIDEN_COLOR = new Color(255, 255, 193);
    private CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
    private String companyID = this.currentCompany.getId().toString();
    private boolean isShouldSelectTree = true;
    private boolean isFirstLoad = true;
    private CommonQueryDialog dialog = null;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.core.fm.ClientHelper");
    public static final String RES = "com.kingdee.eas.base.core.fm.UIMessageResource";

    public CostObjectListUI() throws Exception {
        CostObjectFactory.getRemoteInstance().isCostObjectOfBillRequired(this.companyID);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionGroupMoveTree.setEnabled(true);
        this.actionGroupMoveTree.setVisible(true);
        this.actionMoveTree.setEnabled(true);
        this.actionMoveTree.setVisible(true);
        this.actionBatchAddnew.setEnabled(true);
        this.btnBatchAddnew.setVisible(true);
        this.actionLocate.setEnabled(true);
        this.actionBatchAddnew.setEnabled(false);
        this.pnlMain.setDividerLocation((this.getWidth() - 500) / 2);
        this.treeView.setShowButton(true);
        boolean iscompany = SysContext.getSysContext().getCurrentOrgUnit().isIsCompanyOrgUnit();
        CompanyOrgUnitInfo companyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (companyOrgUnitInfo == null || !companyOrgUnitInfo.isIsBizUnit() || !iscompany) {
            this.actionSynchronousCheck.setEnabled(false);
        } else {
            this.actionSynchronousCheck.setEnabled(true);
        }
        this.btnSynchronousCheck.setEnabled(false);
        this.btnSynchronousCheck.setVisible(false);
        this.kDMenuItemSynchronousCheck.setEnabled(false);
        this.kDMenuItemSynchronousCheck.setVisible(false);
        BDCMClientUtils.addNCMDataToolUI((CoreUIObject)this, this.menuEdit);
    }

    protected String getGroupEditUIName() {
        return COGroupEditUI.class.getName();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getRootName() {
        return EASResource.getString((String)COST_OBJECT_RESOURCE, (String)"CostObject");
    }

    protected String getQueryFieldName() {
        return "CostObjectGroup.id";
    }

    protected String getSelectDetailTreeName() {
        return "CostObjectGroup";
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return CostObjectGroupFactory.getRemoteInstance();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getEditUIName() {
        if (this.isFirstLoad) {
            this.isFirstLoad = false;
            return CostObjectEditUI.class.getName();
        }
        CORelatedType relatedType = null;
        if (this.isShouldSelectTree) {
            if (this.treeMain.getSelectionPath() == null) {
                return CostObjectEditUI.class.getName();
            }
            Object temp = this.getSelectedTreeNode().getUserObject();
            if (temp == null || !(temp instanceof CostObjectGroupInfo)) return CostObjectEditUI.class.getName();
            CostObjectGroupInfo groupInfo = (CostObjectGroupInfo)temp;
            relatedType = groupInfo.getRelatedType();
        } else {
            try {
                CostObjectInfo selectInfo = (CostObjectInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())));
                relatedType = selectInfo.getRelatedType();
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (UuidException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        if (CORelatedType.Product.equals((Object)relatedType)) {
            return CostObjectEditUI.class.getName();
        }
        if (CORelatedType.Project.equals((Object)relatedType)) {
            return ProjectCostObjectEditUI.class.getName();
        }
        if (!CORelatedType.Overhead.equals((Object)relatedType)) return OtherCostObjectEditUI.class.getName();
        return OverheadCostObjectEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CostObjectFactory.getRemoteInstance();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        COCommonQueryProcess cmcq = new COCommonQueryProcess();
        cmcq.set("companyid", SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        this.dialog.setProcessor((IProcessor)cmcq);
        return this.dialog;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyID, CompareType.EQUALS));
        return filter;
    }

    protected void applyPreference() {
        super.applyPreference();
        this.chkIncludeChild.setSelected(true);
        this.treeMain.setSelectionRow(0);
    }

    private FilterInfo getOldFilterInfo() {
        FilterInfo fi = new FilterInfo();
        HashSet<String> leafIdSetOld = new HashSet<String>();
        leafIdSetOld.add("bf0NjwEcEADgABWBwKgTycw5rkg=");
        fi.getFilterItems().add(new FilterItemInfo("id", leafIdSetOld, CompareType.NOTINCLUDE));
        return fi;
    }

    private FilterInfo getCommonFilterInfo() {
        FilterInfo fi = new FilterInfo();
        HashSet<String> leafIdSetNew = new HashSet<String>();
        leafIdSetNew.add("qtsXyapZTneI8TxJu+B2Q8w5rkg=");
        leafIdSetNew.add("qpkJKvmjSlyR6x4kMxWdz8w5rkg=");
        leafIdSetNew.add("ZMfbW/12RhCf5K6BbufhTMw5rkg=");
        leafIdSetNew.add("diT5keCxSGyRwp3nrwTPWsw5rkg=");
        leafIdSetNew.add("DFDpbFyBRL++FZTI1I+IA8w5rkg=");
        fi.getFilterItems().add(new FilterItemInfo("id", leafIdSetNew, CompareType.INCLUDE));
        return fi;
    }

    private FilterInfo getCompanyFilterInfo() {
        FilterInfo fi = new FilterInfo();
        String companyid = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
        return fi;
    }

    private FilterInfo getControlUnitFilterInfo() throws BOSException {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("company.id", null, CompareType.EQUALS));
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), (String)SysContext.getSysContext().getCurrentCtrlUnit().getLongNumber());
        fi.mergeFilter(filterInfoCU, "and");
        return fi;
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo leafFilterInfo = new FilterInfo();
        try {
            FilterInfo validInfo = new FilterInfo();
            validInfo.mergeFilter(this.getCommonFilterInfo(), "and");
            validInfo.mergeFilter(this.getControlUnitFilterInfo(), "or");
            validInfo.mergeFilter(this.getCompanyFilterInfo(), "or");
            FilterInfo invalidInfo = this.getOldFilterInfo();
            leafFilterInfo.mergeFilter(invalidInfo, "and");
            leafFilterInfo.mergeFilter(validInfo, "and");
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return leafFilterInfo;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        Object value;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows != null && selectRows.length > 0 && selectRows[0] >= 0 && (value = this.tblMain.getRow(selectRows[0]).getCell("number").getValue()) != null && "SCOID".equals(value.toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)COST_OBJECT_RESOURCE, (String)"SCO_CANNOT_EDIT_AND_DELETE"));
            return;
        }
        this.checkSelected();
        String selectKeyValue = this.getSelectedKeyValue();
        if (selectKeyValue == null) {
            return;
        }
        CostObjectInfo costObject = ((ICostObject)this.getBizInterface()).getCostObjectInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)selectKeyValue)));
        if (costObject == null) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        if (this.isCostObjectGenByOrder(costObject)) {
            MsgBox.showInfo((String)EASResource.getString((String)COST_OBJECT_RESOURCE, (String)"OrderCO_CanNot_Modify"));
            return;
        }
        this.isShouldSelectTree = false;
        super.actionEdit_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.isShouldSelectTree = false;
        super.actionView_actionPerformed(e);
    }

    @Override
    public void actionBatchAddnew_actionPerformed(ActionEvent e) throws Exception {
        if (this.currentCompany == null || !this.currentCompany.isIsBizUnit()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)COST_OBJECT_RESOURCE, (String)"notBizOrg"));
            return;
        }
        super.actionBatchAddnew_actionPerformed(e);
        int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)COST_OBJECT_RESOURCE, (String)"confirmGenerateCostObject"));
        if (2 == result) {
            return;
        }
        try {
            this.requestMutex(this.currentCompany.getId().toString());
            CostObjectFactory.getRemoteInstance().batchAddFromMaterial(this.currentCompany);
        }
        finally {
            this.releaseMutex(this.currentCompany.getId().toString());
        }
        MsgBox.showInfo((String)EASResource.getString((String)COST_OBJECT_RESOURCE, (String)"generateSuccessed"));
    }

    protected void requestMutex(String comID) throws Exception {
        try {
            this.setOprtState("CLOSING");
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            this.handUIException(t);
            this.abort();
        }
    }

    protected void releaseMutex(String comID) throws Exception {
        this.setOprtState("RELEASEALL");
        try {
            this.pubFireVOChangeListener("d3T+lgEaEADgAAobwKgRj53UGuM=" + comID);
        }
        catch (Throwable t) {
            this.handUIException(t);
        }
    }

    @Override
    protected void btnBatchAddnew_actionPerformed(ActionEvent e) throws Exception {
        super.btnBatchAddnew_actionPerformed(e);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnBatchAddnew.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.btnGenBomData.setIcon(EASResource.getIcon((String)"imgTbtn_BZinput"));
        this.kDMenuItemGenBomData.setIcon(EASResource.getIcon((String)"imgTbtn_BZinput"));
        this.btnSynchronousCheck.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
        this.kDMenuItemSynchronousCheck.setIcon(EASResource.getIcon((String)"imgTbtn_check"));
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        String id = this.getSelectedKeyValue();
        if (id != null) {
            ObjectUuidPK detail = new ObjectUuidPK(id);
            try {
                CostObjectInfo treeInfo = (CostObjectInfo)this.getBizInterface().getValue((IObjectPK)detail);
                if (treeInfo.getCostObjectGroup().getId() != null) {
                    ObjectUuidPK tree = new ObjectUuidPK(treeInfo.getCostObjectGroup().getId());
                    return tree;
                }
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        this.treeMain.setSelectionRow(0);
        return null;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.isFinalRoot()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"CanNotAddCO"));
            return;
        }
        this.isShouldSelectTree = true;
        super.actionAddNew_actionPerformed(e);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        this.isShouldSelectTree = false;
        super.tblMain_tableClicked(e);
    }

    protected boolean isOptimizeTree() {
        return true;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return true;
    }

    @Override
    public void forbid_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"71_CostObjectListUI"));
        if (2 == result) {
            return;
        }
        try {
            IObjectPK[] pks = this.getSelectPKS();
            if (pks == null || pks.length == 0) {
                return;
            }
            HashSet<String> pkSet = new HashSet<String>();
            for (int i = 0; i < pks.length; ++i) {
                pkSet.add(pks[i].toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", pkSet, CompareType.INCLUDE));
            view.setFilter(filter);
            CostObjectCollection col = CostObjectFactory.getRemoteInstance().getCostObjectCollection(view);
            for (int i = 0; i < col.size(); ++i) {
                CostObjectInfo costObject = col.get(i);
                if (costObject.getOrderID() == null || costObject.getOrderID().length() <= 0) continue;
                MsgBox.showError((String)EASResource.getString((String)COST_OBJECT_RESOURCE, (String)"OrderCO_CanNot_Forbid"));
                SysUtil.abort();
            }
            ((ICostObject)this.getBizInterface()).forbid(pks);
            CostObjectListUI.showSuccessMessage((CoreUI)this, e);
            this.refresh(e);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public static void showSuccessMessage(CoreUI ui, ActionEvent e) {
        if (e == null || !(e.getSource() instanceof Component)) {
            return;
        }
        String actionCommand = e.getActionCommand();
        if (e.getSource() instanceof AbstractButton) {
            AbstractButton btn = (AbstractButton)e.getSource();
            String txt = btn.getText();
            try {
                actionCommand = txt.replaceAll("\\(+[A-Z]+\\)", "");
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
                actionCommand = "";
            }
        }
        if (!EmptyUtil.isEmpty((String)actionCommand)) {
            ui.setMessageText(actionCommand + EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"141_CostObjectSuccess"));
            ui.showMessage();
            return;
        }
        Component component = (Component)e.getSource();
        CostObjectListUI.showSuccessInfo((Component)ui, component);
    }

    public static void showSuccessInfo(Component ui, Component component) {
        if (!(component instanceof KDWorkButton)) {
            return;
        }
        String text = ((KDWorkButton)component).getText();
        MsgBox.showInfo((Component)ui, (String)(text + EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"141_CostObjectSuccess")));
    }

    @Override
    public void unForbid_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().size() > 0) {
            HashSet<String> numberSet = new HashSet<String>();
            int blockSize = this.tblMain.getSelectManager().size();
            for (int blockIndex = 0; blockIndex < blockSize; ++blockIndex) {
                KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(blockIndex);
                if (selectBlock == null) continue;
                int rowSize = selectBlock.getBottom();
                for (int rowIndex = selectBlock.getTop(); rowIndex >= 0 && rowIndex <= rowSize; ++rowIndex) {
                    Object value = this.tblMain.getRow(rowIndex).getCell("number").getValue();
                    if (value == null) continue;
                    String number = value.toString();
                    if (numberSet.contains(number)) {
                        MsgBox.showInfo((String)EASResource.getString((String)COST_OBJECT_RESOURCE, (String)"SelRepeat_CanNot_UnForbid"));
                        return;
                    }
                    numberSet.add(number);
                }
            }
        }
        try {
            IObjectPK[] pks = this.getSelectPKS();
            ((ICostObject)this.getBizInterface()).unForbid(pks);
            CostObjectListUI.showSuccessMessage((CoreUI)this, e);
            this.refresh(e);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private IObjectPK[] getSelectPKS() {
        this.checkSelected();
        ArrayList list = super.getSelectedIdValues();
        int count = list.size();
        IObjectPK[] pks = null;
        if (count != 0) {
            pks = new IObjectPK[count];
            for (int i = 0; i < count; ++i) {
                pks[i] = new ObjectStringPK(list.get(i).toString());
            }
        }
        return pks;
    }

    public void onGetRowSet(IRowSet rowSet) {
        if (rowSet == null || rowSet.size() == 0) {
            this.forbid.setEnabled(false);
            this.unForbid.setEnabled(false);
        } else {
            this.forbid.setEnabled(true);
            this.unForbid.setEnabled(true);
        }
    }

    private boolean isSysDefinedRoot() {
        String groupId;
        return this.getSelectedTreeNode() == null || this.getSelectedTreeNode().getUserObject() == null || !(this.getSelectedTreeNode().getUserObject() instanceof CostObjectGroupInfo) || "qtsXyapZTneI8TxJu+B2Q8w5rkg=".equals(groupId = ((CostObjectGroupInfo)this.getSelectedTreeNode().getUserObject()).getId().toString()) || "qpkJKvmjSlyR6x4kMxWdz8w5rkg=".equals(groupId) || "diT5keCxSGyRwp3nrwTPWsw5rkg=".equals(groupId) || "ZMfbW/12RhCf5K6BbufhTMw5rkg=".equals(groupId) || "DFDpbFyBRL++FZTI1I+IA8w5rkg=".equals(groupId);
    }

    private boolean isFinalRoot() {
        boolean ret = false;
        if (this.getSelectedTreeNode() != null) {
            if (this.getSelectedTreeNode().getUserObject() != null && !(this.getSelectedTreeNode().getUserObject() instanceof CostObjectGroupInfo)) {
                ret = true;
            }
        } else {
            ret = true;
        }
        return ret;
    }

    private boolean isOverheadGroup() {
        String groupId;
        return this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() != null && this.getSelectedTreeNode().getUserObject() instanceof CostObjectGroupInfo && "diT5keCxSGyRwp3nrwTPWsw5rkg=".equals(groupId = ((CostObjectGroupInfo)this.getSelectedTreeNode().getUserObject()).getId().toString());
    }

    private boolean isAUXOverheadGroup() {
        String groupId;
        return this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() != null && this.getSelectedTreeNode().getUserObject() instanceof CostObjectGroupInfo && "DFDpbFyBRL++FZTI1I+IA8w5rkg=".equals(groupId = ((CostObjectGroupInfo)this.getSelectedTreeNode().getUserObject()).getId().toString());
    }

    private boolean isGenByMaterial() {
        String sourceID;
        return this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() != null && this.getSelectedTreeNode().getUserObject() instanceof CostObjectGroupInfo && (sourceID = ((CostObjectGroupInfo)this.getSelectedTreeNode().getUserObject()).getSourceId()) != null && sourceID.length() > 0;
    }

    @Override
    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.isFinalRoot()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"72_CostObjectListUI"));
            return;
        }
        if (this.isOverheadGroup()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"73_CostObjectListUI"));
            return;
        }
        super.actionGroupAddNew_actionPerformed(e);
    }

    protected void prepareGroupUIContext(UIContext uiContext, ActionEvent e) {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            if (uiContext.containsKey((Object)"ID") && uiContext.get((Object)"ID") != null) {
                if (treeNode.getParent() instanceof KDTreeNode) {
                    KDTreeNode parent = (KDTreeNode)treeNode.getParent();
                    if (parent.getUserObject().equals("\u6210\u672c\u5bf9\u8c61")) {
                        uiContext.put((Object)"ParentNode", treeNode.getUserObject());
                    } else if (parent.getUserObject() instanceof CostObjectGroupInfo) {
                        uiContext.put((Object)"ParentNode", parent.getUserObject());
                    } else {
                        uiContext.put((Object)"ParentNode", null);
                    }
                } else {
                    uiContext.put((Object)"ParentNode", null);
                }
            } else {
                uiContext.put((Object)"ParentNode", treeNode.getUserObject());
            }
            uiContext.put((Object)"thisNode", treeNode.getUserObject());
        } else {
            uiContext.put((Object)"ParentNode", null);
        }
    }

    @Override
    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isGenByMaterial()) {
            MsgBox.showError((String)"\u4e0d\u80fd\u4fee\u6539\u3001\u79fb\u52a8\u548c\u5220\u9664\u4ece\u7269\u6599\u5de6\u6811\u5217\u8868\u540c\u6b65\u8fc7\u6765\u7684\u8282\u70b9\u3002");
            return;
        }
        if (this.isSysDefinedRoot()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"56_COGroupEditUI"));
            return;
        }
        super.actionGroupEdit_actionPerformed(e);
    }

    @Override
    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.isGenByMaterial()) {
            MsgBox.showError((String)"\u4e0d\u80fd\u4fee\u6539\u3001\u79fb\u52a8\u548c\u5220\u9664\u4ece\u7269\u6599\u5de6\u6811\u5217\u8868\u540c\u6b65\u8fc7\u6765\u7684\u8282\u70b9\u3002");
            return;
        }
        if (this.isSysDefinedRoot()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"74_CostObjectListUI"));
            return;
        }
        if (this.tblMain.getRowCount() > 0) {
            String msg = EASResource.getString((String)"com.kingdee.eas.basedata.assistant.client.AssistantResource4", (String)"costObjectGroupContainCostObject");
            MsgBox.showError((Component)((Object)this), (String)msg);
            return;
        }
        super.actionGroupRemove_actionPerformed(e);
    }

    @Override
    public void actionGroupMoveTree_actionPerformed(ActionEvent e) throws Exception {
        if (this.isGenByMaterial()) {
            MsgBox.showError((String)"\u4e0d\u80fd\u4fee\u6539\u3001\u79fb\u52a8\u548c\u5220\u9664\u4ece\u7269\u6599\u5de6\u6811\u5217\u8868\u540c\u6b65\u8fc7\u6765\u7684\u8282\u70b9\u3002");
            return;
        }
        if (this.isSysDefinedRoot()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"75_CostObjectListUI"));
            return;
        }
        super.actionGroupMoveTree_actionPerformed(e);
    }

    protected void moveTreeNode(MoveTreeEvent e) {
        if (this.canMoveGroupTreeNode(e)) {
            CostObjectGroupInfo target = (CostObjectGroupInfo)e.getTargetTreeBaseInfo();
            if (target.isIsLeaf()) {
                super.moveTreeNode(e);
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"76_CostObjectListUI"));
            }
        }
    }

    protected void moveGroupTreeNode(MoveTreeEvent e) {
        if (this.canMoveGroupTreeNode(e)) {
            super.moveGroupTreeNode(e);
        }
    }

    private boolean canMoveGroupTreeNode(MoveTreeEvent e) {
        CostObjectGroupInfo source = (CostObjectGroupInfo)e.getSourceTreeBaseInfo();
        CostObjectGroupInfo target = (CostObjectGroupInfo)e.getTargetTreeBaseInfo();
        if (target == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"77_CostObjectListUI"));
            return false;
        }
        if (!source.getRelatedType().equals((Object)target.getRelatedType())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"78_CostObjectListUI"));
            return false;
        }
        if ("diT5keCxSGyRwp3nrwTPWsw5rkg=".equals(target.getId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"79_CostObjectListUI"));
            return false;
        }
        return true;
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() instanceof CostObjectGroupInfo && CORelatedType.Product.equals((Object)((CostObjectGroupInfo)this.getSelectedTreeNode().getUserObject()).getRelatedType())) {
            this.actionBatchAddnew.setEnabled(true);
        } else {
            this.actionBatchAddnew.setEnabled(false);
        }
    }

    @Override
    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
        this.refresh(e);
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "costobject";
        param.alias = EASResource.getString((String)"com.kingdee.eas.basedata.assistant.ASSISTANTAutoGenerateResource", (String)"80_CostObjectListUI");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int start = e.getFirstRow();
                int end = e.getLastRow();
                CostObjectListUI.this.setTreeDisplayStyle(start, end + 1);
            }
        });
    }

    private void setTreeDisplayStyle(int start, int end) {
        int count = end;
        for (int i = start; i < count; ++i) {
            boolean isForbiden;
            Object value;
            IRow row = this.tblMain.getRow(i);
            if (row == null) continue;
            if (row.getCell("isForbiden") != null && row.getCell("isForbiden").getValue() != null && (value = row.getCell("isForbiden").getValue()) instanceof Boolean && (isForbiden = ((Boolean)value).booleanValue())) {
                row.getStyleAttributes().setBackground(FORBIDEN_COLOR);
            }
            if (row.getCell("isMoreBom") == null || row.getCell("isMoreBom").getValue() == null || !((value = row.getCell("isMoreBom").getValue()) instanceof Boolean) || !(isForbiden = ((Boolean)value).booleanValue())) continue;
            row.getStyleAttributes().setBackground(new Color(255, 255, 100));
        }
    }

    private boolean isRefByCostObject(TreeBaseInfo tree) throws EASBizException, BOSException {
        if (tree != null) {
            FilterInfo fiCU = new FilterInfo();
            fiCU.getFilterItems().add(new FilterItemInfo("company.id", null, CompareType.EQUALS));
            FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)SysContext.getSysContext().getCurrentFIUnit().getId().toString(), (String)SysContext.getSysContext().getCurrentFIUnit().getLongNumber());
            fiCU.mergeFilter(filterInfoCU, "and");
            FilterInfo fiCompany = new FilterInfo();
            CompanyOrgUnitInfo companyInfo = SysContext.getSysContext().getCurrentFIUnit();
            if (companyInfo != null && companyInfo.getId() != null) {
                fiCompany.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString()));
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("CostObjectGroup.id", (Object)tree.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"SCOID", CompareType.NOTEQUALS));
            fiCU.mergeFilter(fiCompany, "or");
            filterInfo.mergeFilter(fiCU, "and");
            ICostObject icostObject = CostObjectFactory.getRemoteInstance();
            boolean exists = icostObject.exists(filterInfo);
            return exists;
        }
        return false;
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String selectKeyValue = this.getSelectedKeyValue();
        if (selectKeyValue == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("Bom.*"));
        sic.add(new SelectorItemInfo("Bom.material.*"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("batchNumber"));
        sic.add(new SelectorItemInfo("calculateMode"));
        sic.add(new SelectorItemInfo("entries.quotiety"));
        sic.add(new SelectorItemInfo("entries.isMainProduct"));
        sic.add(new SelectorItemInfo("entries.isByproduct"));
        sic.add(new SelectorItemInfo("CostObjectGroup.*"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("entries.RelatedID"));
        sic.add(new SelectorItemInfo("entries.RelatedNumber"));
        sic.add(new SelectorItemInfo("entries.RelatedName"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("relatedType"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("orderID"));
        sic.add(new SelectorItemInfo("sourceBillNumber"));
        sic.add(new SelectorItemInfo("standardRation"));
        CostObjectInfo costObject = ((ICostObject)this.getBizInterface()).getCostObjectInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)selectKeyValue)), sic);
        if (costObject == null) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        if (CORelatedType.Product.equals((Object)costObject.getRelatedType()) && CalculateModeEnum.VARIET.equals((Object)costObject.getCalculateMode())) {
            MsgBox.showInfo((String)EASResource.getString((String)COST_OBJECT_RESOURCE, (String)"CANNOT_COPY_VARIET"));
            return;
        }
        if (this.isCostObjectGenByOrder(costObject)) {
            MsgBox.showInfo((String)EASResource.getString((String)COST_OBJECT_RESOURCE, (String)"OrderCO_CanNot_Copy"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)selectKeyValue);
        uiContext.put((Object)"InitDataObject", (Object)costObject);
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"ActionEvent", (Object)e);
        String editUIName = this.getEditUIName();
        if (editUIName == null) {
            editUIName = CORelatedType.Product.equals((Object)costObject.getCostObjectGroup().getRelatedType()) ? CostObjectEditUI.class.getName() : (CORelatedType.Project.equals((Object)costObject.getCostObjectGroup().getRelatedType()) ? ProjectCostObjectEditUI.class.getName() : (CORelatedType.Overhead.equals((Object)costObject.getCostObjectGroup().getRelatedType()) ? OverheadCostObjectEditUI.class.getName() : OtherCostObjectEditUI.class.getName()));
        }
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(editUIName, (Map)uiContext, null, "COPY") : UIFactory.createUIFactory((String)this.getEditUIModal()).create(editUIName, (Map)uiContext, null, "COPY");
        uiWindow.show();
        if (this.isDoRefresh(uiWindow)) {
            if (UtilRequest.isPrepare((String)"ActionRefresh", (CoreUIObject)this)) {
                this.prepareRefresh(null).callHandler();
            }
            this.setLocatePre(false);
            this.refresh(e);
            this.setPreSelecteRow();
            this.setLocatePre(true);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().size() > 0) {
            int blockSize = this.tblMain.getSelectManager().size();
            for (int blockIndex = 0; blockIndex < blockSize; ++blockIndex) {
                KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(blockIndex);
                if (selectBlock == null) continue;
                HashSet<String> pkSet = new HashSet<String>();
                int rowSize = selectBlock.getBottom();
                for (int rowIndex = selectBlock.getTop(); rowIndex >= 0 && rowIndex <= rowSize; ++rowIndex) {
                    String id = this.tblMain.getRow(rowIndex).getCell("id").getValue().toString();
                    pkSet.add(id);
                    Object value = this.tblMain.getRow(rowIndex).getCell("number").getValue();
                    if (value == null || !"SCOID".equals(value.toString())) continue;
                    MsgBox.showInfo((String)EASResource.getString((String)COST_OBJECT_RESOURCE, (String)"SCO_CANNOT_EDIT_AND_DELETE"));
                    return;
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", pkSet, CompareType.INCLUDE));
                view.setFilter(filter);
                CostObjectCollection col = CostObjectFactory.getRemoteInstance().getCostObjectCollection(view);
                for (int i = 0; i < col.size(); ++i) {
                    CostObjectInfo costObject = col.get(i);
                    if (costObject.getOrderID() != null && costObject.getOrderID().length() > 0) {
                        MsgBox.showError((String)EASResource.getString((String)COST_OBJECT_RESOURCE, (String)"OrderCO_CanNot_Delete"));
                        SysUtil.abort();
                    }
                    if (this.isCostObjectGenByMat(costObject)) {
                        MsgBox.showInfo((String)"\u4e0d\u80fd\u624b\u5de5\u5220\u9664\u4ece\u7269\u6599\u57fa\u7840\u8d44\u6599\u540c\u6b65\u8fc7\u6765\u7684\u6210\u672c\u5bf9\u8c61\u3002");
                        return;
                    }
                    if (!CORelatedType.Overhead.equals((Object)costObject.getRelatedType())) continue;
                    try {
                        costObject.getEntries();
                        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)costObject.getEntries().get(0).getRelatedID().toString()));
                        this.getBizInterface().isReferenced((IObjectPK)pk);
                        continue;
                    }
                    catch (ObjectReferedException ex) {
                        BizReference ref = (BizReference)ex.getReferingObject();
                        throw new ObjectReferedException((Object)ref, (Throwable)ex);
                    }
                }
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionGenBomData_actionPerformed(ActionEvent e) throws Exception {
        this.checkAuditPermission("bd_assistant_costObject_update");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"companyID", (Object)this.companyID);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CostObjectSetBomDataParamUI.class.getName(), (Map)uiContext, null);
        uiWindow.show();
        this.refresh(e);
    }

    @Override
    public void actionSynchronousCheck_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"companyID", (Object)this.companyID);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SynchronousCheckWizardUI.class.getName(), (Map)uiContext, null);
        uiWindow.show();
    }

    private boolean isCostObjectGenByOrder(CostObjectInfo costObject) {
        return costObject != null && CalculateModeEnum.BYORDER.equals((Object)costObject.getCalculateMode());
    }

    private boolean isCostObjectGenByMat(CostObjectInfo costObject) {
        return costObject != null && CalculateModeEnum.VARIET.equals((Object)costObject.getCalculateMode()) && 0 == costObject.getRelatedType().getValue();
    }

    protected void beforeExcutQuery(EntityViewInfo evi) {
        if (evi.getSorter().size() == 0) {
            SorterItemCollection sort = evi.getSorter();
            sort.add(new SorterItemInfo("number"));
        }
        super.beforeExcutQuery(evi);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK arg0, EntityViewInfo arg1) {
        IQueryExecutor qe = super.getQueryExecutor(arg0, arg1);
        return qe;
    }

    private boolean checkAuditPermission(String printPermission) throws Exception {
        boolean bPermission = false;
        if (!printPermission.equals("")) {
            PermissionHelper.checkFunctionPermission(null, null, (String)printPermission);
            bPermission = true;
        }
        return bPermission;
    }
}

