/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectGroupFactory;
import com.kingdee.eas.basedata.assistant.CostObjectGroupInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.client.AbstractProjectCostObjectListUI;
import com.kingdee.eas.basedata.assistant.client.BDCMClientUtils;
import com.kingdee.eas.basedata.assistant.client.COCommonQueryProcess;
import com.kingdee.eas.basedata.assistant.client.COGroupEditUI;
import com.kingdee.eas.basedata.assistant.client.ProjectCostObjectEditUI;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.MoveTreeEvent;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public class ProjectCostObjectListUI
extends AbstractProjectCostObjectListUI {
    public String resClassName = "com.kingdee.eas.basedata.assistant.client.AssistantResource4";
    private CommonQueryDialog dialog;

    public ProjectCostObjectListUI() throws Exception {
        this.menuBiz.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        if (SysContext.getSysContext().getCurrentFIUnit() == null) {
            MsgBox.showError((String)EASResource.getString((String)this.resClassName, (String)"SysCuNotCostObject"));
            SysUtil.abort();
        }
        this.menuItemImportData.setVisible(false);
        super.onLoad();
        this.mainQuery.setIngorePreOrders(true);
        this.btnMoveTree.setVisible(false);
        if (this.treeMain.getRowCount() > 0) {
            this.treeMain.setSelectionRow(0);
        }
        BDCMClientUtils.addNCMDataToolUI((CoreUIObject)this, this.menuEdit);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo defaultFilterInfo = super.getDefaultFilterForQuery();
        FilterInfo filterInfo = new FilterInfo();
        String companyid = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
        try {
            defaultFilterInfo.mergeFilter(filterInfo, "and");
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        return defaultFilterInfo;
    }

    protected void buildTreeFilter() {
        super.buildTreeFilter();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getGroupEditUIName() {
        return COGroupEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "CostObjectGroup.id";
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return CostObjectGroupFactory.getRemoteInstance();
    }

    @Override
    protected String getEditUIName() {
        return ProjectCostObjectEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CostObjectFactory.getRemoteInstance();
    }

    protected String getLongNumberFieldName() {
        return "CostObjectGroup.longNumber";
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getRootName() {
        return EASResource.getString((String)this.resClassName, (String)"CostObjectName");
    }

    protected ArrayList getImportCostObjectParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = EASResource.getString((String)this.resClassName, (String)"costObjectImportSolutionPath");
        param.alias = EASResource.getString((String)this.resClassName, (String)"CostObjectName");
        param.varList = new ArrayList();
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        String id = this.getSelectedKeyValue();
        if (id != null) {
            ObjectUuidPK detail = new ObjectUuidPK(id);
            try {
                CostObjectInfo treeInfo = (CostObjectInfo)this.getBizInterface().getValue((IObjectPK)detail);
                if (treeInfo.getCostObjectGroup() != null) {
                    ObjectUuidPK tree = new ObjectUuidPK(treeInfo.getCostObjectGroup().getId());
                    return tree;
                }
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        this.treeMain.setSelectionRow(0);
        return null;
    }

    protected String getSelectDetailTreeName() {
        return "CostObjectGroup";
    }

    protected boolean canMoveDetailToRoot() {
        return false;
    }

    public void actionMoveTree_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        Object sourceOject = treeNode.getUserObject();
        if (!(sourceOject instanceof CostObjectGroupInfo)) {
            String msg = EASResource.getString((String)this.resClassName, (String)"costObjectGroupInvalid");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            return;
        }
        super.actionMoveTree_actionPerformed(e);
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() > 0) {
            String msg = EASResource.getString((String)this.resClassName, (String)"costObjectGroupContainCostObject");
            MsgBox.showError((Component)((Object)this), (String)msg);
            return;
        }
        super.actionGroupRemove_actionPerformed(e);
    }

    protected void moveTreeNode(MoveTreeEvent e) {
        if (this.canMoveGroupTreeNode(e)) {
            super.moveTreeNode(e);
        }
    }

    protected void moveGroupTreeNode(MoveTreeEvent e) {
        if (this.canMoveGroupTreeNode(e)) {
            super.moveGroupTreeNode(e);
        }
    }

    private boolean canMoveGroupTreeNode(MoveTreeEvent e) {
        CostObjectGroupInfo source = (CostObjectGroupInfo)e.getSourceTreeBaseInfo();
        CostObjectGroupInfo target = (CostObjectGroupInfo)e.getTargetTreeBaseInfo();
        if (!(target == null || source.getRelatedType().equals((Object)target.getRelatedType()) && source.getCalculateMode().equals((Object)target.getCalculateMode()))) {
            String msg = EASResource.getString((String)this.resClassName, (String)"costObjectGroupNotSuited");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            return false;
        }
        return true;
    }

    protected ArrayList getImportTypeParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = EASResource.getString((String)this.resClassName, (String)"costObjectImportSolutionPath");
        param.varList = new ArrayList();
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode node = this.getSelectedTreeNode();
        if (!node.isLeaf()) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resClassName, (String)"AddNewCostObject"));
            return;
        }
        super.actionAddNew_actionPerformed(e);
    }

    protected FilterInfo getDefaultFilterForTree() {
        String companyid = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid, CompareType.EQUALS));
        return filterInfo;
    }

    protected boolean isOptimizeTree() {
        return true;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        COCommonQueryProcess cmcq = new COCommonQueryProcess();
        cmcq.set("companyid", SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        this.dialog.setProcessor((IProcessor)cmcq);
        return this.dialog;
    }
}

