/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.common.perf.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.job.JobStateEnum;
import com.kingdee.eas.basedata.common.perf.JobInstExtFactory;
import com.kingdee.eas.basedata.common.perf.JobInstExtHstFactory;
import com.kingdee.eas.basedata.common.perf.client.AbstractJobInstExtListUI;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.AbstractButton;

public class JobInstExtListUI
extends AbstractJobInstExtListUI {
    private static final long serialVersionUID = -6573686893007535474L;
    protected static final String COL_STATE = "state";
    protected boolean isCurrentQueryHst = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initButtonAndMenuItemStatus();
    }

    private void initButtonAndMenuItemStatus() {
        AbstractButton[] hideBtns = new AbstractButton[]{this.btnAddNew, this.btnView, this.btnEdit, this.btnQueryCurrent, this.btnLocate, this.menuItemAddNew, this.menuEdit, this.menuItemView, this.menuItemLocate, this.btnViewResult};
        this.setButtonVisibleAndEnabled(hideBtns, false, false);
        this.setBizButtonDisabled();
        this.setBizButtonEnabled();
    }

    protected void setBizButtonDisabled() {
        AbstractButton[] disabledBtns = new AbstractButton[]{this.btnAbortJob, this.btnDumpJobs, this.btnRemove};
        this.setButtonVisibleAndEnabled(disabledBtns, true, false);
    }

    protected void setBizButtonEnabled() {
        AbstractButton[] enabledBtns = new AbstractButton[]{this.btnQueryHst, this.btnQueryCurrent};
        this.setButtonVisibleAndEnabled(enabledBtns, true, true);
        this.btnQueryCurrent.setVisible(false);
    }

    protected void setButtonVisibleAndEnabled(AbstractButton[] btns, boolean visible, boolean enabled) {
        int len = btns.length;
        for (int i = 0; i < len; ++i) {
            btns[i].setEnabled(enabled);
            btns[i].setVisible(visible);
        }
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        this.setStateInfoValue();
    }

    private void setStateInfoValue() {
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isCurrentQueryHst) {
            return;
        }
        this.checkSelected();
        int ret = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PerfResource.RemoveHstConfirm"));
        if (0 == ret) {
            ArrayList idList = this.getSelectedIdValues();
            IObjectPK[] pks = new IObjectPK[idList.size()];
            int size = idList.size();
            for (int i = 0; i < size; ++i) {
                pks[i] = new ObjectStringPK((String)idList.get(i));
            }
            JobInstExtHstFactory.getRemoteInstance().deleteBatchData(pks);
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PerfResource.OperateComplete"));
            this.showMessage();
            this.refresh(null);
        }
    }

    @Override
    public void actionAbortJob_actionPerformed(ActionEvent e) throws Exception {
        if (this.isCurrentQueryHst) {
            return;
        }
        this.checkSelected();
        int ret = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PerfResource.AbortJobConfirm"));
        if (0 == ret) {
            ArrayList idList = this.getSelectedIdValues();
            int result = JobInstExtFactory.getRemoteInstance().cancel(idList);
            StringBuffer tip = new StringBuffer();
            tip.append(EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PerfResource.CancelPre")).append(" ").append(result).append(" ").append(EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PerfResource.CancelLast"));
            if (idList.size() > result) {
                tip.append("\uff0c\r\n").append(EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PerfResource.CancelPre2")).append(" ").append(idList.size() - result).append(" ").append(EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PerfResource.CancelLast2"));
            }
            tip.append("\u3002");
            MsgBox.showInfo((String)tip.toString());
            if (result > 0) {
                this.refresh(null);
            }
        }
    }

    @Override
    public void actionDumpJobs_actionPerformed(ActionEvent e) throws Exception {
        if (this.isCurrentQueryHst) {
            return;
        }
        this.checkSelected();
        JobInstExtFactory.getRemoteInstance().dump(this.getSelectedIdValues());
        this.refresh(null);
    }

    protected String getEditUIName() {
        return null;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return JobInstExtFactory.getRemoteInstance();
    }

    protected void setActionState() {
        if (this.isCurrentQueryHst) {
            return;
        }
        super.setActionState();
        HashSet<String> s = new HashSet<String>();
        this.getSelectedIdValues();
        ArrayList list = this.getSelectList();
        if (list != null && list.size() > 0) {
            s.add("abortJob");
            s.add("viewResult");
            s.add("dumpJobs");
            int row = (Integer)list.get(0);
            BizEnumValueDTO objValue = (BizEnumValueDTO)this.tblMain.getCell(row, COL_STATE).getValue();
            JobStateEnum stateEnum = JobStateEnum.getEnum((String)((String)objValue.getValue()));
            if (!JobStateEnum.COMPLETE.equals((Object)stateEnum) && !JobStateEnum.FAILED.equals((Object)stateEnum)) {
                s.remove("viewResult");
            }
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                row = (Integer)list.get(i);
                objValue = (BizEnumValueDTO)this.tblMain.getCell(row, COL_STATE).getValue();
                stateEnum = JobStateEnum.getEnum((String)((String)objValue.getValue()));
                if (stateEnum == null) continue;
                if (JobStateEnum.RUNNING.equals((Object)stateEnum) || JobStateEnum.READY.equals((Object)stateEnum) || JobStateEnum.WAITING.equals((Object)stateEnum) || JobStateEnum.CREATED.equals((Object)stateEnum) || JobStateEnum.RESCHEDULED.equals((Object)stateEnum)) {
                    s.remove("dumpJobs");
                } else {
                    s.remove("abortJob");
                }
                if (!s.contains("dumpJobs") && !s.contains("abortJob")) break;
            }
        }
        this.btnDumpJobs.setEnabled(s.contains("dumpJobs"));
        this.btnAbortJob.setEnabled(s.contains("abortJob"));
        this.btnViewResult.setEnabled(s.contains("viewResult"));
    }

    @Override
    public void actionQueryHst_actionPerformed(ActionEvent e) throws Exception {
        if (this.isCurrentQueryHst) {
            this.mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.basedata.common.perf.app", (String)"JobInstExtQuery");
        } else {
            this.mainQueryPK = MetaDataPK.create((String)"com.kingdee.eas.basedata.common.perf.app", (String)"JobInstExtHstQuery");
            this.setBizButtonDisabled();
        }
        this.btnQueryCurrent.setVisible(!this.isCurrentQueryHst);
        this.btnQueryHst.setVisible(this.isCurrentQueryHst);
        this.isCurrentQueryHst = !this.isCurrentQueryHst;
        this.btnRemove.setEnabled(this.isCurrentQueryHst);
        this.refresh(null);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = super.getDefaultFilterForQuery();
        if (null == filterInfo) {
            filterInfo = new FilterInfo();
        }
        if (this.isNeedUserFilter()) {
            String userid = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            filterInfo.getFilterItems().add(new FilterItemInfo("userid", (Object)userid));
        }
        return filterInfo;
    }

    protected boolean isNeedUserFilter() {
        return true;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnViewResult.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.btnAbortJob.setIcon(EASResource.getIcon((String)"imgTbtn_cancelcheck"));
        this.btnDumpJobs.setIcon(EASResource.getIcon((String)"imgTbtn_conversionsave"));
        this.btnQueryCurrent.setIcon(EASResource.getIcon((String)"imgTbtn_demandnoncedata"));
        this.btnQueryHst.setIcon(EASResource.getIcon((String)"imgTbtn_demandhistorydata"));
    }
}

