/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.common.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.StateInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.eas.base.job.JobStateEnum;
import com.kingdee.eas.basedata.common.perf.JobInstExtCollection;
import com.kingdee.eas.basedata.common.perf.JobInstExtInfo;
import com.kingdee.eas.basedata.common.perf.JobInstStatusFacadeFactory;
import com.kingdee.eas.basedata.common.perf.client.JobSwingWorker;
import com.kingdee.eas.basedata.common.perf.client.ctrl.WinMsgManager;
import com.kingdee.eas.util.client.EASResource;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JobMonitorManager {
    private static JobMonitorManager instance = null;
    private Map jobMap = Collections.synchronizedMap(new HashMap());
    private Thread refreshThread = new Thread(new RefreshStatusTask());
    private int refreshInterval = 5;

    private JobMonitorManager() {
        this.refreshThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobMonitorManager getInstance() {
        Class<JobMonitorManager> clazz = JobMonitorManager.class;
        synchronized (JobMonitorManager.class) {
            if (instance == null) {
                instance = new JobMonitorManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitorInfo(String jobId, String jobTitle) {
        JobSwingWorker worker = new JobSwingWorker(jobId);
        MonitorInfo info = new MonitorInfo(jobTitle, null, (SwingWorker)worker, null, false);
        Map map = this.jobMap;
        synchronized (map) {
            this.jobMap.put(jobId, info);
        }
        ThreadPool.addActionThread((MonitorInfo)info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitorInfo(String jobId, String jobTitle, JobSwingWorker worker) {
        MonitorInfo info = new MonitorInfo(jobTitle, null, (SwingWorker)worker, null, false);
        Map map = this.jobMap;
        synchronized (map) {
            this.jobMap.put(jobId, info);
        }
        ThreadPool.addActionThread((MonitorInfo)info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void afterJobFinished(String jobId, JobStateEnum jobStateEnum) {
        String s;
        MonitorInfo info = null;
        Map map = this.jobMap;
        synchronized (map) {
            info = (MonitorInfo)this.jobMap.remove(jobId);
        }
        if (null == info) {
            return;
        }
        ThreadPool.destroyMonitor((MonitorInfo)info);
        if (JobStateEnum.COMPLETE.equals((Object)jobStateEnum)) {
            s = EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PERFAutoGenerateResource", (String)"16_JobMonitorManager");
        } else if (JobStateEnum.FAILED.equals((Object)jobStateEnum)) {
            s = EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PERFAutoGenerateResource", (String)"17_JobMonitorManager");
        } else if (JobStateEnum.ABORTED.equals((Object)jobStateEnum)) {
            s = EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PERFAutoGenerateResource", (String)"18_JobMonitorManager");
        } else {
            return;
        }
        MessageFormat mf = new MessageFormat(s);
        String title = mf.format(new String[]{info.getTitle()});
        info.setTitle(title);
        ThreadPool.addActionThread((MonitorInfo)info);
        WinMsgManager.newWinMsg(EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PERFAutoGenerateResource", (String)"19_JobMonitorManager"), info.getTitle(), info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refreshProgress() throws BOSException {
        String[] ids = null;
        Map map = this.jobMap;
        synchronized (map) {
            Set idSet = this.jobMap.keySet();
            if (idSet == null || idSet.size() == 0) {
                return;
            }
            ids = new String[idSet.size()];
            Iterator iterator = idSet.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                ids[index] = (String)iterator.next();
                ++index;
            }
        }
        JobInstExtCollection jobInstCol = JobInstStatusFacadeFactory.getRemoteInstance().queryJobInstStatus(ids);
        if (null == jobInstCol || jobInstCol.size() == 0) {
            return;
        }
        Map map2 = this.jobMap;
        synchronized (map2) {
            int size = jobInstCol.size();
            for (int i = 0; i < size; ++i) {
                JobInstExtInfo jobInfo = jobInstCol.get(i);
                MonitorInfo monitorInfo = (MonitorInfo)this.jobMap.get(jobInfo.getId().toString());
                if (null == monitorInfo || null == monitorInfo.getWorker()) continue;
                JobSwingWorker jobSwingWorker = (JobSwingWorker)monitorInfo.getWorker();
                StateInfo stateInfo = new StateInfo();
                stateInfo.setKey(jobInfo.getId().toString());
                stateInfo.setProgress((int)jobInfo.getProgress());
                stateInfo.setProgressDetail(jobInfo.getProgressDetail());
                stateInfo.setCanStop(this.isCanStop(jobInfo));
                jobSwingWorker.setStateInfo(stateInfo);
                jobSwingWorker.setJobStateEnum(jobInfo.getState());
            }
        }
    }

    private boolean isCanStop(JobInstExtInfo jobInfo) {
        if (null == jobInfo) {
            return false;
        }
        if (jobInfo.getJobType() == 1) {
            return true;
        }
        JobStateEnum jobState = jobInfo.getState();
        return JobStateEnum.CREATED.equals((Object)jobState) || JobStateEnum.WAITING.equals((Object)jobState) || JobStateEnum.READY.equals((Object)jobState) || JobStateEnum.RESCHEDULED.equals((Object)jobState);
    }

    private class RefreshStatusTask
    implements Runnable {
        RefreshStatusTask() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        JobMonitorManager.this.refreshProgress();
                        Thread.sleep(JobMonitorManager.this.refreshInterval * 1000);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

