/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.common.perf.client.ctrl;

import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.eas.basedata.common.perf.client.ctrl.IWinMsgManager;
import com.kingdee.eas.basedata.common.perf.client.ctrl.WindowMessage;
import com.kingdee.eas.util.client.EASResource;
import java.awt.GraphicsConfiguration;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JWindow;

public class WinMsgManager
implements Runnable,
IWinMsgManager {
    private static WinMsgManager winMsgMgr = null;
    private static List WinMsgList = null;
    private static int currentScreen = 0;
    private int stateBarHight = 0;
    private int msgHight = 150;
    private int ScreenHeight = 0;

    private WinMsgManager() {
        JWindow win = new JWindow();
        this.stateBarHight = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)win.getGraphicsConfiguration()).bottom;
        currentScreen = Toolkit.getDefaultToolkit().getScreenSize().height - this.stateBarHight;
        this.ScreenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        WinMsgList = Collections.synchronizedList(new ArrayList());
    }

    public static synchronized WinMsgManager getWinMsgManager() {
        if (winMsgMgr == null) {
            winMsgMgr = new WinMsgManager();
            new Thread(winMsgMgr).start();
        }
        return winMsgMgr;
    }

    public static void newWinMsg(String title, String msg, MonitorInfo info) {
        WindowMessage winMsg = new WindowMessage("250", "150", title, msg, info);
        WinMsgManager.getWinMsgManager().initWinMsg(winMsg);
    }

    public static void newWinMsg(String width, String height, String title, String msg, MonitorInfo info) {
        WindowMessage winMsg = new WindowMessage(width, height, title, msg, info);
        WinMsgManager.getWinMsgManager().initWinMsg(winMsg);
    }

    private void initWinMsg(WindowMessage winMsg) {
        new Thread(winMsg).start();
    }

    @Override
    public synchronized void adapterWindow(JWindow winMsg) {
        if (winMsg == null) {
            return;
        }
        WindowMessage windowMsg = (WindowMessage)winMsg;
        if (windowMsg.getOperatorState() == 101 && windowMsg.getMessageWindowState() != 2) {
            this.openWinMsg(windowMsg);
            windowMsg.setOperatorState(0);
        } else if (windowMsg.getOperatorState() == 111 && windowMsg.getMessageWindowState() == 2) {
            this.closingWinMsg(windowMsg);
        } else if (windowMsg.getOperatorState() == 110 && windowMsg.getMessageWindowState() == 2) {
            this.closeWin(windowMsg);
        }
    }

    private void openWinMsg(WindowMessage WindowMsg) {
        WinMsgList.add(WindowMsg);
        if (currentScreen > 0) {
            currentScreen = this.ScreenHeight - this.msgHight * WinMsgList.size() - this.stateBarHight;
        }
        this.moveUp(WindowMsg);
        WindowMsg.setMessageWindowState(2);
    }

    private void closingWinMsg(WindowMessage WindowMsg) {
        currentScreen = WindowMsg.getLocation().y;
        this.moveDown(WindowMsg);
        WindowMsg.setMessageWindowState(4);
        if (WinMsgList.size() > 0) {
            Iterator it = WinMsgList.iterator();
            WindowMessage winMsg = null;
            while (it.hasNext()) {
                winMsg = (WindowMessage)it.next();
                if (winMsg.getMessageWindowState() != 2) continue;
                this.move(winMsg);
            }
        }
        if (WinMsgList.size() > 0) {
            WinMsgList.remove(WindowMsg);
            currentScreen = this.ScreenHeight - this.msgHight * WinMsgList.size() - this.stateBarHight;
        }
        WindowMsg.setMessageWindowState(4);
        WindowMsg.dispose();
    }

    private void closeWin(WindowMessage winMsg) {
        currentScreen = winMsg.getLocation().y;
        winMsg.setLocation(winMsg.getLocation().x, winMsg.getLocation().y + this.msgHight);
        winMsg.setMessageWindowState(4);
        if (WinMsgList.size() > 0) {
            Iterator it = WinMsgList.iterator();
            WindowMessage winMsgs = null;
            while (it.hasNext()) {
                winMsgs = (WindowMessage)it.next();
                if (winMsgs.getMessageWindowState() != 2) continue;
                this.move(winMsgs);
            }
        }
        if (WinMsgList.size() > 0) {
            WinMsgList.remove(winMsg);
            currentScreen = this.ScreenHeight - this.msgHight * WinMsgList.size() - this.stateBarHight;
        }
        winMsg.setMessageWindowState(4);
        winMsg.dispose();
    }

    private void moveUp(WindowMessage winMsg) {
        while (winMsg.getLocation().y > currentScreen) {
            winMsg.setLocation(winMsg.getLocation().x, winMsg.getLocation().y - 2);
            try {
                Thread.sleep(2L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (winMsg.getLocation().y == currentScreen) {
            currentScreen = this.ScreenHeight - this.msgHight * WinMsgList.size() - this.stateBarHight;
        }
    }

    private void moveDown(WindowMessage winMsg) {
        while (winMsg.getLocation().y < this.ScreenHeight) {
            winMsg.setLocation(winMsg.getLocation().x, winMsg.getLocation().y + 2);
            try {
                Thread.sleep(2L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void move(WindowMessage winMsg) {
        while (winMsg.getLocation().y < currentScreen) {
            winMsg.setLocation(winMsg.getLocation().x, winMsg.getLocation().y + 2);
            try {
                Thread.sleep(2L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (currentScreen == winMsg.getLocation().y) {
            currentScreen -= this.msgHight;
        }
    }

    @Override
    public void run() {
        this.adapterWindow(null);
    }

    public static void main(String[] args) throws InterruptedException {
        for (int i = 0; i < 4; ++i) {
            WinMsgManager.newWinMsg(EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PERFAutoGenerateResource", (String)"14_WindowMessage"), EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PERFAutoGenerateResource", (String)"15_WindowMessage"), null);
        }
    }
}

