/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.common.perf.client.ctrl;

import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.basedata.common.perf.client.ctrl.WinMsgManager;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JEditorPane;
import javax.swing.JWindow;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class WindowMessage
extends JWindow
implements HyperlinkListener,
Runnable {
    private static final String res = "com.kingdee.eas.basedata.common.perf.PerfResource";
    private static final long serialVersionUID = 1L;
    public static final int NOINIT = 0;
    public static final int OPEN = 2;
    public static final int CLOSED = 4;
    public static final int CLOSINGWINMSG = 111;
    public static final int CLOSEWINMSG = 110;
    public static final int NEWWINMSG = 101;
    public static final int NULLOPERATION = 0;
    private MonitorInfo minfo;
    private int messageWindowState;
    private int operatorState = 0;
    private int screenWidth;
    private int screenHeight;
    private int msgWindowWidth;
    private int msgWindowHeight;
    private String title;
    private String msg;
    private JEditorPane jEditorPane;

    public WindowMessage(String width, String height, String title, String msg, MonitorInfo info) {
        super(SystemEntry.instance.getOwnerFrame());
        this.initValue(width, height, title, msg, info);
        this.initWindow();
        this.addListener();
        this.setVisible(true);
    }

    private void initValue(String width, String height, String title, String message, MonitorInfo info) {
        this.jEditorPane = new JEditorPane();
        this.setMessageWindowState(0);
        this.setOperatorState(101);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.screenWidth = dimension.width;
        this.screenHeight = dimension.height;
        this.msgWindowWidth = Integer.parseInt(width);
        this.msgWindowHeight = Integer.parseInt(height);
        this.title = title;
        this.msg = message;
        this.minfo = info;
    }

    private void initWindow() {
        this.setSize(this.msgWindowWidth, this.msgWindowHeight);
        this.setLayout(new BorderLayout());
        this.jEditorPane.setEditable(false);
        this.jEditorPane.setSize(this.msgWindowWidth, this.msgWindowHeight);
        this.jEditorPane.setContentType("text/html");
        String closeStr = EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PERFAutoGenerateResource", (String)"16_WindowMessage");
        String showDetailStr = EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PERFAutoGenerateResource", (String)"17_WindowMessage");
        this.jEditorPane.setText("<html><head></head><body><table border=0 cellspacing=0 width=100% height=100%><tr style='height:30;background-color:#81A6C8;'><td align=left>" + this.title + "</td><td align=right><a href=\"http://closeMsgWindow\" style=\"cursor:pointer;\">" + closeStr + "</a></td></tr><tr style=background-color:#E0F2FF;<td valign=top align=left colspan=2 height=" + (this.msgWindowHeight - 30) + ">" + this.msg + "<br><br><center><a href=\"http://www.kingdee.com\" style=\"cursor:pointer;\">" + showDetailStr + "</a></center></td></tr></table></body>");
        this.getContentPane().add((Component)this.jEditorPane, "Center");
        this.setAlwaysOnTop(false);
        this.setLocation(this.screenWidth - this.msgWindowWidth, this.screenHeight);
    }

    private void addListener() {
        this.jEditorPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                WindowMessage.this.setLocation(WindowMessage.this.screenWidth - WindowMessage.this.msgWindowWidth, WindowMessage.this.getLocation().y);
                WindowMessage.this.setOperatorState(0);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                WindowMessage.this.setOperatorState(111);
                WinMsgManager.getWinMsgManager().adapterWindow(WindowMessage.this.getWinMsg());
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.jEditorPane.addHyperlinkListener(this);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (e.getURL().toString().equals("http://closeMsgWindow")) {
                this.setOperatorState(111);
            } else {
                try {
                    if (this.minfo != null) {
                        this.minfo.getWorker().finishedLater();
                        ThreadPool.destroyMonitor((MonitorInfo)this.minfo);
                        this.setOperatorState(110);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            WinMsgManager.getWinMsgManager().adapterWindow(this.getWinMsg());
        }
    }

    @Override
    public void run() {
        WinMsgManager.getWinMsgManager().adapterWindow(this.getWinMsg());
    }

    public int getMessageWindowState() {
        return this.messageWindowState;
    }

    public void setMessageWindowState(int messageWindowState) {
        this.messageWindowState = messageWindowState;
    }

    public int getOperatorState() {
        return this.operatorState;
    }

    public void setOperatorState(int operatorState) {
        this.operatorState = operatorState;
    }

    private WindowMessage getWinMsg() {
        return this;
    }

    public static void main(String[] args) throws InterruptedException {
        new WindowMessage("250", "150", EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PERFAutoGenerateResource", (String)"14_WindowMessage"), EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PERFAutoGenerateResource", (String)"15_WindowMessage"), null);
    }
}

