/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ws.account;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.master.account.AccountCurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountTypeCollection;
import com.kingdee.eas.basedata.master.account.AccountTypeFactory;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.util.APIPermissionCheckUtil;
import com.kingdee.eas.basedata.ws.account.AbstractImportAccountViewFacadeControllerBean;
import com.kingdee.eas.basedata.ws.common.WsCommonImportUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonTag;
import com.kingdee.eas.basedata.ws.common.WsCommonUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonXMLUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class ImportAccountViewFacadeControllerBean
extends AbstractImportAccountViewFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ws.account.ImportAccountViewFacadeControllerBean");
    private String billNumber = "";
    private String retstatus = "0";
    private String errorMessage = "";

    @Override
    protected String _importAccountViewData(Context ctx, String xmlData) throws BOSException, EASBizException {
        try {
            Document doc = WsCommonXMLUtil.builderDocument(xmlData);
            if (null != doc) {
                WsCommonXMLUtil.validateRootElement(doc, "DataInfo");
                HashMap headPro = WsCommonXMLUtil.getBillHead(doc, "DataHead");
                ArrayList entiesPro = WsCommonXMLUtil.getBillEntries(doc, "DataEntries//entry");
                this.billNumber = (String)headPro.get("number");
                CtrlUnitInfo cuInfo = WsCommonUtil.getCuInfo(ctx, (String)headPro.get("CU"));
                if (cuInfo == null) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUNOTFOUND", (Context)ctx));
                }
                ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)cuInfo);
                String opAttributeName = WsCommonXMLUtil.getAttributeValue(doc, "op");
                String bostype = WsCommonXMLUtil.getAttributeValue(doc, "bostype");
                AccountViewInfo accountViewInfo = new AccountViewInfo();
                EntityObjectInfo eo = WsCommonUtil.getEntityObjectInfo(ctx, bostype);
                Map<String, Object> map = WsCommonImportUtil.getBillHeadProperties(eo);
                if (null != opAttributeName && "0".equals(opAttributeName) && null == (accountViewInfo = (AccountViewInfo)WsCommonUtil.getCoreBaseInfo(ctx, eo, this.billNumber, cuInfo.getId().toString()))) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUSTOMERNOTEXISTS", (Context)ctx));
                }
                if (null != opAttributeName && ("3".equals(opAttributeName) || "4".equals(opAttributeName))) {
                    this.checkNumber(ctx, headPro);
                }
                if ("0".equals(opAttributeName) || "3".equals(opAttributeName) || "4".equals(opAttributeName)) {
                    String[] mustValidateHead = WsCommonTag.getMustValidateProsByAccountViewHead();
                    String[] mustValidateEntry = WsCommonTag.getMustValidateProsByAccountViewEntry();
                    if (!"0".equals(opAttributeName)) {
                        WsCommonUtil.validateHeadProperty(mustValidateHead, headPro);
                        WsCommonUtil.validateEntiesProperty(mustValidateEntry, entiesPro);
                        this.buildBillEnties(ctx, entiesPro, mustValidateEntry, accountViewInfo, eo, cuInfo.getId().toString());
                    } else {
                        mustValidateHead = null;
                        mustValidateEntry = null;
                    }
                    WsCommonImportUtil.buildBillHead(ctx, (CoreBaseInfo)accountViewInfo, map, mustValidateHead, null, headPro, cuInfo.getId().toString());
                    this.setAccountInfo(ctx, accountViewInfo, headPro);
                }
                String comId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
                if (accountViewInfo.getCompanyID() != null) {
                    comId = accountViewInfo.getCompanyID().getId().toString();
                }
                APIPermissionCheckUtil.checkPermission(ctx, comId, "bd_account_accountview_importfromfile");
                ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
                WsCommonUtil.operationBill(ctx, eo, (CoreBaseInfo)accountViewInfo, opAttributeName, headPro, map, "usedStatus");
            }
        }
        catch (Exception e) {
            this.retstatus = "1";
            this.errorMessage = e.getMessage();
        }
        return WsCommonXMLUtil.buildResultXml(this.retstatus, this.billNumber, this.errorMessage);
    }

    private void checkNumber(Context ctx, HashMap headPro) throws Exception {
        String companyNumber = (String)headPro.get("companyID");
        String accountTableNumber = (String)headPro.get("accountTableID");
        String number = (String)headPro.get("number");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.number", (Object)accountTableNumber));
        filter.getFilterItems().add(new FilterItemInfo("companyID.number", (Object)companyNumber));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        if (AccountViewFactory.getLocalInstance((Context)ctx).exists(filter)) {
            throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"BASEDATAEXIST", (Context)ctx));
        }
    }

    private void setAccountInfo(Context ctx, AccountViewInfo accountViewInfo, HashMap headPro) throws BOSException {
        FilterInfo filter;
        EntityViewInfo ev;
        String parent;
        String accountTableId = accountViewInfo.getAccountTableID().getId().toString();
        String companyId = accountViewInfo.getCompanyID().getId().toString();
        String accountTypeNumber = headPro.get("accountTypeID") == null ? null : (String)headPro.get("accountTypeID");
        String string = parent = headPro.get("parent") == null ? null : (String)headPro.get("parent");
        if (!StringUtils.isEmpty((String)accountTypeNumber)) {
            ev = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableId));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountTypeNumber));
            ev.setFilter(filter);
            AccountTypeCollection accountTypeCollection = AccountTypeFactory.getLocalInstance((Context)ctx).getAccountTypeCollection(ev);
            if (accountTypeCollection.size() > 0) {
                accountViewInfo.setAccountTypeID(accountTypeCollection.get(0));
            }
        }
        if (!StringUtils.isEmpty((String)parent)) {
            ev = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableId));
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyId));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)parent));
            ev.setFilter(filter);
            AccountViewCollection accountViewCollection = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(ev);
            if (accountViewCollection.size() > 0) {
                accountViewInfo.setParent(accountViewCollection.get(0));
            }
        }
    }

    private void buildBillEnties(Context ctx, ArrayList entiesPro, String[] mustValidate, AccountViewInfo accountViewInfo, EntityObjectInfo eo, String cuId) throws Exception {
        Map<String, Object> map = WsCommonImportUtil.getBillEntiesProperties(ctx, "accountCurrency", eo);
        AccountCurrencyInfo accountCurrencyInfo = null;
        HashMap entryMap = null;
        if (null != map) {
            int count = entiesPro.size();
            for (int i = 0; i < count; ++i) {
                entryMap = null;
                accountCurrencyInfo = null;
                entryMap = (HashMap)entiesPro.get(i);
                accountCurrencyInfo = new AccountCurrencyInfo();
                WsCommonImportUtil.buildBill(ctx, map, null, entryMap, mustValidate, (PropertyContainer)accountCurrencyInfo, cuId);
                accountViewInfo.getAccountCurrency().add(accountCurrencyInfo);
            }
        }
    }
}

