/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ws.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.ws.common.WsCommonImportUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonXMLUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.PropertyContainer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class WsCommonExportUtil {
    static final Logger logger = Logger.getLogger(WsCommonExportUtil.class);

    public static List<String> getBaseDataXml(Context ctx, AbstractObjectCollection coreBaseCollection, Map headMap, Map entryMap, String entryName) throws Exception {
        if (null == coreBaseCollection || coreBaseCollection.size() <= 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        CoreBaseInfo coreBaseInfo = null;
        int count = coreBaseCollection.size();
        for (int i = 0; i < count; ++i) {
            coreBaseInfo = (CoreBaseInfo)coreBaseCollection.getObject(i);
            Map billHead = WsCommonExportUtil.getBaseDataHeadMap(ctx, (PropertyContainer)coreBaseInfo, headMap);
            List<Map> entiesList = WsCommonExportUtil.getBaseDataEnitesMap(ctx, (PropertyContainer)coreBaseInfo, entryMap, entryName);
            String baseDataXml = WsCommonXMLUtil.buildBaseDataXml(billHead, entiesList);
            list.add(baseDataXml);
        }
        return list;
    }

    private static Map getBaseDataHeadMap(Context ctx, PropertyContainer coreBaseInfo, Map headMap) throws BOSException {
        if (null == headMap || headMap.size() <= 0) {
            return null;
        }
        HashMap<String, Object> billHeadMap = new HashMap<String, Object>();
        try {
            for (Map.Entry et : headMap.entrySet()) {
                String propertyName = et.getKey().toString();
                Object value = et.getValue();
                if (value instanceof EntityObjectInfo) {
                    billHeadMap.put(propertyName, WsCommonUtil.getLinkProperties(ctx, coreBaseInfo, propertyName, (EntityObjectInfo)value));
                    continue;
                }
                if (value.toString().equals("Date")) {
                    billHeadMap.put(propertyName, WsCommonUtil.getDateProperties(coreBaseInfo, propertyName));
                    continue;
                }
                if (value.toString().equals("TimeStamp")) {
                    billHeadMap.put(propertyName, WsCommonUtil.getTimeStatmpProperties(coreBaseInfo, propertyName));
                    continue;
                }
                if (value.toString().equals("Integer")) {
                    billHeadMap.put(propertyName, WsCommonUtil.getIntProperties(coreBaseInfo, propertyName));
                    continue;
                }
                if (value.toString().equals("BigDecimal")) {
                    billHeadMap.put(propertyName, WsCommonUtil.getDeciamlProperties(coreBaseInfo, propertyName));
                    continue;
                }
                if (value.toString().equals("Boolean")) {
                    billHeadMap.put(propertyName, WsCommonUtil.getBooleanProperties(coreBaseInfo, propertyName));
                    continue;
                }
                if (!value.toString().equals("String")) continue;
                billHeadMap.put(propertyName, WsCommonUtil.getStrProperties(coreBaseInfo, propertyName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return billHeadMap;
    }

    private static List<Map> getBaseDataEnitesMap(Context ctx, PropertyContainer coreBaseInfo, Map entiesMap, String entisName) {
        if (null == entisName || "".equals(entisName)) {
            return null;
        }
        Object obj = coreBaseInfo.get(entisName);
        if (null == obj) {
            return null;
        }
        AbstractObjectCollection coll = null;
        if (obj instanceof AbstractObjectCollection) {
            coll = (AbstractObjectCollection)obj;
        }
        if (null == coll || coll.size() <= 0) {
            return null;
        }
        ArrayList<Map> list = new ArrayList<Map>();
        try {
            int count = coll.size();
            for (int i = 0; i < count; ++i) {
                PropertyContainer pInfo = (PropertyContainer)coll.getObject(i);
                list.add(WsCommonExportUtil.getBaseDataHeadMap(ctx, pInfo, entiesMap));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return list;
    }

    private static String getStringInSql(IRowSet set) throws SQLException {
        StringBuffer result = new StringBuffer("");
        if (null != set && set.size() > 0) {
            String str = "";
            Vector<String> stringVector = new Vector<String>();
            while (set.next()) {
                str = set.getString("fid");
                if ("".equals(str) || "NULL".equalsIgnoreCase(str) || stringVector.contains(str)) continue;
                result.append("'" + str + "',");
                stringVector.add(str);
            }
            str = null;
            Object var3_3 = null;
        }
        if (!"".equals(result.toString())) {
            return result.toString().substring(0, result.length() - 1);
        }
        return "";
    }

    public static List<String> buildBillXml(Context ctx, String bostype, String entryName, int start, int rows, int flag) throws Exception {
        EntityObjectInfo eo = WsCommonUtil.getEntityObjectInfo(ctx, bostype);
        if (null != eo) {
            EntityViewInfo view;
            CoreBaseCollection coreBaseCollection;
            Map<String, Object> headMap = WsCommonImportUtil.getBillHeadProperties(eo);
            Map<String, Object> entryMap = null;
            if (null != entryName && !"".equals(entryName)) {
                entryMap = WsCommonImportUtil.getBillEntiesProperties(ctx, entryName, eo);
            }
            String tableName = eo.getTable().getName();
            ICoreBase iLinkCoreBase = null;
            iLinkCoreBase = WsCommonUtil.getLocalInstance(ctx, eo);
            String ids = WsCommonExportUtil.getids(ctx, tableName, start, rows);
            if (null != ids && !"".equals(ids) && null != (coreBaseCollection = iLinkCoreBase.getCollection(view = WsCommonExportUtil.getQueryView(headMap, ids, entryMap, entryName, flag))) && coreBaseCollection.size() > 0) {
                return WsCommonExportUtil.getBaseDataXml(ctx, (AbstractObjectCollection)coreBaseCollection, headMap, entryMap, entryName);
            }
        }
        return null;
    }

    public static List<String> buildBillXmlByCssp(Context ctx, String bostype, String groupStandard, int start, int rows, int flag) throws Exception {
        EntityObjectInfo eo = WsCommonUtil.getEntityObjectInfo(ctx, bostype);
        if (null != eo) {
            EntityViewInfo view;
            CoreBaseCollection coreBaseCollection;
            Map<String, Object> headMap = WsCommonImportUtil.getBillHeadProperties(eo);
            String tableName = eo.getTable().getName();
            ICoreBase iLinkCoreBase = null;
            iLinkCoreBase = WsCommonUtil.getLocalInstance(ctx, eo);
            String ids = WsCommonExportUtil.getidsByCssp(ctx, tableName, groupStandard, start, rows);
            if (null != ids && !"".equals(ids) && null != (coreBaseCollection = iLinkCoreBase.getCollection(view = WsCommonExportUtil.getQueryView(headMap, ids, null, "", flag))) && coreBaseCollection.size() > 0) {
                return WsCommonExportUtil.getBaseDataXml(ctx, (AbstractObjectCollection)coreBaseCollection, headMap, null, "");
            }
        }
        return null;
    }

    private static EntityViewInfo getQueryView(Map headMap, String ids, Map entryMap, String entryName, int flag) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("id", (Object)ids, CompareType.INNER));
        SelectorItemCollection sic = view.getSelector();
        if (flag == 0) {
            WsCommonUtil.setHeadSelectorItem(sic, headMap);
            if (null != entryMap && entryMap.size() > 0) {
                WsCommonUtil.setEntrySelectorItem(sic, entryName, entryMap);
            }
        } else if (flag == 1) {
            sic.add(new SelectorItemInfo("*"));
        }
        view.setFilter(filter);
        return view;
    }

    private static String getids(Context ctx, String tableName, int start, int rows) throws BOSException, SQLException {
        String ids = "";
        String sql = "select fid from " + tableName;
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (int)start, (int)rows);
        ids = WsCommonExportUtil.getStringInSql(set);
        return ids;
    }

    private static String getidsByCssp(Context ctx, String tableName, String groupStandard, int start, int rows) throws BOSException, SQLException {
        String ids = "";
        String sql = "select fid from " + tableName + " where  FCSSPGroupStandardID in (select fid from T_BD_CSSPGroupStandard where fnumber ='" + groupStandard + "')";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (int)start, (int)rows);
        ids = WsCommonExportUtil.getStringInSql(set);
        return ids;
    }
}

