/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ws.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.KAClassficationCollection;
import com.kingdee.eas.basedata.assistant.KAClassficationFactory;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.ws.common.WsCommonXMLUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.PropertyContainer;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class WsCommonUtil {
    static final Logger logger = Logger.getLogger(WsCommonUtil.class);

    public static EntityObjectInfo getEntityObjectInfo(Context ctx, String bostype) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo eo = loader.getEntity(BOSObjectType.create((String)bostype));
        if (null != eo) {
            return eo;
        }
        return null;
    }

    public static void validateHeadProperty(String[] bilHeadProps, HashMap billHeadMap) throws Exception {
        if (null == bilHeadProps || bilHeadProps.length <= 0) {
            return;
        }
        for (int i = 0; i < bilHeadProps.length; ++i) {
            if (WsCommonUtil.validateProperty(billHeadMap, bilHeadProps[i])) continue;
            throw new Exception(bilHeadProps[i] + EASResource.getString((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"MUSTFILL"));
        }
    }

    private static boolean validateProperty(HashMap infoMap, String prop) {
        if (infoMap == null || prop == null) {
            return false;
        }
        return infoMap.get(prop) != null;
    }

    public static void validateEntiesProperty(String[] bilEntriesProps, ArrayList billEntriesList) throws Exception {
        if (null == bilEntriesProps || bilEntriesProps.length <= 0) {
            return;
        }
        HashMap entryMap = null;
        for (int i = 0; i < billEntriesList.size(); ++i) {
            entryMap = (HashMap)billEntriesList.get(i);
            for (int j = 0; j < bilEntriesProps.length; ++j) {
                if (WsCommonUtil.validateProperty(entryMap, bilEntriesProps[j])) continue;
                throw new Exception(bilEntriesProps[j] + EASResource.getString((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"MUSTFILL"));
            }
        }
    }

    public static void setStrProperties(PropertyContainer info, String[] notBuild, String porpertyName, HashMap billHeadMap) {
        if (WsCommonUtil.isBuildLinkInfo(porpertyName, notBuild)) {
            info.setString(porpertyName, (String)billHeadMap.get(porpertyName));
        }
    }

    public static Short getShortProperties(PropertyContainer info, String porpertyName) {
        return info.getShort(porpertyName);
    }

    public static Float getFloatProperties(PropertyContainer info, String porpertyName) {
        return Float.valueOf(info.getFloat(porpertyName));
    }

    public static Double getDoubleProperties(PropertyContainer info, String porpertyName) {
        return info.getDouble(porpertyName);
    }

    public static Long getLongProperties(PropertyContainer info, String porpertyName) {
        return info.getLong(porpertyName);
    }

    public static String getStrProperties(PropertyContainer info, String porpertyName) {
        return info.getString(porpertyName);
    }

    public static String getBOSUuidProperties(PropertyContainer info, String porpertyName) {
        BOSUuid id = info.getBOSUuid(porpertyName);
        if (null != id) {
            return id.toString();
        }
        return null;
    }

    public static void setBooleanProperties(PropertyContainer info, String[] notBuild, String porpertyName, HashMap billHeadMap) throws Exception {
        try {
            if (WsCommonUtil.isBuildLinkInfo(porpertyName, notBuild)) {
                boolean boolValue = false;
                String propValue = null;
                propValue = (String)billHeadMap.get(porpertyName);
                boolValue = propValue != null && (propValue.equals("1") || propValue.equals("true"));
                info.setBoolean(porpertyName, boolValue);
            }
        }
        catch (Exception e) {
            throw new Exception(porpertyName + ": " + EASResource.getString((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"VALUEERROR"));
        }
    }

    public static int getBooleanProperties(PropertyContainer info, String porpertyName) {
        boolean boolvalue = info.getBoolean(porpertyName);
        if (boolvalue) {
            return 1;
        }
        return 0;
    }

    public static void setIntProperties(PropertyContainer info, String porpertyName, HashMap billHeadMap) throws Exception {
        try {
            String value = null;
            value = billHeadMap.get(porpertyName) == null ? "0" : (String)billHeadMap.get(porpertyName);
            info.setInt(porpertyName, Integer.parseInt(value));
        }
        catch (Exception e) {
            throw new Exception(porpertyName + ": " + EASResource.getString((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"VALUEERROR"));
        }
    }

    public static int getIntProperties(PropertyContainer info, String porpertyName) {
        return info.getInt(porpertyName);
    }

    public static void setDeciamlProperties(PropertyContainer info, String propertyName, HashMap billHeadMap) throws Exception {
        try {
            String value = null;
            if (billHeadMap.get(propertyName) != null) {
                value = (String)billHeadMap.get(propertyName);
                info.setBigDecimal(propertyName, new BigDecimal(value));
            }
        }
        catch (Exception e) {
            throw new Exception(propertyName + ": " + EASResource.getString((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"VALUEERROR"));
        }
    }

    public static BigDecimal getDeciamlProperties(PropertyContainer info, String propertyName) {
        BigDecimal value = info.getBigDecimal(propertyName);
        return value;
    }

    public static void seTimeStampProperties(PropertyContainer info, String propertyName, HashMap billHeadMap) throws Exception {
        Timestamp timeStamp = null;
        try {
            timeStamp = WsCommonUtil.getTimeStampFromStr((String)billHeadMap.get(propertyName));
            info.setTimestamp(propertyName, timeStamp);
        }
        catch (Exception e) {
            throw new Exception(propertyName + ": " + EASResource.getString((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"VALUEERROR"));
        }
    }

    private static Timestamp getTimeStampFromStr(String timeStr) throws Exception {
        if (timeStr != null) {
            return Timestamp.valueOf(timeStr);
        }
        return null;
    }

    public static String getTimeStatmpProperties(PropertyContainer info, String propertyName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp timestamp = info.getTimestamp(propertyName);
        if (null != timestamp) {
            return dateFormat.format(timestamp);
        }
        return "";
    }

    public static void setDateProperties(PropertyContainer info, String propertyName, HashMap billHeadMap) throws Exception {
        java.util.Date date = null;
        try {
            date = WsCommonUtil.convertStrToDate((String)billHeadMap.get(propertyName), "yyyy-MM-dd");
            info.setDate(propertyName, date);
        }
        catch (Exception e) {
            throw new Exception(propertyName + ": " + EASResource.getString((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"VALUEERROR"));
        }
    }

    private static java.util.Date convertStrToDate(String strDate, String parttern) throws Exception {
        if (strDate != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(parttern);
            return dateFormat.parse(strDate);
        }
        return null;
    }

    public static String getDateProperties(PropertyContainer info, String propertyName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = info.getDate(propertyName);
        if (null != date) {
            return dateFormat.format(date);
        }
        return "";
    }

    public static void setLinkProperties(Context ctx, PropertyContainer info, String[] mustHeadPros, String propertyName, Object linkeo, String[] notBuild, HashMap billHeadMap, String cuId) throws Exception {
        CoreBaseInfo linkBaseInfo = null;
        try {
            String number = (String)billHeadMap.get(propertyName);
            if (null == number || "".equals(number)) {
                return;
            }
            if (WsCommonUtil.isBuildLinkInfo(propertyName, notBuild)) {
                EntityObjectInfo eo = (EntityObjectInfo)linkeo;
                ctx.put((Object)"cssptype", (Object)propertyName);
                linkBaseInfo = WsCommonUtil.getLinkPropCoreBaseInfo(ctx, eo, number, "");
                ctx.remove((Object)"cssptype");
                if (null == linkBaseInfo && WsCommonUtil.isMustValidateProperty(propertyName, mustHeadPros)) {
                    throw new Exception(eo.getAlias() + EASResource.getString((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"LINKNOTEXSIT"));
                }
                info.put(propertyName, (Object)linkBaseInfo);
            }
        }
        catch (Exception e) {
            throw new Exception(propertyName + ": " + EASResource.getString((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"VALUEERROR"));
        }
    }

    public static String getLinkProperties(Context ctx, PropertyContainer info, String propertyName, EntityObjectInfo eo) throws BOSException {
        Object obj = info.get(propertyName);
        String number = "";
        if (null != obj && obj instanceof PropertyContainer) {
            PropertyContainer cinfo = (PropertyContainer)obj;
            Object numbers = cinfo.get("number");
            if (null != cinfo && null != numbers) {
                number = numbers.toString();
            } else if (null != cinfo && null == numbers) {
                String id = cinfo.get("id").toString();
                number = WsCommonUtil.getCoreBaseNumber(ctx, id, eo);
            }
        }
        return number;
    }

    private static boolean isBuildLinkInfo(String proName, String[] notBuildPros) {
        if (null == notBuildPros || notBuildPros.length <= 0) {
            return true;
        }
        int count = notBuildPros.length;
        for (int i = 0; i < count; ++i) {
            if (!proName.equals(notBuildPros[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isMustValidateProperty(String propName, String[] musValidateProp) {
        if (null == musValidateProp || musValidateProp.length <= 0) {
            return false;
        }
        for (int i = 0; i < musValidateProp.length; ++i) {
            if (!musValidateProp[i].equals(propName)) continue;
            return true;
        }
        return false;
    }

    private static CoreBaseInfo getLinkPropCoreBaseInfo(Context ctx, EntityObjectInfo linkEo, String number, String cuId) throws BOSException {
        return WsCommonUtil.getCoreBaseInfo(ctx, linkEo, number, cuId);
    }

    public static void validateNumber(Context ctx, EntityObjectInfo linkEo, String number) throws Exception {
        CoreBaseInfo linkInfo = null;
        linkInfo = WsCommonUtil.getCoreBaseInfo(ctx, linkEo, number, "");
        if (null != linkInfo) {
            throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"BASEDATAEXIST", (Context)ctx));
        }
    }

    public static void validateNumber(Context ctx, EntityObjectInfo linkEo, String number, String cuid) throws Exception {
        String table;
        if (null != linkEo.getTable() && null != (table = linkEo.getTable().getName()) && !"".equals(table)) {
            IRowSet set;
            String sql = "select fid,fnumber from " + table + " where fnumber='" + number + "'";
            if (null != cuid && cuid.trim().length() > 0) {
                sql = sql + " and FControlUnitID='" + cuid + "'";
            }
            if (null != (set = DbUtil.executeQuery((Context)ctx, (String)sql)) && set.size() > 0) {
                throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"BASEDATAEXIST", (Context)ctx));
            }
        }
    }

    public static CoreBaseInfo validateBill(Context ctx, EntityObjectInfo eo, String attributeName, String billNumber, String cuid, CoreBaseInfo info) throws Exception {
        if (null != attributeName && ("0".equals(attributeName) || "1".equals(attributeName) || "2".equals(attributeName))) {
            info = WsCommonUtil.getCoreBaseInfo(ctx, eo, billNumber, "");
            if (null == info) {
                throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"BASEDATANOTEXIST", (Context)ctx));
            }
            if ("1".equals(attributeName)) {
                info.put("deletedStatus", (Object)1);
            } else if ("2".equals(attributeName)) {
                info.put("deletedStatus", (Object)2);
            }
        } else {
            WsCommonUtil.validateNumber(ctx, eo, billNumber);
        }
        return info;
    }

    public static CoreBaseInfo validateBills(Context ctx, EntityObjectInfo eo, String attributeName, String billNumber, String cuid, CoreBaseInfo info) throws Exception {
        if (null != attributeName && "0".equals(attributeName)) {
            info = WsCommonUtil.getCoreBaseInfo(ctx, eo, billNumber, "");
            if (null == info) {
                throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"BASEDATANOTEXIST", (Context)ctx));
            }
        } else {
            WsCommonUtil.validateNumber(ctx, eo, billNumber);
        }
        return info;
    }

    public static void operationBill(Context ctx, EntityObjectInfo eo, CoreBaseInfo info, String opAttributeName, Map headPro, Map map, String statusName) throws EASBizException, BOSException {
        ICoreBase iCoreBase = null;
        info.put("isImport", (Object)true);
        info.put("notSupportRule", (Object)true);
        if (null != eo) {
            iCoreBase = WsCommonUtil.getLocalInstance(ctx, eo);
            if (null != opAttributeName) {
                if ("0".equals(opAttributeName) || "1".equals(opAttributeName) || "2".equals(opAttributeName) || "5".equals(opAttributeName)) {
                    SelectorItemCollection selector = new SelectorItemCollection();
                    if (null != info.get("name") && !"".equals(info.get("name"))) {
                        String name = info.get("name").toString().replaceAll("(^[ |\u3000]*|[ |\u3000]*$)", "");
                        info.put("name", (Object)name);
                    }
                    info.put("name", info.get("name"));
                    info.put("name", info.get("name", new Locale("L1", "")), new Locale("L1", ""));
                    info.put("name", info.get("name", new Locale("L2", "")), new Locale("L2", ""));
                    info.put("name", info.get("name", new Locale("L3", "")), new Locale("L3", ""));
                    if ("0".equals(opAttributeName)) {
                        iCoreBase.update((IObjectPK)new ObjectUuidPK(info.getId()), info);
                    } else {
                        selector.add(new SelectorItemInfo(statusName));
                        iCoreBase.updatePartial(info, selector);
                    }
                } else if ("3".equals(opAttributeName)) {
                    iCoreBase.save(info);
                } else if ("4".equals(opAttributeName)) {
                    iCoreBase.submit(info);
                }
            }
        }
    }

    public static void operationBills(Context ctx, EntityObjectInfo eo, CoreBaseInfo info, String opAttributeName, Map headPro, Map map) throws EASBizException, BOSException {
        ICoreBase iCoreBase = null;
        if (null != eo) {
            iCoreBase = WsCommonUtil.getLocalInstance(ctx, eo);
            if (null != opAttributeName) {
                if ("0".equals(opAttributeName)) {
                    SelectorItemCollection selector = new SelectorItemCollection();
                    WsCommonUtil.setHeadSelectorItem(selector, WsCommonUtil.getSelectorMap(headPro, map));
                    if (null != info.get("name") && !"".equals(info.get("name"))) {
                        String name = info.get("name").toString().replaceAll("(^[ |\u3000]*|[ |\u3000]*$)", "");
                        info.put("name", (Object)name);
                    }
                    info.put("name", info.get("name"));
                    info.put("name", info.get("name", new Locale("L1", "")), new Locale("L1", ""));
                    info.put("name", info.get("name", new Locale("L2", "")), new Locale("L2", ""));
                    info.put("name", info.get("name", new Locale("L3", "")), new Locale("L3", ""));
                    iCoreBase.update((IObjectPK)new ObjectUuidPK(info.getId()), info);
                } else if ("3".equals(opAttributeName)) {
                    iCoreBase.save(info);
                } else if ("4".equals(opAttributeName)) {
                    iCoreBase.submit(info);
                }
            }
        }
    }

    public static CoreBaseInfo getCoreBaseInfo(Context ctx, EntityObjectInfo eo, String cnNumber, String cuId) throws BOSException {
        ICoreBase iLinkCoreBase = null;
        CoreBaseInfo corebaseinfo = null;
        if (null != eo && null != cnNumber) {
            String cssptype;
            iLinkCoreBase = WsCommonUtil.getLocalInstance(ctx, eo);
            corebaseinfo = cuId != null && cuId.trim().length() > 0 ? WsCommonUtil.getCoreBaseInfo(iLinkCoreBase, cnNumber, cuId) : ((cssptype = (String)ctx.get((Object)"cssptype")) != null && cssptype.length() > 0 ? WsCommonUtil.getCoreBaseInfo(ctx, iLinkCoreBase, cnNumber, cssptype) : WsCommonUtil.getCoreBaseInfo(iLinkCoreBase, cnNumber));
        }
        return corebaseinfo;
    }

    private static CoreBaseInfo getCoreBaseInfo(Context ctx, ICoreBase iDataBase, String number, String cssptype) throws BOSException {
        block18: {
            if ("supplierGroupStandard".equals(cssptype) || "customerGroupStandard".equals(cssptype)) {
                String type = "";
                if ("supplierGroupStandard".equals(cssptype)) {
                    type = "0,2";
                } else if ("customerGroupStandard".equals(cssptype)) {
                    type = "0,1";
                }
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = view.getSelector();
                sic.add(new SelectorItemInfo("*"));
                FilterInfo filter = new FilterInfo();
                FilterItemCollection fic = filter.getFilterItems();
                fic.add(new FilterItemInfo("number", (Object)number.toString(), CompareType.EQUALS));
                fic.add(new FilterItemInfo("type", (Object)type, CompareType.INCLUDE));
                view.setFilter(filter);
                return WsCommonUtil.getCoreBaseInfo(iDataBase, view);
            }
            if ("supplierGroup".equals(cssptype) || "customerGroup".equals(cssptype)) {
                int type = 0;
                if ("supplierGroup".equals(cssptype)) {
                    type = 2;
                } else if ("customerGroup".equals(cssptype)) {
                    type = 1;
                }
                String sql = "select g.fid from T_BD_CSSPGROUP g left join T_BD_CSSPGROUPSTANDARD s on s.FID = g.FCSSPGROUPSTANDARDID where g.fnumber = '" + number + "'  and s.FTYPE in (0," + type + ")";
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                String fid = "";
                try {
                    if (rowSet.next()) {
                        fid = rowSet.getString("fid");
                        String[] fields = new String[]{"id"};
                        String[] values = new String[]{fid};
                        EntityViewInfo view = WsCommonUtil.getEntityViewInfo(fields, values);
                        return WsCommonUtil.getCoreBaseInfo(iDataBase, view);
                    }
                    break block18;
                }
                catch (SQLException e) {
                    throw new BOSException();
                }
            }
            if ("browseGroup".equals(cssptype)) {
                String infoType = (String)ctx.get((Object)"infoType");
                int type = 0;
                if ("customer".equals(infoType)) {
                    type = 1;
                } else if ("supplier".equals(infoType)) {
                    type = 2;
                }
                String sql = "select g.fid from T_BD_CSSPGROUP g left join T_BD_CSSPGROUPSTANDARD s on s.FID = g.FCSSPGROUPSTANDARDID where g.fnumber = '" + number + "'  and s.FTYPE in (0," + type + ")";
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                String fid = "";
                try {
                    if (rowSet.next()) {
                        fid = rowSet.getString("fid");
                        String[] fields = new String[]{"id"};
                        String[] values = new String[]{fid};
                        EntityViewInfo view = WsCommonUtil.getEntityViewInfo(fields, values);
                        return WsCommonUtil.getCoreBaseInfo(iDataBase, view);
                    }
                    break block18;
                }
                catch (SQLException e) {
                    throw new BOSException();
                }
            }
            return WsCommonUtil.getCoreBaseInfo(iDataBase, number);
        }
        return null;
    }

    public static CtrlUnitInfo getCuInfo(Context ctx, String cuNumber) throws Exception {
        if (null == (cuNumber = WsCommonXMLUtil.getCUtNumberByXML(cuNumber)) || "".equals(cuNumber)) {
            return null;
        }
        CtrlUnitCollection col = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitCollection("select * where number='" + cuNumber + "'");
        if (null != col && col.size() > 0) {
            return col.get(0);
        }
        return null;
    }

    private static CoreBaseInfo getCoreBaseInfo(ICoreBase iDataBase, String number) throws BOSException {
        String[] fields = new String[]{"number"};
        String[] values = new String[]{number};
        EntityViewInfo view = WsCommonUtil.getEntityViewInfo(fields, values);
        return WsCommonUtil.getCoreBaseInfo(iDataBase, view);
    }

    private static CoreBaseInfo getCoreBaseInfo(ICoreBase iDataBase, String number, String cuId) throws BOSException {
        if (cuId == null || cuId.trim().length() == 0) {
            return WsCommonUtil.getCoreBaseInfo(iDataBase, number);
        }
        String[] fields = new String[]{"number", "CU"};
        String[] values = new String[]{number, cuId};
        EntityViewInfo view = WsCommonUtil.getEntityViewInfo(fields, values);
        return WsCommonUtil.getCoreBaseInfo(iDataBase, view);
    }

    private static String getCoreBaseNumber(Context ctx, String id, EntityObjectInfo eo) throws BOSException {
        ICoreBase iLinkCoreBase = null;
        CoreBaseInfo corebaseinfo = null;
        if (null != eo && null != id) {
            iLinkCoreBase = WsCommonUtil.getLocalInstance(ctx, eo);
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
            view.setFilter(filter);
            CoreBaseCollection coreBaseCollection = iLinkCoreBase.getCollection(view);
            if (coreBaseCollection != null && null != (corebaseinfo = coreBaseCollection.get(0)) && null != corebaseinfo.get("number")) {
                return corebaseinfo.get("number").toString();
            }
        }
        return null;
    }

    private static EntityViewInfo getEntityViewInfo(String[] fields, String[] fieldsValue) {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        if (fields != null && fieldsValue != null && fields.length >= fieldsValue.length) {
            sic.add(new SelectorItemInfo("*"));
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            for (int j = 0; j < fields.length && j < fieldsValue.length; ++j) {
                fic.add(new FilterItemInfo(fields[j], (Object)fieldsValue[j].trim(), CompareType.EQUALS));
            }
            view.setFilter(filter);
        }
        return view;
    }

    public static CoreBaseInfo getCoreBaseInfo(ICoreBase iDataBase, EntityViewInfo view) throws BOSException {
        CoreBaseCollection coreBaseCollection;
        CoreBaseInfo coreBaseInfo = null;
        if (iDataBase != null && null != (coreBaseCollection = iDataBase.getCollection(view)) && coreBaseCollection.size() > 0) {
            coreBaseInfo = coreBaseCollection.get(0);
        }
        return coreBaseInfo;
    }

    public static ICoreBase getLocalInstance(Context ctx, EntityObjectInfo eo) {
        ICoreBase iCoreBase = null;
        try {
            Class<?> cls = Class.forName(eo.getBusinessImplFactory());
            Method mtd = cls.getMethod("getLocalInstance", Context.class);
            iCoreBase = (ICoreBase)mtd.invoke(cls, ctx);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return iCoreBase;
    }

    public static void setHeadSelectorItem(SelectorItemCollection selector, Map headMap) {
        for (Map.Entry et : headMap.entrySet()) {
            String propertyName = et.getKey().toString();
            Object value = et.getValue();
            if (value instanceof EntityObjectInfo) {
                selector.add(new SelectorItemInfo(propertyName + ".id"));
                selector.add(new SelectorItemInfo(propertyName + ".name"));
                selector.add(new SelectorItemInfo(propertyName + ".number"));
                continue;
            }
            selector.add(new SelectorItemInfo(propertyName));
        }
    }

    public static void setEntrySelectorItem(SelectorItemCollection selector, String entryname, Map entiesMap) {
        for (Map.Entry et : entiesMap.entrySet()) {
            String propertyName = et.getKey().toString();
            Object value = et.getValue();
            propertyName = entryname + "." + propertyName;
            if (value instanceof EntityObjectInfo) {
                propertyName = propertyName + ".*";
            }
            selector.add(new SelectorItemInfo(propertyName));
        }
    }

    public static Map getSelectorMap(Map xmlHeadPro, Map headMap) {
        for (Map.Entry et : headMap.entrySet()) {
            String propertyName = et.getKey().toString();
            Object value = et.getValue();
            if (!xmlHeadPro.containsKey(propertyName)) continue;
            xmlHeadPro.put(propertyName, value);
        }
        return xmlHeadPro;
    }

    public static PositionInfo getPrimaryPositionInfo(PersonInfo personInfo, Context ctx) {
        PositionInfo positionInfo = null;
        try {
            if (null != personInfo) {
                String id = personInfo.getId().toString();
                if (!"".equals(id)) {
                    String sql = "select id, position.id, position.number, position.name,  position.adminOrgUnit.id, position.adminOrgUnit.number, position.adminOrgUnit.name,position.adminOrgUnit.longNumber, position.adminOrgUnit.isCompanyOrgUnit, position.adminOrgUnit.isCostOrgUnit where  isPrimary=1 and person.id='" + id + "'";
                    PositionMemberCollection positionMemberCollection = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(sql);
                    if (null != positionMemberCollection && positionMemberCollection.size() > 0 && null != positionMemberCollection.get(0).getPosition()) {
                        positionInfo = positionMemberCollection.get(0).getPosition();
                    }
                    sql = "";
                    positionMemberCollection = null;
                }
                id = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        ctx = null;
        personInfo = null;
        return positionInfo;
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnitInfo(AdminOrgUnitInfo adminOrgUnitInfo, Context ctx) {
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        if (null != adminOrgUnitInfo) {
            while (!WsCommonUtil.isCompany(adminOrgUnitInfo)) {
                adminOrgUnitInfo = WsCommonUtil.getSuperiorAdminOrgUnitInfo(adminOrgUnitInfo, ctx);
            }
            if (null != adminOrgUnitInfo) {
                companyOrgUnitInfo.setId(adminOrgUnitInfo.getId());
                companyOrgUnitInfo.setNumber(adminOrgUnitInfo.getNumber());
                companyOrgUnitInfo.setName(adminOrgUnitInfo.getName());
                companyOrgUnitInfo.setLongNumber(adminOrgUnitInfo.getLongNumber());
            }
        }
        adminOrgUnitInfo = null;
        ctx = null;
        return companyOrgUnitInfo;
    }

    private static boolean isCompany(AdminOrgUnitInfo adminOrgUnitInfo) {
        boolean flag = false;
        if (null != adminOrgUnitInfo && adminOrgUnitInfo.isIsCompanyOrgUnit()) {
            flag = true;
        }
        adminOrgUnitInfo = null;
        return flag;
    }

    private static AdminOrgUnitInfo getSuperiorAdminOrgUnitInfo(AdminOrgUnitInfo adminOrgUnitInfo, Context ctx) {
        try {
            if (null != adminOrgUnitInfo) {
                String id = adminOrgUnitInfo.getId().toString();
                if (!"".equals(id)) {
                    String sql = "select id, parent.id, parent.number, parent.name, parent.longNumber, parent.isCompanyOrgUnit where id='" + id + "'";
                    AdminOrgUnitCollection adminOrgUnitCollection = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(sql);
                    if (null != adminOrgUnitCollection && adminOrgUnitCollection.size() > 0) {
                        adminOrgUnitInfo = adminOrgUnitCollection.get(0).getParent();
                    }
                    sql = null;
                    adminOrgUnitCollection = null;
                } else {
                    adminOrgUnitInfo = null;
                }
                id = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        ctx = null;
        return adminOrgUnitInfo;
    }

    public static String[] getTargetCUNumber(ArrayList list) throws Exception {
        String[] targetnum = null;
        if (null != list) {
            targetnum = new String[list.size()];
            HashMap cunumber = null;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                cunumber = null;
                cunumber = (HashMap)list.get(i);
                String number = (String)cunumber.get("cuNumber");
                targetnum[i] = WsCommonXMLUtil.getCUtNumberByXML(number);
            }
        }
        return targetnum;
    }

    public static void setPropertyNumberByXml(Context ctx, Map headMap, String proName, String codefile) throws Exception {
        String number;
        if (null != headMap.get(proName) && !"".equals((String)headMap.get(proName)) && null != (number = WsCommonXMLUtil.gePropertyNumberByXML(ctx, (String)headMap.get(proName), codefile)) && !"".equals(number)) {
            headMap.put(proName, number);
        }
    }

    public static CustomerInfo getCustomerInfo(Context ctx, String number, String cuId) throws Exception {
        CustomerInfo customerInfo = null;
        if (null != number && !"".equals(number)) {
            try {
                CustomerCollection col;
                String sql = "select * where number='" + number + "'";
                if (null != cuId && !"".equals(cuId)) {
                    sql = "";
                    sql = "select * where number='" + number + "' and CU.id='" + cuId + "'";
                }
                if (null != (col = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCollection(sql)) && col.size() > 0) {
                    customerInfo = col.get(0);
                }
            }
            catch (BOSException e) {
                throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUSTOMERNOTEXISTS", (Context)ctx));
            }
        }
        return customerInfo;
    }

    public static SupplierInfo getSupplierInfo(Context ctx, String number, String cuId) throws Exception {
        SupplierInfo supplierInfo = null;
        if (null != number && !"".equals(number)) {
            try {
                SupplierCollection col;
                String sql = "select * where number='" + number + "'";
                if (null != cuId && !"".equals(cuId)) {
                    sql = "";
                    sql = "select * where number='" + number + "' and CU.id='" + cuId + "'";
                }
                if (null != (col = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection(sql)) && col.size() > 0) {
                    supplierInfo = col.get(0);
                }
            }
            catch (BOSException e) {
                throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"SUPPLIERNOTEXISTS", (Context)ctx));
            }
        }
        return supplierInfo;
    }

    public static void refCode(Context ctx, Map headMap, Map refMap) throws Exception {
        if (null != refMap && refMap.size() > 0) {
            for (Map.Entry et : refMap.entrySet()) {
                String key = et.getKey().toString();
                String value = et.getValue().toString();
                WsCommonUtil.setPropertyNumberByXml(ctx, headMap, key, value);
            }
        }
    }

    public static KAClassficationInfo getDefaultAccountClass(String type, String comID, String accountTableId, Context ctx) throws Exception {
        String typeID = "";
        if (comID == null) {
            comID = "";
        }
        if (accountTableId == null) {
            accountTableId = "";
        }
        if (type.equals("customer")) {
            typeID = "7ac99937-00fb-2000-e000-0002c0a81345B999CA39";
        } else if (type.equals("supplier")) {
            typeID = "7ac99937-00fb-3000-e000-0002c0a81345B999CA39";
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("typelink.objectType.id", (Object)typeID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("currencyCompany.id", (Object)comID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("accountTableId.id", (Object)accountTableId, CompareType.EQUALS));
        StringBuffer sql = new StringBuffer(100);
        sql.append("select min(k.fnumber) from t_bd_kaclassfication k inner join t_bd_kaclassficationtype kt on k.ftypelink=kt.fid where ");
        sql.append(" kt.fobjecttypeid='").append(typeID).append("'");
        sql.append(" and k.fcurrencycompany='").append(comID).append("'");
        sql.append(" and k.faccounttableid='").append(accountTableId).append("'");
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)sql.toString(), CompareType.INNER));
        filterInfo.setMaskString("#0 and #1 and #2 and #3");
        evi.setFilter(filterInfo);
        KAClassficationInfo kaClassficationInfo = null;
        KAClassficationCollection collection = KAClassficationFactory.getLocalInstance((Context)ctx).getKAClassficationCollection(evi);
        if (collection.size() > 0) {
            kaClassficationInfo = collection.get(0);
        }
        return kaClassficationInfo;
    }
}

