/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ws.customer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerLinkManCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerLinkManInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.util.APIPermissionCheckUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonImportUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonTag;
import com.kingdee.eas.basedata.ws.common.WsCommonUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonXMLUtil;
import com.kingdee.eas.basedata.ws.customer.AbstractImportCustomerSaleFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.PropertyContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class ImportCustomerSaleFacadeControllerBean
extends AbstractImportCustomerSaleFacadeControllerBean {
    private static final long serialVersionUID = -8898723608582309922L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ws.customer.ImportCustomerSaleFacadeControllerBean");
    private String billNumber = "";
    private String retstatus = "0";
    private String errorMessage = "";

    @Override
    protected String _importCustomerSaleData(Context ctx, String xmlData) throws BOSException, EASBizException {
        try {
            Document doc = WsCommonXMLUtil.builderDocument(xmlData);
            if (null != doc) {
                WsCommonXMLUtil.validateRootElement(doc, "DataInfo");
                HashMap headPro = WsCommonXMLUtil.getBillHead(doc, "DataHead");
                ArrayList entiesPro = WsCommonXMLUtil.getBillEntries(doc, "DataEntries//entry");
                this.billNumber = (String)headPro.get("customer");
                CtrlUnitInfo cuInfo = WsCommonUtil.getCuInfo(ctx, (String)headPro.get("CU"));
                if (cuInfo == null) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUNOTFOUND", (Context)ctx));
                }
                ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)cuInfo);
                String opAttributeName = WsCommonXMLUtil.getAttributeValue(doc, "op");
                String bostype = WsCommonXMLUtil.getAttributeValue(doc, "bostype");
                CustomerSaleInfoInfo customerSaleInfo = new CustomerSaleInfoInfo();
                EntityObjectInfo eo = WsCommonUtil.getEntityObjectInfo(ctx, bostype);
                this.checkPermission(ctx, cuInfo, opAttributeName);
                Map<String, Object> map = WsCommonImportUtil.getBillHeadProperties(eo);
                CustomerInfo customerInfo = WsCommonUtil.getCustomerInfo(ctx, this.billNumber, cuInfo.getId().toString());
                if (null == customerInfo) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUSTOMERNOTEXISTS", (Context)ctx));
                }
                customerSaleInfo = this.getCustomerSaleInfoInfo(ctx, this.billNumber, (String)headPro.get("saleOrgUnit"));
                if ("0".equals(opAttributeName) && null == customerSaleInfo) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"SALENOTFOUND", (Context)ctx));
                }
                if (("3".equals(opAttributeName) || "4".equals(opAttributeName)) && null != customerSaleInfo) {
                    opAttributeName = "0";
                } else if (("3".equals(opAttributeName) || "4".equals(opAttributeName)) && null == customerSaleInfo) {
                    customerSaleInfo = null;
                    customerSaleInfo = new CustomerSaleInfoInfo();
                }
                if ("0".equals(opAttributeName) || "3".equals(opAttributeName) || "4".equals(opAttributeName)) {
                    String[] mustValidateHead = WsCommonTag.getMustValidateProsByCustomerSaleHead();
                    String[] mustValidateEntry = WsCommonTag.getMustValidateProsByCustomerSaleEntry();
                    if (!"0".equals(opAttributeName)) {
                        WsCommonUtil.validateHeadProperty(mustValidateHead, headPro);
                        WsCommonUtil.validateEntiesProperty(mustValidateEntry, entiesPro);
                    } else {
                        mustValidateHead = null;
                        mustValidateEntry = null;
                    }
                    WsCommonImportUtil.buildBillHead(ctx, (CoreBaseInfo)customerSaleInfo, map, mustValidateHead, null, headPro, cuInfo.getId().toString());
                    CustomerLinkManCollection col = new CustomerLinkManCollection();
                    this.buildBillEnties(ctx, entiesPro, mustValidateEntry, customerSaleInfo, eo, cuInfo.getId().toString(), opAttributeName, col);
                    ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
                    WsCommonUtil.operationBill(ctx, eo, (CoreBaseInfo)customerSaleInfo, opAttributeName, headPro, map, "");
                }
            }
        }
        catch (Exception e) {
            this.retstatus = "1";
            this.errorMessage = e.getMessage();
        }
        return WsCommonXMLUtil.buildResultXml(this.retstatus, this.billNumber, this.errorMessage);
    }

    private void buildBillEnties(Context ctx, ArrayList entiesPro, String[] mustValidate, CustomerSaleInfoInfo customerSaleInfo, EntityObjectInfo eo, String cuId, String op, CustomerLinkManCollection col) throws Exception {
        Map<String, Object> map = WsCommonImportUtil.getBillEntiesProperties(ctx, "customerLinkMan", eo);
        CustomerLinkManInfo customerLinkManinfo = null;
        HashMap entryMap = null;
        customerSaleInfo.getCustomerLinkMan().clear();
        if (null != map) {
            int count = entiesPro.size();
            for (int i = 0; i < count; ++i) {
                entryMap = null;
                customerLinkManinfo = null;
                entryMap = (HashMap)entiesPro.get(i);
                customerLinkManinfo = new CustomerLinkManInfo();
                WsCommonImportUtil.buildBill(ctx, map, null, entryMap, mustValidate, (PropertyContainer)customerLinkManinfo, cuId);
                if ("3".equals(op) || "4".equals(op)) {
                    customerSaleInfo.getCustomerLinkMan().add(customerLinkManinfo);
                }
                if (!"0".equals(op)) continue;
                customerLinkManinfo.setCustomerSale(customerSaleInfo);
                col.add(customerLinkManinfo);
            }
            customerSaleInfo.getCustomerLinkMan().addCollection(col);
        }
    }

    private CustomerSaleInfoInfo getCustomerSaleInfoInfo(Context ctx, String customerNumber, String saleNumber) throws Exception {
        CustomerSaleInfoInfo saleInfo = null;
        if (null != customerNumber && !"".equals(customerNumber) && null != saleNumber && !"".equals(saleNumber)) {
            try {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                FilterItemCollection fic = filter.getFilterItems();
                fic.add(new FilterItemInfo("customer.number", (Object)customerNumber, CompareType.EQUALS));
                fic.add(new FilterItemInfo("saleOrgUnit.number", (Object)saleNumber, CompareType.EQUALS));
                view.setFilter(filter);
                CustomerSaleInfoCollection col = CustomerSaleInfoFactory.getLocalInstance((Context)ctx).getCustomerSaleInfoCollection(view);
                if (null != col && col.size() > 0) {
                    saleInfo = col.get(0);
                }
            }
            catch (BOSException e) {
                throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"SALENOTFOUND", (Context)ctx));
            }
        }
        return saleInfo;
    }

    private void checkPermission(Context ctx, CtrlUnitInfo cuInfo, String opAttributeName) throws BOSException, EASBizException {
        String permItemName = "";
        permItemName = "0".equals(opAttributeName) ? "Customersaleinfo_AddNew" : "Customersaleinfo_Update";
        APIPermissionCheckUtil.checkPermission(ctx, cuInfo, permItemName);
    }
}

