/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ws.person;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.util.APIPermissionCheckUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonImportUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonTag;
import com.kingdee.eas.basedata.ws.common.WsCommonUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonXMLUtil;
import com.kingdee.eas.basedata.ws.person.AbstractImportPersonFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class ImportPersonFacadeControllerBean
extends AbstractImportPersonFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ws.person.ImportPersonFacadeControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.basedata.person.EmployeeInputResource";
    private String billNumber = "";
    private String retstatus = "0";
    private String errorMessage = "";

    @Override
    protected String _importPersonData(Context ctx, String xmlData) throws BOSException, EASBizException {
        try {
            Document doc = WsCommonXMLUtil.builderDocument(xmlData);
            if (null != doc) {
                WsCommonXMLUtil.validateRootElement(doc, "DataInfo");
                HashMap headPro = WsCommonXMLUtil.getBillHead(doc, "DataHead");
                this.billNumber = (String)headPro.get("number");
                CtrlUnitInfo cuInfo = WsCommonUtil.getCuInfo(ctx, (String)headPro.get("CU"));
                if (cuInfo == null) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUNOTFOUND", (Context)ctx));
                }
                ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)cuInfo);
                APIPermissionCheckUtil.checkPermission(ctx, cuInfo, "Person_import");
                String attributeName = WsCommonXMLUtil.getAttributeValue(doc, "op");
                String bostype = WsCommonXMLUtil.getAttributeValue(doc, "bostype");
                PersonInfo personInfo = new PersonInfo();
                EntityObjectInfo eo = WsCommonUtil.getEntityObjectInfo(ctx, bostype);
                Map<String, Object> map = WsCommonImportUtil.getBillHeadProperties(eo);
                personInfo = (PersonInfo)WsCommonUtil.validateBills(ctx, eo, attributeName, this.billNumber, "", (CoreBaseInfo)personInfo);
                if ("0".equals(attributeName) || "3".equals(attributeName) || "4".equals(attributeName)) {
                    String[] mustValidateHead = WsCommonTag.getMustValidateProsByPersonHead();
                    if (!"0".equals(attributeName)) {
                        WsCommonUtil.validateHeadProperty(mustValidateHead, headPro);
                    } else {
                        mustValidateHead = null;
                    }
                    WsCommonImportUtil.buildBillHead(ctx, (CoreBaseInfo)personInfo, map, mustValidateHead, null, headPro, "");
                    String deletedStatus = (String)headPro.get("deletedStatus");
                    if (deletedStatus != null && "2".equals(deletedStatus)) {
                        personInfo.setDeletedStatus(DeletedStatusEnum.DELETED);
                    } else {
                        personInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
                    }
                    this.dealWithPositionMember(ctx, headPro, personInfo);
                }
                ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
                WsCommonUtil.operationBills(ctx, eo, (CoreBaseInfo)personInfo, attributeName, headPro, map);
            }
        }
        catch (Exception e) {
            this.retstatus = "1";
            this.errorMessage = e.getMessage();
        }
        return WsCommonXMLUtil.buildResultXml(this.retstatus, this.billNumber, this.errorMessage);
    }

    private void dealWithPositionMember(Context ctx, HashMap headPro, PersonInfo personInfo) throws Exception {
        AdminOrgUnitCollection adminColl;
        String nps;
        if (headPro.get("NOPOSITION_PERSON_SAVE") != null && "0".equals(nps = (String)headPro.get("NOPOSITION_PERSON_SAVE"))) {
            String position = "";
            String adminOrgUnit = "";
            int isPrimary = 0;
            if (headPro.get("position") == null) {
                throw new Exception("position" + EASResource.getString((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"MUSTFILL"));
            }
            position = (String)headPro.get("position");
            if (headPro.get("adminOrgUnit") == null) {
                throw new Exception("adminOrgUnit" + EASResource.getString((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"MUSTFILL"));
            }
            adminOrgUnit = (String)headPro.get("adminOrgUnit");
            if (headPro.get("isPrimary") == null) {
                throw new Exception("isPrimary" + EASResource.getString((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"MUSTFILL"));
            }
            isPrimary = Integer.parseInt((String)headPro.get("isPrimary"));
            if (isPrimary == 0 && this.getIsPrimaryCount(ctx, (String)headPro.get("number")) == 0) {
                throw new Exception(EASResource.getString((String)RESOURCE, (String)"NO_PRIMARY_POSITION_TO_IMPORT"));
            }
            if (this.isContainSQLSpecialCharacters(position)) {
                logger.error((Object)"position is error!");
                throw new Exception(EASResource.getString((String)RESOURCE, (String)"NOT_FOUND_POSITION"));
            }
            if (this.isContainSQLSpecialCharacters(adminOrgUnit)) {
                logger.error((Object)"adminOrgUnit is error!");
                throw new Exception(EASResource.getString((String)RESOURCE, (String)"ADMINORGUNITID_NOT_EXIST"));
            }
            IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            AdminOrgUnitCollection adminColl2 = iAdmin.getAdminOrgUnitCollection("select id where number = '" + adminOrgUnit.trim() + "'");
            if (adminColl2.size() == 0) {
                throw new Exception(EASResource.getString((String)RESOURCE, (String)"ADMINORGUNITID_NOT_EXIST"));
            }
            IPosition iPosition = PositionFactory.getLocalInstance((Context)ctx);
            PositionCollection posiColl = iPosition.getPositionCollection("select id,adminOrgUnit.CU,adminOrgUnit.isSealUp,adminOrgUnit.isStartSHR, deletedStatus,adminOrgUnit.id where number = '" + position.trim() + "' and adminorgunit = '" + adminColl2.get(0).getId() + "' ");
            if (posiColl.size() == 0) {
                throw new Exception(EASResource.getString((String)RESOURCE, (String)"NOT_FOUND_POSITION"));
            }
            PositionInfo positionInfo = posiColl.get(0);
            String rangeValue = ParamManager.getParamValue((Context)ctx, null, (String)"IS_AFFAIR");
            if ("false".equalsIgnoreCase(rangeValue) && positionInfo.getDeletedStatus().equals((Object)DeletedStatusEnum.DELETED)) {
                throw new Exception(EASResource.getString((String)RESOURCE, (String)"POSITION_ISDELETED"));
            }
            if (positionInfo.getAdminOrgUnit().isIsSealUp()) {
                throw new Exception(EASResource.getString((String)RESOURCE, (String)"POSITION_ISSEALUP"));
            }
            if (positionInfo.getAdminOrgUnit().isIsStartSHR()) {
                throw new Exception(EASResource.getString((String)RESOURCE, (String)"IS_ADMIN_STARTSHR"));
            }
            PositionMemberInfo positionMemberInfo = null;
            if (personInfo.getId() == null) {
                positionMemberInfo = new PositionMemberInfo();
                positionMemberInfo.setPosition(positionInfo);
            } else {
                IPositionMember iPM = PositionMemberFactory.getLocalInstance((Context)ctx);
                PositionMemberCollection oldPmColl = iPM.getPositionMemberCollection("where person='" + personInfo.getId() + "' and position='" + positionInfo.getId() + "'");
                if (oldPmColl.size() > 0) {
                    positionMemberInfo = oldPmColl.get(0);
                } else {
                    positionMemberInfo = new PositionMemberInfo();
                    positionMemberInfo.setPosition(positionInfo);
                }
            }
            positionMemberInfo.setIsPrimary(isPrimary == 1);
            PositionMemberCollection pmColl = new PositionMemberCollection();
            pmColl.add(positionMemberInfo);
            personInfo.put("PositionList", (Object)pmColl);
            return;
        }
        personInfo.put("NOPOSITION_PERSON_SAVE", (Object)"NOPOSITION_PERSON_SAVE");
        if (headPro.get("gkadmin") != null) {
            String gkadmin = (String)headPro.get("gkadmin");
            if (this.isContainSQLSpecialCharacters(gkadmin)) {
                logger.error((Object)"gkadmin is error!");
                throw new Exception(EASResource.getString((String)RESOURCE, (String)"PERSON_DEP_NOT_EXIST"));
            }
            IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            adminColl = iAdmin.getAdminOrgUnitCollection("select id,isSealUp,isStartSHR where number = '" + gkadmin.trim() + "'");
            if (adminColl == null || adminColl.size() == 0) {
                throw new Exception(EASResource.getString((String)RESOURCE, (String)"PERSON_DEP_NOT_EXIST"));
            }
            if (adminColl.get(0).isIsStartSHR()) {
                throw new Exception(EASResource.getString((String)RESOURCE, (String)"IS_HRINIT_FINISHED"));
            }
            if (adminColl.get(0).isIsSealUp()) {
                throw new Exception(EASResource.getString((String)RESOURCE, (String)"POSITION_ISSEALUP"));
            }
        } else {
            throw new Exception("gkadmin" + EASResource.getString((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"MUSTFILL"));
        }
        personInfo.setGkAdmin(adminColl.get(0));
        personInfo.put("GKADMIN", (Object)adminColl.get(0));
    }

    private int getIsPrimaryCount(Context ctx, String PersonNumber) throws Exception {
        StringBuffer sql = new StringBuffer("SELECT 1 FROM T_ORG_POSITIONMEMBER pm ");
        sql.append("LEFT OUTER JOIN T_BD_PERSON b ON b.FID = pm.FPERSONID ");
        sql.append("where pm.FISPRIMARY = 1 ");
        sql.append("and b.FNUMBER = ? ");
        Object[] param = new Object[]{PersonNumber};
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
            if (rows.next()) {
                return 1;
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
        return 0;
    }

    private boolean isContainSQLSpecialCharacters(String number) {
        if (!StringUtils.isEmpty((String)number)) {
            String[] inj_strA = new String[]{"'", " and ", " or ", "<", "("};
            for (int i = 0; i < inj_strA.length; ++i) {
                if (number.indexOf(inj_strA[i]) == -1) continue;
                return true;
            }
        }
        return false;
    }
}

