/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.ws.supplier;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierPurchaseInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierGroupDetailInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.util.APIPermissionCheckUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonImportUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonTag;
import com.kingdee.eas.basedata.ws.common.WsCommonUtil;
import com.kingdee.eas.basedata.ws.common.WsCommonXMLUtil;
import com.kingdee.eas.basedata.ws.supplier.AbstractImportSupplierFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.util.TimeStampUtility;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.PropertyContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class ImportSupplierFacadeControllerBean
extends AbstractImportSupplierFacadeControllerBean {
    private static final long serialVersionUID = 1744433858926918747L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.ws.supplier.ImportSupplierFacadeControllerBean");
    private String billNumber = "";
    private String retstatus = "0";
    private String errorMessage = "";
    private boolean isFlag = true;

    @Override
    protected String _importSupplierData(Context ctx, String xmlData) throws BOSException, EASBizException {
        block21: {
            try {
                Document doc = WsCommonXMLUtil.builderDocument(xmlData);
                if (null == doc) break block21;
                WsCommonXMLUtil.validateRootElement(doc, "DataInfo");
                HashMap headPro = WsCommonXMLUtil.getBillHead(doc, "DataHead");
                ArrayList entiesPro = WsCommonXMLUtil.getBillEntries(doc, "DataEntries//entry");
                this.billNumber = (String)headPro.get("number");
                CtrlUnitInfo cuInfo = WsCommonUtil.getCuInfo(ctx, (String)headPro.get("CU"));
                if (cuInfo == null) {
                    throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"CUNOTFOUND", (Context)ctx));
                }
                ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)cuInfo);
                String opAttributeName = WsCommonXMLUtil.getAttributeValue(doc, "op");
                String bostype = WsCommonXMLUtil.getAttributeValue(doc, "bostype");
                SupplierInfo supplierInfo = new SupplierInfo();
                EntityObjectInfo eo = WsCommonUtil.getEntityObjectInfo(ctx, bostype);
                Map<String, Object> map = WsCommonImportUtil.getBillHeadProperties(eo);
                this.checkPermission(ctx, cuInfo, opAttributeName);
                if (null != opAttributeName && ("0".equals(opAttributeName) || "1".equals(opAttributeName) || "2".equals(opAttributeName) || "5".equals(opAttributeName))) {
                    supplierInfo = (SupplierInfo)WsCommonUtil.getCoreBaseInfo(ctx, eo, this.billNumber, cuInfo.getId().toString());
                    if (null == supplierInfo) {
                        throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"SUPPLIERNOTEXISTS", (Context)ctx));
                    }
                    if ("1".equals(opAttributeName)) {
                        supplierInfo.setUsedStatus(UsedStatusEnum.APPROVED);
                    } else if ("2".equals(opAttributeName)) {
                        supplierInfo.setUsedStatus(UsedStatusEnum.FREEZED);
                    } else if ("5".equals(opAttributeName)) {
                        supplierInfo.setUsedStatus(UsedStatusEnum.UNAPPROVE);
                    }
                }
                if (null != opAttributeName && ("3".equals(opAttributeName) || "4".equals(opAttributeName))) {
                    try {
                        WsCommonUtil.validateNumber(ctx, eo, this.billNumber, cuInfo.getId().toString());
                    }
                    catch (Exception ex) {
                        this.isFlag = false;
                        throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"BASEDATAEXIST", (Context)ctx));
                    }
                }
                if ("0".equals(opAttributeName) || "3".equals(opAttributeName) || "4".equals(opAttributeName)) {
                    String[] mustValidateHead = WsCommonTag.getMustValidateProsBySupplierHead();
                    String[] mustValidateEntry = WsCommonTag.getMustValidateProsBySupplierEntry();
                    if (!"0".equals(opAttributeName)) {
                        WsCommonUtil.validateHeadProperty(mustValidateHead, headPro);
                        WsCommonUtil.validateEntiesProperty(mustValidateEntry, entiesPro);
                        this.buildBillEnties(ctx, entiesPro, mustValidateEntry, supplierInfo, eo, cuInfo.getId().toString());
                    } else if ("0".equals(opAttributeName)) {
                        if (supplierInfo != null && this.isNotEmpty((IObjectCollection)supplierInfo.getSupplierGroupDetails())) {
                            supplierInfo.getSupplierGroupDetails().clear();
                        }
                        this.buildBillEnties(ctx, entiesPro, mustValidateEntry, supplierInfo, eo, cuInfo.getId().toString());
                    } else {
                        mustValidateHead = null;
                        mustValidateEntry = null;
                    }
                    ctx.put((Object)"infoType", (Object)"supplier");
                    WsCommonImportUtil.buildBillHead(ctx, (CoreBaseInfo)supplierInfo, map, mustValidateHead, null, headPro, cuInfo.getId().toString());
                    ctx.remove((Object)"infoType");
                }
                ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
                WsCommonUtil.operationBill(ctx, eo, (CoreBaseInfo)supplierInfo, opAttributeName, headPro, map, "usedStatus");
                if ("4".equals(opAttributeName)) {
                    supplierInfo = (SupplierInfo)WsCommonUtil.getCoreBaseInfo(ctx, eo, this.billNumber, cuInfo.getId().toString());
                    if (null == supplierInfo) {
                        throw new Exception(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"SUPPLIERNOTEXISTS", (Context)ctx));
                    }
                    this.saveCompanyAndSale(ctx, supplierInfo);
                }
            }
            catch (Exception e) {
                this.retstatus = this.isFlag ? "1" : "3";
                this.errorMessage = e.getMessage();
            }
        }
        return WsCommonXMLUtil.buildResultXml(this.retstatus, this.billNumber, this.errorMessage);
    }

    private void saveCompanyAndSale(Context ctx, SupplierInfo supplierInfo) throws Exception {
        try {
            ISupplierCompanyInfo isupplierCompanyInfo = SupplierCompanyInfoFactory.getLocalInstance((Context)ctx);
            ISupplierPurchaseInfo iSupplierPurchaseInfo = SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx);
            if (null != supplierInfo.getCU()) {
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(supplierInfo.getCU().getId()));
                if (company != null) {
                    SupplierCompanyInfoInfo vo = new SupplierCompanyInfoInfo();
                    vo.setCompanyOrgUnit(company);
                    vo.setSupplier(supplierInfo);
                    vo.setCU(company.getCU());
                    vo.setIsFreezePayment(false);
                    vo.setCreateTime(TimeStampUtility.getTime());
                    vo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
                    vo.setLastUpdateTime(null);
                    vo.setLastUpdateUser(null);
                    String accountTableId = null;
                    if (company != null) {
                        if (company.getAccountTable() != null) {
                            accountTableId = company.getAccountTable().getId().toString();
                            String companyOrgId = company.getId().toString();
                            KAClassficationInfo kaClassficationInfo = WsCommonUtil.getDefaultAccountClass("supplier", companyOrgId, accountTableId, ctx);
                            vo.setAccountingClassification(kaClassficationInfo);
                        } else {
                            vo.setAccountingClassification(null);
                        }
                    }
                    vo.setSettlementCurrency(company.getBaseCurrency());
                    isupplierCompanyInfo.submit((CoreBaseInfo)vo);
                }
                PurchaseOrgUnitInfo purOrg = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(supplierInfo.getCU().getId()));
                SupplierPurchaseInfoInfo purchaseInfo = new SupplierPurchaseInfoInfo();
                if (purchaseInfo != null) {
                    purchaseInfo.setPurchaseOrgUnit(purOrg);
                    purchaseInfo.setDeliverOrgUnit(supplierInfo);
                    purchaseInfo.setBillingOrgUnit(supplierInfo);
                    purchaseInfo.setSupplier(supplierInfo);
                    purchaseInfo.setGrade("0");
                    purchaseInfo.setCU(purOrg.getCU());
                    purchaseInfo.setIsFreezeMakeOrder(false);
                    purchaseInfo.setCreateTime(TimeStampUtility.getTime());
                    purchaseInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
                    purchaseInfo.setLastUpdateTime(null);
                    purchaseInfo.setLastUpdateUser(null);
                    iSupplierPurchaseInfo.submit((CoreBaseInfo)purchaseInfo);
                }
            }
        }
        catch (Exception e) {
            String msg = EASCommonResource.getString((String)"com.kingdee.eas.basedata.ws.common.WebSericeResource", (String)"AddSup_PurChase_Error", (Locale)ctx.getLocale());
            throw new Exception(msg);
        }
    }

    private void buildBillEnties(Context ctx, ArrayList entiesPro, String[] mustValidate, SupplierInfo supplierInfo, EntityObjectInfo eo, String cuId) throws Exception {
        Map<String, Object> map = WsCommonImportUtil.getBillEntiesProperties(ctx, "supplierGroupDetails", eo);
        SupplierGroupDetailInfo supplierDetialinfo = null;
        HashMap entryMap = null;
        if (null != map) {
            int count = entiesPro.size();
            for (int i = 0; i < count; ++i) {
                entryMap = null;
                supplierDetialinfo = null;
                entryMap = (HashMap)entiesPro.get(i);
                supplierDetialinfo = new SupplierGroupDetailInfo();
                WsCommonImportUtil.buildBill(ctx, map, null, entryMap, mustValidate, (PropertyContainer)supplierDetialinfo, cuId);
                supplierInfo.getSupplierGroupDetails().add(supplierDetialinfo);
            }
        }
    }

    private void checkPermission(Context ctx, CtrlUnitInfo cuInfo, String opAttributeName) throws BOSException, EASBizException {
        String permItemName = "";
        permItemName = "0".equals(opAttributeName) ? "Supplier_Update" : "Supplier_AddNew";
        APIPermissionCheckUtil.checkPermission(ctx, cuInfo, permItemName);
    }

    private boolean isNotEmpty(IObjectCollection collection) {
        if (collection == null) {
            return false;
        }
        return collection.size() > 0;
    }
}

