/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.hraux.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.AdminTreeBuilderFacadeFactory;
import com.kingdee.eas.base.core.hr.IAdminTreeBuilderFacade;
import com.kingdee.eas.basedata.hraux.EmployeeEntityPropertyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.EmployeeFenLeiInfo;
import com.kingdee.eas.hr.base.EmployeeTypeCollection;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class HRTreeUtil {
    private static final Icon groupIcon = EASResource.getIcon((String)"imgTree_group");
    private static final Icon companyIcon = EASResource.getIcon((String)"imgTree_company");
    private static final Icon positionIcon = EASResource.getIcon((String)"imgTree_position");
    private static Color disableColor = Color.GRAY;
    private static HashMap nodeCache = new HashMap();
    private static String oldDSessionId = null;

    public static void disableTreeNode(DefaultKingdeeTreeNode treeNode) {
        treeNode.setTextColor(disableColor);
    }

    public static boolean isTreeNodeDisable(DefaultKingdeeTreeNode treeNode) {
        if (treeNode.getTextColor() == null) {
            return true;
        }
        return disableColor.equals(treeNode.getTextColor());
    }

    public static DefaultKingdeeTreeNode createEmployeeFenLeiTreeNode(boolean includeEmployeeType) throws Exception {
        return HRTreeUtil.createEmployeeFenLeiTreeNode(includeEmployeeType, null);
    }

    public static DefaultKingdeeTreeNode createEmployeeFenLeiTreeNode(boolean includeEmployeeType, HashSet employeeTypeSet) throws Exception {
        return HRTreeUtil.createEmployeeFenLeiTreeNode(includeEmployeeType, employeeTypeSet, null);
    }

    public static DefaultKingdeeTreeNode createEmployeeFenLeiTreeNode(boolean includeEmployeeType, HashSet employeeTypeSet, HashSet employeeTypeIdSet) throws Exception {
        EmployeeTypeCollection empTypeColl = HRTreeUtil.getEmpTypeCollForTree(employeeTypeSet, employeeTypeIdSet);
        if (empTypeColl == null || empTypeColl.size() == 0) {
            return null;
        }
        DefaultKingdeeTreeNode rootTreeNode = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"16_EmployeeFenLeiListUI"));
        DefaultKingdeeTreeNode empTypeTreeNode = null;
        HashMap<String, DefaultKingdeeTreeNode> nodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
        EmployeeTypeInfo empTypeInfo = null;
        String empFenLeiId = null;
        EmployeeFenLeiInfo employeeFenLeiInfo = null;
        HashSet<String> empFenLeiIdSet = new HashSet<String>();
        for (int i = 0; i < empTypeColl.size(); ++i) {
            empTypeInfo = empTypeColl.get(i);
            employeeFenLeiInfo = empTypeInfo.getEmployeeFenLei();
            if (employeeFenLeiInfo == null) continue;
            empFenLeiId = employeeFenLeiInfo.getId().toString();
            if (!empFenLeiIdSet.contains(empFenLeiId)) {
                empFenLeiIdSet.add(empFenLeiId);
                DefaultKingdeeTreeNode subTreeNode = new DefaultKingdeeTreeNode((Object)employeeFenLeiInfo);
                if (employeeFenLeiInfo.getParent() != null && nodeMap.containsKey(employeeFenLeiInfo.getParent().getId().toString())) {
                    ((DefaultKingdeeTreeNode)nodeMap.get(employeeFenLeiInfo.getParent().getId().toString())).add((MutableTreeNode)subTreeNode);
                } else {
                    rootTreeNode.add((MutableTreeNode)subTreeNode);
                }
                nodeMap.put(employeeFenLeiInfo.getId().toString(), subTreeNode);
            }
            if (!includeEmployeeType) continue;
            empTypeTreeNode = new DefaultKingdeeTreeNode((Object)empTypeInfo);
            DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)nodeMap.get(empFenLeiId);
            parentNode.add((MutableTreeNode)empTypeTreeNode);
        }
        return rootTreeNode;
    }

    private static EmployeeTypeCollection getEmpTypeCollForTree(HashSet employeeTypeNameSet, HashSet employeeTypeIdSet) throws BOSException {
        EmployeeTypeCollection empTypeColl = null;
        if (employeeTypeIdSet != null) {
            String idStr = HRTreeUtil.getStrFromSet(employeeTypeIdSet);
            String oql = "select *,employeeFenLei.* where id in " + idStr + " order by employeeFenLei.longNumber,index";
            empTypeColl = EmployeeTypeFactory.getRemoteInstance().getEmployeeTypeCollection(oql);
        } else {
            empTypeColl = EmployeeTypeFactory.getRemoteInstance().getEmployeeTypeCollection(" select *,employeeFenLei.* order by employeeFenLei.longNumber,index");
        }
        return empTypeColl;
    }

    public static String getStrFromSet(Set set) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        Iterator ite = set.iterator();
        while (ite.hasNext()) {
            sb.append("'");
            sb.append(ite.next().toString());
            sb.append("',");
        }
        sb.append("'')");
        return sb.toString();
    }

    public static TreePath[] getSelectTreePaths(KDTree tree) {
        int i;
        TreePath[] paths = tree.getSelectionModel().getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        ArrayList<TreePath> list = new ArrayList<TreePath>();
        boolean flag = true;
        int size = paths.length;
        for (i = 0; i < size; ++i) {
            flag = true;
            for (int t = 0; t < paths.length; ++t) {
                if (paths[i] == paths[t] || !paths[t].isDescendant(paths[i])) continue;
                flag = false;
            }
            if (!flag) continue;
            list.add(paths[i]);
        }
        paths = new TreePath[list.size()];
        size = list.size();
        for (i = 0; i < size; ++i) {
            paths[i] = (TreePath)list.get(i);
        }
        return paths;
    }

    public static DefaultKingdeeTreeNode createAdminTreeNodeByUserRange() throws Exception {
        return HRTreeUtil.createAdminTreeNodeByUserRange(false);
    }

    public static DefaultKingdeeTreeNode createAdminTreeNodeByUserRange(boolean includePosition) throws Exception {
        return HRTreeUtil.createAdminTreeNodeByUserRange(includePosition, true);
    }

    public static DefaultKingdeeTreeNode createAdminTreeNodeByUserRange(boolean includePosition, boolean includeVirtualOrg) throws Exception {
        return HRTreeUtil.createAdminTreeNodeByUserRange(includePosition, includeVirtualOrg, null);
    }

    public static DefaultKingdeeTreeNode createAdminTreeNodeByUserRange(boolean includePosition, boolean includeVirtualOrg, boolean includeSealup) throws Exception {
        return HRTreeUtil.createAdminTreeNodeByUserRange(includePosition, includeVirtualOrg, true, includeSealup, null);
    }

    public static DefaultKingdeeTreeNode createAdminTreeNodeByUserRange(boolean includePosition, boolean includeVirtualOrg, HashSet hroSet) throws Exception {
        return HRTreeUtil.createAdminTreeNodeByUserRange(includePosition, includeVirtualOrg, true, false, hroSet);
    }

    public static DefaultKingdeeTreeNode createAdminTreeNodeByUserRange(boolean includePosition, boolean includeVirtualOrg, boolean isUseCache, boolean includeSealup, HashSet hroSet) throws Exception {
        return HRTreeUtil.createAdminTreeNodeByUserRange(includePosition, includeVirtualOrg, true, includeSealup, hroSet, true);
    }

    public static DefaultKingdeeTreeNode createAdminTreeNodeByUserRange(boolean includePosition, boolean includeVirtualOrg, boolean isUseCache, boolean includeSealup, HashSet hroSet, boolean showHiddenInChart) throws Exception {
        String sessionId = SysContext.getSysContext().getSessionID();
        if (oldDSessionId == null) {
            oldDSessionId = sessionId;
        } else if (!sessionId.equals(oldDSessionId)) {
            oldDSessionId = sessionId;
            nodeCache.clear();
        }
        DefaultKingdeeTreeNode rootNode = null;
        String key = oldDSessionId + includePosition + includeVirtualOrg + hroSet + includeSealup;
        if (nodeCache.get(key) == null || !isUseCache) {
            rootNode = HRTreeUtil.createAdminTreeNodeByUserRangeNoCache(includePosition, includeVirtualOrg, hroSet, includeSealup, showHiddenInChart);
            nodeCache.put(key, rootNode);
        } else {
            rootNode = (DefaultKingdeeTreeNode)nodeCache.get(key);
        }
        return HRTreeUtil.cloneAdminTree(rootNode);
    }

    private static DefaultKingdeeTreeNode createAdminTreeNodeByUserRangeNoCache(boolean includePosition, boolean includeVirtualOrg, HashSet hroSet, boolean includeSealup, boolean showHiddenInChart) throws Exception {
        IAdminTreeBuilderFacade iATBFacade = AdminTreeBuilderFacadeFactory.getRemoteInstance();
        ArrayList returnList = iATBFacade.getAdminTreeData(includePosition, includeVirtualOrg, hroSet, includeSealup, showHiddenInChart);
        if (returnList == null || returnList.size() == 0) {
            return null;
        }
        ArrayList adminList = (ArrayList)returnList.get(0);
        IRowSet rows = (IRowSet)returnList.get(1);
        HashSet hasPermissionOrgSet = (HashSet)returnList.get(3);
        if (adminList == null || rows == null) {
            return null;
        }
        HashMap nodeMap = new HashMap();
        DefaultKingdeeTreeNode rootNode = HRTreeUtil.buildTreeNodeByRowSet(rows, nodeMap, hasPermissionOrgSet);
        if (rootNode != null) {
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)rootNode.getUserObject();
            if (!adminList.contains(adminInfo.getLongNumber())) {
                HRTreeUtil.disableTreeNode(rootNode);
            }
            HRTreeUtil.removeInvalidAdminNode(rootNode, adminList);
            HRTreeUtil.sortAdminInTheSameLevel(rootNode);
        }
        if (includePosition) {
            HRTreeUtil.addPositionNode(rootNode, nodeMap, (IRowSet)returnList.get(2));
        }
        return rootNode;
    }

    private static void addPositionNode(DefaultKingdeeTreeNode root, HashMap nodeMap, IRowSet rows) throws Exception {
        if (rows == null || rows.size() == 0) {
            return;
        }
        String adminID = null;
        PositionInfo positionInfo = null;
        DefaultKingdeeTreeNode positionTreeNode = null;
        DefaultKingdeeTreeNode parentNode = null;
        DefaultKingdeeTreeNode childNode = null;
        int index = 0;
        while (rows.next()) {
            adminID = rows.getString("FAdminOrgUnitID");
            if (!nodeMap.containsKey(adminID) || HRTreeUtil.isTreeNodeDisable(parentNode = (DefaultKingdeeTreeNode)nodeMap.get(adminID))) continue;
            positionInfo = HRTreeUtil.createPositionInfo(rows);
            positionTreeNode = new DefaultKingdeeTreeNode((Object)positionInfo);
            positionTreeNode.setCustomIcon(positionIcon);
            if (rows.getBoolean("DefaultPosition")) {
                parentNode.insert((MutableTreeNode)positionTreeNode, 0);
                continue;
            }
            if (parentNode.getChildCount() > 0) {
                childNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(0);
                index = rows.getInt("PFIndex") + 1;
                if (childNode.getUserObject() instanceof PositionInfo && parentNode.getChildCount() > index && rows.getString("PFIndex") != null && rows.getInt("PFIndex") >= 0) {
                    HRTreeUtil.insertPositionNode(parentNode, positionTreeNode, index);
                    continue;
                }
                if (childNode.getUserObject() instanceof PositionInfo && parentNode.getChildCount() <= index) {
                    HRTreeUtil.insertPositionNode(parentNode, positionTreeNode, parentNode.getChildCount());
                    continue;
                }
                if (childNode.getUserObject() instanceof PositionInfo) {
                    parentNode.insert((MutableTreeNode)positionTreeNode, 1);
                    continue;
                }
                parentNode.insert((MutableTreeNode)positionTreeNode, 0);
                continue;
            }
            parentNode.add((MutableTreeNode)positionTreeNode);
        }
        nodeMap = null;
    }

    private static PositionInfo createPositionInfo(IRowSet row) throws Exception {
        PositionInfo info = new PositionInfo();
        info.setId(BOSUuid.read((String)row.getString("id")));
        info.setName(row.getString("name"));
        return info;
    }

    private static void insertPositionNode(DefaultKingdeeTreeNode parent, DefaultKingdeeTreeNode child, int index) {
        for (int i = index; i > 0; --i) {
            if (!(((DefaultKingdeeTreeNode)parent.getChildAt(i - 1)).getUserObject() instanceof PositionInfo)) continue;
            parent.insert((MutableTreeNode)child, i);
            return;
        }
        parent.insert((MutableTreeNode)child, 0);
    }

    private static void removeInvalidAdminNode(DefaultKingdeeTreeNode rootNode, ArrayList adminList) {
        for (int i = rootNode.getChildCount() - 1; i >= 0; --i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)rootNode.getChildAt(i);
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)childNode.getUserObject();
            if (adminList.contains(adminInfo.getLongNumber())) {
                HRTreeUtil.removeInvalidAdminNode(childNode, adminList);
                continue;
            }
            if (childNode.isLeaf()) {
                rootNode.remove((MutableTreeNode)childNode);
                continue;
            }
            HRTreeUtil.disableTreeNode(childNode);
            HRTreeUtil.removeInvalidAdminNode(childNode, adminList);
            if (!childNode.isLeaf()) continue;
            rootNode.remove((MutableTreeNode)childNode);
        }
    }

    private static DefaultKingdeeTreeNode buildTreeNodeByRowSet(IRowSet rows, HashMap nodeMap, HashSet hasPermissionOrgSet) throws Exception {
        if (rows == null) {
            return null;
        }
        DefaultKingdeeTreeNode rootTreeNode = null;
        DefaultKingdeeTreeNode subTreeNode = null;
        AdminOrgUnitInfo adminInfo = null;
        String adminId = null;
        String parentId = null;
        while (rows.next()) {
            adminInfo = HRTreeUtil.createAdminUnitInfo(rows);
            adminId = adminInfo.getId().toString();
            if (hasPermissionOrgSet.contains(adminId)) {
                adminInfo.put("CAN_VIEW", (Object)"1");
            }
            if (rootTreeNode == null) {
                rootTreeNode = new DefaultKingdeeTreeNode((Object)adminInfo);
                rootTreeNode.setCustomIcon(groupIcon);
                nodeMap.put(adminId, rootTreeNode);
                continue;
            }
            subTreeNode = new DefaultKingdeeTreeNode((Object)adminInfo);
            subTreeNode.setCustomIcon(companyIcon);
            if (adminInfo.getParent() != null && nodeMap.containsKey(parentId = adminInfo.getParent().getId().toString())) {
                ((DefaultKingdeeTreeNode)nodeMap.get(parentId)).add((MutableTreeNode)subTreeNode);
            }
            nodeMap.put(adminId, subTreeNode);
        }
        return rootTreeNode;
    }

    private static AdminOrgUnitInfo createAdminUnitInfo(IRowSet row) throws Exception {
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        adminInfo.setId(BOSUuid.read((String)row.getString("FID")));
        adminInfo.setName(row.getString("FName_" + SysContext.getSysContext().getLocale()));
        adminInfo.setSortCode(row.getString("FSortCode"));
        adminInfo.setLongNumber(row.getString("FLongNumber"));
        adminInfo.setIsLeaf(row.getBoolean("FIsLeaf"));
        adminInfo.setLevel(row.getInt("FLevel"));
        AdminOrgUnitInfo parentInfo = new AdminOrgUnitInfo();
        if (StringUtils.isEmpty((String)row.getString("FParentID"))) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("FParentID")));
        }
        adminInfo.setParent(parentInfo);
        return adminInfo;
    }

    private static void sortAdminInTheSameLevel(DefaultKingdeeTreeNode root) {
        int childCount = root.getChildCount();
        if (childCount > 0) {
            int i;
            for (i = 0; i < childCount - 1; ++i) {
                DefaultKingdeeTreeNode minSubNode = (DefaultKingdeeTreeNode)root.getChildAt(i);
                String minSortCode = ((AdminOrgUnitInfo)minSubNode.getUserObject()).getSortCode();
                if (StringUtils.isEmpty((String)minSortCode)) continue;
                int minIndex = i;
                for (int j = i + 1; j < childCount; ++j) {
                    DefaultKingdeeTreeNode subNode = (DefaultKingdeeTreeNode)root.getChildAt(j);
                    String sortCode = ((AdminOrgUnitInfo)subNode.getUserObject()).getSortCode();
                    if (StringUtils.isEmpty((String)sortCode) || sortCode.compareTo(minSortCode) >= 0) continue;
                    minSubNode = subNode;
                    minSortCode = sortCode;
                    minIndex = j;
                }
                if (minIndex == i) continue;
                root.insert((MutableTreeNode)minSubNode, i);
            }
            for (i = 0; i < childCount; ++i) {
                HRTreeUtil.sortAdminInTheSameLevel((DefaultKingdeeTreeNode)root.getChildAt(i));
            }
        }
    }

    public static DefaultKingdeeTreeNode createTreeNodeByEmployeeProperty() throws Exception {
        StringBuffer sql = new StringBuffer("SELECT FName_");
        sql.append(SysContext.getSysContext().getLocale());
        sql.append(",FEntityName FROM T_HR_EmployeeSystemPage WHERE FType = 1 ORDER BY FID");
        ISQLExecutor iSQL = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rows = iSQL.executeSQL();
        DefaultKingdeeTreeNode rootTreeNode = new DefaultKingdeeTreeNode((Object)"Root");
        DefaultKingdeeTreeNode subTreeNode = null;
        EmployeeEntityPropertyInfo info = null;
        while (rows.next()) {
            info = new EmployeeEntityPropertyInfo();
            info.setPropertyAlias(rows.getString("FName_" + SysContext.getSysContext().getLocale()));
            info.setType(0);
            subTreeNode = new DefaultKingdeeTreeNode((Object)info);
            HRTreeUtil.addPropertiesNode(subTreeNode, rows.getString("FEntityName"));
            rootTreeNode.add((MutableTreeNode)subTreeNode);
        }
        return rootTreeNode;
    }

    private static void addPropertiesNode(DefaultKingdeeTreeNode entityNode, String entityName) {
        if (StringUtils.isEmpty((String)entityName)) {
            return;
        }
        EntityObjectInfo entityInfo = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        entityInfo = loader.getEntity((IMetaDataPK)new MetaDataPK(entityName));
        PropertyCollection pColl = entityInfo.getInheritedNoDuplicatedProperties();
        DefaultKingdeeTreeNode propertyNode = null;
        EmployeeEntityPropertyInfo info = null;
        int size = pColl.size();
        for (int i = 0; i < size; ++i) {
            String propertyName = pColl.get(i).getName();
            if (propertyName.equals("jobLevel") || propertyName.equals("pastJobLevel")) continue;
            info = new EmployeeEntityPropertyInfo();
            info.setPropertyAlias(pColl.get(i).getAlias());
            info.setPropertyName(pColl.get(i).getName());
            info.setEntityAlias(entityNode.getText());
            info.setEntityName(entityName);
            info.setType(1);
            propertyNode = new DefaultKingdeeTreeNode((Object)info);
            entityNode.add((MutableTreeNode)propertyNode);
        }
    }

    public static DefaultKingdeeTreeNode cloneAdminTree(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return null;
        }
        DefaultKingdeeTreeNode cloneRoot = (DefaultKingdeeTreeNode)root.clone();
        HRTreeUtil.cloneRootNode(root, cloneRoot);
        return cloneRoot;
    }

    private static void cloneRootNode(DefaultKingdeeTreeNode rootNode, DefaultKingdeeTreeNode cloneRootNode) {
        DefaultKingdeeTreeNode node = null;
        DefaultKingdeeTreeNode newNode = null;
        int count = rootNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            node = (DefaultKingdeeTreeNode)rootNode.getChildAt(i);
            newNode = (DefaultKingdeeTreeNode)node.clone();
            cloneRootNode.add((MutableTreeNode)newNode);
            HRTreeUtil.cloneRootNode(node, newNode);
        }
    }
}

