/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.cssp.CopyDataStatusEnum;
import com.kingdee.eas.basedata.master.cssp.IUserParamater;
import com.kingdee.eas.basedata.master.cssp.UserParamaterCollection;
import com.kingdee.eas.basedata.master.cssp.UserParamaterFactory;
import com.kingdee.eas.basedata.master.cssp.UserParamaterInfo;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mm.basedata.IMaterialTrademark;
import com.kingdee.eas.mm.basedata.MaterialTrademarkFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class MaterialUtil {
    private static final Logger logger = Logger.getLogger(MaterialUtil.class);
    private static String oldSessionId = null;
    private static HashMap paramMap = new HashMap();

    public static String getIdsSql(String[] ids) {
        if (ids == null) {
            return null;
        }
        if (ids.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            sb.append("'").append(ids[i].toString()).append("'").append(",");
        }
        if (sb.length() > 0) {
            sb.insert(0, "(");
            sb.setCharAt(sb.length() - 1, ')');
        }
        return sb.toString();
    }

    public static String getParam(String number) {
        String param = null;
        String sessionId = SysContext.getSysContext().getSessionID();
        if (StringUtils.equals((String)sessionId, (String)oldSessionId) && paramMap.get(number) != null) {
            param = paramMap.get(number).toString();
        } else {
            if (!StringUtils.equals((String)sessionId, (String)oldSessionId)) {
                paramMap.clear();
            }
            param = MaterialUtil.getParam(null, null, number);
            paramMap.put(number, param);
            oldSessionId = sessionId;
        }
        return param;
    }

    public static String getParam(Context ctx, String number) {
        if (ctx == null) {
            return MaterialUtil.getParam(number);
        }
        return MaterialUtil.getParam(ctx, null, number);
    }

    public static String getParam(Context ctx, String orgId, String number) {
        String result = null;
        ObjectUuidPK orgPK = null;
        if (orgId != null && !"".equals(orgId)) {
            orgPK = new ObjectUuidPK(orgId);
        }
        try {
            result = ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)number, orgPK, (boolean)false);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return result;
    }

    public static boolean getBooleanParam(Context ctx, String number, boolean defaultValue) {
        String strValue = MaterialUtil.getParam(ctx, number);
        if (strValue == null) {
            return defaultValue;
        }
        Boolean value = Boolean.valueOf(strValue);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static boolean getBooleanParam(Context ctx, String number, String OrgId, boolean defaultValue) {
        String strValue = MaterialUtil.getParam(ctx, OrgId, number);
        if (strValue == null) {
            return defaultValue;
        }
        Boolean value = Boolean.valueOf(strValue);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static HashSet getRelationOrgIdSet(String orgUnitID, int fromType, int toType) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        if (orgUnitID == null) {
            idSet.add("");
            return idSet;
        }
        OrgUnitCollection orgCol = null;
        IOrgUnitRelation iUtilRel = OrgUnitRelationFactory.getRemoteInstance();
        orgCol = iUtilRel.getToUnit(orgUnitID, fromType, toType);
        if (orgCol.size() == 0) {
            idSet.add("");
            return idSet;
        }
        for (int i = 0; i < orgCol.size(); ++i) {
            idSet.add(orgCol.get(i).getId().toString());
        }
        return idSet;
    }

    public static void setQualityOrgF7(KDBizPromptBox box, OrgUnitInfo org, int fromType, int toType) throws Exception {
        HashSet idSet = null;
        if (org == null) {
            idSet = new HashSet();
            idSet.add("");
        } else {
            idSet = MaterialUtil.getRelationOrgIdSet(org.getId().toString(), fromType, toType);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        box.setEntityViewInfo(viewInfo);
    }

    public static UsedStatusEnum getMaterialCopyStatus(CopyDataStatusEnum copyBaseDataStaus, UsedStatusEnum oldStatus) {
        if (copyBaseDataStaus == CopyDataStatusEnum.UnApprove) {
            return UsedStatusEnum.UNAPPROVE;
        }
        if (copyBaseDataStaus == CopyDataStatusEnum.Approve) {
            return UsedStatusEnum.APPROVED;
        }
        return oldStatus;
    }

    public static UserParamaterInfo getUserParamaterInfo(String number) throws BOSException, EASBizException {
        return MaterialUtil.getUserParamaterInfo(null, number, SysContext.getSysContext().getCurrentUserInfo().getId().toString());
    }

    public static UserParamaterInfo getUserParamaterInfo(String number, String userId) throws BOSException, EASBizException {
        return MaterialUtil.getUserParamaterInfo(null, number, userId);
    }

    public static UserParamaterInfo getUserParamaterInfo(Context ctx, String number, String userId) throws BOSException, EASBizException {
        UserParamaterInfo paramInfo = null;
        IUserParamater iUserParam = ctx == null ? UserParamaterFactory.getRemoteInstance() : UserParamaterFactory.getLocalInstance((Context)ctx);
        UserParamaterCollection userParams = iUserParam.getUserParamaterCollection("select * where userID='" + userId + "' and number='" + number + "'");
        if (userParams != null && userParams.size() > 0) {
            paramInfo = userParams.get(0);
        }
        return paramInfo;
    }

    public static boolean getBooleanUserParamater(Context ctx, String number, String userId) throws BOSException, EASBizException {
        return MaterialUtil.getBooleanUserParamater(ctx, number, userId, false);
    }

    public static boolean getBooleanUserParamater(Context ctx, String number, String userId, boolean defaultValue) throws BOSException, EASBizException {
        UserParamaterInfo userParamaterInfo = MaterialUtil.getUserParamaterInfo(ctx, number, userId);
        if (userParamaterInfo != null) {
            String paramValue = userParamaterInfo.getValue();
            return Boolean.valueOf(paramValue);
        }
        return defaultValue;
    }

    public static boolean isIgnoreRowCount(Context ctx, String userId) throws BOSException, EASBizException {
        return MaterialUtil.getBooleanUserParamater(ctx, "materialIgnoreRowCount", userId);
    }

    public static boolean isLocateTree(Context ctx, String userId) throws BOSException, EASBizException {
        return MaterialUtil.getBooleanUserParamater(ctx, "materialLocateTree", userId, true);
    }

    public static FilterInfo getMaterialTrademarkDFilter(Context ctx, String cuId) throws BOSException, EASBizException {
        IMaterialTrademark iDataBaseD = MaterialTrademarkFactory.getLocalInstance((Context)ctx);
        FilterInfo fitlerInfo = iDataBaseD.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuId), "id", "adminCU.id");
        return fitlerInfo;
    }

    public static MaterialGroupStandardCollection getGroupStandardCollection(Context ctx, CtrlUnitInfo cu) throws BOSException, EASBizException {
        MaterialGroupStandardCollection materialGroupStandards = null;
        IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)cu.getId().toString(), (String)cu.getLongNumber()));
        materialGroupStandards = iMaterialGroupStandard.getMaterialGroupStandardCollection(view);
        return materialGroupStandards;
    }

    public static boolean isUpgradeSubordinate(Context ctx, CtrlUnitInfo cu, String bosType) throws EASBizException, BOSException {
        boolean can = false;
        String longNumber = cu.getLongNumber();
        StringBuffer oql = new StringBuffer(100);
        oql.append("where id in (").append("select a.FID from T_ORG_CtrlUnit a inner join T_ORG_CUBDControl b ").append("on a.FID=b.FControlUnitID where a.FLongNumber like '").append(longNumber).append("!%' ").append("and b.FBDBOSType='").append(bosType).append("' and b.FIsSubordinateUpgradable=1").append(")");
        if (FullOrgUnitFactory.getLocalInstance((Context)ctx).exists(oql.toString())) {
            can = true;
        }
        return can;
    }

    public static boolean isEnableDataPermission(Context ctx) throws EASBizException, BOSException {
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance((Context)ctx);
        return provider != null && provider.isEnableDataPermission();
    }

    public static void checkMeasureUnit(MaterialInfo materialInfo, MeasureUnitInfo comparedUnitInfo, Class classEasException, NumericExceptionSubItem excSubItem, Context ctx) throws BOSException, EASBizException {
    }

    public static Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    public static void checkFunctionPermission(Context ctx, String ouId, String PerminsionItem) throws BOSException, EASBizException {
        String getCUSQL = " select FCONTROLUNITID from T_ORG_BaseUnit where fid = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getCUSQL, (Object[])new Object[]{ouId});
        String cuId = ouId;
        try {
            if (rs.next()) {
                cuId = rs.getString("FCONTROLUNITID");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        ObjectUuidPK CUPK = new ObjectUuidPK(cuId);
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        iPermission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)CUPK, PerminsionItem);
    }

    public static String getCurDateTimeStr4Sql() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "{ts'" + sdf.format(date) + "'}";
    }
}

