/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.AsstAttrCompondingTypeValueGetterFactory;
import com.kingdee.eas.basedata.master.material.IAsstAttrCompondingTypeValueGetter;
import com.kingdee.eas.basedata.master.material.client.AbstractAsstAttrValueChooseUI;
import com.kingdee.eas.basedata.master.material.util.AsstAttrResrc;
import com.kingdee.eas.basedata.master.material.util.AsstAttrSeparator;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class AsstAttrValueChooseUI
extends AbstractAsstAttrValueChooseUI {
    private static final Logger logger = CoreUIObject.getLogger(AsstAttrValueChooseUI.class);
    private boolean isConfirmed = false;
    private ArrayList selValues = new ArrayList();

    public AsstAttrValueChooseUI() throws Exception {
        this.initCtrls();
    }

    private void initCtrls() {
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AsstAttrValueChooseUI.this.onClickForBtnOK();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AsstAttrValueChooseUI.this.onClickForBtnCancel();
            }
        });
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initTable();
    }

    private void initTable() {
        this.kDTable1.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent arg0) {
                AsstAttrValueChooseUI.this.onAfterDataFillForTable();
            }
        });
        this.kDTable1.getDataRequestManager().setDataRequestMode(1);
        this.kDTable1.addKDTDataRequestListener(new KDTDataRequestListener(){

            public void tableDataRequest(KDTDataRequestEvent arg0) {
                AsstAttrValueChooseUI.this.onDataRequestForTable(arg0);
            }
        });
        this.kDTable1.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent arg0) {
                AsstAttrValueChooseUI.this.onEditValueChangedForTable(arg0);
            }
        });
        this.kDTable1.getIndexColumn().getStyleAttributes().setHided(true);
        this.kDTable1.getStyleAttributes().setLocked(true);
        this.kDTable1.getColumn(0).getStyleAttributes().setLocked(false);
    }

    public int getSelectedValuesCount() {
        return this.selValues.size();
    }

    public String[][] getNumberAndName() {
        int size = this.selValues.size();
        String[][] array = new String[size][2];
        for (int i = 0; i < size; ++i) {
            String[] idAndnumberAndname = (String[])this.selValues.get(i);
            array[i][0] = idAndnumberAndname[1].toString();
            array[i][1] = idAndnumberAndname[2].toString();
        }
        return array;
    }

    public String[][] getNumberElements() {
        int size = this.selValues.size();
        String[][] array = new String[size][];
        for (int i = 0; i < size; ++i) {
            String[] idAndnumberAndname = (String[])this.selValues.get(i);
            array[i] = idAndnumberAndname[1].toString().split("/");
        }
        return array;
    }

    public String[][] getIDElements() {
        int size = this.selValues.size();
        String[][] array = new String[size][];
        for (int i = 0; i < size; ++i) {
            String[] idAndnumberAndname = (String[])this.selValues.get(i);
            array[i] = idAndnumberAndname[0].toString().split("/");
        }
        return array;
    }

    private String getSQL() {
        int i;
        String[] basicTypeIDs = (String[])this.getUIContext().get("IDsOfBasicType");
        int size = basicTypeIDs.length;
        String nameList = this.getUIContext().get("NameList").toString();
        String numberList = this.getUIContext().get("NumberList").toString();
        String fid = ".FID";
        String fname = ".FName_" + SysContext.getSysContext().getLocale();
        String fnumber = ".FNumber";
        String strjoin = " || '" + AsstAttrSeparator.get() + "' ||";
        String typeid = ".FBasictypeID=";
        String table = " T_BD_AsstAttrValue";
        String alias = " a";
        StringBuffer sb = new StringBuffer();
        sb.append("select * from (");
        sb.append("select 1 as \"SEL\",");
        for (i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(strjoin);
            }
            sb.append(alias + i + fid);
        }
        sb.append(" as \"VID\",");
        for (i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(strjoin);
            }
            sb.append(alias + i + fnumber);
        }
        sb.append(" as \"VNUMBER\",");
        for (i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(strjoin);
            }
            sb.append(alias + i + fname);
        }
        sb.append(" as \"VNAME\"");
        sb.append(" from");
        for (i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(table + alias + i);
        }
        sb.append(" where");
        for (i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(" and");
            }
            sb.append(alias + i + typeid + "'" + basicTypeIDs[i] + "'");
        }
        sb.append(") t");
        if (nameList.trim().length() != 0 && numberList.trim().length() != 0) {
            sb.append(" where t.\"VNAME\" not in (" + nameList + ") and t.\"VNUMBER\" not in (" + numberList + ")");
        }
        sb.append(" order by t.\"VNUMBER\" asc");
        return sb.toString();
    }

    private void onAfterDataFillForTable() {
    }

    private void onDataRequestForTable(KDTDataRequestEvent e) {
        int start = e.getFirstRow();
        int length = e.getLastRow() - start + 1;
        String sql = this.getSQL();
        try {
            IAsstAttrCompondingTypeValueGetter valueGetter = AsstAttrCompondingTypeValueGetterFactory.getRemoteInstance();
            RptRowSet rst = valueGetter.getResultSetTable(sql, start, length);
            if (rst != null && rst.getVirtualRowCount() != 0) {
                this.kDTable1.setRowCount(rst.getVirtualRowCount());
                Object[][] array = rst.toArray();
                this.restoreSelection(array);
                KDTableUtil.insertRows((Object[][])array, null, (int)start, (KDTable)this.kDTable1);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"EXCEPTION", (Throwable)ex);
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    private void restoreSelection(Object[][] array) {
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            array[i][0] = new Boolean(false);
            if (!this.arrayContains(array[i][1].toString())) continue;
            array[i][0] = new Boolean(true);
        }
    }

    private boolean arrayContains(String sid) {
        if (this.selValues == null || this.selValues.size() <= 0) {
            return false;
        }
        for (int i = 0; i < this.selValues.size(); ++i) {
            String[] ids = (String[])this.selValues.get(i);
            if (!ids[0].equals(sid)) continue;
            return true;
        }
        return false;
    }

    private void onEditValueChangedForTable(KDTEditEvent e) {
        if (e.getColIndex() == 0) {
            int rowIndex = e.getRowIndex();
            boolean isSelected = (Boolean)e.getValue();
            String id = this.kDTable1.getRow(rowIndex).getCell("VID").getValue().toString().trim();
            String number = this.kDTable1.getRow(rowIndex).getCell("VNUMBER").getValue().toString().trim();
            String name = this.kDTable1.getRow(rowIndex).getCell("VNAME").getValue().toString().trim();
            String[] idAndnumberAndname = new String[]{id, number, name};
            if (isSelected) {
                this.selValues.add(idAndnumberAndname);
            } else {
                this.selValues.remove(idAndnumberAndname);
            }
        }
    }

    private void onClickForBtnOK() {
        if (this.selValues.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)AsstAttrResrc.get("AlertWhenClickOK"));
            return;
        }
        this.isConfirmed = true;
        this.disposeUIWindow();
    }

    private void onClickForBtnCancel() {
        this.disposeUIWindow();
    }

    public boolean isConfirmed() {
        return this.isConfirmed;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }
}

