/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.master.material.AsstAttrException;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMaterialAsstAttrValue;
import com.kingdee.eas.basedata.master.material.MaterialAsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.MaterialAsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.MaterialAsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.client.AbstractMaterialAsstAttrValueEditUI;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class MaterialAsstAttrValueEditUI
extends AbstractMaterialAsstAttrValueEditUI {
    private static String RES = "com.kingdee.eas.basedata.master.material.MaterialResource";
    private static final String TB_VALUE_NAME = "valueName";
    private static final String TB_SEQ = "seq";
    private static final String TB_ID = "id";
    private static final String TB_VALUE_NUMBER = "value";
    private static final String MATERIAL_INFO = "materialInfo";
    private static final String EDITABLE = "editable";
    private static final Logger logger = CoreUIObject.getLogger(MaterialAsstAttrValueEditUI.class);
    private MaterialInfo materialInfo = null;
    private CtrlUnitInfo curCtrlUnitInfo = null;

    public static void showUI(Object owner, MaterialInfo materialInfo, boolean editAbel, UIContext uiCtx) throws UIException {
        String uiName = MaterialAsstAttrValueEditUI.class.getName();
        String uiMode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        IUIFactory uif = UIFactory.createUIFactory((String)uiMode);
        IUIWindow ui = uif.create(uiName, (Map)uiCtx);
        ui.show();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get("cu");
        this.tabDetail.checkParsed();
        this.materialInfo = (MaterialInfo)this.getUIContext().get(MATERIAL_INFO);
        if (this.materialInfo == null || this.materialInfo.getId() == null) {
            this.setUIEditable(false);
            return;
        }
        if (this.materialInfo.getAssistAttr() == null) {
            this.setUIEditable(false);
            return;
        }
        this.loadFields(this.materialInfo);
        String asstAttrTypeID = this.materialInfo.getAssistAttr().getId().toString();
        IColumn columnF7 = this.tabDetail.getColumn(TB_VALUE_NUMBER);
        columnF7.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.getAsstAttrValueF7(asstAttrTypeID, this.materialInfo.getId().toString())));
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        columnF7.setRenderer((IBasicRender)avr);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddRow.setToolTipText(this.resHelper.getString("btnAddRow.text"));
        this.btnInsertRow.setToolTipText(this.resHelper.getString("btnInsertRow.text"));
        this.btnDeleteRow.setToolTipText(this.resHelper.getString("btnDeleteRow.text"));
        this.btnSave.setToolTipText(this.resHelper.getString("btnSave.text"));
        Boolean editable = (Boolean)this.getUIContext().get(EDITABLE);
        this.setUIEditable(editable != null && editable != false);
    }

    private void setUIEditable(boolean editable) {
        this.tabDetail.setEditable(editable);
        this.btnAddRow.setEnabled(editable);
        this.btnInsertRow.setEnabled(editable);
        this.btnDeleteRow.setEnabled(editable);
        this.btnSave.setEnabled(editable);
    }

    private void loadFields(MaterialInfo materialInfo) {
        try {
            this.txtMaterialName.setText(materialInfo.getName());
            this.txtMaterialNumber.setText(materialInfo.getNumber());
            String materialId = materialInfo.getId().toString();
            MaterialAsstAttrValueCollection collection = this.getValueCollectionByMaterialID(materialId);
            this.tabDetail.removeRows();
            for (int i = 0; i < collection.size(); ++i) {
                MaterialAsstAttrValueInfo valueInfo = collection.get(i);
                IRow iRow = this.tabDetail.addRow(i);
                this.fillDataToTable(iRow, valueInfo);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private MaterialAsstAttrValueCollection getValueCollectionByMaterialID(String materialId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        evi.setFilter(filterInfo);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("value.id"));
        sic.add(new SelectorItemInfo("value.number"));
        sic.add(new SelectorItemInfo("value.name"));
        IMaterialAsstAttrValue iMaterialAsstAttrValue = MaterialAsstAttrValueFactory.getRemoteInstance();
        return iMaterialAsstAttrValue.getMaterialAsstAttrValueCollection(evi);
    }

    private void fillDataToTable(IRow row, MaterialAsstAttrValueInfo materialValueInfo) {
        row.setUserObject((Object)materialValueInfo);
        row.getCell(TB_VALUE_NUMBER).setValue((Object)materialValueInfo.getValue());
        row.getCell(TB_VALUE_NAME).setValue((Object)materialValueInfo.getValue().getName());
    }

    private KDBizPromptBox getAsstAttrValueF7(String asstAttrTypeID, String materialID) {
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        bizPromptBox.setEditable(true);
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setDisplayFormat("$number$");
        bizPromptBox.setCommitFormat("$number$");
        bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7AsstAttrValueQuery");
        EntityViewInfo evi = this.getValueEntityView(asstAttrTypeID, materialID);
        bizPromptBox.setEntityViewInfo(evi);
        bizPromptBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                MaterialAsstAttrValueEditUI.this.attrValueChanged(eventObj);
            }
        });
        return bizPromptBox;
    }

    private EntityViewInfo getValueEntityView(String asstAttrTypeID, String materialID) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        int iRowCount = this.tabDetail.getRowCount();
        filterInfo.getFilterItems().add(new FilterItemInfo("basictype.id", (Object)asstAttrTypeID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("compondingtype.id", (Object)asstAttrTypeID, CompareType.EQUALS));
        String subSql = "select FAsstAttrValueID from T_BD_MaterialAsstAttrValue where FMaterialID ='" + materialID + "'";
        filterInfo.getFilterItems().add(new FilterItemInfo("ASSTATTRVALUE.id", (Object)subSql, CompareType.NOTINNER));
        if (iRowCount == 0) {
            filterInfo.setMaskString("#0 or #1");
        } else {
            filterInfo.setMaskString("(#0 or #1) and #2");
        }
        evi.setFilter(filterInfo);
        return evi;
    }

    private void attrValueChanged(DataChangeEvent eventObj) {
        Object newValue = eventObj.getNewValue();
        if (newValue instanceof AsstAttrValueInfo) {
            AsstAttrValueInfo valueInfo = (AsstAttrValueInfo)newValue;
            int rowIndex = this.tabDetail.getEditManager().getEditRowIndex();
            this.tabDetail.getCell(rowIndex, TB_VALUE_NUMBER).setUserObject((Object)valueInfo);
            this.tabDetail.getCell(rowIndex, TB_VALUE_NAME).setValue((Object)valueInfo.getName());
        }
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddRow_actionPerformed(e);
        this.addRow(this.tabDetail, -1);
    }

    private void addRow(KDTable kdtDetail, int pos) {
        MaterialAsstAttrValueInfo materialValueInfo = new MaterialAsstAttrValueInfo();
        materialValueInfo.setMaterial(this.materialInfo);
        IRow row = pos < 0 ? kdtDetail.addRow() : kdtDetail.addRow(pos);
        row.setUserObject((Object)materialValueInfo);
    }

    @Override
    public void actionInsertRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertRow_actionPerformed(e);
        int indexRow = -1;
        if (this.tabDetail.getSelectManager() != null && this.tabDetail.getSelectManager().get() != null) {
            indexRow = this.tabDetail.getSelectManager().get().getBeginRow();
        }
        this.addRow(this.tabDetail, indexRow);
    }

    @Override
    public void actionDeleteRow_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteRow_actionPerformed(e);
        if (this.tabDetail.getSelectManager() == null || this.tabDetail.getSelectManager().get() == null) {
            return;
        }
        int iBeginRow = this.tabDetail.getSelectManager().get().getBeginRow();
        int iEndRow = this.tabDetail.getSelectManager().get().getEndRow();
        if (iBeginRow != -1) {
            for (int i = iEndRow; i > iBeginRow - 1; --i) {
                this.tabDetail.removeRow(i);
            }
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        super.actionSave_actionPerformed(e);
        int iRowCount = this.tabDetail.getRowCount();
        if (iRowCount == 0) {
            IMaterialAsstAttrValue iMaterialAsstAttrValue = MaterialAsstAttrValueFactory.getRemoteInstance();
            iMaterialAsstAttrValue.removeByMaterial(this.materialInfo.getId());
            return;
        }
        MaterialAsstAttrValueCollection collection = new MaterialAsstAttrValueCollection();
        for (int i = 0; i < iRowCount; ++i) {
            IRow iRow = this.tabDetail.getRow(i);
            MaterialAsstAttrValueInfo materialValueInfo = (MaterialAsstAttrValueInfo)iRow.getUserObject();
            Object object = iRow.getCell(TB_VALUE_NUMBER).getValue();
            this.checkValueInfoIsNotNull(object, i + 1);
            AsstAttrValueInfo valueInfo = (AsstAttrValueInfo)object;
            for (int j = i + 1; j < iRowCount; ++j) {
                IRow followRow = this.tabDetail.getRow(j);
                Object followObject = followRow.getCell(TB_VALUE_NUMBER).getValue();
                this.checkValueInfoIsNotNull(followObject, j + 1);
                AsstAttrValueInfo followValueInfo = (AsstAttrValueInfo)followObject;
                if (!valueInfo.getId().equals((Object)followValueInfo.getId())) continue;
                String tempMsg = new AsstAttrException(AsstAttrException.VALUE_EXSISTS).getMessage();
                MsgBox.showInfo((Component)((Object)this), (String)this.getRowMsg(j + 1).append(",").append(tempMsg).toString());
                SysUtil.abort();
            }
            materialValueInfo.setValue(valueInfo);
            materialValueInfo.setSeq(i + 1);
            collection.add(materialValueInfo);
        }
        IMaterialAsstAttrValue iMaterialAsstAttrValue = MaterialAsstAttrValueFactory.getRemoteInstance();
        iMaterialAsstAttrValue.saveCollection(collection);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
    }

    private StringBuffer getRowMsg(int rowIndex) {
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)RES, (String)"Multi_No"));
        sb.append(rowIndex);
        sb.append(EASResource.getString((String)RES, (String)"Multi_Row"));
        return sb;
    }

    private void checkValueInfoIsNotNull(Object object, int rowIndex) {
        if (object == null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getRowMsg(rowIndex).append(EASResource.getString((String)RES, (String)"NAME_NOT_NULL")).toString());
            SysUtil.abort();
        }
    }

    protected void verifyInput() throws Exception {
        if (this.isAssignMaterial()) {
            DataBaseDException exception = new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
            MsgBox.showInfo((Component)((Object)this), (String)exception.getMessage());
            SysUtil.abort();
        } else if (this.materialInfo.getStatus().equals((Object)UsedStatusEnum.APPROVED)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"CannotEditIFApprovedMaterial"));
            SysUtil.abort();
        }
    }

    private boolean isAssignMaterial() {
        return this.materialInfo.getCU() != null && !this.materialInfo.getCU().getId().toString().equals(this.curCtrlUnitInfo.getId().toString());
    }
}

