/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.client.F7MeasureUnitTreeDetailListUI;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.framework.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.IMaterialPropertyBase;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPropertyBaseInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.PageEnum;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.org.client.f7.NewCtrlF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.org.client.f7.NewProfitCenterF7;
import com.kingdee.eas.basedata.org.client.f7.NewPurchaseF7;
import com.kingdee.eas.basedata.org.client.f7.NewSaleF7;
import com.kingdee.eas.basedata.org.client.f7.NewStorageF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.TabEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class MaterialClientTools {
    public static final String ASSISTANT_RESOURCE = "com.kingdee.eas.basedata.master.material.MaterialResource";
    public static final String UI_TITLE_SEPRATOR = " - ";
    public static final String ADDNEW = "addnew";
    public static final String EDIT = "edit";
    public static final String VIEW = "view";
    public static final String MATERIAL = "material";
    public static final String MATERIALCLASS = "materialgroup";
    public static final String MATERIALTYPE = "materialtype";
    public static final BigDecimal MAXVAL_BigDecimal = new BigDecimal("9999999999999.99999");
    public static final int HALF_UP = 4;
    public static final BigDecimal BigDecimal_0 = new BigDecimal("0");
    public static final BigDecimal ZERO_BigDecimal = new BigDecimal("0.00");
    public static final BigDecimal MINVAL_BigDecimal = new BigDecimal("-9999999999999.99999");
    public static final BigDecimal MAXVAL_INT = new BigDecimal("9999999999");
    public static final Integer HUNDRED_INT = new Integer("100");
    public static final Integer ZERO_INT = new Integer("0");
    public static final Integer ONE_INT = new Integer("1");
    public static final int PRECISIONDEFAULT = 8;
    private static final String PARENT_CTX = "ParentCtx";
    protected static final String MATERIAL_UI_STATUS = "MATERIAL_UI_STATUS";
    protected static final String MATERIAL_DATA = "MATERIAL_DATA";
    protected static final String PRICE_PRECISION = "PRICE_PRECISION";
    public static final String BASEQTY_PRECISION = "BASEQTY_PRECISION";

    public static void setupUITitle(CoreUIObject ui, String bindedEntityName) {
        if (ui != null) {
            if (ui instanceof EditUI) {
                if (ui.getOprtState().equalsIgnoreCase(OprtState.ADDNEW)) {
                    ui.setUITitle(bindedEntityName + UI_TITLE_SEPRATOR + EASResource.getString((String)ASSISTANT_RESOURCE, (String)ADDNEW));
                } else if (ui.getOprtState().equalsIgnoreCase(OprtState.EDIT)) {
                    ui.setUITitle(bindedEntityName + UI_TITLE_SEPRATOR + EASResource.getString((String)ASSISTANT_RESOURCE, (String)EDIT));
                } else if (ui.getOprtState().equalsIgnoreCase(OprtState.VIEW)) {
                    ui.setUITitle(bindedEntityName + UI_TITLE_SEPRATOR + EASResource.getString((String)ASSISTANT_RESOURCE, (String)VIEW));
                }
            } else {
                ui.setUITitle(bindedEntityName);
            }
        }
    }

    public static void setEnumToCmb(JComboBox cb) {
        DefaultComboBoxModel<PageEnum> model = new DefaultComboBoxModel<PageEnum>();
        Iterator i = PageEnum.iterator();
        while (i.hasNext()) {
            PageEnum e = (PageEnum)((Object)i.next());
            if (e == PageEnum.PAGE_BASE) continue;
            model.addElement(e);
        }
        cb.setModel(model);
    }

    public static void setOrgUnitF7(KDBizPromptBox box, CtrlUnitInfo curCtrlUnit, int page) {
        box.setEnabled(true);
        box.setEditable(true);
        box.setDisplayFormat("$name$");
        box.setEditFormat("$number$");
        box.setCommitFormat("$number$");
        box.setCurrentCtrlUnit(curCtrlUnit);
        NewOrgUnitFilterInfoProducer producer = null;
        switch (page) {
            case 0: {
                NewCtrlF7 cuF7 = new NewCtrlF7();
                cuF7.setCurrentCUID(curCtrlUnit.getId().toString());
                cuF7.setMultiSelect(false);
                cuF7.setIsCUFilter(true);
                producer = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)cuF7);
                box.setFilterInfoProducer((IFilterInfoProducer)producer);
                box.setSelector((KDPromptSelector)cuF7);
                box.setQueryInfo("com.kingdee.eas.basedata.org.app.CUQuery");
                box.setEnabled(false);
                break;
            }
            case 1: 
            case 5: {
                NewCompanyF7 comF7 = new NewCompanyF7();
                comF7.setMultiSelect(false);
                comF7.setIsCUFilter(true);
                comF7.setNeedAddOrgRange(true);
                comF7.setCurrentCUID(curCtrlUnit.getId().toString());
                producer = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)comF7);
                box.setFilterInfoProducer((IFilterInfoProducer)producer);
                box.setSelector((KDPromptSelector)comF7);
                box.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyQuery");
                break;
            }
            case 2: {
                NewPurchaseF7 purOrgF7 = new NewPurchaseF7();
                purOrgF7.setMultiSelect(false);
                purOrgF7.setIsCUFilter(true);
                purOrgF7.setNeedAddOrgRange(false);
                box.setSelector((KDPromptSelector)purOrgF7);
                purOrgF7.setCurrentCUID(curCtrlUnit.getId().toString());
                producer = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)purOrgF7);
                box.setFilterInfoProducer((IFilterInfoProducer)producer);
                box.setQueryInfo("com.kingdee.eas.basedata.org.app.PurchaseOrgUnitQuery");
                break;
            }
            case 3: {
                NewSaleF7 saleOrgF7 = new NewSaleF7();
                saleOrgF7.setMultiSelect(false);
                saleOrgF7.setIsCUFilter(true);
                saleOrgF7.setNeedAddOrgRange(false);
                box.setSelector((KDPromptSelector)saleOrgF7);
                saleOrgF7.setCurrentCUID(curCtrlUnit.getId().toString());
                producer = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)saleOrgF7);
                box.setFilterInfoProducer((IFilterInfoProducer)producer);
                box.setQueryInfo("com.kingdee.eas.basedata.org.app.SaleOrgUnitQuery");
                break;
            }
            case 4: {
                NewStorageF7 invOrgF7 = new NewStorageF7();
                invOrgF7.setMultiSelect(false);
                invOrgF7.setIsCUFilter(true);
                invOrgF7.setNeedAddOrgRange(false);
                box.setSelector((KDPromptSelector)invOrgF7);
                invOrgF7.setCurrentCUID(curCtrlUnit.getId().toString());
                producer = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)invOrgF7);
                box.setFilterInfoProducer((IFilterInfoProducer)producer);
                box.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
                break;
            }
            case 6: {
                NewStorageF7 planOrgF7 = new NewStorageF7();
                planOrgF7.setMultiSelect(false);
                planOrgF7.setIsCUFilter(true);
                planOrgF7.setNeedAddOrgRange(false);
                box.setSelector((KDPromptSelector)planOrgF7);
                planOrgF7.setCurrentCUID(curCtrlUnit.getId().toString());
                producer = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)planOrgF7);
                box.setFilterInfoProducer((IFilterInfoProducer)producer);
                box.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
                break;
            }
            case 7: {
                NewProfitCenterF7 profitOrgF7 = new NewProfitCenterF7();
                profitOrgF7.setMultiSelect(false);
                profitOrgF7.setIsCUFilter(true);
                profitOrgF7.setNeedAddOrgRange(false);
                box.setSelector((KDPromptSelector)profitOrgF7);
                profitOrgF7.setCurrentCUID(curCtrlUnit.getId().toString());
                producer = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)profitOrgF7);
                box.setFilterInfoProducer((IFilterInfoProducer)producer);
                box.setQueryInfo("com.kingdee.eas.basedata.org.app.ProfitCenterOrgUnitQuery");
            }
        }
    }

    public static void setMeasureUnitF7(Component comp, KDBizPromptBox box) {
        GeneralKDPromptSelectorAdaptor selectorLisenterMeasureUnit = null;
        try {
            selectorLisenterMeasureUnit = new GeneralKDPromptSelectorAdaptor((KDPromptBox)box, (Component)new F7MeasureUnitTreeDetailListUI(), (Object)comp, MeasureUnitGroupInfo.getBosType(), "com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery", "measureUnitGroup.id");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        box.setSelector(selectorLisenterMeasureUnit);
        box.addSelectorListener(selectorLisenterMeasureUnit);
    }

    public static void checkIsMaintainCU(DataBaseDInfo dataDaseDInfo, CtrlUnitInfo currentCtrlUnit, Component comp) {
        if (!dataDaseDInfo.getCU().getId().equals((Object)currentCtrlUnit.getId())) {
            MsgBox.showInfo((Component)comp, (String)EASResource.getString((String)ASSISTANT_RESOURCE, (String)"maintainCU_Check"));
            SysUtil.abort();
        }
    }

    public static int getDaysByTimeUnit(int timeUnitIntValue, int value) {
        switch (timeUnitIntValue) {
            case 3: {
                return value;
            }
            case 2: {
                return value * 30;
            }
            case 1: {
                return value * 365;
            }
        }
        return value;
    }

    public static void addCloseButton(KDToolBar toolBar, final EditUI edit) {
        JToolBar.Separator endSeparator = null;
        KDWorkButton btnCloseTab = null;
        endSeparator = new JToolBar.Separator();
        btnCloseTab = new KDWorkButton();
        endSeparator.setOrientation(1);
        btnCloseTab.setIcon(UIFrameResource.getCommonIcon((String)"imgTbtn_quit"));
        btnCloseTab.setText(UIFrameResource.getString((String)"close"));
        btnCloseTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TabEditUI tab = MaterialClientTools.getParentUI(edit);
                    tab.actionExitCurrent_actionPerformed(null);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        toolBar.add((Component)endSeparator);
        toolBar.add((Component)btnCloseTab);
    }

    private static TabEditUI getParentUI(EditUI edit) {
        Container c;
        for (c = edit.getParent(); c != null && !(c instanceof TabEditUI); c = c.getParent()) {
        }
        return (TabEditUI)c;
    }

    public static void SetSpinnerMaxMin(JSpinner spinner, int min, int max) {
        SpinnerModel model = spinner.getModel();
        if (model instanceof SpinnerNumberModel) {
            if (max > min) {
                ((SpinnerNumberModel)model).setMaximum(new Integer(max));
            }
            ((SpinnerNumberModel)model).setMinimum(new Integer(min));
        }
    }

    public static void SetFormatText(KDFormattedTextField txtField, boolean negatived, boolean bEmpty, Comparable max, Comparable min, int precision) {
        txtField.setHorizontalAlignment(4);
        txtField.setNegatived(negatived);
        txtField.setSupportedEmpty(bEmpty);
        txtField.setPrecision(precision);
        txtField.setRemoveingZeroInDispaly(true);
    }

    public static void SetFormatText(KDFormattedTextField txtField) {
        MaterialClientTools.SetFormatText(txtField, false, true, MAXVAL_BigDecimal, ZERO_BigDecimal, 8);
    }

    public static void SetFormatText(KDFormattedTextField txtField, boolean negatived, boolean bEmpty, Comparable max, Comparable min, int precision, Number defaultvalue) {
        txtField.setHorizontalAlignment(4);
        txtField.setNegatived(negatived);
        txtField.setSupportedEmpty(bEmpty);
        txtField.setMaximumValue(max);
        txtField.setMinimumValue(min);
        txtField.setPrecision(precision);
        txtField.setNumberValue(defaultvalue);
        txtField.setRemoveingZeroInDispaly(true);
    }

    public static FilterInfo getFilterOUMaterial(String OUIdFieldName, String OUID, String materialFieldname, String materialID) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(OUIdFieldName, (Object)OUID));
        filter.getFilterItems().add(new FilterItemInfo(materialFieldname, (Object)materialID));
        filter.setMaskString("#0 and #1");
        return filter;
    }

    public static String getParamValue(CompanyOrgUnitInfo aCompanyOrgUnitInfo, String param_2) throws EASBizException, BOSException {
        IParamControl ipc = ParamControlFactory.getRemoteInstance();
        ObjectUuidPK companyPK = new ObjectUuidPK(aCompanyOrgUnitInfo.getId().toString());
        String calType = ipc.getParamValue((IObjectPK)companyPK, param_2, true);
        return calType;
    }

    public static int getQtyPrecisionByUnit(String matid, String munitid) throws BOSException, EASBizException {
        int iReturn = 2;
        IMultiMeasureUnit iMultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        iReturn = iMultiUnit.getQtyPrecision(matid, munitid);
        if (iReturn < 0) {
            iReturn = 2;
        }
        return iReturn;
    }

    public static void setF7MeasureUnit(KDBizPromptBox bizBox, String matid) {
        if (matid != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)matid, CompareType.EQUALS));
            filterInfo.setMaskString("#0");
            viewInfo.setFilter(filterInfo);
            bizBox.setEntityViewInfo(viewInfo);
        }
    }

    public static HashMap getParentCTX(EditUI editUI) {
        return (HashMap)editUI.getUIContext().get(PARENT_CTX);
    }

    public static void loadCalculateTypeEnum(JComboBox cb) {
        DefaultComboBoxModel<CalculateTypeEnum> model = new DefaultComboBoxModel<CalculateTypeEnum>();
        Iterator i = CalculateTypeEnum.iterator();
        while (i.hasNext()) {
            CalculateTypeEnum e = (CalculateTypeEnum)((Object)i.next());
            if (e.getValue() <= -1) continue;
            model.addElement(e);
        }
        cb.setModel(model);
    }

    public static boolean checkBigDecimalIsInt(BigDecimal val) {
        if (val == null) {
            return false;
        }
        if (val.compareTo(new BigDecimal("1.00")) < 0) {
            return false;
        }
        String valStr = val.toString();
        int startPos = valStr.indexOf(46);
        int length = valStr.length();
        if (startPos > 0) {
            for (int i = startPos + 1; i < length; ++i) {
                if (valStr.charAt(i) == '0') continue;
                return false;
            }
        }
        return true;
    }

    public static void checkMaterialFreeze(MaterialInfo material) throws EASBizException {
        if (material != null && material.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_FREEZED);
        }
    }

    public static void doActionOtherProperty(int actionenumvalue, MaterialPropertyBaseInfo info, IMaterialPropertyBase iproperty, IObjectPK pk, MaterialInfo material) throws BOSException, EASBizException {
        MaterialClientTools.doCheckStatusProperty(info, actionenumvalue, material);
        switch (actionenumvalue) {
            case 0: {
                iproperty.approve(pk);
                break;
            }
            case 1: {
                iproperty.unApprove(pk);
                break;
            }
            case 2: {
                iproperty.freeze(pk);
                break;
            }
            case 3: {
                iproperty.unFreeze(pk);
            }
        }
    }

    private static void doCheckStatusProperty(MaterialPropertyBaseInfo info, int actionenumvalue, MaterialInfo material) throws BOSException, EASBizException {
        if (info == null) {
            return;
        }
        if (info.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTSAVE);
        }
        MaterialClientTools.checkMaterialFreeze(material);
        switch (actionenumvalue) {
            case 0: {
                if (material.getStatus() == UsedStatusEnum.UNAPPROVE) {
                    throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTAPPROVE);
                }
                if (info.getStatus() == UsedStatusEnum.APPROVED) {
                    throw new MaterialBaseException(MaterialBaseException.BASEINFO_APPROVED);
                }
                if (info.getStatus() != UsedStatusEnum.FREEZED) break;
                throw new MaterialBaseException(MaterialBaseException.BASEINFO_FREEZED);
            }
            case 1: {
                if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
                    throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTAPPROVE);
                }
                if (info.getStatus() != UsedStatusEnum.FREEZED) break;
                throw new MaterialBaseException(MaterialBaseException.BASEINFO_FREEZED);
            }
            case 2: {
                if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
                    throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTAPPROVE);
                }
                if (info.getStatus() != UsedStatusEnum.FREEZED) break;
                throw new MaterialBaseException(MaterialBaseException.BASEINFO_FREEZED);
            }
            case 3: {
                if (info.getStatus() == UsedStatusEnum.UNAPPROVE) {
                    throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTAPPROVE);
                }
                if (info.getStatus() != UsedStatusEnum.APPROVED) break;
                throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTFREEZED);
            }
        }
    }

    public static void showError(String error) {
        if (error != null && error.length() > 0) {
            MsgBox.showInfo((String)error);
            SysUtil.abort();
        }
    }

    public static void checkIsOUSealUp(String ouID, BOSObjectType type) throws Exception {
        int orgTypeValue = 0;
        orgTypeValue = FrameWorkUtils.getOrgTypeExtendedPropertyies(null, (BOSObjectType)type);
        if (orgTypeValue < 0) {
            return;
        }
        NewOrgUnitFacadeFactory.getRemoteInstance().checkIsOUSealUp(ouID, orgTypeValue);
    }

    public static void setFromWarehouseFilter(KDBizPromptBox prmtFromInvOrgID, KDBizPromptBox prmtFromWarehouseID) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Object object = prmtFromInvOrgID.getValue();
        if (object != null) {
            OrgUnitInfo orgUnit = (OrgUnitInfo)object;
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgUnit.getId().toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)""));
        }
        viewInfo.setFilter(filter);
        prmtFromWarehouseID.setEntityViewInfo(viewInfo);
    }
}

