/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.client.KAClassficationUtil;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialUtil;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.client.AbstractMaterialCompanyInfoUI;
import com.kingdee.eas.basedata.master.material.client.MaterialClientTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.client.mutex.IVOChangeListener;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MaterialCompanyInfoUI
extends AbstractMaterialCompanyInfoUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialCompanyInfoUI.class);
    private static final String objectTypeID = "7ac99937-00fb-1000-e000-0002c0a81345B999CA39";
    private HashMap parentCTX = null;
    private String materialID = null;
    EventsListener event = null;
    private MaterialInfo material = null;
    CompanyOrgUnitInfo company = null;
    private int pricePrecision = 2;
    private boolean tag = false;
    private CtrlUnitInfo curCtrlUnitInfo;
    private ItemListener calculateTypeListener = null;
    private ItemListener accountTypeListener = null;
    private StringBuffer sb_calculateLat = new StringBuffer("");
    private List s_calculateLat = new ArrayList();
    private List i_calculateLat = new ArrayList();
    private boolean isSPECIAL_ACCT = false;
    String defaultAccountType = null;

    public MaterialCompanyInfoUI() throws Exception {
        this.initArrayList();
        this.event = new EventsListener();
        this.company = SysContext.getSysContext().getCurrentFIUnit();
        this.cbCreateCOByOrder.setEnabled(false);
        this.calculateTypeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (MaterialCompanyInfoUI.this.cbCreateCOByOrder.isSelected()) {
                        MaterialCompanyInfoUI.this.comboCalculateType.removeItemListener(MaterialCompanyInfoUI.this.calculateTypeListener);
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"CbCreateCOByOrder_NotChangeCalType"));
                        MaterialCompanyInfoUI.this.comboCalculateType.setSelectedIndex(2);
                        MaterialCompanyInfoUI.this.comboCalculateType.addItemListener(MaterialCompanyInfoUI.this.calculateTypeListener);
                        return;
                    }
                    MaterialCompanyInfoUI.this.initCbCreateCOByOrder();
                }
            }
        };
        this.comboCalculateType.addItemListener(this.calculateTypeListener);
        this.accountTypeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    MaterialCompanyInfoUI.this.accountType_itemStateChanged();
                }
            }
        };
        this.comboAccountType.addItemListener(this.accountTypeListener);
    }

    protected void accountType_itemStateChanged() {
        if ("VIEW".equals(this.getOprtState())) {
            return;
        }
        if (AccountType.SPECIAL_ACCT.equals(this.comboAccountType.getSelectedItem())) {
            this.cbIsLot.setEnabled(true);
            if (this.isSPECIAL_ACCT && (this.editData.getId() == null || this.editData.getAccountType() != (AccountType)((Object)this.comboAccountType.getSelectedItem()))) {
                this.txtCalculateLat.setText("");
                this.cbIsLot.setSelected(true);
                this.i_calculateLat.set(0, new Integer(1));
                this.setCalculateLatValue();
            } else if (this.isSPECIAL_ACCT) {
                this.cbIsLot.setSelected(this.editData.isIsLot());
                this.cbIsAssistProperty.setSelected(this.editData.isIsAssistProperty());
                this.cbIsProject.setSelected(this.editData.isIsProject());
                this.cbIsTrackNumber.setSelected(this.editData.isIsTrackNumber());
                for (int i = 0; i < this.i_calculateLat.size(); ++i) {
                    this.i_calculateLat.set(i, new Integer(0));
                }
                if (this.cbIsLot.isSelected()) {
                    this.i_calculateLat.set(0, new Integer(1));
                }
                if (this.cbIsAssistProperty.isSelected()) {
                    this.i_calculateLat.set(1, new Integer(1));
                }
                if (this.cbIsProject.isSelected()) {
                    this.i_calculateLat.set(2, new Integer(1));
                }
                if (this.cbIsTrackNumber.isSelected()) {
                    this.i_calculateLat.set(3, new Integer(1));
                }
                this.setCalculateLatValue();
            }
            this.cbIsAssistProperty.setEnabled(true);
            this.cbIsProject.setEnabled(true);
            this.cbIsTrackNumber.setEnabled(true);
        } else {
            this.txtCalculateLat.setText("");
            this.cbIsLot.setEnabled(false);
            this.cbIsLot.setSelected(false);
            this.i_calculateLat.set(0, new Integer(0));
            this.cbIsAssistProperty.setEnabled(false);
            this.cbIsAssistProperty.setSelected(false);
            this.i_calculateLat.set(1, new Integer(0));
            this.cbIsProject.setEnabled(false);
            this.cbIsProject.setSelected(false);
            this.i_calculateLat.set(2, new Integer(0));
            this.cbIsTrackNumber.setEnabled(false);
            this.cbIsTrackNumber.setSelected(false);
            this.i_calculateLat.set(3, new Integer(0));
        }
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        MaterialClientTools.addCloseButton(this.toolBar, this);
    }

    @Override
    public void loadFields() {
        this.removeEventsListerner();
        this.isSPECIAL_ACCT = false;
        if (this.editData != null) {
            CompanyOrgUnitInfo company = this.editData.getCompany();
            if (company != null) {
                try {
                    this.loadAccountTypeEnum(this.comboAccountType, company);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            } else {
                this.comboAccountType.removeAllItems();
            }
        }
        super.loadFields();
        this.addEventsListener();
        this.setSubmitSaveButton();
        for (int i = 0; i < this.i_calculateLat.size(); ++i) {
            this.i_calculateLat.set(i, new Integer(0));
        }
        if (this.cbIsLot.isSelected()) {
            this.i_calculateLat.set(0, new Integer(1));
        }
        if (this.cbIsAssistProperty.isSelected()) {
            this.i_calculateLat.set(1, new Integer(1));
        }
        if (this.cbIsProject.isSelected()) {
            this.i_calculateLat.set(2, new Integer(1));
        }
        if (this.cbIsTrackNumber.isSelected()) {
            this.i_calculateLat.set(3, new Integer(1));
        }
        this.setCalculateLatValue();
        this.isSPECIAL_ACCT = true;
        this.accountType_itemStateChanged();
        this.initCbCreateCOByOrder();
    }

    private void addEventsListener() {
        this.comboCalculateType.addItemListener(this.calculateTypeListener);
        this.comboAccountType.addItemListener(this.accountTypeListener);
        this.prmtCompany.addChangeListener((ChangeListener)this.event);
    }

    private void removeEventsListerner() {
        this.comboCalculateType.removeItemListener(this.calculateTypeListener);
        this.comboAccountType.removeItemListener(this.accountTypeListener);
        this.prmtCompany.removeChangeListener((ChangeListener)this.event);
    }

    @Override
    protected IObjectValue createNewData() {
        MaterialCompanyInfoInfo materialCom = new MaterialCompanyInfoInfo();
        materialCom.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        materialCom.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        materialCom.setCalculateType(CalculateTypeEnum.PURCHASE);
        materialCom.setStatus(UsedStatusEnum.UNAPPROVE);
        if (this.materialID != null) {
            materialCom.setMateial(this.material);
        }
        materialCom.setCreateTime(new Timestamp(new Date().getTime()));
        materialCom.setLastUpdateTime(null);
        materialCom.setStandardCost(new BigDecimal(0));
        return materialCom;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MaterialCompanyInfoFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected void initContextOrg() {
        this.initUIMainOrgContext(this.curCtrlUnitInfo.getId().toString());
    }

    private void initDefaultOrgUnit(CtrlUnitInfo curCtrlUnitInfo) throws EASBizException, BOSException {
        if (SysContext.getSysContext().getCurrentFIUnit() != null && SysContext.getSysContext().getCurrentFIUnit().getCU().equalsPK((IObjectValue)curCtrlUnitInfo)) {
            this.company = SysContext.getSysContext().getCurrentFIUnit();
        } else if (curCtrlUnitInfo.isIsCompanyOrgUnit()) {
            this.company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCtrlUnitInfo.getId()));
        }
    }

    public void onLoad() throws Exception {
        this.txtCalculateLat.setEnabled(false);
        this.cbIsLot.setEnabled(false);
        this.cbIsAssistProperty.setEnabled(false);
        this.cbIsProject.setEnabled(false);
        this.cbIsTrackNumber.setEnabled(false);
        if (this.editData == null) {
            this.parentCTX = MaterialClientTools.getParentCTX(this);
            this.curCtrlUnitInfo = (CtrlUnitInfo)this.parentCTX.get("CurrentCtrlUnit");
            if (this.curCtrlUnitInfo == null) {
                this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
            }
            this.initDefaultOrgUnit(this.curCtrlUnitInfo);
            this.getMaterialID();
            this.getDefaultCompanyInfo();
        }
        MaterialClientTools.loadCalculateTypeEnum((JComboBox)this.comboCalculateType);
        this.btnApprove.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnApprove.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.pkCreateTime.setSupportedEmpty(true);
        this.pkLastUpdateTime.setSupportedEmpty(true);
        this.setPrintEnable();
        super.onLoad();
        if ("EDIT".equals(this.getOprtState()) && CalculateTypeEnum.SELFMANUFACTURE.equals(this.comboCalculateType.getSelectedItem())) {
            this.cbCreateCOByOrder.setEnabled(true);
        }
        KAClassficationUtil.setupKACLlassficationF7ByCompany((KDBizPromptBox)this.prmtKAClass, (int)1, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)this.prmtCompany.getValue()));
        this.doInit();
        this.prmtCompany.setEnabled(true);
        this.prmtCompany.setAccessAuthority(0);
        String format = CtrlFormatUtilities.getDateFormatString();
        this.pkCreateTime.setDatePattern(format);
        this.pkLastUpdateTime.setDatePattern(format);
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    public void doInit() throws Exception {
        NewCompanyF7 fiF7 = new NewCompanyF7();
        fiF7.setIsCUFilter(true);
        fiF7.setCurrentCUID(this.curCtrlUnitInfo.getId().toString());
        fiF7.setNeedConsiderFaultTree(true);
        this.prmtCompany.setSelector((KDPromptSelector)fiF7);
        NewOrgUnitFilterInfoProducer producer = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)fiF7);
        this.prmtCompany.setFilterInfoProducer((IFilterInfoProducer)producer);
        FilterInfo filterinfo = new FilterInfo();
        filterinfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.curCtrlUnitInfo.getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterinfo);
        this.prmtCompany.setEntityViewInfo(viewInfo);
        this.prmtCompany.setCurrentCtrlUnit(this.curCtrlUnitInfo);
        this.prmtCompany.setHandleCUFilter(false);
        MaterialClientTools.SetFormatText(this.txtStandardCost, false, true, MaterialClientTools.MAXVAL_BigDecimal, MaterialClientTools.MINVAL_BigDecimal, this.pricePrecision);
        this.btnCopy.setVisible(false);
        this.actionCopy.setEnabled(false);
        this.menuItemCopy.setVisible(false);
        this.btnSave.setVisible(false);
        this.menuItemSave.setVisible(false);
        this.actionSave.setEnabled(false);
        this.checkCostObjectIsReferenced();
    }

    private void checkCostObjectIsReferenced() throws EASBizException, BOSException {
        boolean isEnable = true;
        if (this.getOprtState().equals(OprtState.EDIT)) {
            // empty if block
        }
        this.comboCalculateType.setEnabled(isEnable);
        this.comboAccountType.setEnabled(isEnable);
    }

    private void getMaterialID() {
        if (this.parentCTX == null) {
            MaterialClientTools.getParentCTX(this);
        }
        if (this.parentCTX != null) {
            this.material = (MaterialInfo)this.parentCTX.get("MATERIAL_DATA");
            this.materialID = this.material.getId().toString();
            this.parentCTX.put("ID", this.materialID);
            String t = (String)this.parentCTX.get("PRICE_PRECISION");
            if (t != null && t.length() > 0) {
                this.pricePrecision = Integer.parseInt(t);
            }
        }
    }

    private void getDefaultCompanyInfo() throws EASBizException, BOSException {
        if (this.materialID != null) {
            MaterialCompanyInfoInfo comInfo = null;
            MaterialCompanyInfoCollection colls = null;
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)this.materialID));
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.curCtrlUnitInfo.getId().toString()));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("company.id"));
            colls = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoCollection(viewInfo);
            if (this.company != null && this.company.getId() != null) {
                comInfo = this.getMCInfoByFilter(MaterialClientTools.getFilterOUMaterial("company.id", this.company.getId().toString(), "mateial.id", this.materialID));
            }
            if (colls != null) {
                RealModeIDList idLists = new RealModeIDList();
                int currentPKIndex = -1;
                for (int i = 0; i < colls.size(); ++i) {
                    MaterialCompanyInfoInfo info = colls.get(i);
                    idLists.add(i, info.getId().toString());
                    if (comInfo == null || !info.getCompany().getId().toString().equals(comInfo.getCompany().getId().toString())) continue;
                    currentPKIndex = i;
                    this.getUIContext().put("ID", comInfo.getId().toString());
                    this.tag = false;
                }
                if (currentPKIndex == -1 && idLists != null && idLists.size() != 0) {
                    currentPKIndex = 0;
                }
                idLists.setCurrentIndex(currentPKIndex);
                this.getUIContext().put("IDList", idLists);
            }
            if (comInfo == null) {
                comInfo = (MaterialCompanyInfoInfo)this.createNewData();
            }
            this.getUIContext().put("InitDataObject", comInfo);
        }
    }

    private MaterialCompanyInfoInfo getMCInfoByFilter(FilterInfo filterinfo) throws BOSException, EASBizException {
        MaterialCompanyInfoInfo info = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterinfo);
        SelectorItemCollection selectors = viewInfo.getSelector();
        Iterator t = this.getMergedSelector().iterator();
        while (t.hasNext()) {
            selectors.add((SelectorItemInfo)t.next());
        }
        MaterialCompanyInfoCollection con = MaterialCompanyInfoFactory.getRemoteInstance().getMaterialCompanyInfoCollection(viewInfo);
        if (con != null && con.size() >= 1) {
            info = con.get(0);
        }
        return info;
    }

    @Override
    public void setOprtState(String oprtType) {
        if (!oprtType.equalsIgnoreCase(this.getOprtState())) {
            super.setOprtState(oprtType);
            if (this.parentCTX != null && !oprtType.equalsIgnoreCase("ADDNEW")) {
                this.parentCTX.put("MATERIAL_UI_STATUS", oprtType);
            }
        }
    }

    protected void prmtCompany_stateChanged(ChangeEvent e) throws Exception {
        CompanyOrgUnitInfo comInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        MaterialCompanyInfoInfo info = null;
        if (comInfo != null) {
            this.loadAccountTypeEnum(this.comboAccountType, comInfo);
            info = this.getMCInfoByFilter(MaterialClientTools.getFilterOUMaterial("company.id", comInfo.getId().toString(), "mateial.id", this.materialID));
            this.tag = false;
        }
        if (info == null) {
            info = (MaterialCompanyInfoInfo)this.createNewData();
            if (comInfo != null) {
                info.setCompany(comInfo);
                if (this.defaultAccountType == null) {
                    this.defaultAccountType = MaterialUtil.getParam(null, this.curCtrlUnitInfo.getId().toString(), "defaultAccountType");
                }
                int intDefaultAccountType = 0;
                if (this.defaultAccountType != null) {
                    intDefaultAccountType = Integer.parseInt(this.defaultAccountType);
                }
                info.setAccountType((AccountType)((Object)this.comboAccountType.getItemAt(intDefaultAccountType)));
            } else {
                this.comboAccountType.removeAllItems();
            }
            this.tag = true;
        }
        KAClassficationUtil.setupKACLlassficationF7ByCompany((KDBizPromptBox)this.prmtKAClass, (int)1, (CompanyOrgUnitInfo)comInfo);
        this.setDataObject((IObjectValue)info);
        this.loadFields();
    }

    private void initCbCreateCOByOrder() {
        if (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.ADDNEW)) {
            if (CalculateTypeEnum.SELFMANUFACTURE.equals(this.comboCalculateType.getSelectedItem())) {
                this.cbCreateCOByOrder.setEnabled(true);
            } else {
                this.cbCreateCOByOrder.setSelected(false);
                this.cbCreateCOByOrder.setEnabled(false);
            }
        }
    }

    private void loadAccountTypeEnum(KDComboBox cb, CompanyOrgUnitInfo comOrgInfo) throws EASBizException, BOSException {
        cb.removeAllItems();
        cb.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.basedata.master.material.AccountType").toArray());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = super.getSelectors();
        selectors.add(new SelectorItemInfo("mateial.*"));
        selectors.add("materialId");
        selectors.add("effectedStatus");
        selectors.add("status");
        selectors.add("company.*");
        return selectors;
    }

    public SelectorItemCollection getMergedSelector() {
        SelectorItemCollection selectors = super.getMergedSelector();
        selectors.add(new SelectorItemInfo("mateial.*"));
        selectors.add("materialId");
        selectors.add("effectedStatus");
        selectors.add("status");
        selectors.add("company.*");
        return selectors;
    }

    protected void loadData() throws Exception {
        if (this.parentCTX != null && this.materialID != null && !this.materialID.equalsIgnoreCase(this.parentCTX.get("ID").toString())) {
            this.getMaterialID();
            this.getDefaultCompanyInfo();
        }
        this.getMaterialID();
        if ("EDIT".equalsIgnoreCase(this.getOprtState()) || "ADDNEW".equalsIgnoreCase(this.getOprtState())) {
            this.unLockUI();
        } else if ("VIEW".equalsIgnoreCase(this.getOprtState())) {
            this.lockUIForViewStatus();
        }
        super.loadData();
        if (this.editData.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            CoreBaseInfo info = this.getBizInterface().getValue((IObjectPK)pk, this.getMergedSelector());
            this.setDataObject((IObjectValue)info);
            this.loadFields();
        }
        this.tag = false;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (!(this.editData.isIsAssistProperty() == this.cbIsAssistProperty.isSelected() && this.editData.isIsLot() == this.cbIsLot.isSelected() && this.editData.isIsProject() == this.cbIsProject.isSelected() && this.editData.isIsTrackNumber() == this.cbIsTrackNumber.isSelected() || this.canChangeCal())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"CalModelNotChange"));
            return;
        }
        super.actionSave_actionPerformed(e);
        if (this.editData != null && this.editData.getId() != null && this.editData.getCompany() != null && this.company != null && this.editData.getCompany().getId().equals((Object)this.company.getId())) {
            this.getUIContext().put("InitDataObject", this.editData);
            this.getUIContext().put("ID", this.editData.getId());
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (!(this.editData.isIsAssistProperty() == this.cbIsAssistProperty.isSelected() && this.editData.isIsLot() == this.cbIsLot.isSelected() && this.editData.isIsProject() == this.cbIsProject.isSelected() && this.editData.isIsTrackNumber() == this.cbIsTrackNumber.isSelected() || this.canChangeCal())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"CalModelNotChange"));
            return;
        }
        if (this.editData.getStatus() == UsedStatusEnum.APPROVED) {
            return;
        }
        super.actionSubmit_actionPerformed(e);
        if (this.editData != null && this.editData.getId() != null && this.editData.getCompany() != null && this.company != null && this.editData.getCompany().getId().equals((Object)this.company.getId())) {
            this.getUIContext().put("InitDataObject", this.editData);
            this.getUIContext().put("ID", this.editData.getId());
        }
        this.tag = false;
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.tag) {
            this.loadData();
        } else {
            if (this.getOprtState().equals(OprtState.EDIT) && this.editData != null && this.editData.getCalculateType().equals((Object)CalculateTypeEnum.SELFMANUFACTURE)) {
                FilterInfo filterinfo = new FilterInfo();
                filterinfo.getFilterItems().add(new FilterItemInfo("StdProductID", (Object)this.editData.getMateial().getId().toString()));
                filterinfo.getFilterItems().add(new FilterItemInfo("company", (Object)this.editData.getCompany().getId().toString()));
                EntityViewInfo viewInfo = new EntityViewInfo();
                viewInfo.setFilter(filterinfo);
                CostObjectCollection costColl = null;
                try {
                    costColl = CostObjectFactory.getRemoteInstance().getCostObjectCollection(viewInfo);
                }
                catch (BOSException er) {
                    er.printStackTrace();
                }
                if (costColl != null && costColl.size() > 0) {
                    String strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"materialHasCostObject");
                    MaterialClientTools.showError(strMsg);
                    return;
                }
            }
            super.actionRemove_actionPerformed(e);
        }
        if (this.editData != null && this.editData.getId() == null) {
            this.getUIContext().put("InitDataObject", this.editData);
            this.getUIContext().put("ID", null);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String strMsg = null;
        MaterialClientTools.checkMaterialFreeze(this.material);
        if (this.editData.getCompany() == null) {
            strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"ComOU_NOT_NULL");
            this.prmtCompany.requestFocus();
            MaterialClientTools.showError(strMsg);
        }
        if ((e.getSource().equals(this.btnSubmit) || e.getSource().equals(this.menuItemSubmit)) && AccountType.STANDARDCOST.equals((Object)this.editData.getAccountType()) && (this.editData.getStandardCost() == null || this.editData.getStandardCost().compareTo(MaterialClientTools.ZERO_BigDecimal) <= 0)) {
            strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"STANDARD_NOT_NULL");
            this.txtStandardCost.requestFocus();
            MaterialClientTools.showError(strMsg);
        }
    }

    private void doActionOtherCompany(int actionenumvalue) throws Exception {
        if (this.editData != null && this.editData.getId() != null && !"".equals(this.editData.getId().toString())) {
            IMaterialCompanyInfo imc = (IMaterialCompanyInfo)this.getBizInterface();
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            this.doCheckStatusCompany(actionenumvalue);
            switch (actionenumvalue) {
                case 0: {
                    imc.approve((IObjectPK)pk);
                    break;
                }
                case 1: {
                    imc.unApprove((IObjectPK)pk);
                    break;
                }
                case 2: {
                    imc.freeze((IObjectPK)pk);
                    break;
                }
                case 3: {
                    imc.unFreeze((IObjectPK)pk);
                }
            }
            IObjectValue newData = this.getValue((IObjectPK)pk);
            this.setDataObject(newData);
            this.getUIContext().put("InitDataObject", newData);
            this.loadFields();
            this.setSubmitSaveButton();
        }
    }

    private void doCheckStatusCompany(int actionenumvalue) throws BOSException, EASBizException {
        if (this.editData == null) {
            return;
        }
        if (this.editData.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTSAVE);
        }
        MaterialClientTools.checkMaterialFreeze(this.material);
        switch (actionenumvalue) {
            case 0: {
                if (this.material.getStatus() == UsedStatusEnum.UNAPPROVE) {
                    throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTAPPROVE);
                }
                if (this.editData.getStatus() == UsedStatusEnum.APPROVED) {
                    throw new MaterialBaseException(MaterialBaseException.BASEINFO_APPROVED);
                }
                if (this.editData.getStatus() != UsedStatusEnum.FREEZED) break;
                throw new MaterialBaseException(MaterialBaseException.BASEINFO_FREEZED);
            }
            case 1: {
                if (this.editData.getStatus() == UsedStatusEnum.UNAPPROVE) {
                    throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTAPPROVE);
                }
                if (this.editData.getStatus() != UsedStatusEnum.FREEZED) break;
                throw new MaterialBaseException(MaterialBaseException.BASEINFO_FREEZED);
            }
            case 2: {
                if (this.editData.getStatus() == UsedStatusEnum.UNAPPROVE) {
                    throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTAPPROVE);
                }
                if (this.editData.getStatus() != UsedStatusEnum.FREEZED) break;
                throw new MaterialBaseException(MaterialBaseException.BASEINFO_FREEZED);
            }
            case 3: {
                if (this.editData.getStatus() == UsedStatusEnum.UNAPPROVE) {
                    throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTAPPROVE);
                }
                if (this.editData.getStatus() != UsedStatusEnum.APPROVED) break;
                throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTFREEZED);
            }
        }
    }

    @Override
    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherCompany(0);
    }

    @Override
    public void actionUnApprove_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherCompany(1);
        this.checkCostObjectIsReferenced();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherCompany(2);
    }

    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherCompany(3);
    }

    private void setActionButtonVisible(int vostatus) {
        if (vostatus == 0) {
            this.btnApprove.setEnabled(true);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnApprove.setVisible(true);
            this.btnUnApprove.setVisible(false);
            this.btnCancel.setVisible(false);
            this.menuItemCancel.setVisible(false);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
        } else if (vostatus == 1) {
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(true);
            this.btnCancel.setEnabled(true);
            this.menuItemCancel.setEnabled(true);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnApprove.setVisible(false);
            this.btnUnApprove.setVisible(true);
            this.btnCancel.setVisible(true);
            this.menuItemCancel.setVisible(true);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
        } else {
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(true);
            this.menuItemCancelCancel.setEnabled(true);
            this.btnApprove.setVisible(false);
            this.btnUnApprove.setVisible(false);
            this.btnCancel.setVisible(false);
            this.menuItemCancel.setVisible(false);
            this.btnCancelCancel.setVisible(true);
            this.menuItemCancelCancel.setVisible(true);
        }
    }

    private void setSubmitSaveButton() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnRemove.setEnabled(false);
            if (this.editData != null && this.editData.getId() != null) {
                this.btnRemove.setEnabled(true);
            }
            this.menuItemRemove.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            if (this.editData != null && EffectedStatusEnum.getEnum((int)this.editData.getInt("effectedStatus")) == EffectedStatusEnum.EFFECTED) {
                int vostatus = this.editData.getInt("status");
                this.setActionButtonVisible(vostatus);
            } else {
                this.btnApprove.setVisible(true);
                this.btnUnApprove.setVisible(false);
                this.btnCancel.setVisible(false);
                this.menuItemCancel.setVisible(false);
                this.btnCancelCancel.setVisible(false);
                this.menuItemCancelCancel.setVisible(false);
            }
            return;
        }
        if (this.material != null && this.material.getStatus() == UsedStatusEnum.FREEZED) {
            this.btnAddNew.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.menuItemSubmit.setEnabled(false);
            if (!this.btnRemove.isVisible()) {
                this.menuItemRemove.setEnabled(false);
            }
            this.btnApprove.setEnabled(false);
            this.btnApprove.setVisible(false);
            this.btnUnApprove.setEnabled(false);
            this.btnUnApprove.setVisible(true);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancel.setVisible(true);
            this.menuItemCancel.setVisible(true);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
            return;
        }
        this.btnAddNew.setEnabled(true);
        if (this.editData != null && EffectedStatusEnum.getEnum((int)this.editData.getInt("effectedStatus")) == EffectedStatusEnum.EFFECTED) {
            int vostatus = this.editData.getInt("status");
            if (vostatus == 0) {
                if (this.editData.getId() != null) {
                    this.btnRemove.setEnabled(true);
                    this.menuItemRemove.setEnabled(true);
                } else {
                    this.btnRemove.setEnabled(false);
                    this.menuItemRemove.setEnabled(false);
                }
                this.btnSave.setEnabled(false);
                this.btnSubmit.setEnabled(true);
                this.menuItemSubmit.setEnabled(true);
            } else if (vostatus == 1) {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
                this.btnSave.setEnabled(false);
                this.btnSubmit.setEnabled(false);
                this.menuItemSubmit.setEnabled(false);
                this.btnApprove.setEnabled(false);
                this.btnUnApprove.setEnabled(true);
                this.btnCancel.setEnabled(true);
                this.menuItemCancel.setEnabled(true);
                this.btnCancelCancel.setEnabled(false);
                this.menuItemCancelCancel.setEnabled(false);
            } else {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
                this.btnSave.setEnabled(false);
                this.btnSubmit.setEnabled(false);
                this.menuItemSubmit.setEnabled(false);
                this.btnApprove.setEnabled(false);
                this.btnUnApprove.setEnabled(false);
                this.btnCancel.setEnabled(false);
                this.menuItemCancel.setEnabled(false);
                this.btnCancelCancel.setEnabled(true);
                this.menuItemCancelCancel.setEnabled(true);
            }
            this.setActionButtonVisible(vostatus);
            if (this.material != null && this.material.getStatus() == UsedStatusEnum.UNAPPROVE) {
                this.btnApprove.setEnabled(false);
            }
        } else {
            this.btnSave.setEnabled(true);
            this.btnSubmit.setEnabled(true);
            this.menuItemSubmit.setEnabled(true);
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnApprove.setVisible(true);
            this.btnUnApprove.setVisible(false);
            this.btnCancel.setVisible(false);
            this.menuItemCancel.setVisible(false);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
            } else if (this.editData != null) {
                if (this.editData.getId() != null) {
                    this.btnRemove.setEnabled(true);
                    this.menuItemRemove.setEnabled(true);
                } else {
                    this.btnRemove.setEnabled(false);
                    this.menuItemRemove.setEnabled(false);
                }
            } else {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
            }
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setSubmitSaveButton();
        this.doFieldPermission();
        this.checkCostObjectIsReferenced();
        if (CalculateTypeEnum.SELFMANUFACTURE.equals(this.comboCalculateType.getSelectedItem())) {
            this.cbCreateCOByOrder.setEnabled(true);
        }
        this.accountType_itemStateChanged();
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        for (int j = 0; j < this.i_calculateLat.size(); ++j) {
            this.i_calculateLat.set(j, new Integer(0));
        }
        MaterialClientTools.checkMaterialFreeze(this.material);
        super.actionAddNew_actionPerformed(e);
        this.getUIContext().put("InitDataObject", this.editData);
    }

    private void setPrintEnable(boolean enablead) {
        this.btnPrint.setVisible(enablead);
        this.menuItemPrint.setVisible(enablead);
        this.actionPrint.setEnabled(enablead);
        this.btnPrintPreview.setVisible(enablead);
        this.menuItemPrint.setVisible(enablead);
        this.actionPrintPreview.setEnabled(enablead);
        this.separatorFW2.setVisible(enablead);
        this.kDSeparator3.setVisible(enablead);
    }

    private void setPrintEnable() {
        this.setPrintEnable(false);
    }

    public boolean isModify() {
        ArrayList<String> arr1 = new ArrayList<String>();
        arr1.add(new String("tagState"));
        ArrayList<Boolean> arr2 = new ArrayList<Boolean>();
        Boolean boolTag = new Boolean(this.tag);
        arr2.add(0, boolTag);
        this.getUIContext().put(arr1, arr2);
        if (this.prmtCompany.getValue() != null && this.tag) {
            return true;
        }
        return super.isModify();
    }

    protected void addVOChangeListener(IVOChangeListener listener) {
        super.addVOChangeListener(null);
    }

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (EmptyUtil.isEmpty((String)state)) {
            super.getOnloadPermItemName();
        }
        if (state.equals(OprtState.ADDNEW)) {
            return "bd_materialCom_addNew";
        }
        if (state.equals(OprtState.EDIT)) {
            return "bd_materialCom_update";
        }
        return "bd_materialCom_view";
    }

    protected void setCalculateLatValue() {
        for (int i = 0; i < this.i_calculateLat.size(); ++i) {
            if (!this.i_calculateLat.get(i).toString().equals("1")) continue;
            if (this.sb_calculateLat.toString().equals("")) {
                this.sb_calculateLat.append(this.s_calculateLat.get(i));
                continue;
            }
            this.sb_calculateLat.append("+").append(this.s_calculateLat.get(i));
        }
        this.txtCalculateLat.setText(this.sb_calculateLat.toString());
        this.sb_calculateLat = new StringBuffer("");
    }

    @Override
    protected void cbCreateCOByOrder_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getId() != null && this.editData.getCompany() != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("StdProductID", (Object)this.material.getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.editData.getCompany().getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            CostObjectCollection col = null;
            ICostObject iCostObject = CostObjectFactory.getRemoteInstance();
            try {
                col = iCostObject.getCostObjectCollection(view);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            if (col != null && col.size() > 0) {
                try {
                    iCostObject.delete((IObjectPK)new ObjectUuidPK(col.get(0).getId().toString()));
                }
                catch (ObjectReferedException exc) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"CanNotChangeCbCreateCOByOrder"));
                    this.cbCreateCOByOrder.setSelected(!this.cbCreateCOByOrder.isSelected());
                    SysUtil.abort();
                }
            }
        }
    }

    @Override
    protected void cbIsLot_actionPerformed(ActionEvent e) throws Exception {
        if (this.cbIsLot.isSelected()) {
            this.i_calculateLat.set(0, new Integer(1));
        } else {
            this.i_calculateLat.set(0, new Integer(0));
        }
        this.setCalculateLatValue();
    }

    @Override
    protected void cbIsAssistProperty_actionPerformed(ActionEvent e) throws Exception {
        if (this.cbIsAssistProperty.isSelected()) {
            this.i_calculateLat.set(1, new Integer(1));
        } else {
            this.i_calculateLat.set(1, new Integer(0));
        }
        this.setCalculateLatValue();
    }

    @Override
    protected void cbIsProject_actionPerformed(ActionEvent e) throws Exception {
        if (this.cbIsProject.isSelected()) {
            this.i_calculateLat.set(2, new Integer(1));
        } else {
            this.i_calculateLat.set(2, new Integer(0));
        }
        this.setCalculateLatValue();
    }

    @Override
    protected void cbIsTrackNumber_actionPerformed(ActionEvent e) throws Exception {
        if (this.cbIsTrackNumber.isSelected()) {
            this.i_calculateLat.set(3, new Integer(1));
        } else {
            this.i_calculateLat.set(3, new Integer(0));
        }
        this.setCalculateLatValue();
    }

    public void initArrayList() {
        this.s_calculateLat.add(EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"LOT"));
        this.s_calculateLat.add(EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"ASSISTPROPERTY"));
        this.s_calculateLat.add(EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"PROJECT"));
        this.s_calculateLat.add(EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"TRACKNUMBER"));
        for (int i = 0; i < 4; ++i) {
            this.i_calculateLat.add(new Integer(0));
        }
    }

    protected boolean canChangeCal() throws BOSException {
        boolean canChange = true;
        try {
            Class<?> calModelFacadeFactory = Class.forName("com.kingdee.eas.scm.cal.CalModelFacadeFactory");
            Method m = calModelFacadeFactory.getMethod("getRemoteInstance", null);
            Object o = m.invoke(null, null);
            Class<?> iCalModelFacade = Class.forName("com.kingdee.eas.scm.cal.ICalModelFacade");
            Method m1 = iCalModelFacade.getMethod("canChangeCalModel", String.class, String.class);
            String companyID = null;
            if (this.prmtCompany.getValue() != null) {
                companyID = ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString();
            }
            canChange = (Boolean)m1.invoke(o, companyID, this.materialID);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
            canChange = true;
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e);
            canChange = true;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return canChange;
    }

    public boolean checkBeforeWindowClosing() {
        if (this.editData.getMateial() != null && this.editData.getMateial().getId() != null) {
            MutexServiceControlFactory.getRemoteInstance().releaseObjIDForUpdate(this.editData.getMateial().getId().toString());
        }
        if (this.getTabbedPane() != null && this.getTabbedPane().getSelectedIndex() != 1) {
            return true;
        }
        return super.checkBeforeWindowClosing();
    }

    private KDTabbedPane getTabbedPane() {
        if (this.getParent() == null) {
            return null;
        }
        Container c = this.getParent().getParent();
        if (c != null && c instanceof KDTabbedPane) {
            return (KDTabbedPane)c;
        }
        return null;
    }

    private class EventsListener
    implements ChangeListener {
        private EventsListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            try {
                if (e.getSource().equals(MaterialCompanyInfoUI.this.prmtCompany)) {
                    MaterialCompanyInfoUI.this.prmtCompany_stateChanged(e);
                }
            }
            catch (Exception ex) {
                MaterialCompanyInfoUI.this.handUIException(ex);
            }
        }
    }
}

