/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDImageIcon;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.agent.AgentUtility;
import com.kingdee.bos.framework.agent.IObjectValueAgent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.BOSUIContext;
import com.kingdee.bos.ui.face.BOSUIContextEvent;
import com.kingdee.bos.ui.face.BOSUIContextEventListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfo;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.WorkFlowUtil;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.framework.IDataBaseD;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.cssp.client.CSClientUtils;
import com.kingdee.eas.basedata.master.cssp.client.UserParamterUI;
import com.kingdee.eas.basedata.master.material.AbstractMaterialGroupDetialInfo;
import com.kingdee.eas.basedata.master.material.EquipmentPropertyEnum;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.IMaterialOtherParameter;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupDetialCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupDetialInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialOtherParameterCollection;
import com.kingdee.eas.basedata.master.material.MaterialOtherParameterFactory;
import com.kingdee.eas.basedata.master.material.MaterialOtherParameterInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.client.AbstractMaterialEditUI;
import com.kingdee.eas.basedata.master.material.client.F7BaseSelector;
import com.kingdee.eas.basedata.master.material.client.F7MaterialGroupUI;
import com.kingdee.eas.basedata.master.material.client.MaterialAsstAttrValueEditUI;
import com.kingdee.eas.basedata.master.material.client.MaterialClientTools;
import com.kingdee.eas.basedata.master.material.client.MaterialCompanyInfoUI;
import com.kingdee.eas.basedata.master.material.client.MaterialGroupPromptBox;
import com.kingdee.eas.basedata.master.material.client.PictureFilter;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.framework.client.TabEditUI;
import com.kingdee.eas.mm.basedata.IMaterialTrademark;
import com.kingdee.eas.mm.basedata.MaterialTrademarkFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class MaterialEditUI
extends AbstractMaterialEditUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialEditUI.class);
    private int pricePrecision = 6;
    private int baseqtyPrecision = 2;
    private KDMenuItem menuSaveAll = null;
    private CtrlUnitInfo curCtrlUnitInfo = null;
    private boolean isUsedCodingRule = false;
    private boolean isCodingRuleModifiable = false;
    private boolean isAddNewCodingRule = false;
    private boolean isAddNoBreakCodingRule = false;
    BufferedImage materialImage;
    private String pictureId = "";
    private File pictureFile;
    private boolean isNeedSave = false;
    private SeqUnitDataChangeListener seqListener = null;
    private MaterialGroupStandardCollection materialGroupStandards = null;
    private MaterialGroupStandardInfo materialGroupStandardInfo = null;
    private MaterialOtherParameterCollection materialOtherParameterCollection = null;
    private boolean isMaterialGroupStandardLoaded = false;
    protected MaterialGroupInfo materialBrowseGroup = null;
    private MaterialOtherParameterInfo currentMaterialOtherPara = null;
    private MaterialInfo oldMaterialValue = null;
    private String copyMaterialID = null;
    private String copyMaterialNum = null;
    private String copyMaterialName = null;
    private boolean copyIsAssignMaterial = false;
    private DefaultComboBoxModel comboModel4EquipmentProperty = null;
    private static final String GROUP_TAB_STANDARNAME = "standardName";
    private static final String GROUP_TAB_GROUPNAME = "groupName";
    protected boolean isInOnload = false;
    private Map batchCallResult = new HashMap();
    private Map batchCallParamGroups = new HashMap();
    private static final String EDITABLE = "editable";
    private static final String MATERIAL_INFO = "materialInfo";

    public MaterialEditUI() throws Exception {
        this.seqListener = new SeqUnitDataChangeListener();
    }

    public void initNumberTextFile(boolean falg) {
        this.txtNumber.setEnabled(falg);
        this.mulName.setEnabled(falg);
        this.txtModel.setEnabled(falg);
    }

    public KDTabbedPane[] getKDTabs() {
        KDTabbedPane[] tabs = new KDTabbedPane[]{this.kdTMain};
        return tabs;
    }

    public void registerTabInfo() {
        this.registerTab(this, this.kdTMain, this.registerUI);
    }

    private void registerTab(MaterialEditUI ui, KDTabbedPane kdTMain, ArrayList registerUI) {
        MaterialEditUI materialEditUI = ui;
        ((Object)((Object)materialEditUI)).getClass();
        TabEditUI.TabInfo tabBaseInfo = new TabEditUI.TabInfo((TabEditUI)materialEditUI, kdTMain, 0, false, ((Object)((Object)ui)).getClass());
        MaterialEditUI materialEditUI2 = ui;
        ((Object)((Object)materialEditUI2)).getClass();
        TabEditUI.TabInfo tabCompanyInfo = new TabEditUI.TabInfo((TabEditUI)materialEditUI2, kdTMain, 1, true, MaterialCompanyInfoUI.class);
        try {
            MaterialEditUI materialEditUI3 = ui;
            ((Object)((Object)materialEditUI3)).getClass();
            TabEditUI.TabInfo tabProfitCenterInfo = new TabEditUI.TabInfo((TabEditUI)materialEditUI3, kdTMain, 2, true, Class.forName("com.kingdee.eas.basedata.master.material.client.MaterialProfitCenterInfoUI"));
            MaterialEditUI materialEditUI4 = ui;
            ((Object)((Object)materialEditUI4)).getClass();
            TabEditUI.TabInfo tabPurInfo = new TabEditUI.TabInfo((TabEditUI)materialEditUI4, kdTMain, 3, true, Class.forName("com.kingdee.eas.basedata.master.material.client.MaterialPurchasingUI"));
            MaterialEditUI materialEditUI5 = ui;
            ((Object)((Object)materialEditUI5)).getClass();
            TabEditUI.TabInfo tabSaleInfo = new TabEditUI.TabInfo((TabEditUI)materialEditUI5, kdTMain, 4, true, Class.forName("com.kingdee.eas.basedata.master.material.client.MaterialSalesUI"));
            MaterialEditUI materialEditUI6 = ui;
            ((Object)((Object)materialEditUI6)).getClass();
            TabEditUI.TabInfo tabInvInfo = new TabEditUI.TabInfo((TabEditUI)materialEditUI6, kdTMain, 5, true, Class.forName("com.kingdee.eas.basedata.master.material.client.MaterialInventoryUI"));
            MaterialEditUI materialEditUI7 = ui;
            ((Object)((Object)materialEditUI7)).getClass();
            TabEditUI.TabInfo tabCostInfo = new TabEditUI.TabInfo((TabEditUI)materialEditUI7, kdTMain, 6, true, Class.forName("com.kingdee.eas.basedata.master.material.client.MaterialCostUI"));
            MaterialEditUI materialEditUI8 = ui;
            ((Object)((Object)materialEditUI8)).getClass();
            TabEditUI.TabInfo tabManufactureInfo = new TabEditUI.TabInfo((TabEditUI)materialEditUI8, kdTMain, 7, true, Class.forName("com.kingdee.eas.basedata.master.material.client.MaterialManufactureUI"));
            registerUI.add(tabBaseInfo);
            registerUI.add(tabCompanyInfo);
            registerUI.add(tabProfitCenterInfo);
            registerUI.add(tabPurInfo);
            registerUI.add(tabSaleInfo);
            registerUI.add(tabInvInfo);
            registerUI.add(tabCostInfo);
            registerUI.add(tabManufactureInfo);
        }
        catch (ClassNotFoundException e) {
            this.handleException(e);
        }
    }

    private void showAsOriginaSize() {
        if (this.materialImage != null) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int width = this.materialImage.getWidth();
            int height = this.materialImage.getHeight();
            if (width + 15 > dimension.width) {
                width = dimension.width - 15;
            }
            if (height + 35 > dimension.height) {
                height = dimension.height - 55;
            }
            JLabel picLabel = new JLabel();
            ImageIcon imageIcon = new ImageIcon(this.materialImage);
            picLabel.setIcon(imageIcon);
            JScrollPane picScrollPane = new JScrollPane(picLabel, 20, 30);
            JFrame picFrame = new JFrame();
            picFrame.getContentPane().setLayout(new BorderLayout());
            picFrame.getContentPane().add((Component)picScrollPane, "Center");
            picFrame.setSize(width + 15, height + 35);
            picFrame.show();
        }
    }

    @Override
    protected void labPicShow_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.showAsOriginaSize();
        } else if (e.getButton() == 3) {
            KDPopupMenu popupMenu = this.CreatePopuMenu();
            this.add((Component)popupMenu);
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    protected IObjectValue createNewData() {
        MaterialInfo vo = new MaterialInfo();
        vo.setPricePrecision(-1);
        vo.setMaterialGroup(this.getMaterialParent());
        vo.setEffectedStatus(1);
        vo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        vo.setCreateTime(new Timestamp(new Date().getTime()));
        vo.setCU(this.curCtrlUnitInfo);
        vo.setVersion(0);
        vo.setStatus(UsedStatusEnum.UNAPPROVE);
        vo.setIsWeighted(false);
        vo.setEquipProperty(EquipmentPropertyEnum.DEFAULT);
        return vo;
    }

    protected void initContextOrg() {
        if (this.isInOnload && this.getMainOrgContext() != null) {
            return;
        }
        this.initUIMainOrgContext(this.curCtrlUnitInfo.getId().toString());
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MaterialFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    private void getNumberByRule(IObjectValue caller) {
        if (this.isUsedCodingRule) {
            String number = null;
            if (this.isAddNewCodingRule || this.isAddNoBreakCodingRule) {
                try {
                    number = MaterialFactory.getRemoteInstance().readNewNumber(this.curCtrlUnitInfo.getId().toString(), this.editData);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            this.txtNumber.setEditable(false);
            if (this.isAddNewCodingRule) {
                this.txtNumber.setEnabled(true);
            }
            this.prepareNumber(caller, number);
            if (this.isAddNewCodingRule && this.isCodingRuleModifiable) {
                this.setNumberTextEnabled();
            }
        } else {
            this.setNumberTextEnabled();
        }
    }

    private void doSubmitCheck() throws Exception {
        String strMsg = "";
        if ((this.isUsedCodingRule && this.isAddNewCodingRule || !this.isUsedCodingRule) && (this.txtNumber.getText() == null || "".equals(this.txtNumber.getText()))) {
            strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"NUMBER_NOT_NULL");
            this.txtNumber.requestFocus();
        }
        if (strMsg.equals("") && (this.mulName.getEditor().getItem() == null || "".equals(this.mulName.getEditor().getItem().toString()))) {
            strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"NAME_NOT_NULL");
            this.mulName.requestFocus();
        }
        if (strMsg.equals("") && this.prmtBaseUnit.getData() == null) {
            strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"BASEUNIT_NOT_NULL");
            this.prmtBaseUnit.requestFocus();
        }
        if (strMsg.equals("") && this.txtVolume.getNumberValue() != null && this.txtVolume.getNumberValue().doubleValue() > 0.0 && this.prmtVolumnUnit.getData() == null) {
            strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"VolumeUnit_Not_Null");
            this.prmtVolumnUnit.requestFocus();
        }
        if (strMsg.equals("") && this.txtGrossWeight.getNumberValue() != null && this.txtNetWeight.getNumberValue() != null) {
            BigDecimal bgGross = (BigDecimal)this.txtGrossWeight.getValue(BigDecimal.class);
            BigDecimal bgNet = (BigDecimal)this.txtNetWeight.getValue(BigDecimal.class);
            if (bgNet.compareTo(bgGross) > 0) {
                strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Gross_Net_Compair");
                this.txtNetWeight.requestFocus();
            }
        }
        if (strMsg.isEmpty() && this.mulName.getEditor().getItem() != null && this.mulName.getEditor().getItem().toString().indexOf(";") != -1) {
            strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"SEMICOLONNOTALLOW4C");
        }
        if ((Integer)this.kDPricePrecision.getValue() < this.oldMaterialValue.getPricePrecision() && this.checkReference(this.editData.getId()).booleanValue()) {
            strMsg = new MaterialBaseException(MaterialBaseException.REF_NOT_REDUCE_PRECISION).getMessage();
            MaterialClientTools.SetSpinnerMaxMin((JSpinner)this.kDPricePrecision, this.oldMaterialValue.getPricePrecision(), 8);
        }
        if (!strMsg.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            SysUtil.abort();
        }
    }

    public MaterialGroupInfo getMaterialParent() {
        if (this.materialGroupStandardInfo == null || !this.materialGroupStandardInfo.getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard)) {
            return null;
        }
        MaterialGroupInfo group = (MaterialGroupInfo)this.getUIContext().get("ParentNode");
        if (group != null && !group.isIsLeaf() && !MaterialInfo.isAllowNonLeafGroup()) {
            return null;
        }
        if (group != null && group.getDeletedStatus().equals((Object)DeletedStatusEnum.DELETED)) {
            return null;
        }
        return group;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setString("IsCreateAll", "false");
        this.doSubmit(e);
    }

    public void doSubmit(ActionEvent e) throws Exception {
        this.doSubmitCheck();
        this.AccountVolume();
        String strMsg = this.checkBaseInfoDup();
        if (strMsg != "") {
            if (this.currentMaterialOtherPara.isIsNotSaved()) {
                strMsg = strMsg + EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"CannotSubmit_Dup");
                MsgBox.showError((String)strMsg);
                return;
            }
            if (MsgBox.isYes((int)MsgBox.showConfirm2New((Component)((Object)this), (String)(strMsg + "\r\n" + EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Confirm_Save"))))) {
                super.actionSubmit_actionPerformed(e);
                return;
            }
        } else {
            super.actionSubmit_actionPerformed(e);
        }
        if (this.editData != null && this.editData.getId() != null) {
            this.getUIContext().put("ID", this.editData.getId().toString());
        }
    }

    private String checkBaseInfoDup() throws Exception {
        String txtForeignnameStr;
        String mulNameStr;
        String strMsg = "";
        IMaterial iMat = (IMaterial)this.getBizInterface();
        if (this.currentMaterialOtherPara.isNameSelected() && this.mulName.getEditor().getItem() != null && !"".equals(this.mulName.getEditor().getItem()) && iMat.exists(this.getFilterDup("name", mulNameStr = this.mulName.getEditor().getItem().toString().replaceAll("(^[ |\u3000]*|[ |\u3000]*$)", ""), CompareType.EQUALS))) {
            strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Dup_Name") + "\r\n";
        }
        if (this.currentMaterialOtherPara.isEnglishSelected() && this.txtForeignname.getText() != null && !"".equals(this.txtForeignname.getText()) && iMat.exists(this.getFilterDup("foreignname", txtForeignnameStr = this.txtForeignname.getText().replaceAll("(^[ |\u3000]*|[ |\u3000]*$)", ""), CompareType.EQUALS))) {
            strMsg = strMsg + EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Dup_Foreignname") + "\r\n";
        }
        if (this.currentMaterialOtherPara.isHelpSelected() && this.txtHelpCode.getText() != null && !"".equals(this.txtHelpCode.getText()) && iMat.exists(this.getFilterDup("helpcode", this.txtHelpCode.getText(), CompareType.EQUALS))) {
            strMsg = strMsg + EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Dup_HelpCode") + "\r\n";
        }
        if (this.currentMaterialOtherPara.isBarCodeSelected() && this.txtBarCode.getText() != null && !"".equals(this.txtBarCode.getText()) && iMat.exists(this.getFilterDup("barcode", this.txtBarCode.getText(), CompareType.EQUALS))) {
            strMsg = strMsg + EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Dup_BarCode") + "\r\n";
        }
        if (this.currentMaterialOtherPara.isModeSelected() && this.txtModel.getText() != null && !"".equals(this.txtModel.getText()) && iMat.exists(this.getFilterDup("model", this.txtModel.getText(), CompareType.EQUALS))) {
            strMsg = strMsg + EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Dup_Model") + "\r\n";
        }
        if (this.currentMaterialOtherPara.isMameAndMode() && this.mulName.getEditor().getItem() != null && !"".equals(this.mulName.getEditor().getItem())) {
            FilterInfo filterInfo = new FilterInfo();
            String nameEQStr = this.mulName.getEditor().getItem().toString().replaceAll("(^[ |\u3000]*|[ |\u3000]*$)", "");
            FilterItemInfo filterNameEQ = new FilterItemInfo("name", (Object)nameEQStr, CompareType.EQUALS);
            FilterItemInfo filterIDNotEQ = new FilterItemInfo("id", (Object)this.editData.getId(), CompareType.NOTEQUALS);
            filterInfo.getFilterItems().add(filterIDNotEQ);
            filterInfo.getFilterItems().add(filterNameEQ);
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(3), CompareType.NOTEQUALS));
            FilterItemInfo filterModelEQ = null;
            FilterItemInfo filterModelNull = null;
            FilterItemInfo cuFilterInfo = null;
            if (this.txtModel.getText() != null && !"".equals(this.txtModel.getText())) {
                filterModelEQ = new FilterItemInfo("model", (Object)this.txtModel.getText(), CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterModelEQ);
                if (this.currentMaterialOtherPara.isCuUniqueSelected()) {
                    cuFilterInfo = new FilterItemInfo("cu", (Object)this.curCtrlUnitInfo.getId(), CompareType.EQUALS);
                    filterInfo.getFilterItems().add(cuFilterInfo);
                    filterInfo.setMaskString("#0 and #1 and #2 and #3 and #4)");
                } else {
                    filterInfo.setMaskString("#0 and #1 and #2 and #3)");
                }
            } else {
                filterModelEQ = new FilterItemInfo("model", (Object)"", CompareType.EQUALS);
                filterModelNull = new FilterItemInfo("model", null, CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterModelEQ);
                filterInfo.getFilterItems().add(filterModelNull);
                if (this.currentMaterialOtherPara.isCuUniqueSelected()) {
                    cuFilterInfo = new FilterItemInfo("cu", (Object)this.curCtrlUnitInfo.getId(), CompareType.EQUALS);
                    filterInfo.getFilterItems().add(cuFilterInfo);
                    filterInfo.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5");
                } else {
                    filterInfo.setMaskString("#0 and #1 and #2 and (#3 or #4)");
                }
            }
            if (iMat.exists(filterInfo)) {
                strMsg = strMsg + EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"Dup_Name_And_Model") + "\r\n";
            }
        }
        return strMsg;
    }

    private FilterInfo getFilterDup(String fieldName, Object compareValue, CompareType compareType) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo(fieldName, compareValue, compareType);
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(3), CompareType.NOTEQUALS));
        if (this.editData.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)this.editData.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            if (this.currentMaterialOtherPara.isCuUniqueSelected()) {
                filter = this.setCuFilter(filter);
                filter.setMaskString("#0 and #1 and #2 and #3");
            } else {
                filter.setMaskString("#0 and #1 and #2");
            }
        } else if (this.currentMaterialOtherPara.isCuUniqueSelected()) {
            filter = this.setCuFilter(filter);
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.setMaskString("#0 and #1");
        }
        return filter;
    }

    private FilterInfo setCuFilter(FilterInfo filter) throws BOSException {
        FilterInfo cuFilterInfo = new FilterInfo();
        cuFilterInfo.getFilterItems().add(new FilterItemInfo("cu", (Object)this.curCtrlUnitInfo.getId(), CompareType.EQUALS));
        filter.mergeFilter(cuFilterInfo, "and");
        return filter;
    }

    private void AccountVolume() {
        if (this.prmtVolumnUnit.getData() == null) {
            return;
        }
        BigDecimal bgLength = (BigDecimal)this.txtLength.getValue(BigDecimal.class);
        BigDecimal bgWidth = (BigDecimal)this.txtWidth.getValue(BigDecimal.class);
        BigDecimal bgHeight = (BigDecimal)this.txtHeight.getValue(BigDecimal.class);
        if (bgLength != null && bgWidth != null && bgHeight != null && bgLength.compareTo(new BigDecimal(0)) > 0 && bgWidth.compareTo(new BigDecimal(0)) > 0 && bgHeight.compareTo(new BigDecimal(0)) > 0) {
            BigDecimal bgVolume = bgLength.multiply(bgWidth).multiply(bgHeight);
            if ((bgVolume = bgVolume.setScale(8, 4)).compareTo(new BigDecimal("9999999999")) > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"VolumnOurOfMaxRange"));
                this.txtVolume.setNumberValue((Number)new Integer(0));
            } else {
                this.txtVolume.setNumberValue((Number)bgVolume);
            }
        }
    }

    @Override
    public void loadFields() {
        if (this.materialGroupStandards == null && !this.isMaterialGroupStandardLoaded) {
            this.loadGroupData();
            this.isMaterialGroupStandardLoaded = true;
        }
        if (this.editData != null) {
            this.editData.setString("isMultiCopy", "false");
        }
        this.loadMaterialGroupTable(this.materialGroupStandards, this.editData);
        this.setupKDTable();
        this.removeEventListeners();
        super.loadFields();
        this.addEventListeners();
        this.updateMaterialGroupTable((IObjectValue)this.editData);
        this.setUpTitle();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            MaterialClientTools.SetSpinnerMaxMin((JSpinner)this.kDPricePrecision, 0, 8);
            this.btnCopy.setEnabled(false);
            this.menuItemCopy.setEnabled(false);
            this.multiPageCopy.setEnabled(false);
            this.menuItemMultiPageCopy.setEnabled(false);
            this.btnMultiPageCopy.setEnabled(false);
            this.setFirstFocus();
            if (this.editData.getPricePrecision() != -1) {
                this.pricePrecision = this.editData.getPricePrecision();
            }
            this.editData.setPricePrecision(this.pricePrecision);
            this.kDPricePrecision.setValue((Object)new Integer(this.pricePrecision));
            this.btnSubmitAll.setVisible(true);
            this.setSeqUnitFilter(true);
            if (this.isUsedCodingRule && this.editData != null && this.editData.getNumber() == null) {
                this.getNumberByRule((IObjectValue)this.editData);
                if (this.isAddNewCodingRule || this.isAddNoBreakCodingRule) {
                    this.txtNumber.setText(this.editData.getNumber());
                    this.initOldData((IObjectValue)this.editData);
                }
            } else {
                this.txtNumber.setEnabled(true);
                this.txtNumber.setEditable(true);
                this.initOldData((IObjectValue)this.editData);
            }
        } else {
            MaterialClientTools.SetSpinnerMaxMin((JSpinner)this.kDPricePrecision, 0, 8);
            if (this.editData.getId() != null) {
                this.btnCopy.setEnabled(true);
                this.menuItemCopy.setEnabled(true);
                this.multiPageCopy.setEnabled(true);
                this.menuItemMultiPageCopy.setEnabled(true);
                this.btnMultiPageCopy.setEnabled(true);
                this.initTxtNumber(this.editData);
                this.pricePrecision = this.editData.getPricePrecision();
                String matid = this.editData.getId().toString();
                this.setBasePreInCTX();
                this.setSeqUnitFilter(matid);
            } else {
                this.setSeqUnitFilter("NULL_MATERIAL");
            }
            this.btnSubmitAll.setVisible(false);
        }
        this.getUIContext().put("MATERIAL_DATA", this.editData);
        this.setSubmitSaveButton();
        try {
            this.ClearImage();
            this.getPicture();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.storeFields();
        this.oldMaterialValue = (MaterialInfo)this.editData.clone();
    }

    private void setBasePreInCTX() {
        this.getUIContext().put("PRICE_PRECISION", "" + this.pricePrecision);
        this.getUIContext().put("BASEQTY_PRECISION", "" + this.baseqtyPrecision);
    }

    private void doInit() throws Exception {
        if (this.menuSaveAll == null) {
            this.menuItemSave.setVisible(false);
            this.menuSaveAll = new KDMenuItem();
            this.menuSaveAll.setAction((Action)((Object)this.actionSubmitAll));
            this.menuSaveAll.setText(EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Submit_All"));
            this.menuSaveAll.setEnabled(true);
            this.btnSubmitAll.setEnabled(true);
            this.setPrintEnable();
            this.btnSave.setVisible(false);
            this.menuItemSave.setVisible(false);
            this.actionSave.setEnabled(false);
        }
        ((BOSUIContext)this.getUIContext()).addChangeListener(new BOSUIContextEventListener(){

            public void afterPut(BOSUIContextEvent e) {
                if (e.getKey().toString().equalsIgnoreCase("MATERIAL_UI_STATUS")) {
                    if (!e.getNewValue().equals(e.getOldValue())) {
                        MaterialEditUI.this.setSubUIOprtState(MaterialEditUI.this.kdTMain, e.getNewValue().toString());
                    }
                    if (!e.getNewValue().equals(MaterialEditUI.this.getOprtState())) {
                        MaterialEditUI.this.setOprtState(e.getNewValue().toString());
                        if (e.getNewValue().equals("EDIT")) {
                            try {
                                MaterialEditUI.this.actionEdit_actionPerformed(null);
                            }
                            catch (Exception e1) {
                                MaterialEditUI.this.handUIException(e1);
                            }
                        } else if ("VIEW".equals(e.getNewValue())) {
                            MaterialEditUI.this.initDataStatus();
                            MaterialEditUI.this.setSubmitSaveButton();
                        }
                    }
                }
            }
        });
        this.isUsedCodingRule = this.isMaterialBaseUsedCodingRule();
        this.setBtnIcon();
        MaterialGroupPromptBox groupBox = new MaterialGroupPromptBox((IUIObject)this);
        groupBox.setCurCtrlUnitInfo(this.curCtrlUnitInfo);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard.standardType", (Object)new Integer(1)));
        boolean isAllowNonLeafGroup = false;
        isAllowNonLeafGroup = this.isInOnload ? (Boolean)this.batchCallResult.get("isAllowNonLeafGroup") : MaterialInfo.isAllowNonLeafGroup();
        if (!isAllowNonLeafGroup) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
        }
        view.setFilter(filterInfo);
        this.prmtMaterialGroup.setEntityViewInfo(view);
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"onlyBaseStandard", (Object)Boolean.TRUE);
        ctx.put((Object)"cu", (Object)this.curCtrlUnitInfo);
        F7BaseSelector f7Selector = new F7BaseSelector(F7MaterialGroupUI.class, this.prmtMaterialGroup, ctx);
        this.prmtMaterialGroup.setSelector((KDPromptSelector)f7Selector);
        MaterialClientTools.SetFormatText(this.txtGrossWeight);
        MaterialClientTools.SetFormatText(this.txtNetWeight);
        MaterialClientTools.SetFormatText(this.txtLength);
        MaterialClientTools.SetFormatText(this.txtWidth);
        MaterialClientTools.SetFormatText(this.txtHeight);
        MaterialClientTools.SetFormatText(this.txtVolume);
        MaterialClientTools.setMeasureUnitF7((Component)((Object)this), this.prmtBaseUnit);
        MaterialClientTools.setMeasureUnitF7((Component)((Object)this), this.prmtAssistUnit);
        MaterialClientTools.setMeasureUnitF7((Component)((Object)this), this.prmtWeightUnit);
        MaterialClientTools.setMeasureUnitF7((Component)((Object)this), this.prmtLengthUnit);
        MaterialClientTools.setMeasureUnitF7((Component)((Object)this), this.prmtVolumnUnit);
    }

    private void initTxtNumber(MaterialInfo materialInfo) {
        if (materialInfo != null && materialInfo.getId() != null) {
            boolean isModify = false;
            try {
                if (this.isUsedCodingRule) {
                    if (this.isCodingRuleModifiable) {
                        isModify = true;
                    }
                } else {
                    isModify = true;
                }
                if (isModify) {
                    this.setNumberTextEnabled();
                } else {
                    this.txtNumber.setEnabled(false);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void setUpTitle() {
        MaterialClientTools.setupUITitle((CoreUIObject)this, EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"material"));
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    private void batchCall() throws Exception {
        this.initBatchCallParams();
        if (this.getBizInterface() != null && this.getBizInterface() instanceof IDataBaseD) {
            IDataBaseD idatabased = (IDataBaseD)this.getBizInterface();
            this.batchCallResult = idatabased.onloadBatchCaller("MaterialEditUI", this.batchCallParamGroups);
        }
    }

    protected void initBatchCallParams() throws Exception {
        HashMap<String, String> paramGroup1 = new HashMap<String, String>();
        String materialID = null;
        if (this.getUIContext().get("ID") != null) {
            materialID = this.getUIContext().get("ID").toString();
        }
        paramGroup1.put("materialID", materialID);
        this.batchCallParamGroups.put("paramGroup1", paramGroup1);
    }

    public void onLoad() throws Exception {
        this.isInOnload = true;
        this.loadCtx();
        this.initContextOrg();
        this.getMaterialParam();
        this.batchCall();
        this.doInit();
        this.comboModel4EquipmentProperty = new DefaultComboBoxModel();
        this.comboModel4EquipmentProperty.addElement(EquipmentPropertyEnum.DEFAULT);
        this.comboModel4EquipmentProperty.addElement(EquipmentPropertyEnum.EQUIPMENT);
        this.comboModel4EquipmentProperty.addElement(EquipmentPropertyEnum.SPARE_PART);
        this.comboModel4EquipmentProperty.addElement(EquipmentPropertyEnum.TOOL);
        this.comboEquipProperty.setModel((ComboBoxModel)this.comboModel4EquipmentProperty);
        super.onLoad();
        this.loadInitData();
        this.btnAsstAttrValue.setEnabled(true);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.txtVersion.setValue((Object)new Integer(0));
            this.btnAsstAttrValue.setEnabled(false);
        }
        this.btnPicture.setEnabled(false);
        this.btnPicture.setVisible(false);
        this.activeTabbedPane = this.kdTMain;
        this.kdTMain.setAutoscrolls(true);
        this.activeUI = this;
        this.activeVOInfo = this.editData;
        this.activeTabIndex = 0;
        this.txtNumber.setMaxLength(80);
        this.mulName.setMaxLength(255);
        this.setF7Context();
        this.getMaterialOtherParam();
        this.setMaterialTrademarkFilter();
        String format = CtrlFormatUtilities.getDateFormatString();
        this.pkCreateTime.setDatePattern(format);
        this.pkLastUpdateTime.setDatePattern(format);
        this.isInOnload = false;
        this.getPicture();
        if (!StringUtil.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.setEnabled(true);
        }
    }

    private void getMaterialParam() throws EASBizException, BOSException {
        String str = ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(this.curCtrlUnitInfo.getId().toString()), (String)"defaultPricePrecison");
        if (!StringUtils.isEmpty((String)str)) {
            this.pricePrecision = new Integer(str);
        }
    }

    private Boolean checkReference(BOSUuid id) {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        try {
            String msg = FMIsqlFacadeFactory.getRemoteInstance().wholeSearchs(pk.toString());
            if (StringUtils.isEmpty((String)msg)) {
                return false;
            }
            return true;
        }
        catch (BizReferenceException e) {
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void loadInitData() {
        Map initData = null;
        initData = (Map)this.batchCallResult.get("initData");
        if (initData == null || initData.size() == 0) {
            return;
        }
        this.materialGroupStandards = (MaterialGroupStandardCollection)((Object)initData.get("materialGroupStandards"));
        this.materialGroupStandardInfo = (MaterialGroupStandardInfo)initData.get("materialGroupStandardInfo");
        this.materialOtherParameterCollection = (MaterialOtherParameterCollection)((Object)initData.get("materialOtherParameterCollection"));
        if (initData.get("qtyPrecision") != null) {
            this.baseqtyPrecision = (Integer)initData.get("qtyPrecision");
        }
    }

    private void setF7Context() {
        this.prmtMaterialGroup.setF7Context(this.getMainOrgContext());
    }

    private void getMaterialOtherParam() {
        CtrlUnitInfo currentCU = this.curCtrlUnitInfo;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cu", (Object)currentCU.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        try {
            if (this.materialOtherParameterCollection == null) {
                IMaterialOtherParameter iMaterialOtherParam = MaterialOtherParameterFactory.getRemoteInstance();
                this.materialOtherParameterCollection = iMaterialOtherParam.getMaterialOtherParameterCollection(viewInfo);
            }
            this.currentMaterialOtherPara = this.materialOtherParameterCollection != null && this.materialOtherParameterCollection.size() != 0 ? this.materialOtherParameterCollection.get(0) : this.getDefaultParam();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private MaterialOtherParameterInfo getDefaultParam() {
        MaterialOtherParameterInfo materialOtherParam = new MaterialOtherParameterInfo();
        materialOtherParam.setNameSelected(true);
        materialOtherParam.setEnglishSelected(true);
        materialOtherParam.setHelpSelected(true);
        materialOtherParam.setBarCodeSelected(true);
        materialOtherParam.setModeSelected(false);
        materialOtherParam.setMameAndMode(false);
        materialOtherParam.setIsNotSaved(false);
        materialOtherParam.setCuUniqueSelected(false);
        return materialOtherParam;
    }

    protected void loadCtx() {
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get("CurrentCtrlUnit");
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.materialBrowseGroup = (MaterialGroupInfo)this.getUIContext().get("materialBrownseGroup");
        this.materialGroupStandardInfo = (MaterialGroupStandardInfo)this.getUIContext().get("materialStandard");
        this.materialGroupStandards = (MaterialGroupStandardCollection)((Object)this.getUIContext().get("materialStandardCollection"));
    }

    private void setFirstFocus() {
        if (this.txtNumber.isEditable()) {
            this.txtNumber.requestFocus();
        } else {
            this.mulName.requestFocus();
        }
    }

    KDPopupMenu CreatePopuMenu() {
        KDPopupMenu popuMenu = new KDPopupMenu();
        KDMenuItem mItemAdd = new KDMenuItem(EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"ADD_Image"));
        ActionListener lstAdd = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MaterialEditUI.this.showAddImageDialog();
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        };
        mItemAdd.addActionListener(lstAdd);
        popuMenu.add((JMenuItem)mItemAdd);
        if (this.materialImage != null) {
            KDMenuItem mItemSave = new KDMenuItem(EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"SAVE_Image"));
            ActionListener lstSave = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MaterialEditUI.this.showSaveDialog();
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            };
            mItemSave.addActionListener(lstSave);
            popuMenu.add((JMenuItem)mItemSave);
            KDMenuItem mItemDelete = new KDMenuItem(EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DELETE_Image"));
            ActionListener lstDelete = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MaterialEditUI.this.showdeleteImage();
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            };
            mItemDelete.addActionListener(lstDelete);
            popuMenu.add((JMenuItem)mItemDelete);
            KDMenuItem mItemShowOriginaSize = new KDMenuItem(EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"ShowAsOriginaSize"));
            ActionListener lstShowOriginaSize = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MaterialEditUI.this.showAsOriginaSize();
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            };
            mItemShowOriginaSize.addActionListener(lstShowOriginaSize);
            popuMenu.add((JMenuItem)mItemShowOriginaSize);
            if (OprtState.VIEW.equals(this.getOprtState())) {
                mItemAdd.removeActionListener(lstAdd);
                popuMenu.remove((Component)mItemAdd);
                mItemDelete.removeActionListener(lstDelete);
                popuMenu.remove((Component)mItemDelete);
            }
        }
        return popuMenu;
    }

    private void showdeleteImage() throws Exception {
        if (!(this.editData != null && this.editData.getId() != null && !this.editData.getId().toString().equals("") || this.editData != null && this.editData.getId() != null)) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"msgBox_noBaseInfo"));
            SysUtil.abort();
        }
        if (this.editData.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_APPROVED);
        }
        if (this.editData.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_FREEZED);
        }
        if (!this.isNeedSave || this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        if (this.confirmRemove()) {
            if (this.pictureId != null && !this.pictureId.equals("")) {
                this.deleteImage();
            }
            this.ClearImage();
        }
    }

    private void ClearImage() throws Exception {
        this.materialImage = null;
        this.pictureFile = null;
        this.pictureId = "";
        this.labPicShow.setIcon(null);
    }

    private void deleteImage() throws Exception {
        String boid = this.editData.getId().toString();
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String[] attid = acm.getAttachmentIDsByBoIDAndCode(this.editData.getId().toString(), "picture");
        if (attid.length >= 1) {
            acm.deleteOneAssociation(boid, attid[0]);
        }
    }

    private void showAddImageDialog() throws Exception {
        if (!(this.editData != null && this.editData.getId() != null && !this.editData.getId().toString().equals("") || this.editData != null && this.editData.getId() != null)) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"msgBox_noBaseInfo"));
            SysUtil.abort();
        }
        if (this.editData.getStatus() == UsedStatusEnum.APPROVED) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_APPROVED);
        }
        if (this.editData.getStatus() == UsedStatusEnum.FREEZED) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_FREEZED);
        }
        if (!this.isNeedSave || this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        File file = this.chooseFileByDialog((Component)((Object)this));
        if (file != null) {
            this.showImage(file);
            if (this.pictureFile != null) {
                String boid = this.editData.getId().toString();
                AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
                String[] attid = acm.getAttachmentIDsByBoIDAndCode(this.editData.getId().toString(), "picture");
                if (attid.length >= 1) {
                    acm.deleteOneAssociation(boid, attid[0]);
                }
                this.pictureId = acm.addNewAttachment(boid, this.pictureFile, "picture");
                this.pictureFile = null;
            }
        }
    }

    private File chooseFileByDialog(Component owner) {
        File retFile = null;
        boolean isRetFileValid = false;
        KDFileChooser fc = new KDFileChooser(System.getProperty("user.home"));
        fc.setFileFilter((FileFilter)new PictureFilter());
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        while (!isRetFileValid) {
            int retVal = fc.showOpenDialog(owner);
            if (retVal == 1) {
                return retFile;
            }
            retFile = fc.getSelectedFile();
            if (retFile.exists()) {
                if (retFile.length() < 0x3200000L) {
                    isRetFileValid = true;
                    continue;
                }
                MsgBox.showInfo((String)Resrcs.getString((String)"FileSizeNotAllowed"));
                retFile = null;
                continue;
            }
            MsgBox.showInfo((String)Resrcs.getString((String)"FileNotExisted"));
            retFile = null;
        }
        return retFile;
    }

    private void showImage(File file) throws Exception {
        BufferedImage img = ImageIO.read(file);
        if (img == null) {
            throw new MaterialBaseException(MaterialBaseException.INVALID_IMAGE);
        }
        KDImageIcon icon = new KDImageIcon((Image)img);
        this.labPicShow.setIcon((Icon)icon);
        this.materialImage = img;
        this.pictureFile = file;
    }

    private void showImage(byte[] data) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedImage img = ImageIO.read(bais);
        KDImageIcon icon = new KDImageIcon((Image)img);
        this.labPicShow.setIcon((Icon)icon);
        this.materialImage = img;
        this.pictureFile = null;
        bais.close();
    }

    private void getPicture() throws Exception {
        if (this.editData == null) {
            return;
        }
        if (this.editData.getId() == null || this.editData.getId().toString().equals("")) {
            return;
        }
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String[] attid = acm.getAttachmentIDsByBoIDAndCode(this.editData.getId().toString(), "picture");
        if (attid.length >= 1) {
            ComplexAttachmentInfo attinfo = acm.getComplexAttachmentInfo(attid[0]);
            if (attinfo != null) {
                byte[] data = attinfo.getContent();
                this.showImage(data);
                this.pictureId = attid[0];
            } else {
                this.pictureId = "";
            }
        } else {
            this.pictureId = "";
        }
    }

    private void showSaveDialog() {
        KDFileChooser m_chooserSave = new KDFileChooser();
        m_chooserSave.setFileFilter((FileFilter)new PictureFilter());
        int result = m_chooserSave.showSaveDialog((Component)((Object)this));
        if (result != 0) {
            return;
        }
        File f = m_chooserSave.getSelectedFile();
        this.saveComponentToJPEG(f.getAbsolutePath() + f.getName() + ".jpg");
    }

    private void saveComponentToJPEG(String fileName) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fileName));
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPicture_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"msgBox_noBaseInfo"));
            SysUtil.abort();
        }
        this.getPicture();
    }

    private void setBtnIcon() {
        this.btnApprove.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnApprove.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnMultiUnit.setIcon(EASResource.getIcon((String)"imgTbtn_unit"));
        this.btnPicture.setIcon(EASResource.getIcon((String)"imgTbtn_showpicture"));
        this.btnMultiPageCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.menuItemMultiPageCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
    }

    @Override
    public void setOprtState(String oprtType) {
        if (oprtType != null && !oprtType.equals(this.getOprtState())) {
            super.setOprtState(oprtType);
            this.getUIContext().put("MATERIAL_UI_STATUS", oprtType);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setFirstFocus();
    }

    private boolean isMaterialBaseUsedCodingRule() throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = null;
        String strCompanyID = this.curCtrlUnitInfo.getId().toString();
        MaterialInfo material = new MaterialInfo();
        if (this.isInOnload) {
            this.isUsedCodingRule = (Boolean)this.batchCallResult.get("isUsedCodingRule");
        } else {
            iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstanceWithObjectContext((Context)this.getMainOrgContext());
            this.isUsedCodingRule = iCodingRuleManager.isExist((IObjectValue)material, strCompanyID);
        }
        if (this.isUsedCodingRule) {
            if (this.isInOnload) {
                this.isCodingRuleModifiable = (Boolean)this.batchCallResult.get("isCodingRuleModifiable");
                this.isAddNewCodingRule = (Boolean)this.batchCallResult.get("isAddNewCodingRule");
                this.isAddNoBreakCodingRule = (Boolean)this.batchCallResult.get("isAddNoBreakCodingRule");
            } else {
                this.isCodingRuleModifiable = iCodingRuleManager.isModifiable((IObjectValue)material, strCompanyID);
                this.isAddNewCodingRule = iCodingRuleManager.isAddView((IObjectValue)material, strCompanyID);
                this.isAddNoBreakCodingRule = iCodingRuleManager.getRuleStatus((IObjectValue)material, strCompanyID).isAddNoBreak();
            }
        }
        return this.isUsedCodingRule;
    }

    protected void prepareNumber(IObjectValue caller, String number) {
        ((MaterialInfo)caller).setNumber(number);
        this.txtNumber.setText(number);
        this.txtNumber.setEditable(false);
    }

    protected void setNumberTextEnabled() {
        this.txtNumber.setEditable(true);
        this.txtNumber.setEnabled(true);
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Confirm_Delete")));
    }

    @Override
    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherBase(0);
    }

    @Override
    public void actionMultiUnit_actionPerformed(ActionEvent e) throws Exception {
        int vostatus;
        this.checkHasBaseInfo();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)MATERIAL_INFO, (Object)this.editData);
        boolean editEnabled = false;
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            editEnabled = true;
        } else if (!this.getOprtState().equals(OprtState.VIEW) && (vostatus = this.editData.getStatus().getValue()) == 0) {
            editEnabled = true;
        }
        uiContext.put((Object)"editEnabled", (Object)new Boolean(editEnabled));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.basedata.master.material.client.MultiMeasureUnitEditUI", (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        String matid = this.editData.getId().toString();
        this.baseqtyPrecision = MaterialClientTools.getQtyPrecisionByUnit(matid, this.editData.getBaseUnit().getId().toString());
        this.setBasePreInCTX();
    }

    @Override
    public void actionSubmitAll_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setString("IsCreateAll", "true");
        this.doSubmit(e);
    }

    @Override
    public void actionUnApprove_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherBase(1);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherBase(2);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherBase(3);
    }

    private void doActionOtherBase(int actionenumvalue) throws Exception {
        if (this.editData != null) {
            if (this.editData.getCU() != null) {
                MaterialClientTools.checkIsMaintainCU(this.editData, this.curCtrlUnitInfo, (Component)((Object)this));
            }
            if (this.editData.getId() != null && !"".equals(this.editData.getId().toString())) {
                IMaterial ima = null;
                try {
                    ima = (IMaterial)this.getBizInterface();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
                this.doCheckStatusBase(actionenumvalue);
                if (ima != null) {
                    switch (actionenumvalue) {
                        case 0: {
                            String[] idListArray = new String[]{this.editData.getId().toString()};
                            ArrayList IDsInWF = WorkFlowUtil.getIDsInActiveWorkFlow((String[])idListArray);
                            if (IDsInWF.size() != 0) {
                                this.actionMultiapprove_actionPerformed();
                            } else {
                                this.actionApproveByNoWF();
                            }
                            Thread.sleep(2000L);
                            break;
                        }
                        case 1: {
                            ima.unapprove((IObjectPK)pk);
                            break;
                        }
                        case 2: {
                            if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"Material_Freeze_Msgbox")))) {
                                return;
                            }
                            ima.freeze((IObjectPK)pk);
                            break;
                        }
                        case 3: {
                            ima.unfreeze((IObjectPK)pk);
                        }
                    }
                    this.setDataObject((IObjectValue)ima.getValue((IObjectPK)pk, this.getMergedSelector()));
                }
                this.setSaved(true);
                this.loadFields();
            }
        }
    }

    private void doCheckStatusBase(int actionenumvalue) throws BOSException, EASBizException {
        if (this.editData == null) {
            return;
        }
        if (this.editData.getEffectedStatus() != 2) {
            throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTSAVE);
        }
        switch (actionenumvalue) {
            case 0: {
                if (this.editData.getStatus() == UsedStatusEnum.APPROVED) {
                    throw new MaterialBaseException(MaterialBaseException.BASEINFO_APPROVED);
                }
                if (this.editData.getStatus() != UsedStatusEnum.FREEZED) break;
                throw new MaterialBaseException(MaterialBaseException.BASEINFO_FREEZED);
            }
            case 1: {
                if (this.editData.getStatus() == UsedStatusEnum.UNAPPROVE) {
                    throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTAPPROVE);
                }
                if (this.editData.getStatus() != UsedStatusEnum.FREEZED) break;
                throw new MaterialBaseException(MaterialBaseException.BASEINFO_FREEZED);
            }
            case 2: {
                if (this.editData.getStatus() == UsedStatusEnum.UNAPPROVE) {
                    throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTAPPROVE);
                }
                if (this.editData.getStatus() != UsedStatusEnum.FREEZED) break;
                throw new MaterialBaseException(MaterialBaseException.BASEINFO_FREEZED);
            }
            case 3: {
                if (this.editData.getStatus() == UsedStatusEnum.UNAPPROVE) {
                    throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTAPPROVE);
                }
                if (this.editData.getStatus() != UsedStatusEnum.APPROVED) break;
                throw new MaterialBaseException(MaterialBaseException.BASEINFO_NOTFREEZED);
            }
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.setSubmitSaveButton();
        this.setFirstFocus();
        this.txtVersion.setValue((Object)new Integer(0));
    }

    public void checkModified() throws Exception {
        if (this.editData.getStatus() != UsedStatusEnum.UNAPPROVE) {
            return;
        }
        super.checkModified();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.AccountVolume();
        this.editData.setEffectedStatus(1);
        this.editData.setCU(this.curCtrlUnitInfo);
        super.actionSave_actionPerformed(e);
        this.setSubmitSaveButton();
        this.getUIContext().put("ID", this.editData.getId().toString());
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setUpTitle();
        this.initTxtNumber(this.editData);
        this.setSubmitSaveButton();
        this.setFirstFocus();
        if (e != null) {
            this.getUIContext().put("MATERIAL_UI_STATUS", this.getOprtState());
        }
        this.doFieldPermission();
        if (this.kdTMain.getSelectedIndex() != 0) {
            this.initNumberTextFile(false);
        }
    }

    public boolean checkBeforeWindowClosing() {
        if (this.kdTMain.getSelectedIndex() != 0) {
            return true;
        }
        if (this.editData != null && this.editData.getId() != null && !"".equals(this.editData.getId().toString()) && this.editData.getStatus() != UsedStatusEnum.UNAPPROVE) {
            return true;
        }
        return super.checkBeforeWindowClosing();
    }

    public boolean checkHasBaseInfo() {
        if (this.editData == null || this.editData.getId() == null || this.editData.getEffectedStatus() != 2) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"msgBox_noBaseInfo"));
            return false;
        }
        return true;
    }

    private void setSubmitSaveButton() {
        MaterialInfo vo = this.editData;
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnRemove.setEnabled(true);
            this.menuItemRemove.setEnabled(true);
            this.btnSave.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.menuItemSubmit.setEnabled(false);
            if (vo != null && vo.getInt("effectedStatus") == 2) {
                int vostatus = vo.getInt("status");
                this.setActionButtonVisible(vostatus);
            } else {
                this.btnApprove.setVisible(true);
                this.btnUnApprove.setVisible(false);
                this.btnCancel.setVisible(false);
                this.menuItemCancel.setVisible(false);
                this.btnCancelCancel.setVisible(false);
                this.menuItemCancelCancel.setVisible(false);
            }
            this.btnMultiUnit.setEnabled(true);
            this.btnPicture.setEnabled(true);
            this.isNeedSave = true;
            return;
        }
        if (this.editData.getStatus() != UsedStatusEnum.FREEZED) {
            this.btnAddNew.setEnabled(true);
        }
        if (vo != null && vo.getInt("effectedStatus") == 2) {
            int vostatus = vo.getInt("status");
            if (vostatus == 0) {
                this.btnRemove.setEnabled(true);
                this.menuItemRemove.setEnabled(true);
                this.btnSubmit.setEnabled(true);
                this.menuItemSubmit.setEnabled(true);
                this.isNeedSave = true;
            } else if (vostatus == 1) {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
                this.btnSubmit.setEnabled(true);
                this.menuItemSubmit.setEnabled(false);
                this.isNeedSave = false;
            } else {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
                this.btnSubmit.setEnabled(false);
                this.menuItemSubmit.setEnabled(false);
                this.isNeedSave = false;
            }
            this.btnSave.setEnabled(false);
            this.btnMultiUnit.setEnabled(true);
            this.btnPicture.setEnabled(true);
            this.setActionButtonVisible(vostatus);
        } else {
            this.btnSave.setEnabled(true);
            this.btnSubmit.setEnabled(true);
            this.menuItemSubmit.setEnabled(true);
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnApprove.setVisible(true);
            this.btnUnApprove.setVisible(false);
            this.btnCancel.setVisible(false);
            this.menuItemCancel.setVisible(false);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
            this.btnMultiUnit.setEnabled(true);
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                this.btnMultiUnit.setEnabled(false);
                this.btnPicture.setEnabled(false);
            } else if (vo != null) {
                this.btnRemove.setEnabled(true);
                this.menuItemRemove.setEnabled(true);
                this.btnPicture.setEnabled(true);
            } else {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
                this.btnPicture.setEnabled(false);
            }
            this.isNeedSave = true;
        }
    }

    private void setActionButtonVisible(int vostatus) {
        if (vostatus == 0) {
            this.btnApprove.setEnabled(true);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnApprove.setVisible(true);
            this.btnUnApprove.setVisible(false);
            this.btnCancel.setVisible(false);
            this.menuItemCancel.setVisible(false);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
        } else if (vostatus == 1) {
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(true);
            this.btnCancel.setEnabled(true);
            this.menuItemCancel.setEnabled(true);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnApprove.setVisible(false);
            this.btnUnApprove.setVisible(true);
            this.btnCancel.setVisible(true);
            this.menuItemCancel.setVisible(true);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
        } else {
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(true);
            this.menuItemCancelCancel.setEnabled(true);
            this.btnApprove.setVisible(false);
            this.btnUnApprove.setVisible(false);
            this.btnCancel.setVisible(false);
            this.menuItemCancel.setVisible(false);
            this.btnCancelCancel.setVisible(true);
            this.menuItemCancelCancel.setVisible(true);
        }
    }

    public SelectorItemCollection getMergedSelector() {
        SelectorItemCollection selectors = super.getMergedSelector();
        selectors.add(new SelectorItemInfo("effectedStatus"));
        selectors.add(new SelectorItemInfo("CU.id"));
        selectors.add(new SelectorItemInfo("materialGroupDetails.id"));
        selectors.add(new SelectorItemInfo("materialGroupDetails.material.*"));
        selectors.add(new SelectorItemInfo("materialGroupDetails.materialGroupStandard.*"));
        selectors.add(new SelectorItemInfo("materialGroupDetails.materialGroup.*"));
        return selectors;
    }

    protected void loadData() throws Exception {
        super.loadData();
    }

    protected boolean isAllowTabChange() {
        boolean re;
        if (this.activeTabIndex == 0 && !(re = this.checkHasBaseInfo())) {
            this.setAllowTabChange(false);
            return false;
        }
        AbstractObjectValue oldValue = null;
        oldValue = this.activeUI.getDataObject() instanceof IObjectValueAgent ? (AbstractObjectValue)AgentUtility.deepCopyAgentValue((IObjectValueAgent)((IObjectValueAgent)this.activeUI.getDataObject())) : (AbstractObjectValue)((AbstractObjectValue)this.activeUI.getDataObject()).clone();
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"dataSave"));
            switch (result) {
                case 0: {
                    try {
                        ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                        this.activeUI.actionSubmit_actionPerformed(event);
                    }
                    catch (Exception e) {
                        this.handUIException(e);
                        return false;
                    }
                    this.setAllowTabChange(true);
                    break;
                }
                case 1: {
                    ArrayList list;
                    boolean tag = false;
                    ArrayList<String> arr1 = new ArrayList<String>();
                    arr1.add(new String("tagState"));
                    if (this.activeUI.getUIContext().get(arr1) != null && (list = (ArrayList)this.activeUI.getUIContext().get(arr1)).get(0) != null) {
                        tag = (Boolean)list.get(0);
                    }
                    if (!tag) {
                        this.activeUI.getUIContext().put("InitDataObject", oldValue);
                    }
                    this.setAllowTabChange(true);
                    break;
                }
                default: {
                    this.setAllowTabChange(false);
                    return false;
                }
            }
        } else {
            this.setAllowTabChange(true);
        }
        if (this.activeUI.getOprtState().equalsIgnoreCase("ADDNEW")) {
            this.activeUI.setOprtState(this.getOprtState());
        }
        return true;
    }

    public boolean isModify() {
        if (this.activeTabIndex == 0) {
            return super.isModify();
        }
        return this.activeUI.isModify();
    }

    private void setSeqUnitFilter(String matid) {
        this.prmtSeqUnit.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery");
        if (matid != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)matid, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("multiMeasureUnit.baseConvsRate", (Object)new BigDecimal("1.00"), CompareType.GREATER_EQUALS));
            filterInfo.setMaskString("#0 and #1");
            viewInfo.setFilter(filterInfo);
            this.prmtSeqUnit.setEntityViewInfo(viewInfo);
        }
        this.prmtSeqUnit.setEnabled(true);
    }

    private void setSeqUnitFilter(boolean isAddNew) {
        if (isAddNew) {
            this.prmtSeqUnit.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery");
            this.prmtSeqUnit.setEnabled(false);
            MeasureUnitInfo baseUnit = (MeasureUnitInfo)this.prmtBaseUnit.getValue();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            if (baseUnit != null && baseUnit.getMeasureUnitGroup() != null) {
                String ineerSql = "select fid from T_BD_MeasureUnit where FGroupID = '" + baseUnit.getMeasureUnitGroup().getId().toString() + "' and (FCoefficient/" + baseUnit.getCoefficient() + ")>=1";
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ineerSql, CompareType.INNER));
                filterInfo.setMaskString("#0");
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("measureUnitGroup.id", (Object)"UNKNOWN_MATERIALGROUP", CompareType.EQUALS));
            }
            viewInfo.setFilter(filterInfo);
            this.prmtSeqUnit.setEntityViewInfo(viewInfo);
            this.prmtSeqUnit.setEnabled(true);
        }
    }

    private void setMaterialTrademarkFilter() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        try {
            FilterInfo databaseDFilter = null;
            if (this.isInOnload) {
                databaseDFilter = (FilterInfo)this.batchCallResult.get("databaseDFilter");
            } else {
                IMaterialTrademark iDataBaseD = MaterialTrademarkFactory.getRemoteInstance();
                databaseDFilter = iDataBaseD.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(this.curCtrlUnitInfo.getId().toString()), "id", "adminCU.id");
            }
            viewInfo.setFilter(databaseDFilter);
            this.prmtMaterialTrademark.setEntityViewInfo(viewInfo);
            this.prmtMaterialTrademark.setHasCUDefaultFilter(false);
            this.prmtMaterialTrademark.setFilterInfoProducer(new IFilterInfoProducer(){

                public FilterInfo getFilterInfo() {
                    EntityViewInfo evi = new EntityViewInfo();
                    return evi.getFilter();
                }

                public void setCurrentCtrlUnit(CtrlUnitInfo cui) {
                }

                public void setCurrentMainBizOrgUnit(OrgUnitInfo oui, OrgType ot) {
                }
            });
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void addEventListeners() {
        this.prmtSeqUnit.addDataChangeListener((DataChangeListener)this.seqListener);
        this.prmtBaseUnit.addDataChangeListener((DataChangeListener)this.seqListener);
    }

    private void removeEventListeners() {
        this.prmtSeqUnit.removeDataChangeListener((DataChangeListener)this.seqListener);
        this.prmtBaseUnit.removeDataChangeListener((DataChangeListener)this.seqListener);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        int pricePresion = 6;
        pricePresion = (Integer)this.kDPricePrecision.getValue();
        if (this.editData != null && this.editData.getId() != null) {
            this.copyIsAssignMaterial = this.isAssignMaterial();
            this.copyMaterialID = this.editData.getId().toString();
        }
        super.actionCopy_actionPerformed(e);
        this.setFirstFocus();
        this.kDPricePrecision.setValue((Object)new Integer(pricePresion));
        if (this.isUsedCodingRule && !this.isCodingRuleModifiable) {
            this.txtNumber.setEnabled(false);
        }
        if (this.copyIsAssignMaterial) {
            this.prmtMaterialTrademark.setValue(null);
        }
        this.editData.setString("isCopy", "true");
        this.editData.setString("copyOldMaterialId", this.copyMaterialID);
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        CtrlUnitInfo cuInfo = this.curCtrlUnitInfo;
        if (this.isUsedCodingRule && (this.isAddNewCodingRule || this.isAddNoBreakCodingRule)) {
            this.getNumberByRule((IObjectValue)newData);
        } else {
            newData.setString("number", null);
        }
        MaterialInfo info = (MaterialInfo)newData;
        info.setStatus(UsedStatusEnum.UNAPPROVE);
        info.setAdminCU(null);
        info.setCU(cuInfo);
        info.setLastUpdateUser(null);
        info.setLastUpdateTime(null);
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setCreateTime(null);
        info.setFreezeOrgUnit(null);
        info.setVersion(0);
        info.setEffectedStatus(1);
    }

    private void setPrintEnable(boolean enablead) {
        this.btnPrint.setVisible(enablead);
        this.menuItemPrint.setVisible(enablead);
        this.actionPrint.setEnabled(enablead);
        this.btnPrintPreview.setVisible(enablead);
        this.menuItemPrint.setVisible(enablead);
        this.actionPrintPreview.setEnabled(enablead);
        this.separatorFW2.setVisible(enablead);
        this.kDSeparator3.setVisible(enablead);
    }

    private void setPrintEnable() {
        this.setPrintEnable(false);
    }

    public void hideAddEditBtn() {
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnCopy.setVisible(false);
        this.multiPageCopy.setEnabled(false);
        this.menuItemMultiPageCopy.setEnabled(false);
        this.actionAddNew.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.actionCopy.setEnabled(false);
        this.btnMultiPageCopy.setEnabled(false);
    }

    public void setCurrentInterface() {
        super.setCurrentInterface();
        if (this.activeTabIndex == 0) {
            this.initNumberTextFile(true);
        } else {
            this.initNumberTextFile(false);
        }
    }

    protected boolean isShowAttachmentAction() {
        return true;
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        boolean b = this.checkHasBaseInfo();
        if (!b) {
            return;
        }
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        AttachmentUIContextInfo acmInfo = new AttachmentUIContextInfo();
        acmInfo.setBoID(this.editData.getId().toString());
        acmInfo.setNumber("picture");
        if (this.getOprtState().equals(OprtState.VIEW)) {
            acmInfo.setEdit(false);
        } else if (this.editData.getStatus().equals((Object)UsedStatusEnum.UNAPPROVE)) {
            acmInfo.setEdit(true);
        } else {
            acmInfo.setEdit(false);
        }
        acm.showAttachmentListUIByBoID((Object)this, acmInfo);
    }

    protected void loadGroupData() {
        try {
            IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)this.curCtrlUnitInfo.getId().toString(), (String)this.curCtrlUnitInfo.getLongNumber()));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("standardType", (Object)MaterialGroupStandardTypeEnum.BasicStandard, CompareType.NOTEQUALS));
            view.getFilter().mergeFilter(filterInfo, "and");
            this.materialGroupStandards = iMaterialGroupStandard.getMaterialGroupStandardCollection(view);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void loadMaterialGroupTable(MaterialGroupStandardCollection standards, MaterialInfo materialInfo) {
        this.kdtGroupInfo.removeRows();
        MaterialGroupStandardInfo stdVO = null;
        MaterialGroupInfo grpVO = null;
        if (standards != null) {
            int c = standards.size();
            for (int i = 0; i < c; ++i) {
                stdVO = standards.get(i);
                grpVO = this.getMaterialGroupByStandard(stdVO, materialInfo);
                if (stdVO.getStandardType() == MaterialGroupStandardTypeEnum.BasicStandard) continue;
                IRow row = this.kdtGroupInfo.addRow();
                row.getCell(GROUP_TAB_STANDARNAME).setValue((Object)stdVO);
                row.getCell(GROUP_TAB_GROUPNAME).setValue((Object)grpVO);
            }
        }
    }

    protected MaterialGroupInfo getMaterialGroupByStandard(MaterialGroupStandardInfo standard, MaterialInfo vo) {
        if (vo != null) {
            MaterialGroupDetialCollection details = vo.getMaterialGroupDetails();
            int c = details.size();
            for (int i = 0; i < c; ++i) {
                MaterialGroupDetialInfo detail = details.get(i);
                if (detail == null || detail.getMaterialGroupStandard() == null || standard == null || !detail.getMaterialGroupStandard().getId().toString().equalsIgnoreCase(standard.getId().toString())) continue;
                return detail.getMaterialGroup();
            }
        }
        if (OprtState.ADDNEW.equals(this.getOprtState()) && this.materialGroupStandardInfo != null && standard.getNumber().equals(this.materialGroupStandardInfo.getNumber())) {
            return this.materialBrowseGroup;
        }
        return null;
    }

    private boolean isOnlyGroupInfoChange() {
        MaterialInfo oldMaterial = null;
        MaterialInfo newMaterial = null;
        if (this.oldMaterialValue != null && this.editData != null) {
            oldMaterial = (MaterialInfo)this.oldMaterialValue.clone();
            newMaterial = (MaterialInfo)this.editData.clone();
            oldMaterial.getMaterialGroupDetails().clear();
            newMaterial.getMaterialGroupDetails().clear();
            return ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)oldMaterial, (AbstractObjectValue)newMaterial);
        }
        return false;
    }

    private boolean isAssignMaterial() {
        return this.editData.getCU() != null && !this.editData.getCU().getId().toString().equals(this.curCtrlUnitInfo.getId().toString());
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.isAssignMaterial()) {
            if (!this.isOnlyGroupInfoChange()) {
                DataBaseDException exception = new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
                MsgBox.showInfo((Component)((Object)this), (String)exception.getMessage());
                SysUtil.abort();
            }
        } else if (this.editData.getStatus().equals((Object)UsedStatusEnum.APPROVED) && !this.isOnlyGroupInfoChange()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"CannotEditIFApprovedMaterial"));
            SysUtil.abort();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.prmtMaterialGroup.getValue() != null) {
            this.editData.setMaterialGroup((MaterialGroupInfo)this.prmtMaterialGroup.getValue());
        } else {
            this.editData.setMaterialGroup(null);
        }
        if (!this.isFirstOnload()) {
            this.updateMaterialGroupTable((IObjectValue)this.editData);
        }
    }

    private MaterialGroupStandardInfo getBaseMaterialGroupStandard() {
        try {
            MaterialGroupStandardCollection coll = null;
            if (this.isInOnload) {
                coll = (MaterialGroupStandardCollection)((Object)this.batchCallResult.get("materialGroupStandards"));
            } else {
                IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
                coll = iMaterialGroupStandard.getBaseMaterialGroupStandardColl();
            }
            if (coll != null && coll.size() != 0) {
                return coll.get(0);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return null;
    }

    protected void updateMaterialGroupTable(IObjectValue vo) {
        MaterialInfo materialInfo = (MaterialInfo)vo;
        int c = this.kdtGroupInfo.getRowCount();
        for (int i = 0; i < c; ++i) {
            IRow row = this.kdtGroupInfo.getRow(i);
            MaterialGroupStandardInfo std = (MaterialGroupStandardInfo)row.getCell(GROUP_TAB_STANDARNAME).getValue();
            MaterialGroupInfo materialGroupInfo = (MaterialGroupInfo)row.getCell(GROUP_TAB_GROUPNAME).getValue();
            MaterialGroupDetialCollection details = materialInfo.getMaterialGroupDetails();
            AbstractMaterialGroupDetialInfo detail = null;
            int b = details.size();
            for (int j = 0; j < b; ++j) {
                MaterialGroupDetialInfo item = details.get(j);
                if (!item.getMaterialGroupStandard().getId().toString().equalsIgnoreCase(std.getId().toString())) continue;
                detail = item;
                break;
            }
            if (detail == null) {
                if (materialGroupInfo == null) continue;
                MaterialGroupDetialInfo newDetail = new MaterialGroupDetialInfo();
                newDetail.setMaterialGroupStandard(std);
                newDetail.setMaterialGroup(materialGroupInfo);
                newDetail.setMaterial(this.editData);
                materialInfo.getMaterialGroupDetails().add(newDetail);
                continue;
            }
            if (materialGroupInfo == null) {
                materialInfo.getMaterialGroupDetails().remove((MaterialGroupDetialInfo)detail);
                continue;
            }
            if (detail.getMaterialGroup().getId().toString().equals(materialGroupInfo.getId().toString())) continue;
            detail.setMaterialGroup(materialGroupInfo);
        }
        MaterialGroupStandardInfo std = null;
        std = this.getBaseMaterialGroupStandard();
        MaterialGroupInfo materialGroupInfo = (MaterialGroupInfo)this.prmtMaterialGroup.getValue();
        MaterialGroupDetialCollection details = materialInfo.getMaterialGroupDetails();
        AbstractMaterialGroupDetialInfo detail = null;
        int b = details.size();
        for (int j = 0; j < b; ++j) {
            MaterialGroupDetialInfo item = details.get(j);
            if (!item.getMaterialGroupStandard().getId().toString().equalsIgnoreCase(std.getId().toString())) continue;
            detail = item;
            break;
        }
        if (detail == null) {
            if (materialGroupInfo != null) {
                MaterialGroupDetialInfo newDetail = new MaterialGroupDetialInfo();
                newDetail.setMaterialGroupStandard(std);
                newDetail.setMaterialGroup(materialGroupInfo);
                newDetail.setMaterial(this.editData);
                materialInfo.getMaterialGroupDetails().add(newDetail);
            }
        } else if (materialGroupInfo == null) {
            materialInfo.getMaterialGroupDetails().remove((MaterialGroupDetialInfo)detail);
        } else if (!detail.getMaterialGroup().getId().toString().equals(materialGroupInfo.getId().toString())) {
            detail.setMaterialGroup(materialGroupInfo);
        }
    }

    private void setupKDTable() {
        this.kdtGroupInfo.checkParsed();
        this.kdtGroupInfo.getColumn(GROUP_TAB_STANDARNAME).getStyleAttributes().setLocked(true);
        this.kdtGroupInfo.addKDTActiveCellListener((KDTActiveCellListener)new CSGroupTableActiveCellHandler());
        this.kdtGroupInfo.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
    }

    public void _activeCellChanged(int rowIndex, int columnIndex) {
        if (GROUP_TAB_GROUPNAME.equals(this.kdtGroupInfo.getColumnKey(columnIndex))) {
            KDBizPromptBox promptBox = new KDBizPromptBox();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            promptBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.MaterialGroupQuery");
            IRow rowMaterial = this.kdtGroupInfo.getRow(rowIndex);
            if (!(rowMaterial.getCell(GROUP_TAB_STANDARNAME).getValue() instanceof MaterialGroupStandardInfo)) {
                return;
            }
            MaterialGroupStandardInfo std = (MaterialGroupStandardInfo)rowMaterial.getCell(GROUP_TAB_STANDARNAME).getValue();
            filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard.id", (Object)std.getId().toString(), CompareType.EQUALS));
            if (!MaterialInfo.isAllowNonLeafGroup()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
            }
            view.setFilter(filterInfo);
            promptBox.setEntityViewInfo(view);
            promptBox.setEditable(true);
            promptBox.setDisplayFormat("$name$");
            promptBox.setEditFormat("$name$");
            promptBox.setCommitFormat("$number$");
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"cu", (Object)this.curCtrlUnitInfo);
            ctx.put((Object)"groupStandard", (Object)std);
            F7BaseSelector f7Selector = new F7BaseSelector(F7MaterialGroupUI.class, promptBox, ctx);
            promptBox.setSelector((KDPromptSelector)f7Selector);
            this.kdtGroupInfo.getColumn(GROUP_TAB_GROUPNAME).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBox));
        }
    }

    @Override
    public void multiPageCopy_actionPerformed(ActionEvent e) throws Exception {
        int pricePresion = 6;
        pricePresion = (Integer)this.kDPricePrecision.getValue();
        if (this.editData != null && this.editData.getId() != null) {
            this.copyMaterialID = this.editData.getId().toString();
            this.copyMaterialName = this.editData.getName();
            this.copyMaterialNum = this.editData.getNumber();
            this.copyIsAssignMaterial = this.isAssignMaterial();
        }
        super.actionCopy_actionPerformed(e);
        if (this.isUsedCodingRule && !this.isCodingRuleModifiable) {
            this.txtNumber.setEnabled(false);
        }
        if (!this.isUsedCodingRule && this.txtNumber.isEnabled() && this.txtNumber.isEditable()) {
            this.txtNumber.setText(this.copyMaterialNum + "COPY");
        }
        this.mulName.setSelectedItemData((Object)(this.copyMaterialName + "COPY"));
        this.editData.setString("isMultiCopy", "true");
        this.editData.setString("copyOldMaterialId", this.copyMaterialID);
        this.kDPricePrecision.setValue((Object)new Integer(pricePresion));
        this.btnSubmitAll.setVisible(false);
        if (this.copyIsAssignMaterial) {
            this.prmtMaterialTrademark.setValue(null);
        }
    }

    @Override
    public void actionAsstAttrValue_actionPerformed(ActionEvent e) throws Exception {
        super.actionAsstAttrValue_actionPerformed(e);
        boolean editable = false;
        if (this.oldMaterialValue.getId() != null && this.oldMaterialValue.getAssistAttr() != null) {
            int vostatus;
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                editable = true;
            } else if (!this.getOprtState().equals(OprtState.VIEW) && (vostatus = this.editData.getStatus().getValue()) == 0) {
                editable = true;
            }
        }
        UIContext uictx = new UIContext((Object)this);
        uictx.put((Object)MATERIAL_INFO, (Object)this.oldMaterialValue);
        uictx.put((Object)EDITABLE, (Object)editable);
        uictx.put((Object)"cu", (Object)this.curCtrlUnitInfo);
        MaterialAsstAttrValueEditUI.showUI((Object)this, this.oldMaterialValue, editable, uictx);
    }

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (EmptyUtil.isEmpty((String)state)) {
            super.getOnloadPermItemName();
        }
        if (state.equals(OprtState.ADDNEW)) {
            return "bd_material_addNew";
        }
        if (state.equals(OprtState.EDIT)) {
            return "bd_material_update";
        }
        return "bd_material_view";
    }

    private void actionMultiapprove_actionPerformed() throws Exception {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String[] boID = new String[]{this.getSelectBOID()};
        if (boID[0] == null) {
            return;
        }
        MultiApproveUtil.multiapproveBills((CoreUIObject)this, (String)userID, (String[])boID);
    }

    private void actionApproveByNoWF() {
        if (this.editData.getAdminCU() != null) {
            CSClientUtils.checkIsMaintainCU((DataBaseDInfo)this.editData, (Component)((Object)this), (String)this.curCtrlUnitInfo.getId().toString());
        }
        if (!CSClientUtils.actionCommon((this.editData.getId() == null ? 1 : 0) != 0)) {
            return;
        }
        ObjectStringPK pk = new ObjectStringPK(this.editData.getId().toString());
        try {
            ((IMaterial)this.getBizInterface()).approve((IObjectPK)pk);
            this.refreshInterface();
            this.btnApprove.setVisible(false);
            this.btnUnApprove.setVisible(true);
            this.btnUnApprove.setEnabled(true);
        }
        catch (Exception er) {
            super.handUIException((Throwable)er);
        }
    }

    private void refreshInterface() {
        try {
            IMaterial iMaterial = (IMaterial)this.getBizInterface();
            if (this.editData.getId() != null) {
                ObjectUuidPK iObjectPk = new ObjectUuidPK(this.editData.getId());
                this.editData = iMaterial.getMaterialInfo((IObjectPK)iObjectPk, this.getMergedSelector());
            }
        }
        catch (Exception e) {
            super.handleException(e);
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    @Override
    public void actionOption_actionPerformed(ActionEvent e) throws Exception {
        UserParamterUI.showUI((Object)((Object)this));
    }

    public boolean useScrollPane() {
        return true;
    }

    public int getVerticalScrollPolicy() {
        return 20;
    }

    public int getHorizontalScrollPolicy() {
        return 30;
    }

    class CSGroupTableActiveCellHandler
    implements KDTActiveCellListener {
        CSGroupTableActiveCellHandler() {
        }

        public void activeCellChanged(KDTActiveCellEvent e) {
            if (e.getRowIndex() > -1) {
                MaterialEditUI.this._activeCellChanged(e.getRowIndex(), e.getColumnIndex());
            }
        }
    }

    private class SeqUnitDataChangeListener
    implements DataChangeListener,
    PreChangeListener {
        private SeqUnitDataChangeListener() {
        }

        public void dataChanged(DataChangeEvent e) {
            Object newVal = e.getNewValue();
            Object oldVal = e.getOldValue();
            if (newVal != null && newVal.equals(oldVal) || newVal == null && oldVal == null) {
                return;
            }
            Object source = e.getSource();
            if (source != null && source.equals(MaterialEditUI.this.prmtSeqUnit)) {
                MaterialEditUI.this.prmtSeqUnit.removeDataChangeListener((DataChangeListener)MaterialEditUI.this.seqListener);
                if (newVal == null && MaterialEditUI.this.editData.getId() != null && MaterialEditUI.this.editData.getSeqUnit() != null) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"SeqUnit_Is_Null"));
                    MaterialEditUI.this.prmtSeqUnit.setValue((Object)MaterialEditUI.this.editData.getSeqUnit());
                }
                MaterialEditUI.this.prmtSeqUnit.addDataChangeListener((DataChangeListener)MaterialEditUI.this.seqListener);
            } else if (source != null && source.equals(MaterialEditUI.this.prmtBaseUnit)) {
                if (MaterialEditUI.this.editData != null && MaterialEditUI.this.editData.getId() != null) {
                    return;
                }
                MaterialEditUI.this.setSeqUnitFilter(true);
                if (MaterialEditUI.this.prmtSeqUnit.getValue() != null) {
                    MaterialEditUI.this.prmtSeqUnit.removeDataChangeListener((DataChangeListener)MaterialEditUI.this.seqListener);
                    MaterialEditUI.this.prmtSeqUnit.setValue(null);
                    MaterialEditUI.this.prmtSeqUnit.requestFocus();
                    MaterialEditUI.this.prmtSeqUnit.addDataChangeListener((DataChangeListener)MaterialEditUI.this.seqListener);
                }
            }
        }

        public void preChange(PreChangeEvent e) {
            Object source = e.getSource();
            if (source != null && source.equals(MaterialEditUI.this.prmtSeqUnit) && !MaterialEditUI.this.checkHasBaseInfo()) {
                e.setResult(0);
                return;
            }
        }
    }
}

