/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fi.gl.client.ClientHelper;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupException;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.client.AbstractMaterialGroupEditUI;
import com.kingdee.eas.basedata.master.material.client.F7BaseSelector;
import com.kingdee.eas.basedata.master.material.client.F7MaterialGroupUI;
import com.kingdee.eas.basedata.master.material.client.MaterialClientTools;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComboBox;

public class MaterialGroupEditUI
extends AbstractMaterialGroupEditUI {
    private MaterialGroupStandardInfo defaultGroupStandardInfo = null;
    private MaterialGroupInfo defaultGroupInfo = null;
    private ItemListener groupStandardListener;
    private CtrlUnitInfo curCtrlUnitInfo;

    @Override
    public void loadFields() {
        if (this.groupStandardListener != null) {
            this.comboMaterialGroupStandard.removeItemListener(this.groupStandardListener);
        }
        super.loadFields();
        this.comboMaterialGroupStandard.setEnabled(true);
        ClientHelper.setComboBoxSelectByUUid((JComboBox)this.comboMaterialGroupStandard, (ObjectBaseInfo)this.editData.getGroupStandard());
        this.prmtParent.setSelectorCollection(this.getSelectors());
        try {
            this.loadGroupStandard();
            this.loadParentData();
        }
        catch (Exception er) {
            super.handUIException((Throwable)er);
        }
        this.comboMaterialGroupStandard.addItemListener(this.groupStandardListener);
        this.loadDeletedStatus();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initContextOrg() {
        this.initUIMainOrgContext(this.curCtrlUnitInfo.getId().toString());
    }

    public void onLoad() throws Exception {
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get("CurrentCtrlUnit");
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.ccStrategy.setCurrentCUID(this.curCtrlUnitInfo.getId().toString());
        super.onLoad();
        this.hiddenButton();
        this.mltName.getEditorComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.setUpTitle();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getId() != null && this.editData.getDeletedStatus() == DeletedStatusEnum.DELETED) {
            throw new MaterialGroupException(MaterialGroupException.UNPPROVE_NOT_CHANGE);
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getId() != null && this.editData.getDeletedStatus() == DeletedStatusEnum.DELETED) {
            throw new MaterialGroupException(MaterialGroupException.UNPPROVE_NOT_CHANGE);
        }
        super.actionSubmit_actionPerformed(e);
    }

    private void loadGroupStandard() throws Exception {
        if (this.getUIContext().containsKey("materialStandard")) {
            this.defaultGroupStandardInfo = (MaterialGroupStandardInfo)this.getUIContext().get("materialStandard");
        }
        if (this.groupStandardListener == null) {
            this.groupStandardListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MaterialGroupEditUI.this.itemChanaged(e);
                }
            };
        }
        this.comboMaterialGroupStandard.removeAllItems();
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)this.curCtrlUnitInfo.getId().toString(), (String)this.curCtrlUnitInfo.getLongNumber());
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfoCU);
        IMaterialGroupStandard iMaterialgroupstandard = MaterialGroupStandardFactory.getRemoteInstance();
        MaterialGroupStandardCollection stds = iMaterialgroupstandard.getMaterialGroupStandardCollection(viewInfo);
        if (stds != null) {
            this.comboMaterialGroupStandard.addItems(stds.toArray());
        }
        if (this.editData.getGroupStandard() != null) {
            MaterialGroupEditUI.setSelectedById(this.comboMaterialGroupStandard, this.editData.getGroupStandard());
        }
    }

    public static void setSelectedById(KDComboBox list, Object v) {
        if (v == null || list.getItemCount() == 0) {
            return;
        }
        String srcId = null;
        String targId = null;
        CoreBaseInfo coreObject = null;
        if (v instanceof CoreBaseInfo) {
            coreObject = (CoreBaseInfo)v;
            srcId = coreObject.getId().toString();
        } else {
            srcId = v.toString();
        }
        Object o = null;
        int count = list.getItemCount();
        for (int i = 0; i < count; ++i) {
            o = list.getItemAt(i);
            if (o == null) continue;
            if (o instanceof CoreBaseInfo) {
                coreObject = (CoreBaseInfo)o;
                targId = coreObject.getId().toString();
            } else {
                targId = o.toString();
            }
            if (!srcId.equalsIgnoreCase(targId)) continue;
            list.setSelectedIndex(i);
        }
    }

    protected void itemChanaged(ItemEvent e) {
        this.prmtParent.setData(null);
        this.loadParentData();
    }

    protected void loadParentData() {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("level"));
        view.getSelector().add(new SelectorItemInfo("description"));
        view.getSelector().add(new SelectorItemInfo("groupStandard.id"));
        view.getSelector().add(new SelectorItemInfo("groupStandard.name"));
        view.getSelector().add(new SelectorItemInfo("groupStandard.number"));
        view.getSelector().add(new SelectorItemInfo("parent.number"));
        view.getSelector().add(new SelectorItemInfo("parent.name"));
        this.prmtParent.setQueryInfo("com.kingdee.eas.basedata.master.material.app.MaterialGroupQuery");
        this.prmtParent.setDisplayFormat("$number$($name$)");
        this.prmtParent.setCommitFormat("$number$");
        this.prmtParent.setEditFormat("$number$");
        if (this.comboMaterialGroupStandard.getSelectedItem() != null) {
            MaterialGroupStandardInfo standardInfo = (MaterialGroupStandardInfo)this.comboMaterialGroupStandard.getSelectedItem();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard.id", (Object)standardInfo.getId().toString()));
            if (!MaterialInfo.isAllowNonLeafGroup()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
            }
            view.setFilter(filterInfo);
        }
        this.prmtParent.setEntityViewInfo(view);
        UIContext ctx = new UIContext((Object)this);
        MaterialGroupStandardInfo standardInfo = (MaterialGroupStandardInfo)this.comboMaterialGroupStandard.getSelectedItem();
        ctx.put((Object)"groupStandard", (Object)standardInfo);
        ctx.put((Object)"cu", (Object)this.curCtrlUnitInfo);
        F7BaseSelector f7Selector = new F7BaseSelector(F7MaterialGroupUI.class, this.prmtParent, ctx);
        this.prmtParent.setSelector((KDPromptSelector)f7Selector);
    }

    @Override
    public void actionCancelCus_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    public void hiddenButton() {
        this.btnAddNew.setVisible(true);
        this.btnSubmit.setVisible(true);
        this.btnCopy.setVisible(true);
        this.btnFirst.setVisible(true);
        this.btnNext.setVisible(true);
        this.btnLast.setVisible(true);
        this.btnPre.setVisible(true);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnSave.setVisible(false);
    }

    @Override
    protected IObjectValue createNewData() {
        MaterialGroupInfo materialGroupInfo = new MaterialGroupInfo();
        this.comboMaterialGroupStandard.setEnabled(true);
        this.prmtParent.setData(null);
        this.defaultGroupStandardInfo = (MaterialGroupStandardInfo)this.getUIContext().get("materialStandard");
        try {
            if (this.getUIContext().get("materialBrownseGroup") != null) {
                IMaterialGroup imaterial = MaterialGroupFactory.getRemoteInstance();
                try {
                    this.defaultGroupInfo = (MaterialGroupInfo)imaterial.getValue("select *,groupStandard.* where id='" + ((MaterialGroupInfo)this.getUIContext().get("materialBrownseGroup")).getId().toString() + "'");
                    this.defaultGroupStandardInfo = this.defaultGroupInfo == null ? null : this.defaultGroupInfo.getGroupStandard();
                }
                catch (ObjectNotFoundException e) {
                    this.defaultGroupInfo = (MaterialGroupInfo)this.getUIContext().get("materialBrownseGroup");
                }
            }
            materialGroupInfo.setParent(this.defaultGroupInfo);
            materialGroupInfo.setGroupStandard(this.defaultGroupStandardInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        materialGroupInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
        materialGroupInfo.setCU(this.curCtrlUnitInfo);
        return materialGroupInfo;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MaterialGroupFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    private void setUpTitle() {
        MaterialClientTools.setupUITitle((CoreUIObject)this, EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"MaterialGroup"));
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("deletedStatus"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("groupStandard.*"));
        sic.add(new SelectorItemInfo("cu.id"));
        sic.add(new SelectorItemInfo("cu.number"));
        sic.add(new SelectorItemInfo("cu.name"));
        return sic;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        if ("ADDNEW".equals(this.getOprtState()) && ((MaterialGroupInfo)dataObject).getParent() == null) {
            ((MaterialGroupInfo)dataObject).setParent((MaterialGroupInfo)this.getUIContext().get("ParentNode"));
        }
        super.setDataObject(dataObject);
    }

    protected JButton getDefaultButton() {
        return this.btnAddNew;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String number = this.editData.getNumber();
        if (number == null || number.trim().length() == 0) {
            this.txtNumber.requestFocus();
            throw new MaterialGroupException(MaterialGroupException.GROUPNUMBER_NOT_NULL);
        }
        if (number.indexOf(33) > -1) {
            this.txtNumber.requestFocus();
            throw new MaterialGroupException(MaterialGroupException.NUM_SPECIAL_SYM);
        }
        String name = this.editData.getName();
        if (name == null || name.trim().length() == 0) {
            this.mltName.requestFocus();
            throw new MaterialGroupException(MaterialGroupException.GROUPNAME_NOT_NULL);
        }
        super.verifyInput(e);
    }

    protected boolean getIsNumberDupCheckAppliedForS4Tree() {
        return true;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setCU(this.curCtrlUnitInfo);
        super.actionCopy_actionPerformed(e);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("EDIT".equals(this.getOprtState())) {
            this.prmtParent.setEnabled(false);
        }
        if ("ADDNEW".equals(this.getOprtState())) {
            this.prmtParent.setEnabled(true);
        }
    }

    private void loadDeletedStatus() {
        this.kDComDeletedStatus.addItems(DeletedStatusEnum.getEnumList().toArray());
        this.kDComDeletedStatus.setSelectedItem((Object)this.editData.getDeletedStatus());
        this.setCancelControl();
    }

    private void setCancelControl() {
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.btnCancel.setVisible(false);
            this.actionCancel.setEnabled(false);
            this.btnCancelCancel.setVisible(false);
            this.actionCancelCancel.setEnabled(false);
        } else if (this.editData.getDeletedStatus().equals((Object)DeletedStatusEnum.NORMAL)) {
            this.btnCancel.setVisible(true);
            this.actionCancel.setEnabled(true);
            this.btnCancelCancel.setVisible(false);
            this.actionCancelCancel.setEnabled(false);
        } else {
            this.btnCancel.setVisible(false);
            this.actionCancel.setEnabled(false);
            this.btnCancelCancel.setVisible(true);
            this.actionCancelCancel.setEnabled(true);
        }
    }

    protected void checkCU() throws Exception {
        if (!this.curCtrlUnitInfo.equalsPK((IObjectValue)this.editData.getCU())) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkCU();
        ((IMaterialGroup)this.getBizInterface()).unapprove((IObjectValue)this.editData);
        this.editData.setDeletedStatus(DeletedStatusEnum.DELETED);
        this.loadData();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkCU();
        ((IMaterialGroup)this.getBizInterface()).approve((IObjectValue)this.editData);
        this.editData.setDeletedStatus(DeletedStatusEnum.NORMAL);
        this.loadData();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        this.prmtParent.setValue(null);
    }

    protected String getCurrentCUID() {
        if (this.curCtrlUnitInfo == null) {
            this.handUIException(new BOSException("curCtrlUnitInfo cannot be null here"));
            SysUtil.abort();
        }
        return this.curCtrlUnitInfo.getId().toString();
    }

    protected void showSubmitSuccess() {
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
    }
}

