/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.client.AssistantClientUtils;
import com.kingdee.eas.basedata.common.BasedataSysException;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.master.material.client.AbstractMaterialGroupStandardEditUI;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class MaterialGroupStandardEditUI
extends AbstractMaterialGroupStandardEditUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialGroupStandardEditUI.class);
    private static final String defaultCU = "00000000-0000-0000-0000-000000000000CCE7AED4";
    private static final String CTRL_UNIT_STAT = "CurrentCtrlUnit";
    private CtrlUnitInfo curCtrlUnitInfo;

    @Override
    public void loadFields() {
        super.loadFields();
        this.hideUnuseableButtons();
        super.initOldData((IObjectValue)this.editData);
    }

    protected void initContextOrg() {
        this.initUIMainOrgContext(this.curCtrlUnitInfo.getId().toString());
        this.ccStrategy.setCurrentCUID(this.curCtrlUnitInfo.getId().toString());
    }

    public void onLoad() throws Exception {
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get(CTRL_UNIT_STAT);
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        super.onLoad();
        AssistantClientUtils.setupUITitle((CoreUIObject)this, (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"MaterialGroupStandardListTitle"));
        this.initStandardType();
        this.initControls();
    }

    private void initStandardType() {
        if (this.editData.getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard)) {
            return;
        }
        this.comboStandardType.removeItem((Object)MaterialGroupStandardTypeEnum.BasicStandard);
    }

    private void initControls() {
        if (this.editData.getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard)) {
            this.txtNumber.setEditable(false);
            this.comboStandardType.setEnabled(false);
        } else {
            this.txtNumber.setEditable(true);
            this.comboStandardType.setEnabled(true);
        }
        if (this.getOprtState().equals(OprtState.VIEW) && !this.curCtrlUnitInfo.getId().toString().equals(this.editData.getCU().getId().toString())) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnCopy.setEnabled(false);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void hideUnuseableButtons() {
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnPageSetup.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnSave.setVisible(false);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"CannotDeleteBaseStandard"));
        } else {
            if (!this.editData.getCU().getId().toString().equals(this.curCtrlUnitInfo.getId().toString())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"CannotDeleteStandardAtShiUnit"));
                return;
            }
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            PerminsionUtil.checkCUPerminsion(this.curCtrlUnitInfo.getId().toString(), userId, "materialgroupstd_delete");
            super.actionRemove_actionPerformed(e);
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"CannotCopyBaseStandard"));
            return;
        }
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        PerminsionUtil.checkCUPerminsion(this.curCtrlUnitInfo.getId().toString(), userId, "materialgroupstd_addnew");
        this.editData.setCU(this.curCtrlUnitInfo);
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        PerminsionUtil.checkCUPerminsion(this.curCtrlUnitInfo.getId().toString(), userId, "materialgroupstd_addnew");
        super.actionAddNew_actionPerformed(e);
        this.comboStandardType.removeItem((Object)MaterialGroupStandardTypeEnum.BasicStandard);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard) && !SysContext.getSysContext().getCurrentCtrlUnit().getId().toString().equals(defaultCU)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"BasicGroupStandardMainByRoot"));
            return;
        }
        if (!this.editData.getCU().getId().toString().equals(this.curCtrlUnitInfo.getId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"CannotEditStandardAtShiUnit"));
            return;
        }
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        PerminsionUtil.checkCUPerminsion(this.curCtrlUnitInfo.getId().toString(), userId, "materialgroupstd_update");
        super.actionEdit_actionPerformed(e);
        this.initControls();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        MaterialGroupStandardInfo materialGroupStandardInfo = new MaterialGroupStandardInfo();
        materialGroupStandardInfo.setStandardType(MaterialGroupStandardTypeEnum.DefaultStandard);
        return materialGroupStandardInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MaterialGroupStandardFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        ((MaterialGroupStandardInfo)newData).setNumber(null);
        ((MaterialGroupStandardInfo)newData).setName(null);
        ((MaterialGroupStandardInfo)newData).setStandardType(MaterialGroupStandardTypeEnum.DefaultStandard);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        MaterialGroupStandardCollection coll;
        BasedataSysException baseException = null;
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().equals("")) {
            baseException = new BasedataSysException(BasedataSysException.NUMBER_IS_EMPTY);
            MsgBox.showInfo((String)baseException.getMessage());
            SysUtil.abort();
        }
        if (AssistantClientUtils.isMultiLangBoxInputNameEmpty((KDBizMultiLangBox)this.txtName, (IObjectValue)new CSSPGroupStandardInfo(), (String)"name")) {
            baseException = new BasedataSysException(BasedataSysException.NAME_IS_EMPTY);
            MsgBox.showInfo((String)baseException.getMessage());
            SysUtil.abort();
        }
        if (this.txtDescription.getSelectedItem() != null && this.txtDescription.getSelectedItem().toString().length() > 255) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"DecriptionCannotBeSoLong"));
            SysUtil.abort();
        }
        if (this.comboStandardType.getSelectedItem().equals((Object)MaterialGroupStandardTypeEnum.NetOrderType) && (coll = ((IMaterialGroupStandard)this.getBizInterface()).getNetOrderTypeStandardColl(this.editData)).size() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MATERIALAutoGenerateResource", (String)"7_MaterialGroupStandardEditUI"));
            SysUtil.abort();
        }
    }

    protected String getCurrentCUID() {
        String currentCUID = null;
        if (this.curCtrlUnitInfo != null) {
            currentCUID = this.curCtrlUnitInfo.getId().toString();
        }
        if (currentCUID == null) {
            currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        return currentCUID;
    }
}

