/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardTypeEnum;
import com.kingdee.eas.basedata.master.material.PerminsionUtil;
import com.kingdee.eas.basedata.master.material.client.AbstractMaterialGroupStandardListUI;
import com.kingdee.eas.basedata.master.material.client.MaterialGroupStandardEditUI;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class MaterialGroupStandardListUI
extends AbstractMaterialGroupStandardListUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialGroupStandardListUI.class);
    private CtrlUnitInfo curCtrlUnitInfo = null;
    private static final String CTRL_UNIT_STAT = "CurrentCtrlUnit";

    protected void initContextOrg() {
        this.initUIMainOrgContext(this.curCtrlUnitInfo.getId().toString());
        this.setCurrentCUID(this.curCtrlUnitInfo.getId().toString());
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)CTRL_UNIT_STAT, (Object)this.curCtrlUnitInfo);
        super.prepareUIContext(uiContext, e);
    }

    public void onLoad() throws Exception {
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get(CTRL_UNIT_STAT);
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.getUIContext().put("IDList", null);
        super.onLoad();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"MaterialGroupStandardListTitle"));
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getEditUIName() {
        return MaterialGroupStandardEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MaterialGroupStandardFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    private MaterialGroupStandardInfo getMaterialGroupStandard() {
        String id = this.getSelectedKeyValue();
        MaterialGroupStandardInfo materialGroupStandardInfo = null;
        if (id != null) {
            try {
                ObjectStringPK pk = new ObjectStringPK(id);
                IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getRemoteInstance();
                materialGroupStandardInfo = iMaterialGroupStandard.getMaterialGroupStandardInfo((IObjectPK)pk);
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        }
        return materialGroupStandardInfo;
    }

    private boolean canEdit() {
        MaterialGroupStandardInfo groupStandardInfo = this.getMaterialGroupStandard();
        return groupStandardInfo.getStandardType() == null || !groupStandardInfo.getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        PerminsionUtil.checkCUPerminsion(this.curCtrlUnitInfo.getId().toString(), userId, "materialgroupstd_addnew");
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        MaterialGroupStandardInfo groupStandardInfo = this.getMaterialGroupStandard();
        if (groupStandardInfo != null && groupStandardInfo.getStandardType().equals((Object)MaterialGroupStandardTypeEnum.BasicStandard) && !this.curCtrlUnitInfo.getId().toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"BasicGroupStandardMainByRoot"));
            return;
        }
        if (groupStandardInfo != null && !groupStandardInfo.getCU().getId().toString().equals(this.curCtrlUnitInfo.getId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"CannotEditStandardAtShiUnit"));
            return;
        }
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        PerminsionUtil.checkCUPerminsion(this.curCtrlUnitInfo.getId().toString(), userId, "materialgroupstd_update");
        super.actionEdit_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.canEdit()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"CannotDeleteBaseStandard"));
            return;
        }
        MaterialGroupStandardInfo groupStandardInfo = this.getMaterialGroupStandard();
        if (groupStandardInfo != null && !groupStandardInfo.getCU().getId().toString().equals(this.curCtrlUnitInfo.getId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"CannotDeleteStandardAtShiUnit"));
            return;
        }
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        PerminsionUtil.checkCUPerminsion(this.curCtrlUnitInfo.getId().toString(), userId, "materialgroupstd_delete");
        super.actionRemove_actionPerformed(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)this.curCtrlUnitInfo.getId().toString(), (String)this.curCtrlUnitInfo.getLongNumber());
        return filterInfoCU;
    }
}

