/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IOtherParam;
import com.kingdee.eas.base.param.client.ICustomParamUI;
import com.kingdee.eas.basedata.master.material.IMaterialOtherParameter;
import com.kingdee.eas.basedata.master.material.MaterialOtherParameterCollection;
import com.kingdee.eas.basedata.master.material.MaterialOtherParameterFactory;
import com.kingdee.eas.basedata.master.material.MaterialOtherParameterInfo;
import com.kingdee.eas.basedata.master.material.client.AbstractMaterialParameterSetUI;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MaterialParameterSetUI
extends AbstractMaterialParameterSetUI
implements IOtherParam,
ICustomParamUI,
ChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(MaterialParameterSetUI.class);
    private CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
    private MaterialOtherParameterInfo currentMaterialParameterInfo = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void otherParamSave() throws BOSException, EASBizException {
        IMaterialOtherParameter iMaterialParameter = this.getBizInterface();
        MaterialOtherParameterInfo ov = this.getParaValue();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu", (Object)this.cuInfo.getId(), CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        if (iMaterialParameter.exists(filter)) {
            MaterialOtherParameterCollection collection = iMaterialParameter.getMaterialOtherParameterCollection(entityViewInfo);
            ov.setId(collection.get(0).getId());
            iMaterialParameter.submit(ov);
        } else {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.create((String)"A758C816"));
            iMaterialParameter.submit((IObjectPK)pk, ov);
        }
    }

    public MaterialOtherParameterInfo getParaValue() {
        MaterialOtherParameterInfo paraInfo = this.currentMaterialParameterInfo;
        if (paraInfo == null) {
            paraInfo = new MaterialOtherParameterInfo();
        }
        paraInfo.setCu(this.cuInfo);
        boolean boolValue = false;
        boolValue = this.kdCheckName.isSelected();
        paraInfo.setNameSelected(boolValue);
        boolValue = this.kdCheckEngName.isSelected();
        paraInfo.setEnglishSelected(boolValue);
        boolValue = this.kdCheckHelpCode.isSelected();
        paraInfo.setHelpSelected(boolValue);
        boolValue = this.kdCheckMode.isSelected();
        paraInfo.setModeSelected(boolValue);
        boolValue = this.kdCheckBarCode.isSelected();
        paraInfo.setBarCodeSelected(boolValue);
        boolValue = this.kdCheckNameAndMode.isSelected();
        paraInfo.setMameAndMode(boolValue);
        boolValue = this.kdRadioCannotSave.isSelected();
        paraInfo.setIsNotSaved(boolValue);
        boolValue = this.cbCUUniqueMaterial.isSelected();
        paraInfo.setCuUniqueSelected(boolValue);
        return paraInfo;
    }

    public void sendOrgInfo(OrgType orgType, OrgUnitInfo orgUnit, OrgTreeInfo orgTree) {
        if (orgType.getValue() != 10) {
            return;
        }
        if (orgUnit == null || orgUnit.getId() == null) {
            return;
        }
        this.cuInfo = new CtrlUnitInfo();
        this.cuInfo.setId(orgUnit.getId());
        try {
            this.loadFields();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadFields();
        this.addStateChangeListeners();
    }

    private void initControls() {
        this.kdCheckName.setSelected(this.currentMaterialParameterInfo.isNameSelected());
        this.kdCheckEngName.setSelected(this.currentMaterialParameterInfo.isEnglishSelected());
        this.kdCheckHelpCode.setSelected(this.currentMaterialParameterInfo.isHelpSelected());
        this.kdCheckMode.setSelected(this.currentMaterialParameterInfo.isModeSelected());
        this.kdCheckBarCode.setSelected(this.currentMaterialParameterInfo.isBarCodeSelected());
        this.kdCheckNameAndMode.setSelected(this.currentMaterialParameterInfo.isMameAndMode());
        this.cbCUUniqueMaterial.setSelected(this.currentMaterialParameterInfo.isCuUniqueSelected());
        if (this.currentMaterialParameterInfo.isIsNotSaved()) {
            this.kdRadioNotice.setSelected(false);
            this.kdRadioCannotSave.setSelected(true);
        } else {
            this.kdRadioNotice.setSelected(true);
            this.kdRadioCannotSave.setSelected(false);
        }
    }

    private void addStateChangeListeners() {
        this.kdCheckName.addChangeListener((ChangeListener)this);
        this.kdCheckMode.addChangeListener((ChangeListener)this);
        this.kdCheckNameAndMode.addChangeListener((ChangeListener)this);
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        if (arg0.getSource() == this.kdCheckName && this.kdCheckName.isSelected()) {
            this.kdCheckNameAndMode.setSelected(false);
        }
        if (arg0.getSource() == this.kdCheckMode && this.kdCheckMode.isSelected()) {
            this.kdCheckNameAndMode.setSelected(false);
        }
        if (arg0.getSource() == this.kdCheckNameAndMode && this.kdCheckNameAndMode.isSelected()) {
            this.kdCheckName.setSelected(false);
            this.kdCheckMode.setSelected(false);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.getMaterialOtherParamInfo(this.cuInfo);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
        this.initControls();
    }

    private void getMaterialOtherParamInfo(CtrlUnitInfo cu) throws BOSException, EASBizException {
        IMaterialOtherParameter iMaterialParameter = this.getBizInterface();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu", (Object)cu.getId(), CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        if (iMaterialParameter.exists(filter)) {
            MaterialOtherParameterCollection collection = iMaterialParameter.getMaterialOtherParameterCollection(entityViewInfo);
            this.currentMaterialParameterInfo = collection.get(0);
        } else {
            this.currentMaterialParameterInfo = this.setDefaultValue();
        }
    }

    private MaterialOtherParameterInfo setDefaultValue() {
        return MaterialOtherParameterInfo.getDefaultParam();
    }

    private IMaterialOtherParameter getBizInterface() throws BOSException {
        IMaterialOtherParameter iMaterialParameter = MaterialOtherParameterFactory.getRemoteInstance();
        return iMaterialParameter;
    }
}

