/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.extendcontrols.event.DataReadyEvent;
import com.kingdee.bos.ctrl.extendcontrols.event.DataReadyListener;
import com.kingdee.bos.ctrl.extendcontrols.icons.ResourceManager;
import com.kingdee.bos.ctrl.extendcontrols.util.BosHelper;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.master.material.client.AbstractMaterialPropertyListUI;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.cache.CacheService;
import com.kingdee.eas.framework.cache.EntityViewPK;
import com.kingdee.eas.framework.cache.ICacheable;
import com.kingdee.eas.framework.cache.IDataPK;
import com.kingdee.eas.framework.cache.QueryCacheObject;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;

public class MaterialPropertyListUI
extends AbstractMaterialPropertyListUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialPropertyListUI.class);
    protected IMetaDataPK mainQueryPK;
    protected QueryInfo queryInfo;
    private IQueryExecutor queryExecutor;
    private boolean isOrderBy = false;
    protected IRowSet rowSet;
    private EntityViewInfo entityViewInfo;
    protected EntityViewInfo innerFilter = new EntityViewInfo();
    private boolean refresh = true;
    private boolean useCacheObject = false;
    private boolean refreshCache = false;
    private EventListenerList listenerList = new EventListenerList();

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refreshData(true);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.dataFilter();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.table.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.table);
        this.table.getPrintManager().printPreview();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initToolbar();
        this.btnRefresh.setEnabled(true);
        this.initControls();
    }

    public void refresh() {
        this.table.setRefresh(false);
        this.clearTable();
        this.fillTable();
        this.fireAfterDataReady(new DataReadyEvent((Object)this, this.table, this.queryInfo));
        this.table.setRefresh(true);
        this.table.refresh();
        this.setRefresh(false);
    }

    public void refreshData(boolean refreshCache) {
        this.refreshCache = refreshCache;
        this.table.removeRows();
        this.refreshCache = false;
    }

    void fireAfterDataReady(DataReadyEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataReadyListener.class) continue;
            ((DataReadyListener)listeners[i + 1]).afterDataReady(e);
        }
    }

    private void initToolbar() {
        Icon filterIcon;
        Icon printReviewIcon;
        Icon printIcon;
        Icon refreshIcon = this.getMLIcon("refresh.gif");
        if (refreshIcon != null) {
            this.btnRefresh.setIcon(refreshIcon);
        }
        if ((printIcon = this.getMLIcon("print.gif")) != null) {
            this.btnPrint.setIcon(printIcon);
        }
        if ((printReviewIcon = this.getMLIcon("printpreview.gif")) != null) {
            this.btnPrintPreview.setIcon(printReviewIcon);
        }
        if ((filterIcon = this.getMLIcon("filter.gif")) != null) {
            this.btnQuery.setIcon(filterIcon);
        }
    }

    private void initControls() {
        KDTableHelper.releaseEnterAndTab((JComponent)this.table);
        KDTableHelper.releaseEsc((JComponent)this.table);
        this.table.getDataRequestManager().setDataRequestMode(1);
        this.table.getStyleAttributes().setLocked(true);
        this.table.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                MaterialPropertyListUI.this.kdtTable_doRequestRowSet(e);
            }
        });
    }

    private void clearTable() {
        this.table.removeColumns();
    }

    private void fillTable() {
        QueryFieldInfo field;
        if (this.queryInfo == null) {
            throw new IllegalArgumentException("QueryInfo can not be null!");
        }
        SelectorInfo selector = this.queryInfo.getSelector();
        int size = selector.getFields().size();
        String[] bindContents = new String[size];
        Map exProperties = this.queryInfo.getExtendedProperties();
        for (int i = 0; i < size; ++i) {
            IColumn col = this.table.addColumn(i);
            field = (QueryFieldInfo)selector.getFields().get(i);
            exProperties = field.getExtendedProperties();
            bindContents[i] = field.getName();
            col.setKey(bindContents[i]);
            if (exProperties == null) continue;
            Object visible = exProperties.get("isVisibleForKDTable");
            if (visible instanceof Boolean) {
                col.getStyleAttributes().setHided((Boolean)visible == false);
            } else if (visible instanceof String) {
                col.getStyleAttributes().setHided(!KDCommonPromptDialog.stringToboolean((String)((String)visible)));
            }
            Object colWidth = exProperties.get("ColWidthInKDTable");
            if (colWidth == null) {
                colWidth = exProperties.get("colWidthInKDTable");
            }
            if (colWidth instanceof Integer) {
                col.setWidth(((Integer)colWidth).intValue());
            } else if (colWidth instanceof String) {
                col.setWidth(KDCommonPromptDialog.stringToint((String)((String)colWidth)));
            }
            if (field.getName().equals("number")) {
                col.setWidth(100);
                continue;
            }
            if (!field.getName().equals("name")) continue;
            col.setWidth(200);
        }
        this.table.putBindContents("query", bindContents);
        this.table.setFormatXml("");
        this.table.checkParsed(true);
        IRow row = this.table.addHeadRow();
        for (int i = 0; i < size; ++i) {
            field = (QueryFieldInfo)selector.getFields().get(i);
            String displayName = field.getDisplayName(SysContext.getSysContext().getOriginLocale());
            row.getCell(i).setValue((Object)displayName);
        }
    }

    protected void kdtTable_doRequestRowSet(RequestRowSetEvent e) {
        int start = (Integer)e.getParam1();
        int length = (Integer)e.getParam2() - start + 1;
        if (this.rowSet != null) {
            e.setRowSet(this.rowSet);
            this.rowSet = null;
        } else {
            MetaDataPK metaDataPK;
            IRowSet rowSetTemp = null;
            EntityViewInfo filter = this.getEntityViewInfo();
            if (start == 0 && this.isUseCacheObject()) {
                Object obj;
                metaDataPK = new MetaDataPK(this.queryInfo.getPackage(), this.queryInfo.getName());
                EntityViewPK entityViewPK = null;
                if (filter == null) {
                    obj = CacheService.getCacheObject((IMetaDataPK)metaDataPK, (boolean)this.refreshCache);
                } else {
                    entityViewPK = new EntityViewPK(filter);
                    obj = CacheService.getCacheObject((IMetaDataPK)metaDataPK, (IDataPK)entityViewPK, (boolean)this.refreshCache);
                }
                if (obj != null) {
                    rowSetTemp = (IRowSet)obj;
                    e.setRowSet(rowSetTemp);
                } else {
                    QueryCacheObject qco = new QueryCacheObject((IMetaDataPK)metaDataPK, (IDataPK)entityViewPK);
                    CacheService.addTmpCacheObject((ICacheable)qco);
                    obj = CacheService.getCacheObject((IMetaDataPK)metaDataPK, (IDataPK)entityViewPK);
                    if (obj != null) {
                        rowSetTemp = (IRowSet)obj;
                        e.setRowSet(rowSetTemp);
                    }
                }
            }
            if (rowSetTemp == null) {
                try {
                    this.queryExecutor = this.getQueryExecutor(this.mainQueryPK, this.entityViewInfo);
                    if (this.queryExecutor == null) {
                        metaDataPK = new MetaDataPK(this.queryInfo.getPackage(), this.queryInfo.getName());
                        this.queryExecutor = BosHelper.createQueryExecutor((MetaDataPK)metaDataPK);
                    }
                    if (filter != null && filter.getSorter() != null && filter.getSorter().size() > 0) {
                        this.queryExecutor.option().isIgnoreOrder = true;
                    }
                    this.queryExecutor.setObjectView(filter);
                    IRowSet rowSet = this.queryExecutor.executeQuery(start, length);
                    e.setRowSet(rowSet);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public boolean isUseCacheObject() {
        return this.useCacheObject;
    }

    public void setUseCacheObject(boolean useCacheObject) {
        this.useCacheObject = useCacheObject;
    }

    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    public void setQueryInfo(String queryFullName) {
        QueryInfo queryInfo;
        this.mainQueryPK = new MetaDataPK(queryFullName);
        this.queryInfo = queryInfo = MaterialPropertyListUI.getQueryInfo(this.mainQueryPK);
        this.setRefresh(true);
    }

    public static QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery(queryPK);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isIgnoreOrder = this.isOrderBy;
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    public void setEntityViewInfo(EntityViewInfo info) {
        this.entityViewInfo = info;
        this.setRefresh(true);
    }

    public EntityViewInfo getEntityViewInfo() {
        EntityViewInfo returnViewInfo = null;
        if (this.entityViewInfo != null) {
            try {
                returnViewInfo = new EntityViewInfo(this.entityViewInfo.toString());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (this.entityViewInfo.getFilter() != null) {
                if (this.entityViewInfo.getFilter().getFilterItems() != null) {
                    if (this.entityViewInfo.getFilter().getFilterItems().size() > 0) {
                        if (this.innerFilter != null && this.innerFilter.getFilter() != null && this.innerFilter.getFilter().getFilterItems() != null && this.innerFilter.getFilter().getFilterItems().size() > 0) {
                            try {
                                returnViewInfo.getFilter().mergeFilter(this.innerFilter.getFilter(), "and");
                            }
                            catch (BOSException e) {}
                        }
                    } else if (this.innerFilter != null && this.innerFilter.getFilter() != null && this.innerFilter.getFilter().getFilterItems() != null && this.innerFilter.getFilter().getFilterItems().size() > 0) {
                        try {
                            returnViewInfo = new EntityViewInfo(this.innerFilter.toString());
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle((Throwable)e);
                        }
                    }
                } else if (this.innerFilter != null && this.innerFilter.getFilter() != null && this.innerFilter.getFilter().getFilterItems() != null && this.innerFilter.getFilter().getFilterItems().size() > 0) {
                    try {
                        returnViewInfo = new EntityViewInfo(this.innerFilter.toString());
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
            } else if (this.innerFilter != null && this.innerFilter.getFilter() != null && this.innerFilter.getFilter().getFilterItems() != null && this.innerFilter.getFilter().getFilterItems().size() > 0) {
                try {
                    returnViewInfo = new EntityViewInfo(this.innerFilter.toString());
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        } else if (this.innerFilter != null) {
            try {
                returnViewInfo = new EntityViewInfo(this.innerFilter.toString());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (returnViewInfo != null && this.innerFilter != null && returnViewInfo.getSorter() != null && this.innerFilter.getSorter() != null) {
            returnViewInfo.getSorter().clear();
            int j = this.innerFilter.getSorter().size();
            for (int i = 0; i < j; ++i) {
                returnViewInfo.getSorter().add(this.innerFilter.getSorter().get(i));
            }
        }
        return returnViewInfo;
    }

    protected void dataFilter() {
        if (this.queryInfo == null) {
            return;
        }
        Object tempViewInfo = null;
        CommonQueryDialog cqd = new CommonQueryDialog();
        cqd.setOwner((Component)((Object)this));
        cqd.setQueryObjectPK((IMetaDataPK)new MetaDataPK(this.queryInfo.getPackage(), this.queryInfo.getName()));
        cqd.setWidth(480);
        cqd.setParentUIClassName("CommonF7_" + this.queryInfo.getFullName());
        if (this.innerFilter != null) {
            cqd.setEntityViewInfo(this.innerFilter);
        }
        if (cqd.show()) {
            this.innerFilter = cqd.getEntityViewInfoResult();
            this.rowSet = null;
            this.refreshData(true);
        }
    }

    private Icon getMLIcon(String key) {
        Image bi = ResourceManager.getBufferedImage((String)key);
        if (bi != null) {
            return new ImageIcon(bi);
        }
        return null;
    }
}

