/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.eas.basedata.master.cssp.CSSPUtils;
import com.kingdee.eas.basedata.master.material.AbstractMaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.BatchPolicyEnum;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.PlanningModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Locale;

public class MaterialInventoryInfo
extends AbstractMaterialInventoryInfo
implements Serializable {
    public static final int HALF_UP = 4;
    public static final BigDecimal BigDecimal_0 = new BigDecimal("0");
    public static final BigDecimal MAX_DEFAULT = new BigDecimal(Integer.MAX_VALUE);
    public static final BigDecimal MAX_CHEAP_RATE = new BigDecimal("100");
    public static final int PRECISION_CHEAP_RATE = 4;

    public MaterialInventoryInfo() {
    }

    protected MaterialInventoryInfo(String pkField) {
        super(pkField);
    }

    @Override
    public PlanningModeEnum getPlanningMode() {
        return super.getPlanningMode();
    }

    @Override
    public void setPlanningMode(PlanningModeEnum item) {
        super.setPlanningMode(item);
    }

    @Override
    public BigDecimal getReBookQty() {
        return super.getReBookQty();
    }

    @Override
    public void setReBookQty(BigDecimal item) {
        super.setReBookQty(item);
    }

    @Override
    public BigDecimal getConsumeSpeed() {
        return super.getConsumeSpeed();
    }

    @Override
    public void setConsumeSpeed(BigDecimal item) {
        super.setConsumeSpeed(item);
    }

    @Override
    public int getPurchasingAheadDate() {
        return super.getPurchasingAheadDate();
    }

    @Override
    public void setPurchasingAheadDate(int item) {
        super.setPurchasingAheadDate(item);
    }

    @Override
    public BatchPolicyEnum getBatchPolicy() {
        return super.getBatchPolicy();
    }

    @Override
    public void setBatchPolicy(BatchPolicyEnum item) {
        super.setBatchPolicy(item);
    }

    @Override
    public BigDecimal getFixationBatchQty() {
        return super.getFixationBatchQty();
    }

    @Override
    public void setFixationBatchQty(BigDecimal item) {
        super.setFixationBatchQty(item);
    }

    public String getLogInfo() {
        Locale ctx = ContextUtils.getLocaleFromEnv();
        String resource = "com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource";
        String resourceKey = ResourceBase.getString((String)resource, (String)"IsNegative", (Locale)ctx, (Object[])new Object[]{this.isIsNegative()});
        return this.getMaterial().getNumber() + "\t   " + this.getMaterial().getName() + "\t   " + resourceKey;
    }

    public void verify() throws EASBizException, BOSException {
        block16: {
            BigDecimal value;
            block18: {
                block17: {
                    block15: {
                        if (this.isIsCheck() && this.getQualityOrg() == null) {
                            String propName = CSSPUtils.getPropertyAlias(null, (AbstractObjectValue)this, (String)"qualityOrg");
                            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{propName});
                        }
                        value = this.getDaysPlanTurnover();
                        if (value == null) {
                            this.setDaysPlanTurnover(BigDecimal_0);
                        } else {
                            if ((value = value.setScale(2, 4)).compareTo(BigDecimal_0) < 0 || value.compareTo(MAX_DEFAULT) > 0) {
                                value = BigDecimal_0;
                            }
                            this.setDaysPlanTurnover(value);
                        }
                        value = this.getCheapRate();
                        if (value != null) break block15;
                        this.setCheapRate(BigDecimal_0);
                        break block16;
                    }
                    if ((value = value.setScale(4, 4)).compareTo(BigDecimal_0) < 0) break block17;
                    if (value.compareTo(MAX_CHEAP_RATE) < 0) break block18;
                }
                throw new MaterialBaseException(MaterialBaseException.CHEAPRATE);
            }
            this.setCheapRate(value);
        }
        if (this.getQtySafety() != null && this.getQtySafety().doubleValue() <= 0.0 || this.getQtyMax() != null && this.getQtyMax().doubleValue() <= 0.0 || this.getQtyMin() != null && this.getQtyMin().doubleValue() <= 0.0) {
            throw new MaterialBaseException(MaterialBaseException.INVQTYINVALID);
        }
        if ((this.getQtySafety() != null || this.getQtyMax() != null || this.getQtyMin() != null) && this.getInvPlanner() == null) {
            throw new MaterialBaseException(MaterialBaseException.INVPLANNERINVALID);
        }
        if (this.getQtySafety() != null && this.getQtyMax() != null && this.getQtySafety().compareTo(this.getQtyMax()) > 0) {
            throw new MaterialBaseException(MaterialBaseException.INVQTY_INVALID3);
        }
        if (this.getQtySafety() != null && this.getQtyMin() != null && this.getQtySafety().compareTo(this.getQtyMin()) < 0) {
            throw new MaterialBaseException(MaterialBaseException.INVQTY_INVALID2);
        }
        if (this.getQtyMax() != null && this.getQtyMin() != null && this.getQtyMax().compareTo(this.getQtyMin()) < 0) {
            throw new MaterialBaseException(MaterialBaseException.INVQTY_INVALID1);
        }
        if (this.getDaysTurnover() < 0 || this.getDaysTop() < 0 || this.getDaysBottom() < 0 || this.getQtyMinPackage() != null && this.getQtyMinPackage().doubleValue() < 0.0) {
            throw new MaterialBaseException(MaterialBaseException.RANGEINVALID);
        }
        int periodValid = MaterialInventoryInfo.getDaysByTimeUnit(this.getPeriodValidUnit().getValue(), this.getPeriodValid());
        int inWarehsAhead = MaterialInventoryInfo.getDaysByTimeUnit(this.getAheadUnit().getValue(), this.getInWarehsAhead());
        int outWarehsAhead = MaterialInventoryInfo.getDaysByTimeUnit(this.getAheadUnit().getValue(), this.getOutWarehsAhead());
        int prepWarnAhead = MaterialInventoryInfo.getDaysByTimeUnit(this.getAheadUnit().getValue(), this.getPrepWarnAhead());
        if (periodValid < inWarehsAhead || periodValid < outWarehsAhead || periodValid < prepWarnAhead) {
            throw new MaterialBaseException(MaterialBaseException.MATINVPERIODVALIDINVALID);
        }
        if (this.getPlanningMode().equals((Object)PlanningModeEnum.REBOOKPOINT) && this.getQtySafety() == null) {
            throw new MaterialBaseException(MaterialBaseException.QTYSAFETYNOTNULL);
        }
    }

    public static int getDaysByTimeUnit(int timeUnitIntValue, int value) {
        switch (timeUnitIntValue) {
            case 3: {
                return value;
            }
            case 2: {
                return value * 30;
            }
            case 1: {
                return value * 365;
            }
        }
        return value;
    }
}

