/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.CSSPUtils;
import com.kingdee.eas.basedata.master.material.IUnAssign2Checker;
import com.kingdee.eas.basedata.master.material.MaterialAssitDataEnum;
import com.kingdee.eas.basedata.master.material.UnAssign2CheckResult;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.BizCheckerUtil;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.StringEnum;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UnAssignComp2ScmCheckerImpl
implements IUnAssign2Checker {
    private final String TABLE_NAME = "table_name";
    private final String ORG_FIELD = "org_field";

    public UnAssign2CheckResult unAssignCheck(Context ctx, String cuId, String[] orgIds, String[] dataIds, String dataSql, HashSet asstDataSet, Object BosType) throws EASBizException, BOSException {
        MaterialAssitDataEnum key = null;
        String tbl = null;
        HashMap<String, List> mkey = null;
        HashMap<String, List> ms = null;
        if (asstDataSet.size() == 0) {
            return null;
        }
        UnAssign2CheckResult result = new UnAssign2CheckResult();
        StringBuffer message = new StringBuffer();
        String orgnum = null;
        List matnums = null;
        String orgType = null;
        StringBuffer materialNumberStr = new StringBuffer();
        Iterator iterator = asstDataSet.iterator();
        while (iterator.hasNext()) {
            materialNumberStr.setLength(0);
            key = (MaterialAssitDataEnum)iterator.next();
            if (key == MaterialAssitDataEnum.PLAN || key == MaterialAssitDataEnum.COST || key == MaterialAssitDataEnum.PROFITCENTER) continue;
            mkey = new HashMap<String, List>();
            ms = new HashMap<String, List>();
            this.unAssignScmCheck(ctx, orgIds, dataIds, dataSql, BosType, mkey, ms, tbl, key);
            result.put((StringEnum)key, mkey);
            for (Map.Entry entry : ms.entrySet()) {
                orgnum = ((String)entry.getKey()).toString();
                matnums = (List)entry.getValue();
                orgType = key.getAlias(ctx.getLocale());
                for (int i = 0; i < matnums.size(); ++i) {
                    materialNumberStr.append(matnums.get(i));
                    if (i == matnums.size() - 1) continue;
                    materialNumberStr.append("\u3001");
                }
                if (key == MaterialAssitDataEnum.COMPANY) {
                    orgType = ResourceBase.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource", (String)"compayOrg", (Locale)ctx.getLocale());
                }
                message.append(ResourceBase.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource", (String)"materialHasRef", (Locale)ctx.getLocale(), (Object[])new Object[]{orgType, orgnum, materialNumberStr.toString()})).append("\n");
            }
        }
        if (message.length() == 0) {
            return null;
        }
        result.setErrorMessage(message.toString());
        return result;
    }

    private Map<String, List> unAssignScmCheck(Context ctx, String[] orgIds, String[] dataIds, String dataSql, Object bosType, Map<String, List> m, Map<String, List> ms, String tbl, MaterialAssitDataEnum type) throws BOSException, EASBizException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String mappingTableName = null;
        String mappingField = null;
        String materialTblname = null;
        String orgFieldName = null;
        if (!"4409E7F0".equals(bosType.toString())) {
            return m;
        }
        mappingTableName = "T_BD_MATERIAL";
        mappingField = "FMATERIALID";
        Map materialFieldsMap = this.getMaterialFields(type);
        materialTblname = (String)materialFieldsMap.get("table_name");
        orgFieldName = (String)materialFieldsMap.get("org_field");
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct inf.Fid id, inf.").append(orgFieldName).append(" keys ,bu.fnumber keynu,su.Fid vals,su.fnumber valsnu from ").append(materialTblname).append(" inf inner join ").append(mappingTableName).append(" su on inf.").append(mappingField).append(" = su.FID ").append("inner join t_org_baseunit bu on bu.fid = inf.").append(orgFieldName).append(" ");
        if (dataSql != null) {
            dataSql = dataSql.split("order by")[0];
            sql.append("inner join (" + dataSql + ") ma on ma.id = su.Fid ");
        }
        sql.append(" where inf.").append(orgFieldName).append(" in ").append(CSSPUtils.getIdsSql((String[])orgIds));
        if (dataIds != null && dataIds.length > 0 && dataSql == null) {
            sql.append(" and su.fid in ").append(CSSPUtils.getIdsSql((String[])dataIds));
        }
        if (dataIds != null && dataIds.length > 0 && dataSql != null) {
            sql.append(" and su.fid not in ").append(CSSPUtils.getIdsSql((String[])dataIds));
        }
        try {
            con = EJBFactory.getConnection((Context)ctx);
            stmt = con.prepareStatement(sql.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                String id = rs.getString("id");
                String cukey = rs.getString("keys");
                String cukeynu = rs.getString("keynu");
                String vals = rs.getString("vals");
                String valsnu = rs.getString("valsnu");
                BizCheckResult result = BizCheckerUtil.hasDeal((Context)ctx, (BOSUuid)BOSUuid.read((String)id));
                if (result.getDetailMap() == null) continue;
                if (m.containsKey(cukey)) {
                    if (m.get(cukey).contains(vals)) continue;
                    m.get(cukey).add(vals);
                    ms.get(cukeynu).add(valsnu);
                    continue;
                }
                ArrayList<String> dataList = new ArrayList<String>();
                ArrayList<String> msList = new ArrayList<String>();
                dataList.add(vals);
                msList.add(valsnu);
                m.put(cukey, dataList);
                ms.put(cukeynu, msList);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return m;
    }

    private Map getMaterialFields(MaterialAssitDataEnum type) {
        HashMap<String, String> resut = new HashMap<String, String>();
        String tableName = "t_bd_materialCompanyInfo";
        String orgFieldName = "FCOMPANYID";
        if (type == MaterialAssitDataEnum.PURCHASE) {
            tableName = "T_BD_MaterialPurchasing";
            orgFieldName = "FORGUNIT";
        }
        if (type == MaterialAssitDataEnum.COMPANY) {
            tableName = "t_bd_materialCompanyInfo";
            orgFieldName = "FCOMPANYID";
        }
        if (type == MaterialAssitDataEnum.SALE) {
            tableName = "T_BD_MaterialSales";
            orgFieldName = "FORGUNIT";
        }
        if (type == MaterialAssitDataEnum.INVENTORY) {
            tableName = "t_bd_materialinventory";
            orgFieldName = "FORGUNIT";
        }
        resut.put("table_name", tableName);
        resut.put("org_field", orgFieldName);
        return resut;
    }
}

