/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.material.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.scm.util.SCMF7ContextUtils;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.OrgRelationUtils;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.ABCEnum;
import com.kingdee.eas.basedata.master.material.BatchPolicyEnum;
import com.kingdee.eas.basedata.master.material.EquipmentPropertyEnum;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.IMaterialPropertyBase;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.IssuePriorityEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPropertyBaseInfo;
import com.kingdee.eas.basedata.master.material.MaterialUtil;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.PlanningModeEnum;
import com.kingdee.eas.basedata.master.material.TimeUnitEnum;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.client.AbstractMaterialInventoryUI;
import com.kingdee.eas.basedata.master.material.client.MaterialClientTools;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.org.client.f7.NewStorageF7;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.client.mutex.IVOChangeListener;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MaterialInventoryUI
extends AbstractMaterialInventoryUI
implements ItemListener {
    private static final Logger logger = CoreUIObject.getLogger(MaterialInventoryUI.class);
    private HashMap parentCTX = null;
    private String materialID = null;
    EventsListener event = null;
    MyDataChangeListener myDataChangeListEvent = null;
    private MaterialInfo material = null;
    private StorageOrgUnitInfo storageOrg = null;
    private boolean tag = false;
    IMultiMeasureUnit iMultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
    private int unitqtyPrecision = 2;
    private CtrlUnitInfo curCtrlUnitInfo;

    public MaterialInventoryUI() throws Exception {
        this.event = new EventsListener();
        this.myDataChangeListEvent = new MyDataChangeListener();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        MaterialClientTools.addCloseButton((KDToolBar)this.toolBar, (EditUI)this);
    }

    @Override
    public void loadFields() {
        this.removeEventsListerner();
        super.loadFields();
        this.addEventsListener();
        this.initControlByData();
        MaterialClientTools.setF7MeasureUnit((KDBizPromptBox)this.prmtUnit, (String)this.materialID);
        MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtQtySafety, (boolean)false, (boolean)true, (Comparable)MaterialClientTools.MAXVAL_BigDecimal, (Comparable)MaterialClientTools.MINVAL_BigDecimal, (int)this.unitqtyPrecision);
        MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtQtyMax, (boolean)false, (boolean)true, (Comparable)MaterialClientTools.MAXVAL_BigDecimal, (Comparable)MaterialClientTools.MINVAL_BigDecimal, (int)this.unitqtyPrecision);
        MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtQtyMin, (boolean)false, (boolean)true, (Comparable)MaterialClientTools.MAXVAL_BigDecimal, (Comparable)MaterialClientTools.MINVAL_BigDecimal, (int)this.unitqtyPrecision);
        MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtQtyMinPackage, (boolean)false, (boolean)true, (Comparable)MaterialClientTools.MAXVAL_BigDecimal, (Comparable)MaterialClientTools.MINVAL_BigDecimal, (int)this.unitqtyPrecision);
        MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtCheapRate, (boolean)false, (boolean)false, (Comparable)MaterialInventoryInfo.MAX_CHEAP_RATE, (Comparable)MaterialInventoryInfo.BigDecimal_0, (int)4);
        this.txtCheapRate.setMaximumValue((Comparable)MaterialInventoryInfo.BigDecimal_0);
        this.txtCheapRate.setMaximumValue((Comparable)MaterialInventoryInfo.MAX_CHEAP_RATE);
        this.txtDaysPlanTurnover.setMinimumNumber((Number)new Integer(Integer.MIN_VALUE));
        this.txtDaysPlanTurnover.setMaximumNumber((Number)new Integer(Integer.MAX_VALUE));
        int pricePrecision = this.editData.getMaterial().getPricePrecision();
        MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtToolRate, (boolean)false, (boolean)true, (Comparable)MaterialClientTools.MAXVAL_BigDecimal, (Comparable)MaterialClientTools.MINVAL_BigDecimal, (int)pricePrecision);
        if (this.editData != null && this.editData.getMaterial() != null && this.editData.getUnit() != null) {
            this.setRebootQtyPrecision(this.editData.getMaterial().getId().toString(), this.editData.getUnit().getId().toString());
        }
        this.setSubmitSaveButton();
        this.storeFields();
        FullOrgUnitInfo org = null;
        if (this.editData != null) {
            org = this.editData.getOrgUnit();
        }
        try {
            MaterialUtil.setQualityOrgF7((KDBizPromptBox)this.prmtQualityOrg, (OrgUnitInfo)org, (int)4, (int)32);
        }
        catch (Exception e) {
            super.handleException(e);
        }
    }

    private void chkIsCheck_stateChanged() {
        if (this.chkIsCheck.isSelected()) {
            this.prmtQualityOrg.setRequired(true);
        } else {
            this.prmtQualityOrg.setRequired(false);
        }
    }

    public void initControlByData() {
        if (this.editData != null && this.editData.isIsPeriodValid()) {
            this.kDSPeriodValid.setEnabled(true);
            this.comboPeriodValidUnit.setEnabled(true);
            this.kDSInWarehsAhead.setEnabled(true);
            this.spOutWarehsAhead.setEnabled(true);
            this.kDSPrepWarnAhead.setEnabled(true);
            this.comboAheadUnit.setEnabled(true);
            this.comboCloseDateMode.setEnabled(true);
        } else {
            this.kDSPeriodValid.setEnabled(false);
            this.comboPeriodValidUnit.setEnabled(false);
            this.kDSInWarehsAhead.setEnabled(false);
            this.spOutWarehsAhead.setEnabled(false);
            this.kDSPrepWarnAhead.setEnabled(false);
            this.comboAheadUnit.setEnabled(false);
            this.comboCloseDateMode.setEnabled(false);
        }
        if (this.editData != null && this.editData.getPlanningMode().equals((Object)PlanningModeEnum.REBOOKPOINT)) {
            this.txtReBookQty.setEnabled(false);
            this.txtConsumeSpeed.setEnabled(true);
            this.spinnerPurchAheadDate.setEnabled(true);
            this.comboBatchPolicy.setEnabled(true);
            this.txtFixationBatchQty.setEnabled(true);
        } else {
            this.txtReBookQty.setEnabled(false);
            this.txtConsumeSpeed.setEnabled(false);
            this.spinnerPurchAheadDate.setEnabled(false);
            this.comboBatchPolicy.setEnabled(false);
            this.txtFixationBatchQty.setEnabled(false);
        }
        if (this.editData != null && this.editData.getOrgUnit() != null) {
            this.prmtInvPlanner.setEnabled(true);
            try {
                SCMF7ContextUtils.setStockerF7ByStorageOrg((KDBizPromptBox)this.prmtInvPlanner, (StorageOrgUnitInfo)((StorageOrgUnitInfo)this.editData.getOrgUnit().cast(StorageOrgUnitInfo.class)), (CoreUI)this);
                StorageOrgUnitInfo sou = (StorageOrgUnitInfo)this.editData.getOrgUnit().cast(StorageOrgUnitInfo.class);
                this.prmtInvPlanner.setEditable(true);
                this.prmtInvPlanner.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
                this.prmtInvPlanner.setDisplayFormat("$name$");
                this.prmtInvPlanner.setEditFormat("$number$");
                this.prmtInvPlanner.setCommitFormat("$number$;$idNum$");
                this.prmtInvPlanner.setHasCUDefaultFilter(false);
                HashMap<String, Object> hash = new HashMap<String, Object>();
                hash.put("0", "1");
                hash.put("IS_SINGLE_SELECT", new Boolean(true));
                hash.put("0", "2");
                String adminUnitId = null;
                if (sou != null) {
                    adminUnitId = OrgRelationUtils.getAdminOrgUnitInfo((String)sou.getId().toString());
                }
                if (adminUnitId == null && SysContext.getSysContext().getCurrentAdminUnit() != null) {
                    adminUnitId = SysContext.getSysContext().getCurrentAdminUnit().getId().toString();
                }
                if (adminUnitId != null) {
                    hash.put("ADMIN_ID", adminUnitId);
                }
                PersonPromptBox box = new PersonPromptBox((IUIObject)this, hash);
                if (this.curCtrlUnitInfo != null && this.curCtrlUnitInfo.getId() != null) {
                    box.setCU(this.curCtrlUnitInfo.getId().toString());
                }
                this.prmtInvPlanner.setSelector((KDPromptSelector)box);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else {
            this.prmtInvPlanner.setEnabled(false);
        }
        if (this.editData != null && this.editData.getUnit() != null) {
            this.comboPlanningMode.setEnabled(true);
        } else {
            this.comboPlanningMode.setEnabled(false);
        }
        EquipmentPropertyEnum equipmentPropertyEnum = this.editData.getMaterial().getEquipProperty();
        if (EquipmentPropertyEnum.TOOL.equals((Object)equipmentPropertyEnum)) {
            this.txtToolRate.setEnabled(true);
        } else {
            this.txtToolRate.setEnabled(false);
        }
        if (this.editData != null && this.editData.isIsReservation()) {
            this.initReservationData(true);
        } else {
            this.initReservationData(false);
        }
    }

    @Override
    protected IObjectValue createNewData() {
        MaterialInventoryInfo invenInfo = new MaterialInventoryInfo();
        invenInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        invenInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        invenInfo.setStatus(UsedStatusEnum.UNAPPROVE);
        if (this.material != null) {
            invenInfo.setMaterial(this.material);
            invenInfo.setUnit(this.material.getBaseUnit());
        }
        invenInfo.setAbcType(ABCEnum.NOTSELECT);
        invenInfo.setIssuePriorityMode(IssuePriorityEnum.NOTSELECT);
        invenInfo.setIsControl(true);
        invenInfo.setPeriodValid(1);
        invenInfo.setInWarehsAhead(1);
        invenInfo.setOutWarehsAhead(1);
        invenInfo.setPrepWarnAhead(1);
        invenInfo.setPeriodValidUnit(TimeUnitEnum.DAY);
        invenInfo.setAheadUnit(TimeUnitEnum.DAY);
        invenInfo.setCreateTime(new Timestamp(new Date().getTime()));
        invenInfo.setPlanningMode(PlanningModeEnum.NOPLANNING);
        invenInfo.setBatchPolicy(BatchPolicyEnum.FIXATIONBATCH);
        invenInfo.setIssuePriorityMode(IssuePriorityEnum.BYLOTNUMBERQUEUE);
        invenInfo.setToolRate(new BigDecimal(0));
        invenInfo.setIsReservation(true);
        return invenInfo;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MaterialInventoryFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selects = super.getSelectors();
        selects.add("effectedStatus");
        selects.add("status");
        selects.add("material.*");
        return selects;
    }

    public SelectorItemCollection getMergedSelector() {
        SelectorItemCollection selects = super.getMergedSelector();
        selects.add("effectedStatus");
        selects.add("status");
        selects.add("material.*");
        return selects;
    }

    private void addEventsListener() {
        this.prmtOrgUnit.addChangeListener((ChangeListener)this.event);
        this.chkIsPeriodValid.addChangeListener((ChangeListener)this.event);
        this.prmtUnit.addChangeListener((ChangeListener)this.event);
        this.comboPlanningMode.addItemListener((ItemListener)this);
        this.txtQtySafety.addDataChangeListener((DataChangeListener)this.myDataChangeListEvent);
        this.txtConsumeSpeed.addDataChangeListener((DataChangeListener)this.myDataChangeListEvent);
        this.spinnerPurchAheadDate.addChangeListener((ChangeListener)this.event);
        this.chkIsCheck.addChangeListener((ChangeListener)this.event);
        this.chkIsReservation.addChangeListener((ChangeListener)this.event);
    }

    private void removeEventsListerner() {
        this.prmtOrgUnit.removeChangeListener((ChangeListener)this.event);
        this.chkIsPeriodValid.removeChangeListener((ChangeListener)this.event);
        this.prmtUnit.removeChangeListener((ChangeListener)this.event);
        this.comboPlanningMode.removeItemListener((ItemListener)this);
        this.txtQtySafety.removeDataChangeListener((DataChangeListener)this.myDataChangeListEvent);
        this.txtConsumeSpeed.removeDataChangeListener((DataChangeListener)this.myDataChangeListEvent);
        this.spinnerPurchAheadDate.removeChangeListener((ChangeListener)this.event);
        this.chkIsCheck.removeChangeListener((ChangeListener)this.event);
        this.chkIsReservation.removeChangeListener((ChangeListener)this.event);
    }

    private void chkIsPeriodValid_stateChanged(ChangeEvent e) {
        if (this.chkIsPeriodValid.isSelected()) {
            this.chkIsLotNumber.setSelected(true);
            this.kDSPeriodValid.setEnabled(true);
            this.kDSInWarehsAhead.setEnabled(true);
            this.spOutWarehsAhead.setEnabled(true);
            this.kDSPrepWarnAhead.setEnabled(true);
            this.comboPeriodValidUnit.setEnabled(true);
            this.comboAheadUnit.setEnabled(true);
            this.comboCloseDateMode.setEnabled(true);
        } else {
            this.kDSPeriodValid.setValue((Object)MaterialClientTools.ONE_INT);
            this.kDSInWarehsAhead.setValue((Object)MaterialClientTools.ONE_INT);
            this.spOutWarehsAhead.setValue((Object)MaterialClientTools.ONE_INT);
            this.kDSPrepWarnAhead.setValue((Object)MaterialClientTools.ONE_INT);
            this.comboPeriodValidUnit.setSelectedItem((Object)TimeUnitEnum.DAY);
            this.comboAheadUnit.setSelectedItem((Object)TimeUnitEnum.DAY);
            this.kDSPeriodValid.setEnabled(false);
            this.kDSInWarehsAhead.setEnabled(false);
            this.spOutWarehsAhead.setEnabled(false);
            this.kDSPrepWarnAhead.setEnabled(false);
            this.comboPeriodValidUnit.setEnabled(false);
            this.comboAheadUnit.setEnabled(false);
            this.comboCloseDateMode.setEnabled(false);
        }
    }

    public void prmtOrg_stateChanged(ChangeEvent e) throws BOSException {
        StorageOrgUnitInfo org = (StorageOrgUnitInfo)this.prmtOrgUnit.getValue();
        MaterialInventoryInfo info = null;
        if (org != null) {
            info = this.getInvInfoByFilter(MaterialClientTools.getFilterOUMaterial((String)"orgUnit.id", (String)org.getId().toString(), (String)"material.id", (String)this.materialID));
            this.tag = false;
        }
        this.setDefaultWarehouseFilter(org);
        if (info == null) {
            info = (MaterialInventoryInfo)this.createNewData();
            if (org != null) {
                info.setOrgUnit(org.castToFullOrgUnitInfo());
            }
            this.tag = true;
        }
        this.setDataObject((IObjectValue)info);
        this.loadFields();
    }

    private void setDefaultWarehouseFilter(StorageOrgUnitInfo orgUnit) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        if (orgUnit != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgUnit.getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
        }
        this.prmtDefaultWare.setEntityViewInfo(viewInfo);
    }

    public void prmtUnit_stateChanged(ChangeEvent e) throws EASBizException, BOSException {
        if (this.prmtUnit.getValue() != null && this.editData.getMaterial() != null) {
            MeasureUnitInfo unit = (MeasureUnitInfo)this.prmtUnit.getValue();
            this.setRebootQtyPrecision(this.editData.getMaterial().getId().toString(), unit.getId().toString());
            this.comboPlanningMode.setEnabled(true);
        } else {
            this.comboPlanningMode.setSelectedItem((Object)PlanningModeEnum.NOPLANNING);
            this.comboPlanningMode.setEnabled(false);
            this.setRebookPointControls(false);
        }
        this.accountReBookPoint();
    }

    public void setRebootQtyPrecision(String materialID, String unitID) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material", (Object)materialID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("measureUnit", (Object)unitID, CompareType.EQUALS));
        view.setFilter(filterInfo);
        MultiMeasureUnitCollection collection = null;
        try {
            collection = this.iMultiUnit.getMultiMeasureUnitCollection(view);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        if (collection != null && collection.size() != 0) {
            MultiMeasureUnitInfo unitInfo = collection.get(0);
            this.unitqtyPrecision = unitInfo.getQtyPrecision();
            MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtReBookQty, (boolean)false, (boolean)true, (Comparable)MaterialClientTools.MAXVAL_BigDecimal, (Comparable)MaterialClientTools.MINVAL_BigDecimal, (int)this.unitqtyPrecision);
            MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtConsumeSpeed, (boolean)false, (boolean)true, (Comparable)MaterialClientTools.MAXVAL_BigDecimal, (Comparable)MaterialClientTools.MINVAL_BigDecimal, (int)this.unitqtyPrecision);
            MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtFixationBatchQty, (boolean)false, (boolean)true, (Comparable)MaterialClientTools.MAXVAL_BigDecimal, (Comparable)MaterialClientTools.MINVAL_BigDecimal, (int)this.unitqtyPrecision);
            MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtQtySafety, (boolean)false, (boolean)true, (Comparable)MaterialClientTools.MAXVAL_BigDecimal, (Comparable)MaterialClientTools.MINVAL_BigDecimal, (int)this.unitqtyPrecision);
            MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtQtyMax, (boolean)false, (boolean)true, (Comparable)MaterialClientTools.MAXVAL_BigDecimal, (Comparable)MaterialClientTools.MINVAL_BigDecimal, (int)this.unitqtyPrecision);
            MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtQtyMin, (boolean)false, (boolean)true, (Comparable)MaterialClientTools.MAXVAL_BigDecimal, (Comparable)MaterialClientTools.MINVAL_BigDecimal, (int)this.unitqtyPrecision);
            MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtQtyMinPackage, (boolean)false, (boolean)true, (Comparable)MaterialClientTools.MAXVAL_BigDecimal, (Comparable)MaterialClientTools.MINVAL_BigDecimal, (int)this.unitqtyPrecision);
            int pricePrecision = this.editData.getMaterial().getPricePrecision();
            MaterialClientTools.SetFormatText((KDFormattedTextField)this.txtToolRate, (boolean)false, (boolean)true, (Comparable)MaterialClientTools.MAXVAL_BigDecimal, (Comparable)MaterialClientTools.MINVAL_BigDecimal, (int)pricePrecision);
        }
    }

    private void initDefaultOrgUnit(CtrlUnitInfo curCtrlUnitInfo) throws EASBizException, BOSException {
        if (SysContext.getSysContext().getCurrentStorageUnit() != null && SysContext.getSysContext().getCurrentStorageUnit().getCU().equalsPK((IObjectValue)curCtrlUnitInfo)) {
            this.storageOrg = SysContext.getSysContext().getCurrentStorageUnit();
        } else if (curCtrlUnitInfo.isIsStorageOrgUnit()) {
            this.storageOrg = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCtrlUnitInfo.getId()));
        }
    }

    public void onLoad() throws Exception {
        if (this.editData == null) {
            this.parentCTX = MaterialClientTools.getParentCTX((EditUI)this);
            this.curCtrlUnitInfo = (CtrlUnitInfo)this.parentCTX.get("CurrentCtrlUnit");
            if (this.curCtrlUnitInfo == null) {
                this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
            }
            this.initDefaultOrgUnit(this.curCtrlUnitInfo);
            this.getMaterialID();
            this.getDefaultInvInfo();
        }
        this.setPrintEnable();
        this.doInit();
        super.onLoad();
        this.prmtOrgUnit.setEnabled(true);
        this.prmtOrgUnit.setAccessAuthority(0);
        String dateFormatStr = "yyyy-MM-dd";
        this.pkCreateTime.setDatePattern(dateFormatStr);
        this.pkLastUpdateTime.setDatePattern(dateFormatStr);
    }

    protected void initContextOrg() {
        this.initUIMainOrgContext(this.curCtrlUnitInfo.getId().toString());
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    private void doInit() {
        this.btnApprove.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnApprove.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnCopy.setVisible(false);
        this.actionCopy.setEnabled(false);
        this.menuItemCopy.setVisible(false);
        this.btnSave.setVisible(false);
        this.menuItemSave.setVisible(false);
        this.actionSave.setEnabled(false);
        NewStorageF7 invOrgF7 = new NewStorageF7();
        invOrgF7.setIsCUFilter(true);
        invOrgF7.setCurrentCUID(this.curCtrlUnitInfo.getId().toString());
        NewOrgUnitFilterInfoProducer producer = new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)invOrgF7);
        this.prmtOrgUnit.setFilterInfoProducer((IFilterInfoProducer)producer);
        this.prmtOrgUnit.setSelector((KDPromptSelector)invOrgF7);
        FilterInfo filterinfo = new FilterInfo();
        filterinfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.curCtrlUnitInfo.getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterinfo);
        this.prmtOrgUnit.setEntityViewInfo(viewInfo);
        this.prmtOrgUnit.setCurrentCtrlUnit(this.curCtrlUnitInfo);
        this.prmtOrgUnit.setHandleCUFilter(false);
        this.txtDaysPlanTurnover.setPrecision(2);
        MaterialClientTools.SetSpinnerMaxMin((JSpinner)this.spInvDaysTop, (int)0, (int)-1);
        MaterialClientTools.SetSpinnerMaxMin((JSpinner)this.spDaysTurnover, (int)0, (int)-1);
        MaterialClientTools.SetSpinnerMaxMin((JSpinner)this.spDaysBottom, (int)0, (int)-1);
        MaterialClientTools.SetSpinnerMaxMin((JSpinner)this.kDSPeriodValid, (int)1, (int)-1);
        MaterialClientTools.SetSpinnerMaxMin((JSpinner)this.kDSInWarehsAhead, (int)1, (int)-1);
        MaterialClientTools.SetSpinnerMaxMin((JSpinner)this.spOutWarehsAhead, (int)1, (int)-1);
        MaterialClientTools.SetSpinnerMaxMin((JSpinner)this.kDSPrepWarnAhead, (int)1, (int)-1);
        MaterialClientTools.SetSpinnerMaxMin((JSpinner)this.spinnerPurchAheadDate, (int)0, (int)-1);
        this.comboPeriodValidUnit.setSelectedItem((Object)TimeUnitEnum.DAY);
        this.comboAheadUnit.setSelectedItem((Object)TimeUnitEnum.DAY);
        this.kDSPeriodValid.setValue((Object)MaterialClientTools.ONE_INT);
        this.kDSInWarehsAhead.setValue((Object)MaterialClientTools.ONE_INT);
        this.spOutWarehsAhead.setValue((Object)MaterialClientTools.ONE_INT);
        this.kDSPrepWarnAhead.setValue((Object)MaterialClientTools.ONE_INT);
        this.comboBatchPolicy.removeItem((Object)BatchPolicyEnum.STRAIGHTBATCH);
        this.comboBatchPolicy.setSelectedItem((Object)BatchPolicyEnum.FIXATIONBATCH);
    }

    private void getDefaultInvInfo() throws BOSException {
        if (this.materialID != null) {
            MaterialInventoryInfo comInfo = null;
            MaterialInventoryCollection colls = null;
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)this.materialID));
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.curCtrlUnitInfo.getId().toString()));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("orgunit.id"));
            colls = MaterialInventoryFactory.getRemoteInstance().getMaterialInventoryCollection(viewInfo);
            if (this.storageOrg != null && this.storageOrg.getId() != null) {
                comInfo = this.getInvInfoByFilter(MaterialClientTools.getFilterOUMaterial((String)"orgUnit.id", (String)this.storageOrg.getId().toString(), (String)"material.id", (String)this.materialID));
                this.setDefaultWarehouseFilter(this.storageOrg);
            }
            if (colls != null) {
                RealModeIDList idLists = new RealModeIDList();
                int currentPKIndex = -1;
                for (int i = 0; i < colls.size(); ++i) {
                    MaterialInventoryInfo info = colls.get(i);
                    idLists.add(i, info.getId().toString());
                    if (comInfo == null || !info.getOrgUnit().getId().toString().equals(comInfo.getOrgUnit().getId().toString())) continue;
                    currentPKIndex = i;
                    this.getUIContext().put("ID", comInfo.getId().toString());
                    this.tag = false;
                }
                if (currentPKIndex == -1 && idLists != null && idLists.size() != 0) {
                    currentPKIndex = 0;
                }
                idLists.setCurrentIndex(currentPKIndex);
                this.getUIContext().put("IDList", idLists);
            }
            if (comInfo == null) {
                comInfo = (MaterialInventoryInfo)this.createNewData();
            }
            this.getUIContext().put("InitDataObject", comInfo);
        }
    }

    private MaterialInventoryInfo getInvInfoByFilter(FilterInfo filterinfo) throws BOSException {
        MaterialInventoryInfo info = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterinfo);
        SelectorItemCollection selectors = viewInfo.getSelector();
        Iterator t = this.getMergedSelector().iterator();
        while (t.hasNext()) {
            selectors.add((SelectorItemInfo)t.next());
        }
        MaterialInventoryCollection con = MaterialInventoryFactory.getRemoteInstance().getMaterialInventoryCollection(viewInfo);
        if (con != null && con.size() >= 1) {
            info = con.get(0);
        }
        return info;
    }

    private void getMaterialID() {
        if (this.parentCTX == null) {
            MaterialClientTools.getParentCTX((EditUI)this);
        }
        if (this.parentCTX != null) {
            this.materialID = this.parentCTX.get("ID").toString();
            this.material = (MaterialInfo)this.parentCTX.get("MATERIAL_DATA");
        }
    }

    private void setSubmitSaveButton() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnRemove.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            if (this.editData != null && EffectedStatusEnum.getEnum((int)this.editData.getInt("effectedStatus")) == EffectedStatusEnum.EFFECTED) {
                int vostatus = this.editData.getInt("status");
                this.setActionButtonVisible(vostatus);
            } else {
                this.btnApprove.setVisible(true);
                this.btnUnApprove.setVisible(false);
                this.btnCancel.setVisible(false);
                this.menuItemCancel.setVisible(false);
                this.btnCancelCancel.setVisible(false);
                this.menuItemCancelCancel.setVisible(false);
            }
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            return;
        }
        if (this.material != null && this.material.getStatus() == UsedStatusEnum.FREEZED) {
            this.btnAddNew.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.menuItemSubmit.setEnabled(false);
            if (!this.btnRemove.isVisible()) {
                this.menuItemRemove.setEnabled(false);
            }
            this.btnApprove.setEnabled(false);
            this.btnApprove.setVisible(false);
            this.btnUnApprove.setEnabled(false);
            this.btnUnApprove.setVisible(true);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancel.setVisible(true);
            this.menuItemCancel.setVisible(true);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
            return;
        }
        this.btnAddNew.setEnabled(true);
        if (this.editData != null && EffectedStatusEnum.getEnum((int)this.editData.getInt("effectedStatus")) == EffectedStatusEnum.EFFECTED) {
            int vostatus = this.editData.getInt("status");
            if (vostatus == 0) {
                if (this.editData.getId() != null) {
                    this.btnRemove.setEnabled(true);
                    this.menuItemRemove.setEnabled(true);
                } else {
                    this.btnRemove.setEnabled(false);
                    this.menuItemRemove.setEnabled(false);
                }
                this.btnSave.setEnabled(false);
                this.btnSubmit.setEnabled(true);
                this.menuItemSubmit.setEnabled(true);
            } else if (vostatus == 1) {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
                this.btnSave.setEnabled(false);
                this.btnSubmit.setEnabled(false);
                this.menuItemSubmit.setEnabled(false);
                this.btnApprove.setEnabled(false);
                this.btnUnApprove.setEnabled(true);
                this.btnCancel.setEnabled(true);
                this.menuItemCancel.setEnabled(true);
                this.btnCancelCancel.setEnabled(false);
                this.menuItemCancelCancel.setEnabled(false);
            } else {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
                this.btnSave.setEnabled(false);
                this.btnSubmit.setEnabled(false);
                this.menuItemSubmit.setEnabled(false);
                this.btnApprove.setEnabled(false);
                this.btnUnApprove.setEnabled(false);
                this.btnCancel.setEnabled(false);
                this.menuItemCancel.setEnabled(false);
                this.btnCancelCancel.setEnabled(true);
                this.menuItemCancelCancel.setEnabled(true);
            }
            this.setActionButtonVisible(vostatus);
            if (this.material != null && this.material.getStatus() == UsedStatusEnum.UNAPPROVE) {
                this.btnApprove.setEnabled(false);
            }
        } else {
            this.btnSave.setEnabled(true);
            this.btnSubmit.setEnabled(true);
            this.menuItemSubmit.setEnabled(true);
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnApprove.setVisible(true);
            this.btnUnApprove.setVisible(false);
            this.btnCancel.setVisible(false);
            this.menuItemCancel.setVisible(false);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
            } else if (this.editData != null) {
                if (this.editData.getId() != null) {
                    this.btnRemove.setEnabled(true);
                    this.menuItemRemove.setEnabled(true);
                } else {
                    this.btnRemove.setEnabled(false);
                    this.menuItemRemove.setEnabled(false);
                }
            } else {
                this.btnRemove.setEnabled(false);
                this.menuItemRemove.setEnabled(false);
            }
        }
    }

    private void setActionButtonVisible(int vostatus) {
        if (vostatus == 0) {
            this.btnApprove.setEnabled(true);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnApprove.setVisible(true);
            this.btnUnApprove.setVisible(false);
            this.btnCancel.setVisible(false);
            this.menuItemCancel.setVisible(false);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
        } else if (vostatus == 1) {
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(true);
            this.btnCancel.setEnabled(true);
            this.menuItemCancel.setEnabled(true);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnApprove.setVisible(false);
            this.btnUnApprove.setVisible(true);
            this.btnCancel.setVisible(true);
            this.menuItemCancel.setVisible(true);
            this.btnCancelCancel.setVisible(false);
            this.menuItemCancelCancel.setVisible(false);
        } else {
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(true);
            this.menuItemCancelCancel.setEnabled(true);
            this.btnApprove.setVisible(false);
            this.btnUnApprove.setVisible(false);
            this.btnCancel.setVisible(false);
            this.menuItemCancel.setVisible(false);
            this.btnCancelCancel.setVisible(true);
            this.menuItemCancelCancel.setVisible(true);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setSubmitSaveButton();
        this.initControlByData();
        this.doFieldPermission();
    }

    @Override
    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherInventory(0);
    }

    @Override
    public void actionUnApprove_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherInventory(1);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherInventory(2);
    }

    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.doActionOtherInventory(3);
    }

    private void doActionOtherInventory(int actionenumvalue) throws Exception {
        if (this.editData != null && this.editData.getId() != null && !"".equals(this.editData.getId().toString())) {
            IMaterialInventory iMaterialInv = (IMaterialInventory)this.getBizInterface();
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            MaterialClientTools.doActionOtherProperty((int)actionenumvalue, (MaterialPropertyBaseInfo)this.editData, (IMaterialPropertyBase)iMaterialInv, (IObjectPK)pk, (MaterialInfo)this.material);
            IObjectValue newValue = this.getValue((IObjectPK)pk);
            this.getUIContext().put("InitDataObject", newValue);
            this.setDataObject(newValue);
            this.loadFields();
        }
    }

    protected void loadData() throws Exception {
        if (this.parentCTX != null && this.materialID != null && !this.materialID.equalsIgnoreCase(this.parentCTX.get("ID").toString())) {
            this.getMaterialID();
            this.getDefaultInvInfo();
        }
        this.getMaterialID();
        if ("EDIT".equalsIgnoreCase(this.getOprtState()) || "ADDNEW".equalsIgnoreCase(this.getOprtState())) {
            this.unLockUI();
        }
        super.loadData();
        if (this.editData.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            CoreBaseInfo info = this.getBizInterface().getValue((IObjectPK)pk, this.getMergedSelector());
            this.setDataObject((IObjectValue)info);
            this.loadFields();
        }
        this.tag = false;
    }

    @Override
    public void setOprtState(String oprtType) {
        if (!oprtType.equalsIgnoreCase(this.getOprtState())) {
            super.setOprtState(oprtType);
            if (this.parentCTX != null && !this.oprtState.equalsIgnoreCase("ADDNEW")) {
                this.parentCTX.put("MATERIAL_UI_STATUS", oprtType);
            }
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String strMsg = null;
        MaterialClientTools.checkMaterialFreeze((MaterialInfo)this.material);
        if (this.editData.getOrgUnit() == null) {
            strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"InvOU_NOT_NULL");
            this.prmtOrgUnit.requestFocus();
            MaterialClientTools.showError((String)strMsg);
        }
        if (e.getSource().equals(this.btnSubmit) || e.getSource().equals(this.menuItemSubmit) || e.getSource() instanceof KDWorkButton && ((KDWorkButton)e.getSource()).getName().equals("btnSubmit")) {
            if (this.editData.getUnit() == null) {
                strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"InvUnit_NOT_NULL");
                this.prmtUnit.requestFocus();
                MaterialClientTools.showError((String)strMsg);
            }
            if (this.editData.isIsPeriodValid()) {
                if (this.editData.isIsLotNumber()) {
                    TimeUnitEnum pU = this.editData.getPeriodValidUnit();
                    TimeUnitEnum wU = this.editData.getAheadUnit();
                    if (this.editData.getPeriodValidUnit().equals((Object)TimeUnitEnum.NULL)) {
                        strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"PeriodValidUnitCannotBeNull");
                        this.comboPeriodValidUnit.requestFocus();
                        MaterialClientTools.showError((String)strMsg);
                    }
                    if (this.editData.getAheadUnit().equals((Object)TimeUnitEnum.NULL)) {
                        strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"AheadUnitCannotBeNull");
                        this.comboAheadUnit.requestFocus();
                        MaterialClientTools.showError((String)strMsg);
                    }
                    int pValue = this.editData.getPeriodValid();
                    int inWarehsAheadValue = this.editData.getInWarehsAhead();
                    int outWarehsAheadValue = this.editData.getOutWarehsAhead();
                    int preWarnAheadValue = this.editData.getPrepWarnAhead();
                    pValue = MaterialClientTools.getDaysByTimeUnit((int)pU.getValue(), (int)pValue);
                    inWarehsAheadValue = MaterialClientTools.getDaysByTimeUnit((int)wU.getValue(), (int)inWarehsAheadValue);
                    outWarehsAheadValue = MaterialClientTools.getDaysByTimeUnit((int)wU.getValue(), (int)outWarehsAheadValue);
                    preWarnAheadValue = MaterialClientTools.getDaysByTimeUnit((int)wU.getValue(), (int)preWarnAheadValue);
                    if (inWarehsAheadValue > pValue) {
                        strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"WarnInwAheadCheck");
                        this.kDSInWarehsAhead.requestFocus();
                        MaterialClientTools.showError((String)strMsg);
                    }
                    if (outWarehsAheadValue > pValue) {
                        strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"WarnIssueAheadCheck");
                        this.spOutWarehsAhead.requestFocus();
                        MaterialClientTools.showError((String)strMsg);
                    }
                    if (preWarnAheadValue > pValue) {
                        strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"WarnAheadCheck");
                        this.kDSPrepWarnAhead.requestFocus();
                        MaterialClientTools.showError((String)strMsg);
                    }
                } else {
                    strMsg = EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"IsPeriodValidCheck");
                    this.chkIsLotNumber.requestFocus();
                    MaterialClientTools.showError((String)strMsg);
                }
            }
        }
    }

    protected BigDecimal getBaseConvs(String materialID, String measureUnitID) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("material.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("measureUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("baseConvsRate"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)new ObjectUuidPK(BOSUuid.read((String)materialID)), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)new ObjectUuidPK(BOSUuid.read((String)measureUnitID)), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        MultiMeasureUnitCollection measureUnitColl = this.iMultiUnit.getMultiMeasureUnitCollection(viewInfo);
        if (measureUnitColl != null && measureUnitColl.size() != 0) {
            return measureUnitColl.get(0).getBaseConvsRate();
        }
        return new BigDecimal("1.00");
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        MaterialClientTools.checkMaterialFreeze((MaterialInfo)this.material);
        super.actionAddNew_actionPerformed(e);
        this.getUIContext().put("InitDataObject", this.editData);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.tag) {
            this.loadData();
        } else {
            super.actionRemove_actionPerformed(e);
        }
        if (this.editData != null && this.editData.getId() == null) {
            this.getUIContext().put("InitDataObject", this.editData);
            this.getUIContext().put("ID", null);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        if (this.editData != null && this.editData.getId() != null && this.editData.getOrgUnit() != null && this.storageOrg != null && this.editData.getOrgUnit().getId().equals((Object)this.storageOrg.getId())) {
            this.getUIContext().put("InitDataObject", this.editData);
            this.getUIContext().put("ID", this.editData.getId());
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus() == UsedStatusEnum.APPROVED) {
            return;
        }
        super.actionSubmit_actionPerformed(e);
        if (this.editData != null && this.editData.getId() != null && this.editData.getOrgUnit() != null && this.storageOrg != null && this.editData.getOrgUnit().getId().equals((Object)this.storageOrg.getId())) {
            this.getUIContext().put("InitDataObject", this.editData);
            this.getUIContext().put("ID", this.editData.getId());
        }
        this.tag = false;
    }

    private void setPrintEnable(boolean enablead) {
        this.btnPrint.setVisible(enablead);
        this.menuItemPrint.setVisible(enablead);
        this.actionPrint.setEnabled(enablead);
        this.btnPrintPreview.setVisible(enablead);
        this.menuItemPrint.setVisible(enablead);
        this.actionPrintPreview.setEnabled(enablead);
        this.separatorFW2.setVisible(enablead);
        this.kDSeparator3.setVisible(enablead);
    }

    private void setPrintEnable() {
        this.setPrintEnable(false);
    }

    public boolean isModify() {
        ArrayList<String> arr1 = new ArrayList<String>();
        arr1.add(new String("tagState"));
        ArrayList<Boolean> arr2 = new ArrayList<Boolean>();
        Boolean boolTag = new Boolean(this.tag);
        arr2.add(0, boolTag);
        this.getUIContext().put(arr1, arr2);
        if (this.prmtOrgUnit.getValue() != null && this.tag) {
            return true;
        }
        return super.isModify();
    }

    protected void addVOChangeListener(IVOChangeListener listener) {
        super.addVOChangeListener(null);
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
        if (arg0.getSource() == this.comboPlanningMode) {
            if (this.comboPlanningMode.getSelectedItem().equals(PlanningModeEnum.REBOOKPOINT)) {
                this.setRebookPointControls(true);
            } else {
                this.setRebookPointControls(false);
            }
        }
    }

    private void setRebookPointControls(boolean tag) {
        if (tag) {
            this.txtReBookQty.setEnabled(false);
            this.txtConsumeSpeed.setEnabled(true);
            this.spinnerPurchAheadDate.setEnabled(true);
            this.comboBatchPolicy.setEnabled(true);
            this.txtFixationBatchQty.setEnabled(true);
        } else {
            this.txtReBookQty.setValue((Object)MaterialClientTools.ZERO_INT);
            this.txtConsumeSpeed.setValue((Object)MaterialClientTools.ZERO_INT);
            this.spinnerPurchAheadDate.setValue((Object)MaterialClientTools.ZERO_INT);
            this.txtFixationBatchQty.setValue((Object)MaterialClientTools.ZERO_INT);
            this.comboBatchPolicy.setSelectedItem((Object)BatchPolicyEnum.FIXATIONBATCH);
            this.txtReBookQty.setEnabled(false);
            this.txtConsumeSpeed.setEnabled(false);
            this.spinnerPurchAheadDate.setEnabled(false);
            this.comboBatchPolicy.setEnabled(false);
            this.txtFixationBatchQty.setEnabled(false);
        }
    }

    public void spinnerPurchAheadDate_stateChanged(ChangeEvent e) throws EASBizException, BOSException {
        this.accountReBookPoint();
    }

    public void txtQtySafety_dataChanged(DataChangeEvent e) throws EASBizException, BOSException {
        this.accountReBookPoint();
    }

    public void txtConsumeSpeed_dataChanged(DataChangeEvent e) throws EASBizException, BOSException {
        this.accountReBookPoint();
    }

    private void accountReBookPoint() throws EASBizException, BOSException {
        if (this.prmtUnit.getValue() == null) {
            return;
        }
        BigDecimal qtySafety = this.txtQtySafety.getBigDecimalValue();
        BigDecimal conSumeSpeed = this.txtConsumeSpeed.getBigDecimalValue();
        if (qtySafety == null) {
            qtySafety = new BigDecimal("0.00");
        }
        if (conSumeSpeed == null) {
            conSumeSpeed = new BigDecimal("0.00");
        }
        int purchAheadDate = (Integer)this.spinnerPurchAheadDate.getValue();
        BigDecimal reBookQty = conSumeSpeed.multiply(new BigDecimal(purchAheadDate)).add(qtySafety);
        this.txtReBookQty.setValue((Object)reBookQty);
    }

    protected String getOnloadPermItemName() {
        String state = this.getOprtState();
        if (EmptyUtil.isEmpty((String)state)) {
            super.getOnloadPermItemName();
        }
        if (state.equals(OprtState.ADDNEW)) {
            return "bd_materialInv_addNew";
        }
        if (state.equals(OprtState.EDIT)) {
            return "bd_materialInv_update";
        }
        return "bd_materialInv_view";
    }

    private void chkIsReservation_stateChanged() {
        if (this.chkIsReservation.isSelected()) {
            this.spReservationDate.setEnabled(true);
            this.spReservationDate.setRequired(true);
        } else {
            this.spReservationDate.setEnabled(false);
            this.spReservationDate.setRequired(false);
            this.spReservationDate.setValue((Object)MaterialClientTools.ZERO_INT);
        }
    }

    private void initReservationData(boolean isReservation) {
        this.chkIsReservation.setSelected(isReservation);
        this.spReservationDate.setEnabled(isReservation);
        this.spReservationDate.setRequired(isReservation);
        if (!isReservation) {
            this.spReservationDate.setValue((Object)MaterialClientTools.ZERO_INT);
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
    }

    private class MyDataChangeListener
    implements DataChangeListener {
        private MyDataChangeListener() {
        }

        public void dataChanged(DataChangeEvent eventObj) {
            Object source = eventObj.getSource();
            try {
                if (source != null) {
                    if (source.equals(MaterialInventoryUI.this.txtQtySafety)) {
                        MaterialInventoryUI.this.txtQtySafety_dataChanged(eventObj);
                    }
                    if (source.equals(MaterialInventoryUI.this.txtConsumeSpeed)) {
                        MaterialInventoryUI.this.txtConsumeSpeed_dataChanged(eventObj);
                    }
                }
            }
            catch (Exception ex) {
                MaterialInventoryUI.this.handUIException(ex);
            }
        }
    }

    private class EventsListener
    implements ChangeListener {
        private EventsListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            try {
                if (source != null) {
                    if (source.equals(MaterialInventoryUI.this.prmtOrgUnit)) {
                        MaterialInventoryUI.this.prmtOrg_stateChanged(e);
                    } else {
                        if (source.equals(MaterialInventoryUI.this.chkIsPeriodValid)) {
                            MaterialInventoryUI.this.chkIsPeriodValid_stateChanged(e);
                        }
                        if (source.equals(MaterialInventoryUI.this.spinnerPurchAheadDate)) {
                            MaterialInventoryUI.this.spinnerPurchAheadDate_stateChanged(e);
                        }
                        if (source.equals(MaterialInventoryUI.this.prmtUnit)) {
                            MaterialInventoryUI.this.prmtUnit_stateChanged(e);
                        }
                        if (source.equals(MaterialInventoryUI.this.chkIsCheck)) {
                            MaterialInventoryUI.this.chkIsCheck_stateChanged();
                        }
                        if (source.equals(MaterialInventoryUI.this.chkIsReservation)) {
                            MaterialInventoryUI.this.chkIsReservation_stateChanged();
                        }
                    }
                }
            }
            catch (Exception ex) {
                MaterialInventoryUI.this.handUIException(ex);
            }
        }
    }
}

