/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.IFMEntityAccess;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.InvalidDateException;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EntityAccess
implements IFMEntityAccess {
    private Logger logger = Logger.getLogger(EntityAccess.class);
    private static final String VALUES_BRACKET = ") values(? ";
    private static final String RIGHT_BRACKET = " )";
    private static final String LEFT_BRACKET = " ( ";
    private static final String INTEGER = "Integer";
    private static final String TIMESTAMP = "TimeStamp";
    private static final String TIME = "Time";
    private static final String DATE = "Date";
    private static final String BOOLEAN = "Boolean";
    private static final String STRING = "String";
    private static final String ENUM = "Enum";
    private static final String BOSUUID = "BOSUuid";
    private static final String BIGDECIMAL = "BigDecimal";
    private static final String L3 = "_L3";
    private static final String L2 = "_L2";
    private static final String L1 = "_L1";
    private static final String SET = " set ";
    private static final Locale ObjL1 = new Locale("L1");
    private static final Locale ObjL2 = new Locale("L2");
    private static final Locale ObjL3 = new Locale("L3");
    private static final String UPDATE = " update ";
    private static final String SELECT = " select ";
    private static final String INSERT_INTO = " insert into  ";
    private static final String DELETE_FROM = " delete from ";
    private static final String WHERE = " where ";
    private static final String OR = " or ";
    private static final String COMA_QUEST = ",?";
    private static final String EQUAL_QUEST = "=?";
    private static final String COMMA = ", ";
    public static final String ENTITY_PK_NAME = "id";
    public int[] sqlTypeAry = null;
    public String[] entityRunningPropertyAry = null;
    public String[] entityNameAry = null;
    public String[] dbFieldNameAry = null;
    public String[] dataType = null;
    public boolean[] isLang = null;
    public boolean[] isLink = null;
    public String tableName = null;
    public String pkFieldName = null;
    private BOSObjectType objectType;
    public static final BOSUuid[] BOSUUIDARY;
    private static Map insertSQL;
    private static Map deleteSqlMap;

    public EntityAccess() {
    }

    public EntityAccess(Context ctx, BOSObjectType bosType, String[] entityProperties) throws BOSException {
        IMetaDataLoader metaDataloader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        this.objectType = bosType;
        EntityObjectInfo entityObject = metaDataloader.getEntity(this.objectType);
        DataTableInfo tableObject = entityObject.getTable();
        this.tableName = tableObject.getName();
        this.pkFieldName = entityObject.getPropertyByName(ENTITY_PK_NAME).getMappingField().getName();
        int properysize = 0;
        ArrayList<PropertyInfo> prop = new ArrayList<PropertyInfo>();
        for (int i = 0; i < entityProperties.length; ++i) {
            PropertyInfo pro = entityObject.getPropertyByName(entityProperties[i]);
            properysize = pro.getBoolean("isMultilingual") ? (properysize += 3) : ++properysize;
            prop.add(pro);
        }
        this.entityRunningPropertyAry = new String[properysize];
        this.entityNameAry = entityProperties;
        this.isLang = new boolean[properysize];
        this.isLink = new boolean[properysize];
        this.sqlTypeAry = new int[properysize];
        this.dbFieldNameAry = new String[properysize];
        this.dataType = new String[properysize];
        int cnt = 0;
        for (int i = 0; i < entityProperties.length; ++i) {
            PropertyInfo entityProperty = (PropertyInfo)prop.get(i);
            if (entityProperty == null) {
                throw new BOSException("no exist property" + entityProperties[i]);
            }
            String dbField = entityProperty.getMappingField().getName();
            ColumnInfo tableColumn = tableObject.getColumnByName(dbField);
            if (tableColumn == null) {
                this.logger.info((Object)("DBField:" + dbField));
            }
            if (entityProperty.getBoolean("isMultilingual")) {
                this.initStateaInfo(cnt, entityProperty, tableColumn);
                this.entityRunningPropertyAry[cnt] = !ctx.getLocale().equals(ObjL1) ? entityProperties[i] + L1 : entityProperties[i];
                this.dbFieldNameAry[cnt++] = dbField + L1;
                this.initStateaInfo(cnt, entityProperty, tableColumn);
                this.entityRunningPropertyAry[cnt] = !ctx.getLocale().equals(ObjL2) ? entityProperties[i] + L2 : entityProperties[i];
                this.dbFieldNameAry[cnt++] = dbField + L2;
                this.initStateaInfo(cnt, entityProperty, tableColumn);
                this.entityRunningPropertyAry[cnt] = !ctx.getLocale().equals(ObjL3) ? entityProperties[i] + L3 : entityProperties[i];
                this.dbFieldNameAry[cnt++] = dbField + L3;
                continue;
            }
            this.initStateaInfo(cnt, entityProperty, tableColumn);
            this.entityRunningPropertyAry[cnt] = entityProperties[i];
            this.dbFieldNameAry[cnt++] = dbField;
        }
    }

    private void initStateaInfo(int IndexCount, PropertyInfo entityproperty, ColumnInfo tableColumn) {
        if (entityproperty == null || tableColumn == null) {
            return;
        }
        this.isLink[IndexCount] = entityproperty instanceof LinkPropertyInfo;
        if (tableColumn == null) {
            this.logger.info((Object)("EE  colunmName last:" + entityproperty.getName()));
        }
        if (tableColumn.getTypeName() == null) {
            System.out.println("EE typeName:" + tableColumn.getName());
        }
        this.sqlTypeAry[IndexCount] = tableColumn.getTypeName().getSQLType();
        this.dataType[IndexCount] = entityproperty.getString("dataType");
    }

    public String getDBFieldName(int i, String name) {
        Object fieldName = null;
        if (this.isLang[i]) {
            StringBuffer sb = new StringBuffer((name.length() + 4) * 3);
            sb.append(name);
            sb.append(L1);
            sb.append(EQUAL_QUEST);
            sb.append(COMMA);
            sb.append(name);
            sb.append(L2);
            sb.append(EQUAL_QUEST);
            sb.append(COMMA);
            sb.append(name);
            sb.append(L3);
            return sb.toString();
        }
        return name;
    }

    @Override
    public String[] update(Context ctx, IObjectCollection coll) throws BOSException {
        String[] stringArray;
        if (coll == null || coll.size() == 0) {
            return null;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            String[] rst = new String[coll.size()];
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(this.getUpdateSql());
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                String sId;
                IObjectValue vo = coll.getObject(i);
                Object id = vo.get(ENTITY_PK_NAME);
                if (id == null) {
                    throw new BOSException("is empty:id");
                }
                this.bindToParam(stmt, vo, 1);
                rst[i] = sId = id.toString();
                stmt.setString(this.entityRunningPropertyAry.length + 1, sId);
                stmt.addBatch();
            }
            stmt.executeBatch();
            stringArray = rst;
        }
        catch (SQLException e1) {
            try {
                throw new BOSException((Throwable)e1);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return stringArray;
    }

    public String getUpdateSql() {
        StringBuffer updateSb = new StringBuffer(128);
        updateSb.append(UPDATE);
        updateSb.append(this.tableName);
        updateSb.append(SET);
        for (int i = 0; i < this.dbFieldNameAry.length; ++i) {
            if (i == 0) {
                updateSb.append(this.dbFieldNameAry[i]);
                updateSb.append(EQUAL_QUEST);
                continue;
            }
            updateSb.append(COMMA);
            updateSb.append(this.dbFieldNameAry[i]);
            updateSb.append(EQUAL_QUEST);
        }
        updateSb.append(WHERE);
        updateSb.append(this.pkFieldName);
        updateSb.append(EQUAL_QUEST);
        String sql = updateSb.toString();
        return sql;
    }

    public String getSelectorSQL() {
        StringBuffer sb = new StringBuffer(128);
        sb.append(SELECT);
        for (int i = 0; i < this.dbFieldNameAry.length; ++i) {
            if (i == 0) {
                sb.append(this.dbFieldNameAry[i]);
                continue;
            }
            sb.append(COMMA).append(this.dbFieldNameAry[i]);
        }
        sb.append(" from ");
        sb.append(this.tableName);
        sb.append(WHERE);
        sb.append(this.pkFieldName);
        sb.append(EQUAL_QUEST);
        return sb.toString();
    }

    private String getInsertSQL() {
        int i;
        BOSObjectType key = this.objectType;
        String sql = (String)insertSQL.get(this.objectType);
        if (sql != null) {
            return sql;
        }
        StringBuffer updateSb = new StringBuffer(128);
        updateSb.append(INSERT_INTO);
        updateSb.append(this.tableName);
        updateSb.append(LEFT_BRACKET);
        updateSb.append(this.pkFieldName);
        for (i = 0; i < this.dbFieldNameAry.length; ++i) {
            updateSb.append(COMMA);
            updateSb.append(this.dbFieldNameAry[i]);
        }
        updateSb.append(VALUES_BRACKET);
        for (i = 0; i < this.dbFieldNameAry.length; ++i) {
            updateSb.append(COMA_QUEST);
        }
        sql = updateSb.append(RIGHT_BRACKET).toString();
        insertSQL.put(key, sql);
        return sql;
    }

    @Override
    public String[] addnew(Context ctx, IObjectCollection coll) throws BOSException {
        String[] stringArray;
        if (coll == null || coll.size() == 0) {
            return null;
        }
        String sql = this.getInsertSQL();
        PreparedStatement stmt = null;
        Connection conn = null;
        String[] rst = new String[coll.size()];
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql);
            Object id = null;
            for (int i = 0; i < coll.size(); ++i) {
                String sId;
                IObjectValue vo = coll.getObject(i);
                id = vo.get(ENTITY_PK_NAME);
                if (id == null) {
                    id = BOSUuid.create((BOSObjectType)vo.getBOSType());
                    vo.put(ENTITY_PK_NAME, id);
                }
                rst[i] = sId = id.toString();
                stmt.setString(1, sId);
                this.bindToParam(stmt, vo, 2);
                stmt.addBatch();
            }
            stmt.executeBatch();
            stringArray = rst;
        }
        catch (SQLException e11) {
            try {
                throw new BOSException((Throwable)e11);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return stringArray;
    }

    public void bindToParam(PreparedStatement stat, IObjectValue values, int startIndex) throws SQLException {
        for (int i = 0; i < this.entityRunningPropertyAry.length; ++i) {
            this.bindToParam(stat, i, values, startIndex);
        }
    }

    public void bindToParam(PreparedStatement stmt, int i, IObjectValue values, int srartIndex) throws SQLException {
        String fieldname = this.entityRunningPropertyAry[i];
        int sqltype = this.sqlTypeAry[i];
        int parameterIndex = i + srartIndex;
        try {
            Object o = values.get(fieldname);
            if (o == null || o instanceof String && o.toString().length() == 0) {
                if (sqltype == 2005) {
                    stmt.setString(parameterIndex, null);
                    return;
                }
                if (sqltype == 2004) {
                    stmt.setBytes(parameterIndex, null);
                    return;
                }
                stmt.setNull(parameterIndex, sqltype);
                return;
            }
            if (this.isLink[i]) {
                IObjectValue vo = (IObjectValue)o;
                BOSUuid id = vo.getBOSUuid(ENTITY_PK_NAME);
                if (id == null) {
                    stmt.setNull(parameterIndex, sqltype);
                } else {
                    stmt.setString(parameterIndex, id.toString());
                }
                return;
            }
            switch (sqltype) {
                case -1: 
                case 1: 
                case 12: {
                    if (o instanceof BOSUuid) {
                        stmt.setString(parameterIndex, o.toString());
                    } else {
                        stmt.setString(parameterIndex, o.toString());
                    }
                    return;
                }
                case 4: {
                    stmt.setInt(parameterIndex, TypeConversionUtils.objToInt((Object)o));
                    return;
                }
                case -7: {
                    stmt.setBoolean(parameterIndex, TypeConversionUtils.objToBoolean((Object)o));
                    return;
                }
                case -6: {
                    stmt.setByte(parameterIndex, TypeConversionUtils.objToByte((Object)o));
                    return;
                }
                case 5: {
                    stmt.setShort(parameterIndex, TypeConversionUtils.objToShort((Object)o));
                    return;
                }
                case -5: {
                    stmt.setLong(parameterIndex, TypeConversionUtils.objToLong((Object)o));
                    return;
                }
                case 6: 
                case 7: 
                case 8: {
                    stmt.setDouble(parameterIndex, TypeConversionUtils.objToDouble((Object)o));
                    return;
                }
                case 2: 
                case 3: {
                    stmt.setBigDecimal(parameterIndex, TypeConversionUtils.objToBigDecimal((Object)o).setScale(10, 4));
                    return;
                }
                case 91: {
                    stmt.setDate(parameterIndex, TypeConversionUtils.objToDate((Object)o));
                    return;
                }
                case 92: {
                    stmt.setTime(parameterIndex, TypeConversionUtils.objToTime((Object)o));
                    return;
                }
                case 93: {
                    stmt.setObject(parameterIndex, TypeConversionUtils.objToTimestamp((Object)o));
                    return;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    stmt.setBytes(parameterIndex, TypeConversionUtils.objToBytes((Object)o));
                    return;
                }
                case 2005: {
                    stmt.setString(parameterIndex, TypeConversionUtils.objToString((Object)o));
                    return;
                }
            }
            throw new SQLException("Cannot deal with type: " + sqltype);
        }
        catch (IllegalConversionException ice) {
            throw new SQLException(fieldname + "Illegal conversion");
        }
        catch (InvalidDateException dte) {
            throw new SQLException(fieldname + "Invalida Date");
        }
    }

    public boolean removeVOColl(Context ctx, BOSObjectType type, String property, Object[] values) throws EASBizException, BOSException {
        boolean i;
        if (values == null || values.length == 0) {
            return true;
        }
        String sql = this.getDeleteSql(ctx, type, property);
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql);
            for (i = false; i < values.length; i += 1) {
                stmt.setString(1, values[i].toString());
                stmt.addBatch();
            }
            stmt.executeBatch();
            i = true;
        }
        catch (SQLException e1) {
            try {
                throw new BOSException((Throwable)e1);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return i;
    }

    private String getDeleteSql(Context ctx, BOSObjectType type, String property) {
        String key = type + property;
        String sql = (String)deleteSqlMap.get(key);
        if (sql != null) {
            return sql;
        }
        IMetaDataLoader load = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = load.getEntity(type);
        DataTableInfo table = entity.getTable();
        String name = table.getName();
        StringBuffer removeSb = new StringBuffer(128);
        removeSb.append(DELETE_FROM);
        removeSb.append(name);
        PropertyInfo pk = entity.getPropertyByName(property);
        ColumnInfo mapPk = pk.getMappingField();
        removeSb.append(WHERE);
        removeSb.append(mapPk.getName());
        removeSb.append(EQUAL_QUEST);
        sql = removeSb.toString();
        deleteSqlMap.put(key, sql);
        return sql;
    }

    static {
        deleteSqlMap = new Hashtable();
        insertSQL = new Hashtable();
        BOSUUIDARY = new BOSUuid[0];
    }
}

