/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.EntityAccess;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;

public class ORMEngine {
    public static boolean removeColl(Context ctx, BOSObjectType type, String property, Object[] parameters) throws EASBizException, BOSException {
        EntityAccess ea = new EntityAccess();
        return ea.removeVOColl(ctx, type, property, parameters);
    }

    public static boolean storeColl(Context ctx, IObjectCollection coll) throws BOSException {
        IObjectCollection newlist = (IObjectCollection)ORMEngine.cloneInstance(coll);
        IObjectCollection updateList = (IObjectCollection)ORMEngine.cloneInstance(coll);
        for (int i = 0; i < coll.size(); ++i) {
            IObjectValue vo = coll.getObject(i);
            if (ORMEngine.getIsNew(vo)) {
                newlist.addObject(vo);
                continue;
            }
            if (!ORMEngine.getIsChange(vo)) continue;
            updateList.addObject(vo);
        }
        if (newlist.size() > 0) {
            IObjectValue vo = coll.getObject(0);
            ORMEngine.addnewVO(ctx, newlist);
        }
        if (updateList.size() > 0) {
            String[] objectAry = ORMEngine.getLisenerProperties(updateList.getObject(0));
            if (objectAry == null || objectAry.length == 0) {
                objectAry = ORMEngine.getPropertyAry(ctx, updateList.getObject(0).getBOSType());
            }
            ORMEngine.updateColl(ctx, updateList, objectAry);
        }
        return true;
    }

    public static String[] updateColl(Context ctx, IObjectCollection coll, String[] property) throws BOSException {
        if (coll == null || coll.size() == 0) {
            return null;
        }
        IObjectValue vo = coll.getObject(0);
        BOSObjectType type = vo.getBOSType();
        EntityAccess ea = new EntityAccess(ctx, type, property);
        return ea.update(ctx, coll);
    }

    private static String[] getPropertyAry(Context ctx, BOSObjectType type) throws BOSException {
        if (type == null) {
            return null;
        }
        IMetaDataLoader load = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = load.getEntity(type);
        PropertyCollection entityProperty = entity.getPropertiesRuntime();
        int size = entityProperty.size();
        ArrayList<String> property = new ArrayList<String>();
        boolean i = false;
        for (PropertyInfo entityPro : entityProperty) {
            String name = entityPro.getName();
            if (entityPro.getMappingField() == null || name.equals("id")) continue;
            property.add(name);
        }
        String[] rst = property.toArray(new String[0]);
        return rst;
    }

    public static String[] addnewVO(Context ctx, IObjectCollection coll) throws BOSException {
        if (coll == null || coll.size() == 0) {
            return null;
        }
        IObjectValue vo = coll.getObject(0);
        BOSObjectType type = vo.getBOSType();
        String[] property = ORMEngine.getPropertyAry(ctx, type);
        EntityAccess ea = new EntityAccess(ctx, type, property);
        return ea.addnew(ctx, coll);
    }

    public static Object cloneInstance(Object coll) {
        try {
            return coll.getClass().newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static boolean getIsNew(IObjectValue vo) {
        if (vo.getBOSUuid("id") == null) {
            return true;
        }
        return vo.getBoolean("_isnew");
    }

    public static boolean getIsChange(IObjectValue vo) {
        return vo.getBoolean("_ischanged");
    }

    public static String[] getLisenerProperties(IObjectValue vo) {
        return (String[])vo.get("_lisenerproperty");
    }
}

