/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.util;

import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.AncestorListener;

public class ComponentUtil {
    public static String getClassName(String classSpaceName) {
        int lastIndexOf = classSpaceName.lastIndexOf(".");
        return classSpaceName.substring(lastIndexOf + 1, classSpaceName.length());
    }

    public static Map removeComponentListeners(JComponent comp) throws Exception {
        Class[] lstClasses = new Class[]{ActionListener.class, KeyListener.class, AncestorListener.class, SelectorListener.class, CommitListener.class, DataChangeListener.class, FocusListener.class, ItemListener.class};
        int lstClassLen = lstClasses.length;
        HashMap<String, EventListener[]> listenerMap = new HashMap<String, EventListener[]>();
        for (int i = 0; i < lstClassLen; ++i) {
            Class lstClass = lstClasses[i];
            EventListener[] listeners = comp.getListeners(lstClass);
            listenerMap.put(lstClass.getName(), listeners);
            String className = ComponentUtil.getClassName(lstClass.getName());
            int len = listeners.length;
            for (int j = 0; j < len; ++j) {
                Class[] ptTypes = new Class[]{lstClass};
                Method method = comp.getClass().getMethod("remove" + className, ptTypes);
                method.invoke((Object)comp, listeners[j]);
            }
        }
        return listenerMap;
    }

    public static void addComponentListeners(JComponent comp, Map listenerMap) throws Exception {
        if (listenerMap == null || listenerMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : listenerMap.entrySet()) {
            Class<?> lstClass = Class.forName(entry.getKey().toString());
            EventListener[] listeners = (EventListener[])entry.getValue();
            String className = ComponentUtil.getClassName(lstClass.getName());
            int len = listeners.length;
            for (int i = 0; i < len; ++i) {
                Class[] ptTypes = new Class[]{lstClass};
                Method method = comp.getClass().getMethod("add" + className, ptTypes);
                method.invoke((Object)comp, listeners[i]);
            }
        }
    }
}

