/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;

public final class NumberRuleUtil {
    public static String getNumberSilent(Context ctx, CoreBaseInfo info, String companyId) throws BOSException, CodingRuleException, EASBizException {
        if (info == null || companyId == null || companyId.equals("")) {
            return null;
        }
        String result = null;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        result = codingRuleManager.getNumber((IObjectValue)info, companyId);
        return result;
    }

    public static void recycleNumber(Context ctx, CoreBaseInfo info, String companyId) {
        if (info == null || companyId == null || companyId.equals("")) {
            return;
        }
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (codingRuleManager.isExist((IObjectValue)info, companyId) && codingRuleManager.isUseIntermitNumber((IObjectValue)info, companyId)) {
                codingRuleManager.recycleNumber((IObjectValue)info, companyId, info.getString("number"));
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static FilterInfo getCheckNumberDupFilter(IObjectValue model, boolean isNeedComp) {
        FilterInfo filter = new FilterInfo();
        if (isNeedComp) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)model.getObjectValue("company").getBOSUuid("id")));
        }
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)model.getString("number")));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getBOSUuid("id"), CompareType.NOTEQUALS));
        return filter;
    }
}

