/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.common.EASBizException;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class PeriodUtils {
    static final Logger log = Logger.getLogger(PeriodUtils.class);
    private static Calendar calendar = Calendar.getInstance();
    private static int[] monthLength = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static int[] leapYearMonthLength = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final int DAILY_VALUE = 1;
    public static final int WEEKLY_VALUE = 2;
    public static final int MONTHLY_VALUE = 3;
    public static final int QUARTERLY_VALUE = 4;
    public static final int SEMIYEARLY_VALUE = 5;
    public static final int YEARLY_VALUE = 6;

    public static PeriodInfo GetCurrentPeriod(Context ctx, String companyId) throws EASBizException, BOSException {
        ISystemStatusCtrol ibiz = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        return ibiz.getCacheCurrentPeriod(1001, companyId);
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static Date getPeriodLastDate(int year, int period, int periodType) {
        int month = 0;
        int date = 0;
        calendar.clear();
        boolean isLeapYear = PeriodUtils.isLeapYear(year);
        switch (periodType) {
            case 1: {
                calendar.set(1, year);
                calendar.set(6, period);
                return calendar.getTime();
            }
            case 3: {
                if (period > 13) {
                    return null;
                }
                if (period == 13) {
                    period = 12;
                }
                date = isLeapYear ? leapYearMonthLength[period - 1] : monthLength[period - 1];
                calendar.set(year, period - 1, date);
                return calendar.getTime();
            }
            case 4: {
                month = period * 3 - 1;
                if (month > 12) {
                    return null;
                }
                date = isLeapYear ? leapYearMonthLength[month] : monthLength[month];
                calendar.set(year, month, date);
                return calendar.getTime();
            }
            case 5: {
                month = period * 6 - 1;
                if (month > 12) {
                    return null;
                }
                date = isLeapYear ? leapYearMonthLength[month] : monthLength[month];
                calendar.set(year, month, date);
                return calendar.getTime();
            }
            case 2: {
                calendar.set(1, year);
                calendar.set(3, period);
                calendar.set(7, 7);
                return calendar.getTime();
            }
            case 6: {
                calendar.set(year, 11, 31);
                return calendar.getTime();
            }
        }
        return null;
    }

    public static Date getPeriodFirstDate(int year, int period, int periodType) {
        int month = 0;
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        switch (periodType) {
            case 1: {
                calendar.set(1, year);
                calendar.set(6, period);
                return calendar.getTime();
            }
            case 3: {
                if (period == 13) {
                    return PeriodUtils.getPeriodLastDate(year, period, periodType);
                }
                calendar.set(year, period - 1, 1);
                return calendar.getTime();
            }
            case 4: {
                month = period * 3 - 3;
                calendar.set(year, month, 1);
                return calendar.getTime();
            }
            case 5: {
                month = period * 6 - 6;
                calendar.set(year, month, 1);
                return calendar.getTime();
            }
            case 2: {
                calendar.set(1, year);
                calendar.set(3, period);
                calendar.set(7, 1);
                return calendar.getTime();
            }
            case 6: {
                calendar.set(year, 0, 1);
                return calendar.getTime();
            }
        }
        return null;
    }
}

