/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import java.util.ArrayList;

public class WorkFlowUtil {
    public static boolean hasWFInstance(Context ctx, String billId) throws BOSException {
        boolean hasWorkflow = false;
        if (billId != null) {
            IEnactmentService service2 = EnactmentServiceFactory.createRemoteEnactService();
            ProcessInstInfo instInfo = null;
            ProcessInstInfo[] procInsts = service2.getProcessInstanceByHoldedObjectId(billId);
            int n = procInsts.length;
            for (int i = 0; i < n; ++i) {
                if (!"open.running".equals(procInsts[i].getState())) continue;
                instInfo = procInsts[i];
            }
            hasWorkflow = instInfo != null;
        }
        return hasWorkflow;
    }

    public static ArrayList getIDsInActiveWorkFlow(String[] keyIDs) throws BOSException {
        String[] newids = WorkFlowUtil.checkBizObjInWfProcess(keyIDs);
        ArrayList<String> idList = new ArrayList<String>();
        if (newids == null) {
            return idList;
        }
        for (int i = 0; i < newids.length; ++i) {
            idList.add(newids[i]);
        }
        return idList;
    }

    public static String[] checkBizObjInWfProcess(String[] bizObjIds) throws WfException, BOSException {
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        return service.checkBizObjInWfProcess(bizObjIds);
    }

    public static boolean checkAllBizObjInWfProcess(String[] bizObjIds) throws WfException, BOSException {
        String[] bizObjInWfProcess = WorkFlowUtil.checkBizObjInWfProcess(bizObjIds);
        return bizObjInWfProcess != null && bizObjInWfProcess.length == bizObjIds.length;
    }
}

