/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dap.client;

import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.TransModeEnum;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.BOTPMultiBillToDAPTypeErrorSchemaEnum;
import com.kingdee.eas.base.botp.client.BotLogUI;
import com.kingdee.eas.base.dap.DAPFromMultiBillTypeErrorSchemaEnum;
import com.kingdee.eas.base.dap.client.AbstractBOTMappingTransformTypeEditUI;
import com.kingdee.eas.base.job.client.ProcessSchedulePlan;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class BOTMappingTransformTypeEditUI
extends AbstractBOTMappingTransformTypeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BOTMappingTransformTypeEditUI.class);
    private BOTMappingInfo botMappingInfo;
    private EASWfServiceClient workflowClient;

    public void onLoad() throws Exception {
        int i;
        super.onLoad();
        BOTMappingInfo mappingInfo = (BOTMappingInfo)this.getUIContext().get("BOTP_UICONTEXT_MAPPINGINFO");
        if (mappingInfo != null) {
            this.setBotMappingInfo(mappingInfo);
        }
        this.btnSetInterval.setIcon(EASResource.getIcon((String)"imgTbtn_attemper"));
        int count = this.cbxTransformType.getItemCount();
        for (i = 0; i < count; ++i) {
            TransModeEnum transMode = (TransModeEnum)this.cbxTransformType.getItemAt(i);
            if (!transMode.equals((Object)TransModeEnum.All)) continue;
            this.cbxTransformType.removeItemAt(i);
            --i;
            --count;
        }
        count = this.cbxErrorOption.getItemCount();
        for (i = 0; i < count; ++i) {
            DAPFromMultiBillTypeErrorSchemaEnum errorOption = (DAPFromMultiBillTypeErrorSchemaEnum)((Object)this.cbxErrorOption.getItemAt(i));
            if (errorOption.getValue() != 3) continue;
            this.cbxErrorOption.removeItemAt(i);
            --i;
            --count;
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void cbxTransformType_itemStateChanged(ItemEvent e) throws Exception {
        super.cbxTransformType_itemStateChanged(e);
        TransModeEnum transMode = (TransModeEnum)this.cbxTransformType.getSelectedItem();
        if (transMode.equals((Object)TransModeEnum.IMCreate)) {
            this.actionSetInterval.setEnabled(false);
            this.cbxErrorOption.setEnabled(false);
        } else {
            this.actionSetInterval.setEnabled(true);
            this.cbxErrorOption.setEnabled(true);
        }
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionViewLog_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewLog_actionPerformed(e);
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"BOTMAPPINGINFO", (Object)this.botMappingInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BotLogUI.class.getName(), (Map)uiCtx);
        uiWindow.show();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        if (this.botMappingInfo.getDefineSys().equals((Object)DefineSysEnum.DAP)) {
            TransModeEnum transMode = (TransModeEnum)this.cbxTransformType.getSelectedItem();
            if (transMode.equals((Object)TransModeEnum.BGCreate)) {
                String interval = (String)this.btnSetInterval.getUserObject();
                if (interval == null || interval.length() == 0) {
                    throw new BOTPException(BOTPException.TIMEINTERVALMUSTSET);
                }
                this.botMappingInfo.getExtRule().setTransMode(TransModeEnum.BGCreate);
                this.botMappingInfo.getExtRule().setScheduleXml(interval);
                this.botMappingInfo.getExtRule().setErrorProcessOption((BOTPMultiBillToDAPTypeErrorSchemaEnum)this.cbxErrorOption.getSelectedItem());
            } else {
                this.botMappingInfo.getExtRule().setTransMode(TransModeEnum.IMCreate);
            }
        }
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public void actionSetInterval_actionPerformed(ActionEvent e) throws Exception {
        super.actionSetInterval_actionPerformed(e);
        if (this.btnSetInterval.getUserObject() == null) {
            this.btnSetInterval.setUserObject((Object)ProcessSchedulePlan.open((Object)((Object)this), null));
        } else {
            this.btnSetInterval.setUserObject((Object)ProcessSchedulePlan.open((Object)((Object)this), (String)this.btnSetInterval.getUserObject().toString()));
        }
    }

    public BOTMappingInfo getBotMappingInfo() {
        return this.botMappingInfo;
    }

    public void setBotMappingInfo(BOTMappingInfo botMappingInfo) {
        this.botMappingInfo = botMappingInfo;
        if (this.botMappingInfo.getDefineSys().equals((Object)DefineSysEnum.DAP)) {
            TransModeEnum transMode = this.botMappingInfo.getExtRule().getTransMode();
            if (this.botMappingInfo.getExtRule().getScheduleXml() != null && this.botMappingInfo.getExtRule().getScheduleXml().length() > 0) {
                this.btnSetInterval.setUserObject((Object)this.botMappingInfo.getExtRule().getScheduleXml());
            } else if (this.botMappingInfo.getExtRule().getProcessDefId() != null && (this.botMappingInfo.getExtRule().getProcessDefId().length() == 44 || this.botMappingInfo.getExtRule().getProcessDefId().length() == 28)) {
                try {
                    EASWfServiceClient client = this.getWorkflowClient();
                    ProcessDefInfo processDefInfo = client.getProcessDefInfo(this.botMappingInfo.getExtRule().getProcessDefId());
                    String kpdl = EnactmentServiceFactory.createRemoteEnactService().getProcessDefByDefineHashValue(processDefInfo.getMd5HashValue()).toXml();
                    String scheduleXml = KpdlParser.getScheduleXml((String)kpdl);
                    this.btnSetInterval.setUserObject((Object)scheduleXml);
                    this.botMappingInfo.getExtRule().setScheduleXml(scheduleXml);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    e.printStackTrace();
                }
            }
            if (transMode.equals((Object)TransModeEnum.BGCreate)) {
                this.actionSetInterval.setEnabled(true);
                this.cbxErrorOption.setEnabled(true);
                this.cbxTransformType.setSelectedItem((Object)TransModeEnum.BGCreate);
                if (this.botMappingInfo.getExtRule().getErrorProcessOption() != null) {
                    this.cbxErrorOption.setSelectedItem((Object)this.botMappingInfo.getExtRule().getErrorProcessOption());
                }
            } else {
                this.actionSetInterval.setEnabled(false);
                this.cbxErrorOption.setEnabled(false);
                this.cbxTransformType.setSelectedItem((Object)TransModeEnum.IMCreate);
            }
        }
    }

    private EASWfServiceClient getWorkflowClient() throws Exception {
        if (this.workflowClient == null) {
            this.workflowClient = new EASWfServiceClient();
            this.workflowClient.init(UIConfig.getUrl(), SysContext.getSysContext().getSessionID());
        }
        return this.workflowClient;
    }
}

