/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeCellRenderer;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.bot.MappingTypeEnum;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIDialog;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.BotpExtConfigHelper;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.btp.client.BTPBillListImpl;
import com.kingdee.eas.base.dap.AbstractDAPVoucherStrategy;
import com.kingdee.eas.base.dap.DAPException;
import com.kingdee.eas.base.dap.DAPFromMultiBillTypeEntryCollection;
import com.kingdee.eas.base.dap.DAPFromMultiBillTypeEntryInfo;
import com.kingdee.eas.base.dap.DAPFromMultiBillTypeFactory;
import com.kingdee.eas.base.dap.DAPFromMultiBillTypeInfo;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.DAPVoucherTypeEnum;
import com.kingdee.eas.base.dap.IDAPFromMultiBillType;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.base.dap.client.AbstractDAPFromMultiBillTypeEditUI;
import com.kingdee.eas.base.dap.client.DAPGenerateOptionDialog;
import com.kingdee.eas.base.dap.client.DAPMakeFromMultiBillListUI;
import com.kingdee.eas.base.dap.client.DAPMappingSelectUI;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.framework.BillBaseException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class DAPFromMultiBillTypeEditUI
extends AbstractDAPFromMultiBillTypeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DAPFromMultiBillTypeEditUI.class);
    private static final String defaultId = "00000000-0000-0000-0000-0000000000003ED9B47D";
    public static final String STATUS_ADDNEW = "ADDNEW";
    public static final String STATUS_EDIT = "EDIT";
    public static final String STATUS_VIEW = "VIEW";
    private static final String VOUCHERTYPE = "2652E01E";
    public static final String GENERATETYPE = "GENERATETYPE";
    public static final String ERRORPROCESS = "ERRORPROCESS";
    public static final String OPTIONONSAVE = "OPTIONONSAVE";
    private List bosTypeList = new ArrayList();
    private DefaultKingdeeTreeCellRenderer defaultTreeRender;
    private Color backgroundSelectionColor;
    private Color backgroundNonSelectionColor;
    private IUIObject currentBillListUI;
    private Map bosTypeToEntity;
    private Map bosTypeToDapMultiInfo;
    private static final String DAPRES = "com.kingdee.eas.base.dap.DAPResource";
    private String destBillBosType = AbstractDAPVoucherStrategy.getInstanceof("fi").getVoucherInfo().getBOSType().toString();
    private IBOTMapping botMapping = BOTMappingFactory.getRemoteInstance();
    private BOTMappingInfo botMappingInfo = null;
    private EntityViewInfo botpFilter = null;
    public static final String EDITRULE = "EDITRULE";
    private static final String VOUCHERFLAG = "fiVouchered";

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnViewVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_downview"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnOption.setIcon(EASResource.getIcon((String)"imgTbtn_setting"));
        this.btnGeneration.setIcon(EASResource.getIcon((String)"imgTbtn_createcredence"));
    }

    public void onLoad() throws Exception {
        this.destBillBosType = VOUCHERTYPE;
        this.initData();
        super.onLoad();
        this.initBtnState();
        this.bosTypeToEntity = new HashMap();
        this.bosTypeToDapMultiInfo = new HashMap();
        this.tblPnlBillList.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                final ChangeEvent ce = e;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        KDTabbedPane tabpane = (KDTabbedPane)ce.getSource();
                        if (tabpane.getSelectedComponent() instanceof IUIObject) {
                            DAPFromMultiBillTypeEditUI.this.currentBillListUI = (IUIObject)tabpane.getSelectedComponent();
                        } else {
                            DAPFromMultiBillTypeEditUI.this.currentBillListUI = null;
                        }
                    }
                });
            }
        });
        this.setColor();
        this.loadBosTypeList();
        this.defaultTreeRender = new DefaultKingdeeTreeCellRenderer();
        this.initTreeView();
        this.initTabPanel();
    }

    private void initBtnState() {
        String oprtState = this.getOprtState();
        this.actionQuery.setEnabled(true);
        this.actionView.setEnabled(true);
        this.actionRefresh.setEnabled(true);
        this.actionViewVoucher.setEnabled(true);
        this.actionGeneration.setEnabled(true);
        this.actionOption.setEnabled(true);
        if (STATUS_ADDNEW.equals(oprtState) || STATUS_EDIT.equals(oprtState)) {
            this.actionSubmit.setEnabled(true);
        } else {
            this.actionSubmit.setEnabled(false);
        }
    }

    private void initData() throws EASBizException, BOSException {
        if (STATUS_ADDNEW.equals(this.getOprtState())) {
            this.entityDAPFromMultiBillType = new DAPFromMultiBillTypeInfo();
        } else {
            String id = defaultId;
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
            this.entityDAPFromMultiBillType = this.getValue((IObjectPK)pk);
        }
    }

    private DAPFromMultiBillTypeInfo getValue(IObjectPK pk) throws EASBizException, BOSException {
        IDAPFromMultiBillType dapFromMulti = DAPFromMultiBillTypeFactory.getRemoteInstance();
        if (dapFromMulti.exists(pk)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("number");
            sic.add("name");
            sic.add("entries.srcBosType");
            sic.add("entries.botMappingInfo");
            this.setOprtState(STATUS_EDIT);
            return dapFromMulti.getDAPFromMultiBillTypeInfo(pk);
        }
        this.setOprtState(STATUS_ADDNEW);
        return new DAPFromMultiBillTypeInfo();
    }

    private void initTabPanel() {
        for (String string : this.bosTypeList) {
        }
    }

    private void setColor() {
        this.backgroundSelectionColor = UIManager.getColor("Tree.selectionBackground");
        this.backgroundNonSelectionColor = UIManager.getColor("Tree.textBackground");
    }

    private void loadBosTypeList() {
        DAPFromMultiBillTypeEntryCollection entries;
        if (this.entityDAPFromMultiBillType != null && (entries = this.entityDAPFromMultiBillType.getEntries()) != null) {
            Iterator entryIter = entries.iterator();
            while (entryIter.hasNext()) {
                DAPFromMultiBillTypeEntryInfo entryInfo = (DAPFromMultiBillTypeEntryInfo)entryIter.next();
                this.bosTypeList.add(entryInfo.getSrcBosType());
            }
        }
    }

    private void initTreeView() {
        this.treeSrcBosType.setCellRenderer(new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DAPBosTypeInfo dapMultiInfo = (DAPBosTypeInfo)((DefaultKingdeeTreeNode)value).getUserObject();
                if (dapMultiInfo.getBriefInfo().getMetaDataType().equals((Object)MetaDataTypeList.ENTITY)) {
                    KDCheckBox cellRender = null;
                    if (dapMultiInfo.getCellRender() != null) {
                        cellRender = (KDCheckBox)dapMultiInfo.getCellRender();
                    }
                    if (cellRender == null) {
                        cellRender = new KDCheckBox();
                        cellRender.setName("cellRender");
                        cellRender.setText(dapMultiInfo.toString());
                        dapMultiInfo.setCellRender((Component)cellRender);
                    }
                    cellRender.setSelected(dapMultiInfo.isSelected());
                    if (selected) {
                        cellRender.setBackground(DAPFromMultiBillTypeEditUI.this.backgroundSelectionColor);
                    } else {
                        cellRender.setBackground(DAPFromMultiBillTypeEditUI.this.backgroundNonSelectionColor);
                    }
                    return cellRender;
                }
                return DAPFromMultiBillTypeEditUI.this.defaultTreeRender.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            }
        });
        DefaultKingdeeTreeNode root = SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)SubSystemUtils.getRemoveEmptyPackageNode((IBriefViewTreeNode)SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_base_botp", (BOSObjectType)MetaDataTypeList.ENTITY)));
        this.resetBosTypeTree(root);
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        this.treeSrcBosType.setModel((TreeModel)model);
    }

    @Override
    protected void tree_mouseClicked(MouseEvent e) throws Exception {
        TreePath path;
        DefaultKingdeeTreeNode node;
        DAPBosTypeInfo dapMultiInfo;
        int row = this.treeSrcBosType.getRowForLocation(e.getX(), e.getY());
        if (row != -1 && (dapMultiInfo = (DAPBosTypeInfo)(node = (DefaultKingdeeTreeNode)(path = this.treeSrcBosType.getPathForLocation(e.getX(), e.getY())).getLastPathComponent()).getUserObject()).getCellRender() != null) {
            KDCheckBox cellRender = (KDCheckBox)dapMultiInfo.getCellRender();
            boolean selectedStatus = !cellRender.isSelected();
            this.treeSrcBosType.repaint();
            this.changeBosTypeSelect(dapMultiInfo, selectedStatus);
        }
    }

    protected void changeBosTypeSelect(DAPBosTypeInfo dapMultiInfo, boolean selectedStatus) throws BOTPException, DAPException, BOSException {
        MetaDataBriefInfo briefInfo = dapMultiInfo.getBriefInfo();
        String bosType = this.getBosTypeFromBriefInfo(briefInfo);
        if (selectedStatus) {
            BOTMappingCollection botMappingCollection = null;
            botMappingCollection = this.botMapping.getMappingCollectionForSelect(bosType, this.destBillBosType, DefineSysEnum.DAP);
            if (botMappingCollection == null || botMappingCollection.size() == 0) {
                return;
            }
            for (int i = 0; i < botMappingCollection.size(); ++i) {
                BOTMappingInfo mInfo = botMappingCollection.get(i);
                if (mInfo.getMappingType() == MappingTypeEnum.Standard) continue;
                botMappingCollection.removeObject(i);
                --i;
            }
            if (botMappingCollection.size() > 0) {
                HashMap<String, DAPFromMultiBillTypeEditUI> uiContext = new HashMap<String, DAPFromMultiBillTypeEditUI>();
                uiContext.put("Owner", this);
                uiContext.put("BOTMappings", (DAPFromMultiBillTypeEditUI)botMappingCollection);
                IUIWindow window = null;
                window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DAPMappingSelectUI.class.getName(), uiContext, null);
                window.show();
                if (((DAPMappingSelectUI)window.getUIObject()).isCanceled() || ((DAPMappingSelectUI)window.getUIObject()).getSelectBotMappingInfo() == null) {
                    return;
                }
                this.botMappingInfo = ((DAPMappingSelectUI)window.getUIObject()).getSelectBotMappingInfo();
            } else {
                this.botMappingInfo = botMappingCollection.get(0);
            }
            if (this.botMappingInfo != null) {
                try {
                    this.botpFilter = this.getQueryFilterFromBotMapping(this.botMappingInfo);
                }
                catch (ParserException e1) {
                    logger.error((Object)e1.getMessage());
                }
                catch (BOSException e2) {
                    logger.error((Object)e2.getMessage());
                }
            }
            this.addBosTypeToSchema(bosType, this.botMappingInfo, this.botpFilter);
            this.bosTypeToDapMultiInfo.put(bosType, dapMultiInfo);
            this.bosTypeList.add(bosType);
            dapMultiInfo.setSelected(selectedStatus);
        } else {
            this.botpFilter = null;
            this.botMappingInfo = null;
            this.removeBosTypeFromSchema(bosType);
            dapMultiInfo.setSelected(false);
        }
    }

    private void removeBosTypeFromSchema(String bosType) {
        int index = this.bosTypeList.indexOf(bosType);
        if (index < 0) {
            return;
        }
        this.bosTypeList.remove(bosType);
        if (this.bosTypeToDapMultiInfo.containsKey(bosType)) {
            DAPBosTypeInfo currentDapMultiInfo = (DAPBosTypeInfo)this.bosTypeToDapMultiInfo.get(bosType);
            currentDapMultiInfo.setSelected(false);
        }
        Component srcBillListUi = this.tblPnlBillList.getComponentAt(index);
        this.tblPnlBillList.removeTabAt(index);
        if (srcBillListUi != null && srcBillListUi instanceof DAPMakeFromMultiBillListUI && ((DAPMakeFromMultiBillListUI)((Object)srcBillListUi)).getUIWindow() != null) {
            ((DAPMakeFromMultiBillListUI)((Object)srcBillListUi)).getUIWindow().close();
        }
    }

    private void addBosTypeToSchema(String bosType, BOTMappingInfo botMappingInfo, EntityViewInfo botpFilter) throws BOTPException, DAPException, BOSException {
        EntityObjectInfo srcEntity;
        if (this.bosTypeToEntity.containsKey(bosType)) {
            srcEntity = (EntityObjectInfo)this.bosTypeToEntity.get(bosType);
        } else {
            IMetaDataLoader metadataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            srcEntity = metadataLoader.getEntity(new BOSObjectType(bosType));
        }
        this.bosTypeToEntity.put(bosType, srcEntity);
        String alias = srcEntity.getAlias();
        IUIObject billListUI = this.newTab(bosType, botMappingInfo, botpFilter);
        this.tblPnlBillList.addTab(alias, (Component)((Object)((DAPMakeFromMultiBillListUI)billListUI)));
        if (this.tblPnlBillList.getTabCount() > 0 && this.tblPnlBillList.getSelectedIndex() < 0) {
            this.tblPnlBillList.setSelectedIndex(0);
        }
    }

    private String getBosTypeFromBriefInfo(MetaDataBriefInfo briefInfo) {
        return briefInfo.getBOType().toString();
    }

    private void resetBosTypeTree(DefaultKingdeeTreeNode root) {
        if (root != null) {
            String bosType;
            MetaDataBriefInfo briefInfo = (MetaDataBriefInfo)root.getUserObject();
            DAPBosTypeInfo dapMultiInfo = new DAPBosTypeInfo();
            dapMultiInfo.setBriefInfo(briefInfo);
            if (briefInfo.getMetaDataType().equals((Object)MetaDataTypeList.ENTITY) && this.bosTypeList.contains(bosType = briefInfo.getBOType().toString())) {
                dapMultiInfo.setSelected(true);
            }
            root.setUserObject((Object)dapMultiInfo);
            int count = root.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.resetBosTypeTree((DefaultKingdeeTreeNode)root.getChildAt(i));
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.currentBillListUI != null) {
            ((DAPMakeFromMultiBillListUI)this.currentBillListUI).actionQuery_actionPerformed(e);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        if (this.currentBillListUI != null) {
            ((DAPMakeFromMultiBillListUI)this.currentBillListUI).actionRefresh_actionPerformed(e);
        }
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
        if (this.currentBillListUI != null) {
            ((DAPMakeFromMultiBillListUI)this.currentBillListUI).actionView_actionPerformed(e);
        }
    }

    @Override
    public void actionViewVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewVoucher_actionPerformed(e);
        if (this.currentBillListUI != null) {
            CoreBillBaseCollection bills = ((DAPMakeFromMultiBillListUI)this.currentBillListUI).getSrcBillCollection();
            BTPBillListImpl btpListImpl = new BTPBillListImpl((CoreBillListUI)((DAPMakeFromMultiBillListUI)this.currentBillListUI).getCurrentBillListUI());
            HashMap<String, String> navCtx = new HashMap<String, String>();
            navCtx.put("NAVBOSTYPE", VOUCHERTYPE);
            btpListImpl.traceDown(bills, ((CoreBillListUI)((DAPMakeFromMultiBillListUI)this.currentBillListUI).getCurrentBillListUI()).getEntriesPKName(), navCtx);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.storeBosTypeAndBotMapping();
        this.persistent();
        this.showSubmitSuccess();
    }

    private void showSubmitSuccess() {
        String submitMsg = EASResource.getString((String)DAPRES, (String)"DAPFROMMULTIBILLTYPESUBMITSUCCESS");
        this.setMessageText(submitMsg);
        this.showMessage();
    }

    private void persistent() throws EASBizException, BOSException {
        this.entityDAPFromMultiBillType.setId(BOSUuid.read((String)defaultId));
        IDAPFromMultiBillType dapSchema = DAPFromMultiBillTypeFactory.getRemoteInstance();
        dapSchema.submit((CoreBaseInfo)this.entityDAPFromMultiBillType);
    }

    private void storeBosTypeAndBotMapping() throws DAPException {
        if (this.bosTypeList == null || this.bosTypeList.size() == 0) {
            throw new DAPException(DAPException.DAPFROMMULTIBILLMUSTHASSCHEMA);
        }
        ArrayList initialBosTypeList = new ArrayList(this.bosTypeList);
        DAPFromMultiBillTypeEntryCollection entries = this.entityDAPFromMultiBillType.getEntries();
        Iterator entryIter = entries.iterator();
        while (entryIter.hasNext()) {
            DAPFromMultiBillTypeEntryInfo entryInfo = (DAPFromMultiBillTypeEntryInfo)entryIter.next();
            String bosType = entryInfo.getSrcBosType();
            if (this.bosTypeList.contains(bosType)) {
                int index = this.bosTypeList.indexOf(bosType);
                Component billList = this.tblPnlBillList.getComponentAt(index);
                if (billList != null) {
                    BOTMappingInfo botMappingInfo = ((DAPMakeFromMultiBillListUI)((Object)billList)).getCurMappingInfo();
                    if (botMappingInfo != null) {
                        entryInfo.setBotMappingInfo(botMappingInfo);
                    } else {
                        throw new DAPException(DAPException.ENTITYHASNOTBOTMAPPING, new Object[]{entryInfo.getSrcBosType()});
                    }
                }
                initialBosTypeList.remove(bosType);
                continue;
            }
            entryIter.remove();
        }
        for (String bosType : initialBosTypeList) {
            DAPFromMultiBillTypeEntryInfo entryInfo = new DAPFromMultiBillTypeEntryInfo();
            entryInfo.setSrcBosType(bosType);
            entryInfo.setSchema(this.entityDAPFromMultiBillType);
            this.entityDAPFromMultiBillType.getEntries().add(entryInfo);
            int index = this.bosTypeList.indexOf(bosType);
            Component billList = this.tblPnlBillList.getComponentAt(index);
            if (billList != null) {
                BOTMappingInfo botMappingInfo = ((DAPMakeFromMultiBillListUI)((Object)billList)).getCurMappingInfo();
                if (botMappingInfo != null) {
                    entryInfo.setBotMappingInfo(botMappingInfo);
                    continue;
                }
                throw new DAPException(DAPException.ENTITYHASNOTBOTMAPPING, new Object[]{entryInfo.getSrcBosType()});
            }
            EntityObjectInfo entity = (EntityObjectInfo)this.bosTypeToEntity.get(bosType);
            throw new DAPException(DAPException.ENTITYHASNOTBOTMAPPING, new Object[]{entity.getAlias()});
        }
    }

    @Override
    public void actionOption_actionPerformed(ActionEvent e) throws Exception {
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("Owner", (Object)this);
        ctx.put(GENERATETYPE, (Object)this.entityDAPFromMultiBillType.getGenerateType());
        ctx.put(ERRORPROCESS, (Object)this.entityDAPFromMultiBillType.getErrorSchema());
        ctx.put(OPTIONONSAVE, (Object)this.entityDAPFromMultiBillType.getOnSaveSchema());
        IUIWindow uiWin = uiFactory.create(DAPGenerateOptionDialog.class.getName(), ctx);
        uiWin.show();
        DAPGenerateOptionDialog genOptionDlg = (DAPGenerateOptionDialog)uiWin.getUIObject();
        if (!genOptionDlg.isCancel()) {
            this.entityDAPFromMultiBillType.setGenerateType(genOptionDlg.getGenerateType());
            this.entityDAPFromMultiBillType.setErrorSchema(genOptionDlg.getErrorOption());
            this.entityDAPFromMultiBillType.setOnSaveSchema(genOptionDlg.getOptionOnSave());
        }
    }

    protected void verifyBillList(CoreBillBaseCollection sourceBillCollection) throws EASBizException {
        for (CoreBillBaseInfo sourceBill : sourceBillCollection) {
            if (!sourceBill.getBoolean(VOUCHERFLAG)) continue;
            throw new BillBaseException(BillBaseException.FIVOUCHERED);
        }
    }

    @Override
    public void actionGeneration_actionPerformed(ActionEvent e) throws Exception {
        DAPMakeFromMultiBillListUI billListUI;
        int i;
        CoreBillBaseCollection billList = new CoreBillBaseCollection();
        IDAPTransformer iDap = DAPTransformerFactory.getRemoteInstance();
        ArrayList<BOSUuid> botMappingIdList = new ArrayList<BOSUuid>();
        ArrayList<CoreBillBaseCollection> srcBillColsList = new ArrayList<CoreBillBaseCollection>();
        if (this.tblPnlBillList.getTabCount() == 0) {
            return;
        }
        int count = this.tblPnlBillList.getTabCount();
        for (i = 0; i < count; ++i) {
            billListUI = (DAPMakeFromMultiBillListUI)((Object)this.tblPnlBillList.getComponentAt(i));
            if (billListUI == null) {
                throw new DAPException(DAPException.BILLHASNOSELECT, new Object[]{((EntityObjectInfo)this.bosTypeToEntity.get(this.bosTypeList.get(i))).getAlias()});
            }
            CoreBillBaseCollection currentBillList = billListUI.getSrcBillCollection();
            if (currentBillList == null || currentBillList.size() == 0) {
                MsgBox.showWarning((String)(billListUI.getEntityDisplayName() + " " + EASResource.getString((String)DAPRES, (String)"HasNoSrcBills")));
                SysUtil.abort();
            }
            this.verifyBillList(currentBillList);
            billListUI.getSrcListUI().beforeTransform((IObjectCollection)currentBillList, VOUCHERTYPE);
            billList.addObjectCollection((IObjectCollection)currentBillList);
            srcBillColsList.add(currentBillList);
            BOTMappingInfo botMappingInfo = billListUI.getCurMappingInfo();
            if (botMappingInfo != null) {
                botMappingIdList.add(botMappingInfo.getId());
                continue;
            }
            MsgBox.showWarning((String)(billListUI.getEntityDisplayName() + " " + EASResource.getString((String)DAPRES, (String)"HasNoDAPRuleSetting")));
            SysUtil.abort();
        }
        iDap.generateVoucher(srcBillColsList, DAPVoucherTypeEnum.FIVoucher, botMappingIdList);
        this.afterGenerateVoucher((IObjectCollection)billList);
        count = this.tblPnlBillList.getTabCount();
        for (i = 0; i < count; ++i) {
            billListUI = (DAPMakeFromMultiBillListUI)((Object)this.tblPnlBillList.getComponentAt(i));
            billListUI.removeAllBills();
        }
        srcBillColsList.clear();
        billList.clear();
    }

    private void storeBillSelectedPerBillType() throws DAPException {
        int count = this.tblPnlBillList.getTabCount();
        for (int i = 0; i < count; ++i) {
            DAPMakeFromMultiBillListUI billListUI = (DAPMakeFromMultiBillListUI)((Object)this.tblPnlBillList.getComponentAt(i));
            if (billListUI != null) continue;
            throw new DAPException(DAPException.BILLHASNOSELECT, new Object[]{((EntityObjectInfo)this.bosTypeToEntity.get(this.bosTypeList.get(i))).getAlias()});
        }
    }

    private void afterGenerateVoucher(IObjectCollection srcBillCols) throws Exception {
        if (srcBillCols == null || srcBillCols.size() == 0) {
            return;
        }
        Object[] sourceBillPkList = new IObjectPK[srcBillCols.size()];
        Iterator iter = srcBillCols.iterator();
        int index = 0;
        while (iter.hasNext()) {
            CoreBillBaseInfo sourceBill = (CoreBillBaseInfo)iter.next();
            sourceBillPkList[index] = new ObjectUuidPK(sourceBill.getId());
            ++index;
        }
        IBOTRelation iBotRelation = BOTRelationFactory.getRemoteInstance();
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer sbMaskString = new StringBuffer("(");
        String strIdLists = StringUtils.arrayToString((Object[])sourceBillPkList, (String)",");
        sbMaskString.append("#" + String.valueOf(filter.getFilterItems().size()));
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)strIdLists, CompareType.INCLUDE));
        sbMaskString.append(") and #");
        sbMaskString.append(String.valueOf(filter.getFilterItems().size()));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)VOUCHERTYPE));
        filter.setMaskString(sbMaskString.toString());
        entityView.setFilter(filter);
        BOTRelationCollection relationCollection = iBotRelation.getCollection(entityView);
        boolean isTempSave = false;
        boolean isOnlyShowLast = false;
        BOSUuid billId = ((CoreBillBaseInfo)srcBillCols.getObject(0)).getId();
        if (billId.getType().toString().equals("23B52381")) {
            isOnlyShowLast = true;
        }
        StringBuffer sbVoucherNumbers = new StringBuffer("");
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.add("id");
        sic.add("number");
        sic.add("bizStatus");
        sic.add("company.*");
        SorterItemInfo createTimeSorter = new SorterItemInfo("createTime");
        createTimeSorter.setSortType(SortType.DESCEND);
        evi.getSorter().add(createTimeSorter);
        FilterInfo voucherIdFilter = new FilterInfo();
        evi.setFilter(voucherIdFilter);
        AbstractObjectCollection voucherCols = null;
        if (relationCollection.size() > 0) {
            int voucherIndex = 0;
            StringBuffer voucherFilterMask = new StringBuffer();
            Iterator iter2 = relationCollection.iterator();
            StringBuffer strVchIdLists = new StringBuffer();
            while (iter2.hasNext()) {
                BOTRelationInfo relationInfo = (BOTRelationInfo)iter2.next();
                String voucherId = relationInfo.getDestObjectID();
                if (voucherIndex > 0) {
                    strVchIdLists.append(",");
                }
                strVchIdLists.append(voucherId);
                ++voucherIndex;
            }
            voucherFilterMask.append("#" + String.valueOf(voucherIdFilter.getFilterItems().size()));
            voucherIdFilter.getFilterItems().add(new FilterItemInfo("id", (Object)strVchIdLists.toString(), CompareType.INCLUDE));
            voucherIdFilter.setMaskString(voucherFilterMask.toString());
            voucherCols = AbstractDAPVoucherStrategy.getInstanceof("fi").getVoucherCollection(evi);
            int size = voucherCols.size();
            for (int i = 0; i < size; ++i) {
                CoreBillBaseInfo voucher = (CoreBillBaseInfo)voucherCols.getObject(i);
                if (sbVoucherNumbers.length() > 0) {
                    sbVoucherNumbers.append(" , " + voucher.getNumber());
                } else {
                    sbVoucherNumbers.append(voucher.getNumber());
                }
                if (!isTempSave && AbstractDAPVoucherStrategy.getInstanceof("fi").isTempVoucher(voucher)) {
                    isTempSave = true;
                }
                if (isOnlyShowLast) break;
            }
        }
        DAPFromMultiBillTypeEditUI ownerComponent = this;
        String botMappingId = relationCollection.get(0).getBOTMappingID();
        IBOTMapping iBOTMapping = BOTMappingFactory.getRemoteInstance();
        BOTMappingInfo botMappingInfo = iBOTMapping.getMappingInfoByPK((IObjectPK)new ObjectUuidPK(botMappingId));
        if (isTempSave) {
            if (botMappingInfo.getIsShowEditUI() == 1) {
                this.sortByRule(botMappingInfo, voucherCols);
                CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
                if (company.isIsBizUnit()) {
                    this.viewVouchers((Component)((Object)ownerComponent), voucherCols, OprtState.EDIT);
                } else {
                    this.viewVouchers((Component)((Object)ownerComponent), voucherCols, OprtState.VIEW);
                }
            } else {
                String msgForShow = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.base.dap.DAPResource.Msg_SaveVoucher_1"), sbVoucherNumbers.toString());
                MsgBox.showInfo((Component)((Object)ownerComponent), (String)msgForShow);
            }
        } else if (botMappingInfo.getIsShowEditUI() == 1) {
            this.sortByRule(botMappingInfo, voucherCols);
            this.viewVouchers((Component)((Object)ownerComponent), voucherCols, OprtState.VIEW);
        } else {
            MsgBox.showInfo((Component)((Object)ownerComponent), (String)(EASResource.getString((String)"com.kingdee.eas.base.dap.DAPResource.Msg_SumbitVoucher_1") + sbVoucherNumbers.toString() + EASResource.getString((String)"com.kingdee.eas.base.dap.DAPResource.Msg_SumbitVoucher_2")));
        }
    }

    private void viewVouchers(Component ownerComponent, AbstractObjectCollection voucherCol, String soprState) throws UIException {
        if (voucherCol == null || voucherCol.size() == 0) {
            return;
        }
        IIDList voucherIDList = this.collectionList2IIDList((IObjectCollection)voucherCol);
        String voucherId = voucherIDList.getFirstID();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)voucherId);
        uiContext.put((Object)"Owner", (Object)ownerComponent);
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        if (company.isIsBizUnit()) {
            uiContext.put((Object)"company", (Object)SysContext.getSysContext().getCurrentFIUnit());
        } else {
            uiContext.put((Object)"company", voucherCol.getObject(0).get("company"));
        }
        uiContext.put((Object)"NOTLICHA", (Object)"NOTLICHA");
        uiContext.put((Object)"BOTPViewStatus", (Object)1);
        uiContext.put((Object)AbstractDAPVoucherStrategy.getInstanceof("fi").getVoucherEditUIEditRule(), (Object)AbstractDAPVoucherStrategy.getInstanceof("fi").getDefaultVoucherEditRule());
        String uiClass = AbstractDAPVoucherStrategy.getInstanceof("fi").getVoucherEditUIClass();
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiClass, (Map)uiContext, null, soprState);
        uiWindow.show();
    }

    private IIDList collectionList2IIDList(IObjectCollection al) {
        RealModeIDList List2 = RealModeIDList.getEmptyIDList();
        if (al != null && al.size() != 0) {
            for (int i = 0; i < al.size(); ++i) {
                IObjectValue vo = al.getObject(i);
                String curID = vo.get("id").toString();
                List2.add(i, curID);
            }
        }
        return List2;
    }

    private void sortByRule(BOTMappingInfo botMappingInfo, AbstractObjectCollection voucherCols) throws Exception {
        block6: {
            BaseVoucherInfo voucher;
            int i;
            String extconfig = botMappingInfo.getExtConfig();
            BotpExtConfigHelper.ExtConfigInfo info = null;
            BotpExtConfigHelper.XMLProcessor processor = new BotpExtConfigHelper.XMLProcessor(new BotpExtConfigHelper());
            if (extconfig == null || extconfig.equals("")) break block6;
            info = processor.marshallingExtConfig(extconfig);
            if (info.getOrderField() == null || info.getOrderField().equals("")) {
                return;
            }
            String orderField = info.getOrderField();
            String orderStyle = info.getOrderStyle();
            VoucherInfoComparator comparator = new VoucherInfoComparator(orderField);
            ArrayList<BaseVoucherInfo> list = new ArrayList<BaseVoucherInfo>();
            int size = voucherCols.size();
            for (i = 0; i < size; ++i) {
                voucher = (BaseVoucherInfo)voucherCols.getObject(i);
                list.add(voucher);
            }
            Collections.sort(list, comparator);
            voucherCols.clear();
            if (orderStyle.equals("asc")) {
                size = list.size();
                for (i = 0; i < size; ++i) {
                    voucher = (BaseVoucherInfo)list.get(i);
                    voucherCols.addObject((IObjectValue)voucher);
                }
            } else {
                for (i = list.size(); i > 0; --i) {
                    BaseVoucherInfo voucher2 = (BaseVoucherInfo)list.get(i - 1);
                    voucherCols.addObject((IObjectValue)voucher2);
                }
            }
        }
    }

    private IUIObject newTab(String srcBosType, BOTMappingInfo botMappingInfo, EntityViewInfo botpFilter) throws BOTPException, BOSException, DAPException {
        this.setCursorOfWair();
        HashMap<String, DAPFromMultiBillTypeEditUI> uiCtx = new HashMap<String, DAPFromMultiBillTypeEditUI>();
        uiCtx.put("Owner", this);
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            uiCtx.put("BTPEDITPARAMETER", (DAPFromMultiBillTypeEditUI)((Object)this.getUIContext().get("BTPEDITPARAMETER")));
        }
        uiCtx.put("BOTPFilter", (DAPFromMultiBillTypeEditUI)botpFilter);
        uiCtx.put("botMappingInfo", (DAPFromMultiBillTypeEditUI)botMappingInfo);
        IUIObject uiObj = UIFactoryHelper.initUIObject((String)DAPMakeFromMultiBillListUI.class.getName(), uiCtx, null, (String)"FINDVIEW");
        DAPMakeFromMultiBillListUI srcListUI = (DAPMakeFromMultiBillListUI)uiObj;
        srcListUI.setSrcBosType(srcBosType);
        int width = 800;
        int height = 542;
        srcListUI.getUIContentPane().setSize(new Dimension(width, height));
        this.setCursorOfDefault();
        return srcListUI;
    }

    public static String getEditUIModal(IUIObject ui) {
        IUIWindow win = ui.getUIWindow();
        if (win instanceof UINewFrame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        if (win instanceof UIDialog) {
            return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
    }

    protected boolean checkBeforeWindowClosing() {
        int size = this.tblPnlBillList.getTabCount();
        for (int i = 0; i < size; ++i) {
            Component srcBillListUi = this.tblPnlBillList.getComponentAt(i);
            if (srcBillListUi == null || !(srcBillListUi instanceof DAPMakeFromMultiBillListUI) || ((DAPMakeFromMultiBillListUI)((Object)srcBillListUi)).getUIWindow() == null) continue;
            ((DAPMakeFromMultiBillListUI)((Object)srcBillListUi)).getUIWindow().close();
        }
        return super.checkBeforeWindowClosing();
    }

    private EntityViewInfo getQueryFilterFromBotMapping(BOTMappingInfo botMappingInfo) throws ParserException, BOSException {
        EntityViewInfo filter = null;
        if (botMappingInfo.getExtRule().getFilter() != null && botMappingInfo.getExtRule().getFilter().length() > 0) {
            filter = BOTPTools.getEntityViewInfoFromMapping((BOTMappingInfo)botMappingInfo, (int)0);
        }
        EntityViewInfo dataFilter = null;
        if (botMappingInfo.getExtRule().getDataFilter() != null && botMappingInfo.getExtRule().getDataFilter().length() > 0) {
            dataFilter = BOTPTools.getEntityViewInfoFromMapping((BOTMappingInfo)botMappingInfo, (int)1);
        }
        EntityViewInfo botpFilter = this.mergeEntityFilterAndTransToQueryFilter(filter, dataFilter);
        return botpFilter;
    }

    private EntityViewInfo mergeEntityFilterAndTransToQueryFilter(EntityViewInfo filter, EntityViewInfo dataFilter) throws BOSException {
        EntityViewInfo botpFilter = new EntityViewInfo();
        if (filter == null) {
            botpFilter = dataFilter;
        } else if (dataFilter == null) {
            botpFilter = filter;
        } else {
            FilterInfo billFilter = null;
            if (filter.getFilter() == null || filter.getFilter().getFilterItems().size() == 0) {
                billFilter = dataFilter.getFilter();
            } else if (dataFilter.getFilter() == null || dataFilter.getFilter().getFilterItems().size() == 0) {
                billFilter = filter.getFilter();
            } else {
                billFilter = filter.getFilter();
                billFilter.mergeFilter(dataFilter.getFilter(), "and");
            }
            if (billFilter == null) {
                billFilter = new FilterInfo();
            }
            botpFilter.setFilter(billFilter);
            FilterCollection entryFilterCols = null;
            if (filter.getEntryFilters() == null && filter.getEntryFilters().size() == 0) {
                entryFilterCols = dataFilter.getEntryFilters();
            } else if (dataFilter.getEntryFilters() == null || dataFilter.getEntryFilters().size() == 0) {
                entryFilterCols = filter.getEntryFilters();
            } else {
                entryFilterCols = new FilterCollection();
                entryFilterCols.addObjectCollection((IObjectCollection)filter.getEntryFilters());
                entryFilterCols.addObjectCollection((IObjectCollection)dataFilter.getEntryFilters());
            }
            if (entryFilterCols != null && entryFilterCols.size() > 0) {
                botpFilter.getEntryFilters().addObjectCollection((IObjectCollection)entryFilterCols);
            }
        }
        if (botpFilter == null) {
            botpFilter = new EntityViewInfo();
        }
        if (botpFilter.getFilter() == null) {
            FilterInfo defaultFilter = new FilterInfo();
            botpFilter.setFilter(defaultFilter);
        }
        if (botpFilter.getEntryFilters() != null && botpFilter.getEntryFilters().size() > 0) {
            FilterCollection entryFilterCols = botpFilter.getEntryFilters();
            FilterInfo billFilter = botpFilter.getFilter();
            FilterInfo entryQueryFilter = new FilterInfo();
            if (entryFilterCols != null && entryFilterCols.size() > 0) {
                int size = entryFilterCols.size();
                for (int i = 0; i < size; ++i) {
                    FilterInfo entryFilterInfo = entryFilterCols.get(i);
                    if (entryFilterInfo == null || entryFilterInfo.getFilterItems().size() <= 0) continue;
                    String entryName = entryFilterInfo.getEntryName();
                    int count = entryFilterInfo.getFilterItems().size();
                    for (int j = 0; j < count; ++j) {
                        entryQueryFilter.getFilterItems().add(new FilterItemInfo(entryName + '.' + entryFilterInfo.getFilterItems().get(j).getPropertyName(), entryFilterInfo.getFilterItems().get(j).getCompareValue(), entryFilterInfo.getFilterItems().get(j).getCompareType()));
                    }
                    if (i == 0) {
                        entryQueryFilter.setMaskString(entryFilterInfo.getMaskString());
                        continue;
                    }
                    entryQueryFilter.setMaskString(entryQueryFilter.getMaskString() + " and " + entryFilterInfo.getMaskString());
                }
            }
            if (entryQueryFilter.getFilterItems().size() > 0) {
                if (billFilter.getFilterItems().size() > 0) {
                    billFilter.mergeFilter(entryQueryFilter, "and");
                } else {
                    billFilter = entryQueryFilter;
                }
            }
            botpFilter.getEntryFilters().clear();
            botpFilter.setFilter(billFilter);
        }
        return botpFilter;
    }

    public class SimpleBotMappingInfo {
        private BOTMappingInfo botMappingInfo;

        public SimpleBotMappingInfo(BOTMappingInfo botMappingInfo) {
            this.botMappingInfo = botMappingInfo;
        }

        public String toString() {
            return this.botMappingInfo.getAlias(SysContext.getSysContext().getLocale());
        }
    }

    private class DAPBosTypeInfo {
        private boolean isSelected = false;
        private MetaDataBriefInfo briefInfo;
        private Component cellRender = null;

        private DAPBosTypeInfo() {
        }

        public MetaDataBriefInfo getBriefInfo() {
            return this.briefInfo;
        }

        public void setBriefInfo(MetaDataBriefInfo briefInfo) {
            this.briefInfo = briefInfo;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public String toString() {
            return this.briefInfo.getAlias();
        }

        public Component getCellRender() {
            return this.cellRender;
        }

        public void setCellRender(Component cellRender) {
            this.cellRender = cellRender;
        }
    }

    class VoucherInfoComparator
    implements Comparator {
        String orderField = null;

        public VoucherInfoComparator(String orderField) {
            this.orderField = orderField;
        }

        public int compare(Object arg0, Object arg1) {
            CoreBillBaseInfo info1 = (CoreBillBaseInfo)arg0;
            CoreBillBaseInfo info2 = (CoreBillBaseInfo)arg1;
            Object value1 = info1.get(this.orderField);
            Object value2 = info2.get(this.orderField);
            if (value1 == null || value2 == null) {
                return 0;
            }
            if (value1 instanceof BigDecimal) {
                return ((BigDecimal)value1).compareTo((BigDecimal)value2);
            }
            if (value1 instanceof Integer) {
                return ((Integer)value1).compareTo((Integer)value2);
            }
            if (value1 instanceof Date) {
                return ((Date)value1).compareTo((Date)value2);
            }
            return value1.toString().compareToIgnoreCase(value2.toString());
        }
    }
}

