/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dap.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.dap.client.AbstractDAPOrgMappingSelectUI;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class DAPOrgMappingSelectUI
extends AbstractDAPOrgMappingSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(DAPOrgMappingSelectUI.class);
    private boolean isCanceled = true;
    private BOTMappingCollection botMappingCollection = new BOTMappingCollection();

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblBotMapping.checkParsed();
        this.tblBotMapping.getSelectManager().setSelectMode(10);
        this.tblBotMapping.getStyleAttributes().setLocked(true);
        this.loadCtx();
        this.actionCancel.setEnabled(true);
        this.actionConfirm.setEnabled(true);
    }

    private void loadCtx() {
        this.tblBotMapping.removeRows();
        BOTMappingCollection botMappingCollection = (BOTMappingCollection)this.getUIContext().get("BOTMappings");
        if (botMappingCollection != null && botMappingCollection.size() > 0) {
            int count = botMappingCollection.size();
            for (int i = 0; i < count; ++i) {
                IRow row = this.tblBotMapping.addRow();
                BOTMappingInfo botMappingInfo = botMappingCollection.get(i);
                row.getCell("id").setValue((Object)botMappingInfo.getId());
                row.getCell("id").setUserObject((Object)botMappingInfo);
                row.getCell("name").setValue((Object)botMappingInfo.getName());
                row.getCell("alias").setValue((Object)botMappingInfo.getAlias(SysContext.getSysContext().getLocale()));
                row.getCell("isEffected").setValue((Object)botMappingInfo.getExtRule().isIsEffected());
                row.getCell("org").setValue((Object)botMappingInfo.getExtRule().getOrg());
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.confirmBotMappingInfo();
    }

    private int[] getSelectedRows(KDTable tabletmp) {
        if (tabletmp.getRowCount() == 0 || tabletmp.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        ArrayList<Object> idList = new ArrayList<Object>();
        HashSet<Integer> tempSet = new HashSet<Integer>();
        ArrayList blocks = tabletmp.getSelectManager().getBlocks();
        for (KDTSelectBlock block : blocks) {
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                ICell cell = tabletmp.getRow(rowIndex).getCell("id");
                tempSet.add(rowIndex);
                if (idList.contains(cell.getValue())) continue;
                idList.add(cell.getValue());
            }
        }
        int[] rows = new int[tempSet.size()];
        Iterator itera = tempSet.iterator();
        int k = 0;
        while (itera.hasNext()) {
            rows[k] = (Integer)itera.next();
            ++k;
        }
        return rows;
    }

    private void confirmBotMappingInfo() {
        int[] selectRows = this.getSelectedRows(this.tblBotMapping);
        if (selectRows.length == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"NOMAPPINGSELECTEDINSELECTUI"));
        } else {
            for (int i = 0; i < selectRows.length; ++i) {
                IRow row = this.tblBotMapping.getRow(selectRows[i]);
                BOTMappingInfo rule = (BOTMappingInfo)row.getCell("id").getUserObject();
                this.botMappingCollection.add(rule);
            }
            this.setCanceled(false);
            this.getUIWindow().close();
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.setCanceled(true);
        this.getUIWindow().close();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public BOTMappingCollection getSelectBOTMappingCollection() {
        return this.botMappingCollection;
    }

    public void setSelectBOTMappingCollection(BOTMappingCollection selectBotMappingInfo) {
        this.botMappingCollection = selectBotMappingInfo;
    }

    @Override
    protected void tblBotMapping_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.confirmBotMappingInfo();
        }
    }
}

