/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dbclean;

import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.base.dbclean.DB2VO;
import com.kingdee.eas.base.dbclean.DataCenterInfo;
import com.kingdee.eas.base.dbclean.JZTaskException;
import com.kingdee.eas.base.dbclean.OracleVO;
import com.kingdee.eas.base.dbclean.SqlServerVO;
import com.kingdee.eas.base.dbclean.XMLElement;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Vector;

public class DataCenterUtil {
    private static DataCenterInfo xmlElement2Info(XMLElement dcElement) throws JZTaskException {
        String[] addrs;
        DataCenterInfo dcInfo;
        String dbType = dcElement.getStringAttribute("dbtype");
        String dbDriverVersion = dcElement.getStringAttribute("dbversion");
        String datasource = dcElement.getStringAttribute("datasource");
        String dbName = dcElement.getStringAttribute("dbname");
        String dbUser = dcElement.getStringAttribute("dbuser");
        String dbPassword = dcElement.getStringAttribute("dbpassword");
        if ("sqlserver".equalsIgnoreCase(dbType)) {
            SqlServerVO sqlserver = new SqlServerVO();
            dcInfo = new DataCenterInfo(sqlserver);
            addrs = datasource.split(":");
            sqlserver.setDbAddress(addrs[0]);
            sqlserver.setDbPort(Integer.parseInt(addrs[1]));
            sqlserver.setDbName(dbName);
            sqlserver.setDbPassword(KSqlUtil.decodePassword((String)dbPassword));
            sqlserver.setDbUserName(dbUser);
            int instancePos = -1;
            instancePos = sqlserver.getDbAddress().indexOf("\\");
            if (instancePos > 0) {
                String ip = sqlserver.getDbAddress().substring(0, instancePos);
                String instanceName = sqlserver.getDbAddress().substring(instancePos + 1);
                sqlserver.setDbAddress(ip);
                sqlserver.setInstanceName(instanceName);
            }
        } else if ("oracle".equalsIgnoreCase(dbType)) {
            String[] addressList = datasource.split(";");
            OracleVO oracle = new OracleVO();
            dcInfo = new DataCenterInfo(oracle);
            String[] addrs2 = addressList[0].split(":");
            oracle.setDbAddress(addrs2[0]);
            oracle.setDbPort(Integer.parseInt(addrs2[1]));
            oracle.setDbUserName(dbUser);
            oracle.setDbPassword(KSqlUtil.decodePassword((String)dbPassword));
            oracle.setInstanceName(dbName);
            for (int i = 1; i < addressList.length; ++i) {
                oracle.addAdditionalAddress(addressList[i]);
            }
            String dbBalance = dcElement.getStringAttribute("dbbalance");
            if (dbBalance != null && dbBalance.length() > 0) {
                dbBalance = "false";
            }
            oracle.setDBBalance(Boolean.valueOf(dbBalance));
        } else if ("db2".equalsIgnoreCase(dbType)) {
            DB2VO db2 = new DB2VO();
            dcInfo = new DataCenterInfo(db2);
            addrs = datasource.split(":");
            db2.setDbAddress(addrs[0]);
            db2.setDbPort(Integer.parseInt(addrs[1]));
            db2.setDbName(dbName);
            db2.setDbUserName(dbUser);
            db2.setDbPassword(KSqlUtil.decodePassword((String)dbPassword));
        } else {
            throw new JZTaskException("DBType[" + dbType + "] is not supported!  { " + dcElement.toString() + "} will be ignored!");
        }
        dcInfo.setDcNumber(dcElement.getStringAttribute("id"));
        dcInfo.setDcVersion(true, dcElement.getStringAttribute("BOSVersion"));
        dcInfo.setDcVersion(false, dcElement.getStringAttribute("version"));
        dcInfo.setDisable("true".equalsIgnoreCase(dcElement.getStringAttribute("disable")));
        dcInfo.setBindEBGateway("true".equalsIgnoreCase(dcElement.getStringAttribute("bindebgateway")));
        dcInfo.setIsDefaultDC("true".equalsIgnoreCase(dcElement.getStringAttribute("defaultDC", "false")));
        dcInfo.setUseKSQL(!"false".equalsIgnoreCase(dcElement.getStringAttribute("ksql")));
        dcInfo.setEnableKSQLTrace("connection".equalsIgnoreCase(dcElement.getStringAttribute("tracetype")));
        dcInfo.setEnableKSQLTraceFile("log".equalsIgnoreCase(dcElement.getStringAttribute("tracetype")));
        dcInfo.setEncodeURL(!"false".equalsIgnoreCase(dcElement.getStringAttribute("encodeurl")));
        Vector langNames = dcElement.getChildren();
        for (int i = 0; i < langNames.size(); ++i) {
            XMLElement langEle = (XMLElement)langNames.get(i);
            if ("zh_CN".equalsIgnoreCase(langEle.getStringAttribute("locale"))) {
                dcInfo.setDcName_L2(langEle.getContent());
                continue;
            }
            if ("zh_TW".equalsIgnoreCase(langEle.getStringAttribute("locale"))) {
                dcInfo.setDcName_L1(langEle.getContent());
                continue;
            }
            dcInfo.setDcName_L3(langEle.getContent());
        }
        return dcInfo;
    }

    public static DataCenterInfo[] getDCInfoList() throws Exception {
        String easHome = System.getProperty("EAS_HOME");
        String dcInfoFile = null;
        dcInfoFile = easHome == null || easHome.length() <= 0 ? "W:/eas/Server//server/properties/datacenters.xml" : System.getProperty("EAS_HOME") + "/server/properties/datacenters.xml";
        XMLElement xmlEle = new XMLElement();
        FileReader reader = new FileReader(dcInfoFile);
        xmlEle.parseFromReader(reader);
        Vector dcList = xmlEle.getChildren();
        if (dcList != null) {
            HashMap<String, DataCenterInfo> dcsMap = new HashMap<String, DataCenterInfo>();
            String[] dcNums = new String[dcList.size()];
            for (int i = 0; i < dcList.size(); ++i) {
                XMLElement dcEle = (XMLElement)dcList.get(i);
                DataCenterInfo dcInfo = DataCenterUtil.xmlElement2Info(dcEle);
                dcNums[i] = dcInfo.getDcNumber();
                dcsMap.put(dcInfo.getDcNumber(), dcInfo);
            }
            DataCenterInfo[] dcs = new DataCenterInfo[dcList.size()];
            for (int i = 0; i < dcNums.length; ++i) {
                dcs[i] = (DataCenterInfo)dcsMap.get(dcNums[i]);
            }
            return dcs;
        }
        return new DataCenterInfo[0];
    }
}

