/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dbclean;

import com.kingdee.eas.base.dbclean.DB2UDB;
import com.kingdee.eas.base.dbclean.DB2VO;
import com.kingdee.eas.base.dbclean.DatabaseVO;
import com.kingdee.eas.base.dbclean.IDatabase;
import com.kingdee.eas.base.dbclean.JZTaskException;
import com.kingdee.eas.base.dbclean.Oracle;
import com.kingdee.eas.base.dbclean.OracleVO;
import com.kingdee.eas.base.dbclean.SqlServer;
import com.kingdee.eas.base.dbclean.SqlServerVO;
import java.util.HashMap;
import org.apache.log4j.Logger;

public final class DatabaseManager {
    private static HashMap cachedDBEnginesRunSQLScript = new HashMap(20);
    private static final Logger logger = Logger.getLogger(DatabaseManager.class);

    public static synchronized IDatabase getDBEngine(DatabaseVO dbvo) throws JZTaskException {
        HashMap cacheEngine = cachedDBEnginesRunSQLScript;
        if (cacheEngine.containsKey(dbvo.getID())) {
            return (IDatabase)cacheEngine.get(dbvo.getID());
        }
        logger.info((Object)("====Create new database engine for [" + dbvo.getID() + "]"));
        if ("Oracle".equals(dbvo.getDBType())) {
            Oracle oraEngine = new Oracle((OracleVO)dbvo);
            cacheEngine.put(dbvo.getID(), oraEngine);
            return oraEngine;
        }
        if ("MS SqlServer".equals(dbvo.getDBType())) {
            SqlServer sqlEngine = new SqlServer((SqlServerVO)dbvo);
            cacheEngine.put(dbvo.getID(), sqlEngine);
            return sqlEngine;
        }
        if ("DB2".equals(dbvo.getDBType())) {
            DB2UDB db2Engine = new DB2UDB((DB2VO)dbvo);
            cacheEngine.put(dbvo.getID(), db2Engine);
            return db2Engine;
        }
        throw new JZTaskException("DBType[" + dbvo.getDBType() + "] is not supported!");
    }

    public static String[] getSupportedDBTypes() {
        return DatabaseVO.getSupportedDBTypes();
    }
}

