/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dbclean;

import com.kingdee.eas.base.dbclean.DB2VO;
import com.kingdee.eas.base.dbclean.OracleVO;
import com.kingdee.eas.base.dbclean.SqlServerVO;
import java.io.Serializable;

public abstract class DatabaseVO
implements Serializable {
    public static final String DBTYPE_DB2 = "DB2";
    public static final String DBTYPE_ORACLE = "Oracle";
    public static final String DBTYPE_SQLSERVER = "MS SqlServer";
    public static final String DBTYPE_DB2_AS400 = "DB2/400";
    public static final String DBTYPE_SYBASE = "Sybase";
    public static final String DBTYPE_MySQL = "MySQL";
    private static final String[] supportedTypes = new String[]{"MS SqlServer", "Oracle", "DB2", "MySQL"};
    protected String dbUserName;
    protected String dbPassword;
    protected String dbAddress;
    protected String dbVersion = "";
    protected String dbCharset = "";
    private String status;

    public static DatabaseVO initDatabaseVO(String dbType) {
        DatabaseVO database = null;
        if (DBTYPE_SQLSERVER.equalsIgnoreCase(dbType)) {
            database = new SqlServerVO();
        } else if (DBTYPE_DB2.equalsIgnoreCase(dbType)) {
            database = new DB2VO();
        } else if (DBTYPE_ORACLE.equalsIgnoreCase(dbType)) {
            database = new OracleVO();
        }
        return database;
    }

    public String getDbCharset() {
        return this.dbCharset;
    }

    public void setDbCharset(String charset) {
        this.dbCharset = charset;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public void setDbVersion(String ver) {
        this.dbVersion = ver;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String dbstatus) {
        this.status = dbstatus;
    }

    public String getDbUserName() {
        return this.dbUserName;
    }

    public void setDbUserName(String user) {
        this.dbUserName = user;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String password) {
        this.dbPassword = password;
    }

    public String getDbAddress() {
        return this.dbAddress;
    }

    public void setDbAddress(String address) {
        this.dbAddress = address;
    }

    public abstract void setDbPort(int var1);

    public abstract int getDbPort();

    public abstract String getDBType();

    public static String[] getSupportedDBTypes() {
        return supportedTypes;
    }

    public boolean isCompatibleType(String type) {
        String dbType = this.getDBType().toUpperCase();
        return dbType.indexOf(type = type.toUpperCase()) >= 0 || "all".equalsIgnoreCase(type);
    }

    public abstract String getDisplayAddress();

    public abstract String getDisplayDBName();

    public abstract void setDbName(String var1);

    public abstract String getID();
}

