/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.dbclean.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.eas.base.dbclean.DataCenterInfo;
import com.kingdee.eas.base.dbclean.DataCenterUtil;
import com.kingdee.eas.base.dbclean.DatabaseManager;
import com.kingdee.eas.base.dbclean.IDatabase;
import com.kingdee.eas.base.dbclean.IJZService;
import com.kingdee.eas.base.dbclean.JZProcessTask;
import com.kingdee.eas.base.dbclean.JZServiceFactory;
import com.kingdee.eas.base.dbclean.client.JZUtil;
import com.kingdee.eas.base.dbclean.client.excute.JZExcuteTaskDialog;
import com.kingdee.eas.base.dbclean.client.logger.JZTaskLogQueryDialog;
import com.kingdee.eas.base.dbclean.client.register.JZTaskQueryDialog;
import com.kingdee.eas.base.dbclean.client.wizard.JZWizardDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.log4j.PropertyConfigurator;

public class JZFrame
extends KDFrame {
    private ImageIcon newIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/btn_new.gif"));
    private ImageIcon exceIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/btn_startup.gif"));
    private ImageIcon viewIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/btn_View.gif"));
    private ImageIcon registerIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/btn_register.gif"));
    private ImageIcon dataCenterIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/btn_datacenter.gif"));
    private ImageIcon deleteIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/kingdee/eas/base/dbclean/client/images/btn_delete.gif"));
    private CreateTaskAction newTask = new CreateTaskAction();
    private ContinueTaskAction exceTask = new ContinueTaskAction();
    private ViewTaskLogAction viewTaskLog = new ViewTaskLogAction();
    private RegisterTaskAction registerTask = new RegisterTaskAction();
    private DeleteTaskAction deleteTaskAction = new DeleteTaskAction();
    private KDToolBar toolBar;
    private KDLabel label;
    private KDTable taskTable;
    private KDComboBox cmbDC = new KDComboBox();
    private HashMap dcInfoMap = new HashMap();
    private static JZFrame instance = null;

    public static JZFrame getInstance() {
        return instance;
    }

    public JZFrame(KDFrame adminFrame, KDConnection dbConn) throws Exception {
        instance = this;
        this.setTitle("EAS-\u5e10\u5957\u7ed3\u8f6c");
        this.setSize(715, 500);
        this.setLocationRelativeTo((Component)adminFrame);
        this.setDefaultCloseOperation(2);
        this.initComponent();
        JZUtil.setConnection(dbConn);
        this.loadDc();
    }

    private void initComponent() {
        this.toolBar = new KDToolBar();
        this.toolBar.add((Action)this.newTask);
        this.toolBar.addSeparator();
        this.toolBar.add((Action)this.exceTask);
        this.toolBar.addSeparator();
        this.toolBar.add((Action)this.viewTaskLog);
        this.toolBar.addSeparator();
        this.toolBar.add((Action)this.registerTask);
        this.toolBar.addSeparator();
        this.label = new KDLabel("\u6570\u636e\u4e2d\u5fc3   ", (Icon)this.dataCenterIcon, 10);
        this.label.setForeground(Color.WHITE);
        this.toolBar.add((Component)this.label);
        this.cmbDC.setPreferredSize(new Dimension(100, 10));
        this.toolBar.add((Component)this.cmbDC);
        this.toolBar.addSeparator();
        this.toolBar.add((Action)this.deleteTaskAction);
        this.taskTable = new KDTable(5, 1, 0);
        this.taskTable.setCursor(this.getCursor());
        this.taskTable.getColumn(0).setWidth(150);
        this.taskTable.getColumn(1).setWidth(160);
        this.taskTable.getColumn(2).setWidth(100);
        this.taskTable.getColumn(3).setWidth(150);
        this.taskTable.getColumn(4).setWidth(100);
        this.taskTable.getSelectManager().setSelectMode(2);
        IRow headRow = this.taskTable.getHeadRow(0);
        headRow.getCell(0).setValue((Object)"\u4efb\u52a1\u7f16\u53f7");
        headRow.getCell(1).setValue((Object)"\u521b\u5efa\u65f6\u95f4");
        headRow.getCell(2).setValue((Object)"\u7ed3\u8f6c\u6a21\u5757");
        headRow.getCell(3).setValue((Object)"\u4f1a\u8ba1\u671f\u95f4");
        headRow.getCell(4).setValue((Object)"\u5f53\u524d\u6b65\u9aa4");
        this.taskTable.setEditable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.taskTable, "Center");
        this.cmbDC.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    String centerName = (String)JZFrame.this.cmbDC.getSelectedItem();
                    JZFrame.this.setDcName(centerName);
                }
                catch (Exception ex) {
                    KDOptionPane.showMessageDialog((Component)((Object)JZFrame.this), (Object)("\u9519\u8bef:" + ex.getMessage()));
                }
            }
        });
    }

    private void loadDc() throws Exception {
        try {
            DataCenterInfo[] dcList = DataCenterUtil.getDCInfoList();
            if (dcList != null && dcList.length > 0) {
                for (int i = 0; i < dcList.length; ++i) {
                    this.dcInfoMap.put(dcList[i].getDcNumber(), dcList[i]);
                    this.cmbDC.addItem((Object)dcList[i].getDcNumber());
                }
            }
            this.cmbDC.setSelectedIndex(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            KDOptionPane.showMessageDialog(null, (Object)"\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u4fe1\u606f\u5931\u8d25!!!");
        }
    }

    private void setDcName(String dcName) throws Exception {
        DataCenterInfo dcInfo;
        if (dcName != null && (dcInfo = (DataCenterInfo)this.dcInfoMap.get(dcName)) != null) {
            IDatabase dbEngine = DatabaseManager.getDBEngine(dcInfo.getDefaultDatabase());
            JZUtil.setDbEngine(dbEngine);
            this.loadTaskProcess();
        }
    }

    private void loadTaskProcess() throws Exception {
        this.taskTable.refresh();
        IJZService jzService = JZServiceFactory.getJZService();
        List allProcessTask = jzService.queryAllProcessTask(JZUtil.getConnection());
        if (allProcessTask != null && allProcessTask.size() > 0) {
            for (JZProcessTask procTask : allProcessTask) {
                IRow dataRow = this.taskTable.addRow();
                dataRow.getCell(0).setValue((Object)procTask.getProcId());
                dataRow.getCell(1).setValue((Object)procTask.getCreateDt());
                dataRow.getCell(2).setValue((Object)procTask.getModules());
                dataRow.getCell(3).setValue((Object)new Integer(procTask.getPeriodNumber()));
                dataRow.getCell(4).setValue((Object)procTask.getStatusName());
                dataRow.setUserObject((Object)procTask);
            }
        }
    }

    public void addProcessTask(JZProcessTask procTask) {
        IRow dataRow = this.taskTable.addRow();
        dataRow.getCell(0).setValue((Object)procTask.getProcId());
        dataRow.getCell(1).setValue((Object)procTask.getCreateDt());
        dataRow.getCell(2).setValue((Object)procTask.getModules());
        dataRow.getCell(3).setValue((Object)new Integer(procTask.getPeriodNumber()));
        dataRow.getCell(4).setValue((Object)procTask.getStatusName());
        dataRow.setUserObject((Object)procTask);
    }

    public void updateProcessTask(JZProcessTask procTask) {
        for (int i = 0; i < this.taskTable.getRowCount(); ++i) {
            IRow row = this.taskTable.getRow(i);
            String procId = (String)row.getCell(0).getValue();
            if (!procId.equals(procTask.getProcId())) continue;
            row.getCell(4).setValue((Object)procTask.getStatusName());
            row.setUserObject((Object)procTask);
            break;
        }
        this.taskTable.updateUI();
    }

    private JZProcessTask getSelectProcessTask() {
        int curRowIndex = this.taskTable.getSelectManager().getActiveRowIndex();
        if (curRowIndex < 0) {
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u7ed3\u8f6c\u4efb\u52a1!");
            return null;
        }
        IRow curRow = this.taskTable.getRow(curRowIndex);
        JZProcessTask procTask = (JZProcessTask)curRow.getUserObject();
        if (procTask.getStatus() == 1) {
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)"\u5f53\u524d\u4efb\u52a1\u5df2\u7ecf\u5b8c\u6210\uff0c\u4e0d\u80fd\u91cd\u590d\u7ed3\u8f6c!");
            return null;
        }
        return procTask;
    }

    private JZProcessTask getSelectProcessTask1() {
        int curRowIndex = this.taskTable.getSelectManager().getActiveRowIndex();
        if (curRowIndex < 0) {
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u7ed3\u8f6c\u4efb\u52a1!");
            return null;
        }
        IRow curRow = this.taskTable.getRow(curRowIndex);
        JZProcessTask procTask = (JZProcessTask)curRow.getUserObject();
        return procTask;
    }

    private void remove() {
        int result;
        JZProcessTask procTask = this.getSelectProcessTask1();
        if (procTask != null && (result = KDOptionPane.showConfirmDialog(null, (Object)"\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\u8be5\u7ed3\u8f6c\u4efb\u52a1", (String)"\u786e\u8ba4\u63d0\u793a\u6846", (int)0, (int)3)) == 0) {
            try {
                boolean isOK = JZServiceFactory.getJZService().removeTask(procTask, JZUtil.getConnection());
                if (isOK) {
                    KDOptionPane.showMessageDialog((Component)((Object)this), (Object)"\u8be5\u7ed3\u8f6c\u4efb\u52a1\u5df2\u6709\u4efb\u52a1\u9879\u7ed3\u8f6c\u6210\u529f\uff0c\u4e0d\u80fd\u5220\u9664\uff01", (String)"\u4fe1\u606f\u63d0\u793a", (int)0);
                } else {
                    this.loadTaskProcess();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                KDOptionPane.showMessageDialog((Component)((Object)this), (Object)("\u5220\u9664\u5931\u8d25:" + ex.getMessage()));
            }
        }
    }

    public static void main(String[] argv) throws IOException {
        try {
            PropertyConfigurator.configure((String)"dbclean_log4j.properties");
            try {
                KingdeeLookAndFeel.setCurrentTheme((int)4);
                UIManager.setLookAndFeel((LookAndFeel)new KingdeeLookAndFeel());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Object dbConn = null;
            Class<?> jzCls = Class.forName("com.kingdee.eas.base.dbclean.client.JZFrame");
            Class[] typeParam = new Class[]{KDFrame.class, KDConnection.class};
            Constructor<?> construtor = jzCls.getConstructor(typeParam);
            Object[] valueParam = new Object[]{null, dbConn};
            KDFrame jzFrame = (KDFrame)construtor.newInstance(valueParam);
            jzFrame.addWindowListener((WindowListener)new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(128);
                }
            });
            jzFrame.show();
        }
        catch (ClassNotFoundException cne) {
            KDOptionPane.showMessageDialog(null, (Object)"\u5f53\u524d\u7cfb\u7edf\u4e0d\u652f\u6301\u5e10\u5957\u7ed3\u8f6c,\u8bf7\u5b89\u88c5\u90e8\u7f72\u8be5\u529f\u80fd!!!");
        }
        catch (Exception ex) {
            KDOptionPane.showMessageDialog(null, (Object)("\u542f\u52a8\u5e10\u5957\u7ed3\u8f6c\u5931\u8d25,\u539f\u56e0\uff1a" + ex.getCause().getMessage()));
        }
    }

    private class DeleteTaskAction
    extends AbstractAction {
        public DeleteTaskAction() {
            super("\u5220\u9664", JZFrame.this.deleteIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZFrame.this.remove();
        }
    }

    private class RegisterTaskAction
    extends AbstractAction {
        public RegisterTaskAction() {
            super("\u6ce8\u518c\u7ed3\u8f6c\u4ee3\u7801", JZFrame.this.registerIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZTaskQueryDialog regDlg = new JZTaskQueryDialog(JZFrame.this);
            regDlg.show();
        }
    }

    private class ViewTaskLogAction
    extends AbstractAction {
        public ViewTaskLogAction() {
            super("\u67e5\u770b\u7ed3\u8f6c\u65e5\u5fd7", JZFrame.this.viewIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZProcessTask procTask = JZFrame.this.getSelectProcessTask1();
            if (procTask != null) {
                JZTaskLogQueryDialog logDlg = new JZTaskLogQueryDialog(JZFrame.this);
                logDlg.loadLog(procTask);
                logDlg.show();
            }
        }
    }

    private class ContinueTaskAction
    extends AbstractAction {
        public ContinueTaskAction() {
            super("\u6267\u884c\u7ed3\u8f6c\u4efb\u52a1", JZFrame.this.exceIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZProcessTask procTask = JZFrame.this.getSelectProcessTask();
            if (procTask != null) {
                JZExcuteTaskDialog execDlg = new JZExcuteTaskDialog(JZFrame.this);
                execDlg.continueProccessor(procTask);
                execDlg.show();
            }
        }
    }

    private class CreateTaskAction
    extends AbstractAction {
        public CreateTaskAction() {
            super("\u65b0\u5efa\u7ed3\u8f6c\u4efb\u52a1", JZFrame.this.newIcon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JZWizardDialog wizardDlg = new JZWizardDialog(JZFrame.this);
            wizardDlg.show();
        }
    }
}

